/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static List<Method> getSetters(Class<?> clazz, String fieldName) {
        final String internedName = ("set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1)).intern();
        final ArrayList<Method> setters = new ArrayList<Method>(1);
        ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Method>(){

            @Override
            public Method run(Class<?> clazz) {
                Method m;
                Method[] methods = clazz.getDeclaredMethods();
                Method res = null;
                for (int i = 0; i < methods.length; ++i) {
                    m = methods[i];
                    if (!ReflectionUtils.isSetterSignature(m) || m.getName() != internedName || res != null && !res.getParameterTypes()[0].isAssignableFrom(m.getParameterTypes()[0])) continue;
                    res = m;
                }
                if (res != null) {
                    if (!setters.isEmpty()) {
                        ListIterator<Method> listIterator = setters.listIterator();
                        while (listIterator.hasNext()) {
                            m = (Method)listIterator.next();
                            if (!m.getParameterTypes()[0].isAssignableFrom(res.getParameterTypes()[0])) continue;
                            listIterator.set(res);
                            return null;
                        }
                    }
                    setters.add(res);
                }
                return null;
            }
        });
        return setters;
    }

    private static boolean isSetterSignature(Method m) {
        return m != null && m.getReturnType().equals(Void.TYPE) && m.getParameterTypes().length == 1;
    }

    private static <T> T traverseHierarchy(Class<?> clazz, TraverseTask<T> task) {
        LinkedList classQueue = new LinkedList();
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            Class traverseClass = (Class)classQueue.remove();
            T result = task.run(traverseClass);
            if (result != null) {
                return result;
            }
            if (traverseClass.getSuperclass() != null) {
                classQueue.add(traverseClass.getSuperclass());
            }
            for (Class<?> interfaceClass : traverseClass.getInterfaces()) {
                classQueue.add(interfaceClass);
            }
        }
        return null;
    }

    private static interface TraverseTask<T> {
        public T run(Class<?> var1);
    }
}

