/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonUtils {
    private static final byte TYPE_BOOLEAN = 0;
    private static final byte TYPE_INT = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_DOUBLE = 3;
    private static final byte TYPE_STRING = 4;
    private static final byte TYPE_JSON_OBJECT = 5;
    private static final byte TYPE_JSON_ARRAY = 6;

    private JsonUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static <T> boolean isJSONObject(T input) {
        return input instanceof JSONObject;
    }

    public static <T> boolean isJSONArray(T input) {
        return input instanceof JSONArray;
    }

    public static boolean getBoolean(JSONObject jsonObject, String key) {
        return JsonUtils.getBoolean(jsonObject, key, false);
    }

    public static boolean getBoolean(JSONObject jsonObject, String key, boolean defaultValue) {
        return JsonUtils.getValueByType(jsonObject, key, Boolean.valueOf(defaultValue), (byte)0);
    }

    public static boolean getBoolean(String json, String key) {
        return JsonUtils.getBoolean(json, key, false);
    }

    public static boolean getBoolean(String json, String key, boolean defaultValue) {
        return JsonUtils.getValueByType(json, key, Boolean.valueOf(defaultValue), (byte)0);
    }

    public static int getInt(JSONObject jsonObject, String key) {
        return JsonUtils.getInt(jsonObject, key, -1);
    }

    public static int getInt(JSONObject jsonObject, String key, int defaultValue) {
        return JsonUtils.getValueByType(jsonObject, key, Integer.valueOf(defaultValue), (byte)1);
    }

    public static int getInt(String json, String key) {
        return JsonUtils.getInt(json, key, -1);
    }

    public static int getInt(String json, String key, int defaultValue) {
        return JsonUtils.getValueByType(json, key, Integer.valueOf(defaultValue), (byte)1);
    }

    public static long getLong(JSONObject jsonObject, String key) {
        return JsonUtils.getLong(jsonObject, key, -1L);
    }

    public static long getLong(JSONObject jsonObject, String key, long defaultValue) {
        return JsonUtils.getValueByType(jsonObject, key, Long.valueOf(defaultValue), (byte)2);
    }

    public static long getLong(String json, String key) {
        return JsonUtils.getLong(json, key, -1L);
    }

    public static long getLong(String json, String key, long defaultValue) {
        return JsonUtils.getValueByType(json, key, Long.valueOf(defaultValue), (byte)2);
    }

    public static double getDouble(JSONObject jsonObject, String key) {
        return JsonUtils.getDouble(jsonObject, key, -1.0);
    }

    public static double getDouble(JSONObject jsonObject, String key, double defaultValue) {
        return JsonUtils.getValueByType(jsonObject, key, Double.valueOf(defaultValue), (byte)3);
    }

    public static double getDouble(String json, String key) {
        return JsonUtils.getDouble(json, key, -1.0);
    }

    public static double getDouble(String json, String key, double defaultValue) {
        return JsonUtils.getValueByType(json, key, Double.valueOf(defaultValue), (byte)3);
    }

    public static String getString(JSONObject jsonObject, String key) {
        return JsonUtils.getString(jsonObject, key, "");
    }

    public static String getString(JSONObject jsonObject, String key, String defaultValue) {
        return JsonUtils.getValueByType(jsonObject, key, defaultValue, (byte)4);
    }

    public static String getString(String json, String key) {
        return JsonUtils.getString(json, key, "");
    }

    public static String getString(String json, String key, String defaultValue) {
        return JsonUtils.getValueByType(json, key, defaultValue, (byte)4);
    }

    public static JSONObject getJSONObject(JSONObject jsonObject, String key, JSONObject defaultValue) {
        return JsonUtils.getValueByType(jsonObject, key, defaultValue, (byte)5);
    }

    public static JSONObject getJSONObject(String json, String key, JSONObject defaultValue) {
        return JsonUtils.getValueByType(json, key, defaultValue, (byte)5);
    }

    public static JSONArray getJSONArray(JSONObject jsonObject, String key, JSONArray defaultValue) {
        return JsonUtils.getValueByType(jsonObject, key, defaultValue, (byte)6);
    }

    public static JSONArray getJSONArray(String json, String key, JSONArray defaultValue) {
        return JsonUtils.getValueByType(json, key, defaultValue, (byte)6);
    }

    private static <T> T getValueByType(JSONObject jsonObject, String key, T defaultValue, byte type) {
        if (jsonObject == null || key == null || key.length() == 0) {
            return defaultValue;
        }
        try {
            Object ret;
            if (type == 0) {
                ret = jsonObject.getBoolean(key);
            } else if (type == 1) {
                ret = jsonObject.getInt(key);
            } else if (type == 2) {
                ret = jsonObject.getLong(key);
            } else if (type == 3) {
                ret = jsonObject.getDouble(key);
            } else if (type == 4) {
                ret = jsonObject.getString(key);
            } else if (type == 5) {
                ret = jsonObject.getJSONObject(key);
            } else if (type == 6) {
                ret = jsonObject.getJSONArray(key);
            } else {
                return defaultValue;
            }
            return (T)ret;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private static <T> T getValueByType(String json, String key, T defaultValue, byte type) {
        if (json == null || json.length() == 0 || key == null || key.length() == 0) {
            return defaultValue;
        }
        try {
            return JsonUtils.getValueByType(new JSONObject(json), key, defaultValue, type);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String formatJson(String json) {
        return JsonUtils.formatJson(json, 4);
    }

    public static String formatJson(String json, int indentSpaces) {
        try {
            int len = json.length();
            for (int i = 0; i < len; ++i) {
                char c = json.charAt(i);
                if (c == '{') {
                    return new JSONObject(json).toString(indentSpaces);
                }
                if (c == '[') {
                    return new JSONArray(json).toString(indentSpaces);
                }
                if (Character.isWhitespace(c)) continue;
                return json;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }
}

