/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ApiUtils {
    private static final String TAG = "ApiUtils";
    private Map<Class, BaseApi> mApiMap = new ConcurrentHashMap<Class, BaseApi>();
    private Map<Class, Class> mInjectApiImplMap = new HashMap<Class, Class>();

    private ApiUtils() {
        this.init();
    }

    private void init() {
    }

    private void registerImpl(Class implClass) {
        this.mInjectApiImplMap.put(implClass.getSuperclass(), implClass);
    }

    @Nullable
    public static <T extends BaseApi> T getApi(@NonNull Class<T> apiClass) {
        return (T)((BaseApi)ApiUtils.getInstance().getApiInner(apiClass));
    }

    public static void register(@Nullable Class<? extends BaseApi> implClass) {
        if (implClass == null) {
            return;
        }
        ApiUtils.getInstance().registerImpl(implClass);
    }

    @NonNull
    public static String toString_() {
        return ApiUtils.getInstance().toString();
    }

    public String toString() {
        return "ApiUtils: " + this.mInjectApiImplMap;
    }

    private static ApiUtils getInstance() {
        return LazyHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Result> Result getApiInner(Class apiClass) {
        BaseApi api = this.mApiMap.get(apiClass);
        if (api != null) {
            return (Result)api;
        }
        Class clazz = apiClass;
        synchronized (clazz) {
            api = this.mApiMap.get(apiClass);
            if (api != null) {
                return (Result)api;
            }
            Class implClass = this.mInjectApiImplMap.get(apiClass);
            if (implClass != null) {
                try {
                    api = (BaseApi)implClass.newInstance();
                    this.mApiMap.put(apiClass, api);
                    return (Result)api;
                }
                catch (Exception ignore) {
                    Log.e((String)TAG, (String)("The <" + implClass + "> has no parameterless constructor."));
                    return null;
                }
            }
            Log.e((String)TAG, (String)("The <" + apiClass + "> doesn't implement."));
            return null;
        }
    }

    public static class BaseApi {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Api {
        public boolean isMock() default false;
    }

    private static class LazyHolder {
        private static final ApiUtils INSTANCE = new ApiUtils();

        private LazyHolder() {
        }
    }
}

