/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.util.Log;
import com.blankj.utilcode.util.ThreadUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public final class BusUtils {
    private static final Object NULL = "nULl";
    private static final String TAG = "BusUtils";
    private final Map<String, List<BusInfo>> mTag_BusInfoListMap = new ConcurrentHashMap<String, List<BusInfo>>();
    private final Map<String, Set<Object>> mClassName_BusesMap = new ConcurrentHashMap<String, Set<Object>>();
    private final Map<String, List<String>> mClassName_TagsMap = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, Map<String, Object>> mClassName_Tag_Arg4StickyMap = new ConcurrentHashMap<String, Map<String, Object>>();

    private BusUtils() {
        this.init();
    }

    private void init() {
    }

    private void registerBus(String tag, String className, String funName, String paramType, String paramName, boolean sticky, String threadMode) {
        this.registerBus(tag, className, funName, paramType, paramName, sticky, threadMode, 0);
    }

    private void registerBus(String tag, String className, String funName, String paramType, String paramName, boolean sticky, String threadMode, int priority) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            busInfoList = new CopyOnWriteArrayList<BusInfo>();
            this.mTag_BusInfoListMap.put(tag, busInfoList);
        }
        busInfoList.add(new BusInfo(tag, className, funName, paramType, paramName, sticky, threadMode, priority));
    }

    public static void register(Object bus) {
        BusUtils.getInstance().registerInner(bus);
    }

    public static void unregister(Object bus) {
        BusUtils.getInstance().unregisterInner(bus);
    }

    public static void post(String tag) {
        BusUtils.post(tag, NULL);
    }

    public static void post(String tag, Object arg) {
        BusUtils.getInstance().postInner(tag, arg);
    }

    public static void postSticky(String tag) {
        BusUtils.postSticky(tag, NULL);
    }

    public static void postSticky(String tag, Object arg) {
        BusUtils.getInstance().postStickyInner(tag, arg);
    }

    public static void removeSticky(String tag) {
        BusUtils.getInstance().removeStickyInner(tag);
    }

    public static String toString_() {
        return BusUtils.getInstance().toString();
    }

    public String toString() {
        return "BusUtils: " + this.mTag_BusInfoListMap;
    }

    private static BusUtils getInstance() {
        return LazyHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInner(Object bus) {
        if (bus == null) {
            return;
        }
        Class<?> aClass = bus.getClass();
        String className = aClass.getName();
        boolean isNeedRecordTags = false;
        Map<String, Set<Object>> map = this.mClassName_BusesMap;
        synchronized (map) {
            Set<Object> buses = this.mClassName_BusesMap.get(className);
            if (buses == null) {
                buses = new CopyOnWriteArraySet<Object>();
                this.mClassName_BusesMap.put(className, buses);
                isNeedRecordTags = true;
            }
            if (buses.contains(bus)) {
                Log.w((String)TAG, (String)("The bus of <" + bus + "> already registered."));
                return;
            }
            buses.add(bus);
        }
        if (isNeedRecordTags) {
            this.recordTags(aClass, className);
        }
        this.consumeStickyIfExist(bus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTags(Class<?> aClass, String className) {
        List<String> tags = this.mClassName_TagsMap.get(className);
        if (tags == null) {
            Map<String, List<String>> map = this.mClassName_TagsMap;
            synchronized (map) {
                tags = this.mClassName_TagsMap.get(className);
                if (tags == null) {
                    tags = new CopyOnWriteArrayList<String>();
                    for (Map.Entry<String, List<BusInfo>> entry : this.mTag_BusInfoListMap.entrySet()) {
                        for (BusInfo busInfo : entry.getValue()) {
                            try {
                                if (!Class.forName(busInfo.className).isAssignableFrom(aClass)) continue;
                                tags.add(entry.getKey());
                                busInfo.subClassNames.add(className);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    this.mClassName_TagsMap.put(className, tags);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeStickyIfExist(Object bus) {
        Map<String, Object> tagArgMap = this.mClassName_Tag_Arg4StickyMap.get(bus.getClass().getName());
        if (tagArgMap == null) {
            return;
        }
        Map<String, Map<String, Object>> map = this.mClassName_Tag_Arg4StickyMap;
        synchronized (map) {
            for (Map.Entry<String, Object> tagArgEntry : tagArgMap.entrySet()) {
                this.consumeSticky(bus, tagArgEntry.getKey(), tagArgEntry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeSticky(Object bus, String tag, Object arg) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            Log.e((String)TAG, (String)("The bus of tag <" + tag + "> is not exists."));
            return;
        }
        for (BusInfo busInfo : busInfoList) {
            if (!busInfo.subClassNames.contains(bus.getClass().getName()) || !busInfo.sticky) continue;
            Map<String, Map<String, Object>> map = this.mClassName_Tag_Arg4StickyMap;
            synchronized (map) {
                Map<String, Object> tagArgMap = this.mClassName_Tag_Arg4StickyMap.get(busInfo.className);
                if (tagArgMap == null || !tagArgMap.containsKey(tag)) {
                    continue;
                }
                this.invokeBus(bus, arg, busInfo, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInner(Object bus) {
        if (bus == null) {
            return;
        }
        String className = bus.getClass().getName();
        Map<String, Set<Object>> map = this.mClassName_BusesMap;
        synchronized (map) {
            Set<Object> buses = this.mClassName_BusesMap.get(className);
            if (buses == null || !buses.contains(bus)) {
                Log.e((String)TAG, (String)("The bus of <" + bus + "> was not registered before."));
                return;
            }
            buses.remove(bus);
        }
    }

    private void postInner(String tag, Object arg) {
        this.postInner(tag, arg, false);
    }

    private void postInner(String tag, Object arg, boolean sticky) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            Log.e((String)TAG, (String)("The bus of tag <" + tag + "> is not exists."));
            if (this.mTag_BusInfoListMap.isEmpty()) {
                Log.e((String)TAG, (String)"Please check whether the bus plugin is applied.");
            }
            return;
        }
        for (BusInfo busInfo : busInfoList) {
            this.invokeBus(arg, busInfo, sticky);
        }
    }

    private void invokeBus(Object arg, BusInfo busInfo, boolean sticky) {
        this.invokeBus(null, arg, busInfo, sticky);
    }

    private void invokeBus(Object bus, Object arg, BusInfo busInfo, boolean sticky) {
        if (busInfo.method == null) {
            Method method = this.getMethodByBusInfo(busInfo);
            if (method == null) {
                return;
            }
            busInfo.method = method;
        }
        this.invokeMethod(bus, arg, busInfo, sticky);
    }

    private Method getMethodByBusInfo(BusInfo busInfo) {
        try {
            if ("".equals(busInfo.paramType)) {
                return Class.forName(busInfo.className).getDeclaredMethod(busInfo.funName, new Class[0]);
            }
            return Class.forName(busInfo.className).getDeclaredMethod(busInfo.funName, this.getClassName(busInfo.paramType));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Class getClassName(String paramType) throws ClassNotFoundException {
        switch (paramType) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        return Class.forName(paramType);
    }

    private void invokeMethod(Object arg, BusInfo busInfo, boolean sticky) {
        this.invokeMethod(null, arg, busInfo, sticky);
    }

    private void invokeMethod(final Object bus, final Object arg, final BusInfo busInfo, final boolean sticky) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BusUtils.this.realInvokeMethod(bus, arg, busInfo, sticky);
            }
        };
        switch (busInfo.threadMode) {
            case "MAIN": {
                ThreadUtils.runOnUiThread(runnable);
                return;
            }
            case "IO": {
                ThreadUtils.getIoPool().execute(runnable);
                return;
            }
            case "CPU": {
                ThreadUtils.getCpuPool().execute(runnable);
                return;
            }
            case "CACHED": {
                ThreadUtils.getCachedPool().execute(runnable);
                return;
            }
            case "SINGLE": {
                ThreadUtils.getSinglePool().execute(runnable);
                return;
            }
        }
        runnable.run();
    }

    private void realInvokeMethod(Object bus, Object arg, BusInfo busInfo, boolean sticky) {
        HashSet<Object> buses = new HashSet<Object>();
        if (bus == null) {
            for (String subClassName : busInfo.subClassNames) {
                Set<Object> subBuses = this.mClassName_BusesMap.get(subClassName);
                if (subBuses == null || subBuses.isEmpty()) continue;
                buses.addAll(subBuses);
            }
            if (buses.size() == 0) {
                if (!sticky) {
                    Log.e((String)TAG, (String)("The " + busInfo + " was not registered before."));
                }
                return;
            }
        } else {
            buses.add(bus);
        }
        this.invokeBuses(arg, busInfo, buses);
    }

    private void invokeBuses(Object arg, BusInfo busInfo, Set<Object> buses) {
        try {
            if (arg == NULL) {
                for (Object bus : buses) {
                    busInfo.method.invoke(bus, new Object[0]);
                }
            } else {
                for (Object bus : buses) {
                    busInfo.method.invoke(bus, arg);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postStickyInner(String tag, Object arg) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            Log.e((String)TAG, (String)("The bus of tag <" + tag + "> is not exists."));
            return;
        }
        for (BusInfo busInfo : busInfoList) {
            if (!busInfo.sticky) {
                this.invokeBus(arg, busInfo, false);
                continue;
            }
            Map<String, Map<String, Object>> map = this.mClassName_Tag_Arg4StickyMap;
            synchronized (map) {
                Map<String, Object> tagArgMap = this.mClassName_Tag_Arg4StickyMap.get(busInfo.className);
                if (tagArgMap == null) {
                    tagArgMap = new ConcurrentHashMap<String, Object>();
                    this.mClassName_Tag_Arg4StickyMap.put(busInfo.className, tagArgMap);
                }
                tagArgMap.put(tag, arg);
            }
            this.invokeBus(arg, busInfo, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStickyInner(String tag) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            Log.e((String)TAG, (String)("The bus of tag <" + tag + "> is not exists."));
            return;
        }
        for (BusInfo busInfo : busInfoList) {
            if (!busInfo.sticky) continue;
            Map<String, Map<String, Object>> map = this.mClassName_Tag_Arg4StickyMap;
            synchronized (map) {
                Map<String, Object> tagArgMap = this.mClassName_Tag_Arg4StickyMap.get(busInfo.className);
                if (tagArgMap == null || !tagArgMap.containsKey(tag)) {
                    return;
                }
                tagArgMap.remove(tag);
            }
        }
    }

    static void registerBus4Test(String tag, String className, String funName, String paramType, String paramName, boolean sticky, String threadMode, int priority) {
        BusUtils.getInstance().registerBus(tag, className, funName, paramType, paramName, sticky, threadMode, priority);
    }

    private static class LazyHolder {
        private static final BusUtils INSTANCE = new BusUtils();

        private LazyHolder() {
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Bus {
        public String tag();

        public boolean sticky() default false;

        public ThreadMode threadMode() default ThreadMode.POSTING;

        public int priority() default 0;
    }

    public static enum ThreadMode {
        MAIN,
        IO,
        CPU,
        CACHED,
        SINGLE,
        POSTING;

    }

    private static final class BusInfo {
        String tag;
        String className;
        String funName;
        String paramType;
        String paramName;
        boolean sticky;
        String threadMode;
        int priority;
        Method method;
        List<String> subClassNames;

        BusInfo(String tag, String className, String funName, String paramType, String paramName, boolean sticky, String threadMode, int priority) {
            this.tag = tag;
            this.className = className;
            this.funName = funName;
            this.paramType = paramType;
            this.paramName = paramName;
            this.sticky = sticky;
            this.threadMode = threadMode;
            this.priority = priority;
            this.subClassNames = new CopyOnWriteArrayList<String>();
        }

        public String toString() {
            return "BusInfo { tag : " + this.tag + ", desc: " + this.getDesc() + ", sticky: " + this.sticky + ", threadMode: " + this.threadMode + ", method: " + this.method + ", priority: " + this.priority + " }";
        }

        private String getDesc() {
            return this.className + "#" + this.funName + ("".equals(this.paramType) ? "()" : "(" + this.paramType + " " + this.paramName + ")");
        }
    }
}

