/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MaskFilterSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.text.style.UpdateAppearance;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.blankj.utilcode.util.Utils;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public final class SpanUtils {
    private static final int COLOR_DEFAULT = -16777217;
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_TOP = 3;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private TextView mTextView;
    private CharSequence mText = "";
    private int flag;
    private int foregroundColor;
    private int backgroundColor;
    private int lineHeight;
    private int alignLine;
    private int quoteColor;
    private int stripeWidth;
    private int quoteGapWidth;
    private int first;
    private int rest;
    private int bulletColor;
    private int bulletRadius;
    private int bulletGapWidth;
    private int fontSize;
    private boolean fontSizeIsDp;
    private float proportion;
    private float xProportion;
    private boolean isStrikethrough;
    private boolean isUnderline;
    private boolean isSuperscript;
    private boolean isSubscript;
    private boolean isBold;
    private boolean isItalic;
    private boolean isBoldItalic;
    private String fontFamily;
    private Typeface typeface;
    private Layout.Alignment alignment;
    private int verticalAlign;
    private ClickableSpan clickSpan;
    private String url;
    private float blurRadius;
    private BlurMaskFilter.Blur style;
    private Shader shader;
    private float shadowRadius;
    private float shadowDx;
    private float shadowDy;
    private int shadowColor;
    private Object[] spans;
    private Bitmap imageBitmap;
    private Drawable imageDrawable;
    private Uri imageUri;
    private int imageResourceId;
    private int alignImage;
    private int spaceSize;
    private int spaceColor;
    private SerializableSpannableStringBuilder mBuilder = new SerializableSpannableStringBuilder();
    private boolean isCreated;
    private int mType = -1;
    private final int mTypeCharSequence = 0;
    private final int mTypeImage = 1;
    private final int mTypeSpace = 2;

    public static SpanUtils with(TextView textView) {
        return new SpanUtils(textView);
    }

    private SpanUtils(TextView textView) {
        this();
        this.mTextView = textView;
    }

    public SpanUtils() {
        this.setDefault();
    }

    private void setDefault() {
        this.flag = 33;
        this.foregroundColor = -16777217;
        this.backgroundColor = -16777217;
        this.lineHeight = -1;
        this.quoteColor = -16777217;
        this.first = -1;
        this.bulletColor = -16777217;
        this.fontSize = -1;
        this.proportion = -1.0f;
        this.xProportion = -1.0f;
        this.isStrikethrough = false;
        this.isUnderline = false;
        this.isSuperscript = false;
        this.isSubscript = false;
        this.isBold = false;
        this.isItalic = false;
        this.isBoldItalic = false;
        this.fontFamily = null;
        this.typeface = null;
        this.alignment = null;
        this.verticalAlign = -1;
        this.clickSpan = null;
        this.url = null;
        this.blurRadius = -1.0f;
        this.shader = null;
        this.shadowRadius = -1.0f;
        this.spans = null;
        this.imageBitmap = null;
        this.imageDrawable = null;
        this.imageUri = null;
        this.imageResourceId = -1;
        this.spaceSize = -1;
    }

    public SpanUtils setFlag(int flag) {
        this.flag = flag;
        return this;
    }

    public SpanUtils setForegroundColor(@ColorInt int color) {
        this.foregroundColor = color;
        return this;
    }

    public SpanUtils setBackgroundColor(@ColorInt int color) {
        this.backgroundColor = color;
        return this;
    }

    public SpanUtils setLineHeight(@IntRange(from=0L) int lineHeight) {
        return this.setLineHeight(lineHeight, 2);
    }

    public SpanUtils setLineHeight(@IntRange(from=0L) int lineHeight, int align) {
        this.lineHeight = lineHeight;
        this.alignLine = align;
        return this;
    }

    public SpanUtils setQuoteColor(@ColorInt int color) {
        return this.setQuoteColor(color, 2, 2);
    }

    public SpanUtils setQuoteColor(@ColorInt int color, @IntRange(from=1L) int stripeWidth, @IntRange(from=0L) int gapWidth) {
        this.quoteColor = color;
        this.stripeWidth = stripeWidth;
        this.quoteGapWidth = gapWidth;
        return this;
    }

    public SpanUtils setLeadingMargin(@IntRange(from=0L) int first, @IntRange(from=0L) int rest) {
        this.first = first;
        this.rest = rest;
        return this;
    }

    public SpanUtils setBullet(@IntRange(from=0L) int gapWidth) {
        return this.setBullet(0, 3, gapWidth);
    }

    public SpanUtils setBullet(@ColorInt int color, @IntRange(from=0L) int radius, @IntRange(from=0L) int gapWidth) {
        this.bulletColor = color;
        this.bulletRadius = radius;
        this.bulletGapWidth = gapWidth;
        return this;
    }

    public SpanUtils setFontSize(@IntRange(from=0L) int size) {
        return this.setFontSize(size, false);
    }

    public SpanUtils setFontSize(@IntRange(from=0L) int size, boolean isSp) {
        this.fontSize = size;
        this.fontSizeIsDp = isSp;
        return this;
    }

    public SpanUtils setFontProportion(float proportion) {
        this.proportion = proportion;
        return this;
    }

    public SpanUtils setFontXProportion(float proportion) {
        this.xProportion = proportion;
        return this;
    }

    public SpanUtils setStrikethrough() {
        this.isStrikethrough = true;
        return this;
    }

    public SpanUtils setUnderline() {
        this.isUnderline = true;
        return this;
    }

    public SpanUtils setSuperscript() {
        this.isSuperscript = true;
        return this;
    }

    public SpanUtils setSubscript() {
        this.isSubscript = true;
        return this;
    }

    public SpanUtils setBold() {
        this.isBold = true;
        return this;
    }

    public SpanUtils setItalic() {
        this.isItalic = true;
        return this;
    }

    public SpanUtils setBoldItalic() {
        this.isBoldItalic = true;
        return this;
    }

    public SpanUtils setFontFamily(@NonNull String fontFamily) {
        if (fontFamily == null) {
            throw new NullPointerException("Argument 'fontFamily' of type String (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.fontFamily = fontFamily;
        return this;
    }

    public SpanUtils setTypeface(@NonNull Typeface typeface) {
        if (typeface == null) {
            throw new NullPointerException("Argument 'typeface' of type Typeface (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.typeface = typeface;
        return this;
    }

    public SpanUtils setHorizontalAlign(@NonNull Layout.Alignment alignment) {
        if (alignment == null) {
            throw new NullPointerException("Argument 'alignment' of type Alignment (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.alignment = alignment;
        return this;
    }

    public SpanUtils setVerticalAlign(int align) {
        this.verticalAlign = align;
        return this;
    }

    public SpanUtils setClickSpan(@NonNull ClickableSpan clickSpan) {
        if (clickSpan == null) {
            throw new NullPointerException("Argument 'clickSpan' of type ClickableSpan (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (this.mTextView != null && this.mTextView.getMovementMethod() == null) {
            this.mTextView.setMovementMethod(LinkMovementMethod.getInstance());
        }
        this.clickSpan = clickSpan;
        return this;
    }

    public SpanUtils setClickSpan(final @ColorInt int color, final boolean underlineText, final View.OnClickListener listener) {
        if (this.mTextView != null && this.mTextView.getMovementMethod() == null) {
            this.mTextView.setMovementMethod(LinkMovementMethod.getInstance());
        }
        this.clickSpan = new ClickableSpan(){

            public void updateDrawState(@NonNull TextPaint paint) {
                if (paint == null) {
                    throw new NullPointerException("Argument 'paint' of type TextPaint (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
                }
                paint.setColor(color);
                paint.setUnderlineText(underlineText);
            }

            public void onClick(@NonNull View widget) {
                if (widget == null) {
                    throw new NullPointerException("Argument 'widget' of type View (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
                }
                if (listener != null) {
                    listener.onClick(widget);
                }
            }
        };
        return this;
    }

    public SpanUtils setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("Argument 'url' of type String (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (this.mTextView != null && this.mTextView.getMovementMethod() == null) {
            this.mTextView.setMovementMethod(LinkMovementMethod.getInstance());
        }
        this.url = url;
        return this;
    }

    public SpanUtils setBlur(@FloatRange(from=0.0, fromInclusive=false) float radius, BlurMaskFilter.Blur style) {
        this.blurRadius = radius;
        this.style = style;
        return this;
    }

    public SpanUtils setShader(@NonNull Shader shader) {
        if (shader == null) {
            throw new NullPointerException("Argument 'shader' of type Shader (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.shader = shader;
        return this;
    }

    public SpanUtils setShadow(@FloatRange(from=0.0, fromInclusive=false) float radius, float dx, float dy, int shadowColor) {
        this.shadowRadius = radius;
        this.shadowDx = dx;
        this.shadowDy = dy;
        this.shadowColor = shadowColor;
        return this;
    }

    public SpanUtils setSpans(Object ... spans) {
        if (spans == null) {
            throw new NullPointerException("Argument 'spans' of type Object[] (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (spans.length > 0) {
            this.spans = spans;
        }
        return this;
    }

    public SpanUtils append(@NonNull CharSequence text) {
        if (text == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.apply(0);
        this.mText = text;
        return this;
    }

    public SpanUtils appendLine() {
        this.apply(0);
        this.mText = LINE_SEPARATOR;
        return this;
    }

    public SpanUtils appendLine(@NonNull CharSequence text) {
        if (text == null) {
            throw new NullPointerException("Argument 'text' of type CharSequence (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.apply(0);
        this.mText = text + LINE_SEPARATOR;
        return this;
    }

    public SpanUtils appendImage(@NonNull Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("Argument 'bitmap' of type Bitmap (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return this.appendImage(bitmap, 0);
    }

    public SpanUtils appendImage(@NonNull Bitmap bitmap, int align) {
        if (bitmap == null) {
            throw new NullPointerException("Argument 'bitmap' of type Bitmap (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.apply(1);
        this.imageBitmap = bitmap;
        this.alignImage = align;
        return this;
    }

    public SpanUtils appendImage(@NonNull Drawable drawable) {
        if (drawable == null) {
            throw new NullPointerException("Argument 'drawable' of type Drawable (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return this.appendImage(drawable, 0);
    }

    public SpanUtils appendImage(@NonNull Drawable drawable, int align) {
        if (drawable == null) {
            throw new NullPointerException("Argument 'drawable' of type Drawable (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.apply(1);
        this.imageDrawable = drawable;
        this.alignImage = align;
        return this;
    }

    public SpanUtils appendImage(@NonNull Uri uri) {
        if (uri == null) {
            throw new NullPointerException("Argument 'uri' of type Uri (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return this.appendImage(uri, 0);
    }

    public SpanUtils appendImage(@NonNull Uri uri, int align) {
        if (uri == null) {
            throw new NullPointerException("Argument 'uri' of type Uri (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.apply(1);
        this.imageUri = uri;
        this.alignImage = align;
        return this;
    }

    public SpanUtils appendImage(@DrawableRes int resourceId) {
        return this.appendImage(resourceId, 0);
    }

    public SpanUtils appendImage(@DrawableRes int resourceId, int align) {
        this.apply(1);
        this.imageResourceId = resourceId;
        this.alignImage = align;
        return this;
    }

    public SpanUtils appendSpace(@IntRange(from=0L) int size) {
        return this.appendSpace(size, 0);
    }

    public SpanUtils appendSpace(@IntRange(from=0L) int size, @ColorInt int color) {
        this.apply(2);
        this.spaceSize = size;
        this.spaceColor = color;
        return this;
    }

    private void apply(int type) {
        this.applyLast();
        this.mType = type;
    }

    public SpannableStringBuilder get() {
        return this.mBuilder;
    }

    public SpannableStringBuilder create() {
        this.applyLast();
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)((Object)this.mBuilder));
        }
        this.isCreated = true;
        return this.mBuilder;
    }

    private void applyLast() {
        if (this.isCreated) {
            return;
        }
        if (this.mType == 0) {
            this.updateCharCharSequence();
        } else if (this.mType == 1) {
            this.updateImage();
        } else if (this.mType == 2) {
            this.updateSpace();
        }
        this.setDefault();
    }

    private void updateCharCharSequence() {
        if (this.mText.length() == 0) {
            return;
        }
        int start = this.mBuilder.length();
        if (start == 0 && this.lineHeight != -1) {
            this.mBuilder.append(Character.toString('\u0002')).append((CharSequence)"\n").setSpan((Object)new AbsoluteSizeSpan(0), 0, 2, 33);
            start = 2;
        }
        this.mBuilder.append(this.mText);
        int end = this.mBuilder.length();
        if (this.verticalAlign != -1) {
            this.mBuilder.setSpan((Object)new VerticalAlignSpan(this.verticalAlign), start, end, this.flag);
        }
        if (this.foregroundColor != -16777217) {
            this.mBuilder.setSpan(new ForegroundColorSpan(this.foregroundColor), start, end, this.flag);
        }
        if (this.backgroundColor != -16777217) {
            this.mBuilder.setSpan(new BackgroundColorSpan(this.backgroundColor), start, end, this.flag);
        }
        if (this.first != -1) {
            this.mBuilder.setSpan(new LeadingMarginSpan.Standard(this.first, this.rest), start, end, this.flag);
        }
        if (this.quoteColor != -16777217) {
            this.mBuilder.setSpan(new CustomQuoteSpan(this.quoteColor, this.stripeWidth, this.quoteGapWidth), start, end, this.flag);
        }
        if (this.bulletColor != -16777217) {
            this.mBuilder.setSpan(new CustomBulletSpan(this.bulletColor, this.bulletRadius, this.bulletGapWidth), start, end, this.flag);
        }
        if (this.fontSize != -1) {
            this.mBuilder.setSpan(new AbsoluteSizeSpan(this.fontSize, this.fontSizeIsDp), start, end, this.flag);
        }
        if (this.proportion != -1.0f) {
            this.mBuilder.setSpan(new RelativeSizeSpan(this.proportion), start, end, this.flag);
        }
        if (this.xProportion != -1.0f) {
            this.mBuilder.setSpan(new ScaleXSpan(this.xProportion), start, end, this.flag);
        }
        if (this.lineHeight != -1) {
            this.mBuilder.setSpan(new CustomLineHeightSpan(this.lineHeight, this.alignLine), start, end, this.flag);
        }
        if (this.isStrikethrough) {
            this.mBuilder.setSpan(new StrikethroughSpan(), start, end, this.flag);
        }
        if (this.isUnderline) {
            this.mBuilder.setSpan(new UnderlineSpan(), start, end, this.flag);
        }
        if (this.isSuperscript) {
            this.mBuilder.setSpan(new SuperscriptSpan(), start, end, this.flag);
        }
        if (this.isSubscript) {
            this.mBuilder.setSpan(new SubscriptSpan(), start, end, this.flag);
        }
        if (this.isBold) {
            this.mBuilder.setSpan(new StyleSpan(1), start, end, this.flag);
        }
        if (this.isItalic) {
            this.mBuilder.setSpan(new StyleSpan(2), start, end, this.flag);
        }
        if (this.isBoldItalic) {
            this.mBuilder.setSpan(new StyleSpan(3), start, end, this.flag);
        }
        if (this.fontFamily != null) {
            this.mBuilder.setSpan(new TypefaceSpan(this.fontFamily), start, end, this.flag);
        }
        if (this.typeface != null) {
            this.mBuilder.setSpan((Object)new CustomTypefaceSpan(this.typeface), start, end, this.flag);
        }
        if (this.alignment != null) {
            this.mBuilder.setSpan(new AlignmentSpan.Standard(this.alignment), start, end, this.flag);
        }
        if (this.clickSpan != null) {
            this.mBuilder.setSpan(this.clickSpan, start, end, this.flag);
        }
        if (this.url != null) {
            this.mBuilder.setSpan(new URLSpan(this.url), start, end, this.flag);
        }
        if (this.blurRadius != -1.0f) {
            this.mBuilder.setSpan(new MaskFilterSpan((MaskFilter)new BlurMaskFilter(this.blurRadius, this.style)), start, end, this.flag);
        }
        if (this.shader != null) {
            this.mBuilder.setSpan((Object)new ShaderSpan(this.shader), start, end, this.flag);
        }
        if (this.shadowRadius != -1.0f) {
            this.mBuilder.setSpan((Object)new ShadowSpan(this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor), start, end, this.flag);
        }
        if (this.spans != null) {
            for (Object span : this.spans) {
                this.mBuilder.setSpan(span, start, end, this.flag);
            }
        }
    }

    private void updateImage() {
        int start = this.mBuilder.length();
        this.mText = "<img>";
        this.updateCharCharSequence();
        int end = this.mBuilder.length();
        if (this.imageBitmap != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageBitmap, this.alignImage), start, end, this.flag);
        } else if (this.imageDrawable != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageDrawable, this.alignImage), start, end, this.flag);
        } else if (this.imageUri != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageUri, this.alignImage), start, end, this.flag);
        } else if (this.imageResourceId != -1) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageResourceId, this.alignImage), start, end, this.flag);
        }
    }

    private void updateSpace() {
        int start = this.mBuilder.length();
        this.mText = "< >";
        this.updateCharCharSequence();
        int end = this.mBuilder.length();
        this.mBuilder.setSpan((Object)new SpaceSpan(this.spaceSize, this.spaceColor), start, end, this.flag);
    }

    private static class SerializableSpannableStringBuilder
    extends SpannableStringBuilder
    implements Serializable {
        private static final long serialVersionUID = 4909567650765875771L;

        private SerializableSpannableStringBuilder() {
        }
    }

    static class ShadowSpan
    extends CharacterStyle
    implements UpdateAppearance {
        private float radius;
        private float dx;
        private float dy;
        private int shadowColor;

        private ShadowSpan(float radius, float dx, float dy, int shadowColor) {
            this.radius = radius;
            this.dx = dx;
            this.dy = dy;
            this.shadowColor = shadowColor;
        }

        public void updateDrawState(TextPaint tp) {
            tp.setShadowLayer(this.radius, this.dx, this.dy, this.shadowColor);
        }
    }

    static class ShaderSpan
    extends CharacterStyle
    implements UpdateAppearance {
        private Shader mShader;

        private ShaderSpan(Shader shader) {
            this.mShader = shader;
        }

        public void updateDrawState(TextPaint tp) {
            tp.setShader(this.mShader);
        }
    }

    static abstract class CustomDynamicDrawableSpan
    extends ReplacementSpan {
        static final int ALIGN_BOTTOM = 0;
        static final int ALIGN_BASELINE = 1;
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;
        private WeakReference<Drawable> mDrawableRef;

        private CustomDynamicDrawableSpan() {
            this.mVerticalAlignment = 0;
        }

        private CustomDynamicDrawableSpan(int verticalAlignment) {
            this.mVerticalAlignment = verticalAlignment;
        }

        public abstract Drawable getDrawable();

        public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
            int lineHeight;
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            Drawable d = this.getCachedDrawable();
            Rect rect = d.getBounds();
            if (fm != null && (lineHeight = fm.bottom - fm.top) < rect.height()) {
                if (this.mVerticalAlignment == 3) {
                    fm.top = fm.top;
                    fm.bottom = rect.height() + fm.top;
                } else if (this.mVerticalAlignment == 2) {
                    fm.top = -rect.height() / 2 - lineHeight / 4;
                    fm.bottom = rect.height() / 2 - lineHeight / 4;
                } else {
                    fm.top = -rect.height() + fm.bottom;
                    fm.bottom = fm.bottom;
                }
                fm.ascent = fm.top;
                fm.descent = fm.bottom;
            }
            return rect.right;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            if (canvas == null) {
                throw new NullPointerException("Argument 'canvas' of type Canvas (#0 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#8 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            Drawable d = this.getCachedDrawable();
            Rect rect = d.getBounds();
            canvas.save();
            int lineHeight = bottom - top;
            if (rect.height() < lineHeight) {
                float transY = this.mVerticalAlignment == 3 ? (float)top : (this.mVerticalAlignment == 2 ? (float)((bottom + top - rect.height()) / 2) : (this.mVerticalAlignment == 1 ? (float)(y - rect.height()) : (float)(bottom - rect.height())));
                canvas.translate(x, transY);
            } else {
                canvas.translate(x, (float)top);
            }
            d.draw(canvas);
            canvas.restore();
        }

        private Drawable getCachedDrawable() {
            WeakReference<Drawable> wr = this.mDrawableRef;
            Drawable d = null;
            if (wr != null) {
                d = (Drawable)wr.get();
            }
            if (d == null) {
                d = this.getDrawable();
                this.mDrawableRef = new WeakReference<Drawable>(d);
            }
            return d;
        }
    }

    static class CustomImageSpan
    extends CustomDynamicDrawableSpan {
        private Drawable mDrawable;
        private Uri mContentUri;
        private int mResourceId;

        private CustomImageSpan(Bitmap b, int verticalAlignment) {
            super(verticalAlignment);
            this.mDrawable = new BitmapDrawable(Utils.getApp().getResources(), b);
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        private CustomImageSpan(Drawable d, int verticalAlignment) {
            super(verticalAlignment);
            this.mDrawable = d;
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        private CustomImageSpan(Uri uri, int verticalAlignment) {
            super(verticalAlignment);
            this.mContentUri = uri;
        }

        private CustomImageSpan(@DrawableRes int resourceId, int verticalAlignment) {
            super(verticalAlignment);
            this.mResourceId = resourceId;
        }

        @Override
        public Drawable getDrawable() {
            Drawable drawable = null;
            if (this.mDrawable != null) {
                drawable = this.mDrawable;
            } else if (this.mContentUri != null) {
                try {
                    InputStream is = Utils.getApp().getContentResolver().openInputStream(this.mContentUri);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
                    drawable = new BitmapDrawable(Utils.getApp().getResources(), bitmap);
                    drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    Log.e((String)"sms", (String)("Failed to loaded content " + this.mContentUri), (Throwable)e);
                }
            } else {
                try {
                    drawable = ContextCompat.getDrawable((Context)Utils.getApp(), (int)this.mResourceId);
                    drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
                }
                catch (Exception e) {
                    Log.e((String)"sms", (String)("Unable to find resource: " + this.mResourceId));
                }
            }
            return drawable;
        }
    }

    @SuppressLint(value={"ParcelCreator"})
    static class CustomTypefaceSpan
    extends TypefaceSpan {
        private final Typeface newType;

        private CustomTypefaceSpan(Typeface type) {
            super("");
            this.newType = type;
        }

        public void updateDrawState(TextPaint textPaint) {
            this.apply((Paint)textPaint, this.newType);
        }

        public void updateMeasureState(TextPaint paint) {
            this.apply((Paint)paint, this.newType);
        }

        private void apply(Paint paint, Typeface tf) {
            Typeface old = paint.getTypeface();
            int oldStyle = old == null ? 0 : old.getStyle();
            int fake = oldStyle & ~tf.getStyle();
            if ((fake & 1) != 0) {
                paint.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                paint.setTextSkewX(-0.25f);
            }
            paint.getShader();
            paint.setTypeface(tf);
        }
    }

    static class CustomBulletSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int radius;
        private final int gapWidth;
        private Path sBulletPath = null;

        private CustomBulletSpan(int color, int radius, int gapWidth) {
            this.color = color;
            this.radius = radius;
            this.gapWidth = gapWidth;
        }

        public int getLeadingMargin(boolean first) {
            return 2 * this.radius + this.gapWidth;
        }

        public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
            if (((Spanned)text).getSpanStart((Object)this) == start) {
                Paint.Style style = p.getStyle();
                int oldColor = 0;
                oldColor = p.getColor();
                p.setColor(this.color);
                p.setStyle(Paint.Style.FILL);
                if (c.isHardwareAccelerated()) {
                    if (this.sBulletPath == null) {
                        this.sBulletPath = new Path();
                        this.sBulletPath.addCircle(0.0f, 0.0f, (float)this.radius, Path.Direction.CW);
                    }
                    c.save();
                    c.translate((float)(x + dir * this.radius), (float)(top + bottom) / 2.0f);
                    c.drawPath(this.sBulletPath, p);
                    c.restore();
                } else {
                    c.drawCircle((float)(x + dir * this.radius), (float)(top + bottom) / 2.0f, (float)this.radius, p);
                }
                p.setColor(oldColor);
                p.setStyle(style);
            }
        }
    }

    static class CustomQuoteSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int stripeWidth;
        private final int gapWidth;

        private CustomQuoteSpan(int color, int stripeWidth, int gapWidth) {
            this.color = color;
            this.stripeWidth = stripeWidth;
            this.gapWidth = gapWidth;
        }

        public int getLeadingMargin(boolean first) {
            return this.stripeWidth + this.gapWidth;
        }

        public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
            Paint.Style style = p.getStyle();
            int color = p.getColor();
            p.setStyle(Paint.Style.FILL);
            p.setColor(this.color);
            c.drawRect((float)x, (float)top, (float)(x + dir * this.stripeWidth), (float)bottom, p);
            p.setStyle(style);
            p.setColor(color);
        }
    }

    static class SpaceSpan
    extends ReplacementSpan {
        private final int width;
        private final Paint paint = new Paint();

        private SpaceSpan(int width) {
            this(width, 0);
        }

        private SpaceSpan(int width, int color) {
            this.width = width;
            this.paint.setColor(color);
            this.paint.setStyle(Paint.Style.FILL);
        }

        public int getSize(@NonNull Paint paint, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fm) {
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            return this.width;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            if (canvas == null) {
                throw new NullPointerException("Argument 'canvas' of type Canvas (#0 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#8 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            canvas.drawRect(x, (float)top, x + (float)this.width, (float)bottom, this.paint);
        }
    }

    static class CustomLineHeightSpan
    implements LineHeightSpan {
        private final int height;
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;
        static Paint.FontMetricsInt sfm;

        CustomLineHeightSpan(int height, int verticalAlignment) {
            this.height = height;
            this.mVerticalAlignment = verticalAlignment;
        }

        public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm) {
            if (sfm == null) {
                sfm = new Paint.FontMetricsInt();
                CustomLineHeightSpan.sfm.top = fm.top;
                CustomLineHeightSpan.sfm.ascent = fm.ascent;
                CustomLineHeightSpan.sfm.descent = fm.descent;
                CustomLineHeightSpan.sfm.bottom = fm.bottom;
                CustomLineHeightSpan.sfm.leading = fm.leading;
            } else {
                fm.top = CustomLineHeightSpan.sfm.top;
                fm.ascent = CustomLineHeightSpan.sfm.ascent;
                fm.descent = CustomLineHeightSpan.sfm.descent;
                fm.bottom = CustomLineHeightSpan.sfm.bottom;
                fm.leading = CustomLineHeightSpan.sfm.leading;
            }
            int need = this.height - (v + fm.descent - fm.ascent - spanstartv);
            if (need > 0) {
                if (this.mVerticalAlignment == 3) {
                    fm.descent += need;
                } else if (this.mVerticalAlignment == 2) {
                    fm.descent += need / 2;
                    fm.ascent -= need / 2;
                } else {
                    fm.ascent -= need;
                }
            }
            if ((need = this.height - (v + fm.bottom - fm.top - spanstartv)) > 0) {
                if (this.mVerticalAlignment == 3) {
                    fm.bottom += need;
                } else if (this.mVerticalAlignment == 2) {
                    fm.bottom += need / 2;
                    fm.top -= need / 2;
                } else {
                    fm.top -= need;
                }
            }
            if (end == ((Spanned)text).getSpanEnd((Object)this)) {
                sfm = null;
            }
        }
    }

    static class VerticalAlignSpan
    extends ReplacementSpan {
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;

        VerticalAlignSpan(int verticalAlignment) {
            this.mVerticalAlignment = verticalAlignment;
        }

        public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            text = text.subSequence(start, end);
            return (int)paint.measureText(text.toString());
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            if (canvas == null) {
                throw new NullPointerException("Argument 'canvas' of type Canvas (#0 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            if (paint == null) {
                throw new NullPointerException("Argument 'paint' of type Paint (#8 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
            }
            text = text.subSequence(start, end);
            Paint.FontMetricsInt fm = paint.getFontMetricsInt();
            canvas.drawText(text.toString(), x, (float)(y - ((y + fm.descent + y + fm.ascent) / 2 - (bottom + top) / 2)), paint);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Align {
    }
}

