/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.blankj.utilcode.constant.PermissionConstants;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import com.blankj.utilcode.util.UtilsTransActivity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class PermissionUtils {
    private static PermissionUtils sInstance;
    private String[] mPermissionsParam;
    private OnRationaleListener mOnRationaleListener;
    private SimpleCallback mSimpleCallback;
    private FullCallback mFullCallback;
    private ThemeCallback mThemeCallback;
    private Set<String> mPermissions;
    private List<String> mPermissionsRequest;
    private List<String> mPermissionsGranted;
    private List<String> mPermissionsDenied;
    private List<String> mPermissionsDeniedForever;
    private static SimpleCallback sSimpleCallback4WriteSettings;
    private static SimpleCallback sSimpleCallback4DrawOverlays;

    public static List<String> getPermissions() {
        return PermissionUtils.getPermissions(Utils.getApp().getPackageName());
    }

    public static List<String> getPermissions(String packageName) {
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            String[] permissions = pm.getPackageInfo((String)packageName, (int)4096).requestedPermissions;
            if (permissions == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(permissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static boolean isGranted(String ... permissions) {
        for (String permission2 : permissions) {
            if (PermissionUtils.isGranted(permission2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGranted(String permission2) {
        return Build.VERSION.SDK_INT < 23 || 0 == ContextCompat.checkSelfPermission((Context)Utils.getApp(), (String)permission2);
    }

    @RequiresApi(api=23)
    public static boolean isGrantedWriteSettings() {
        return Settings.System.canWrite((Context)Utils.getApp());
    }

    @RequiresApi(api=23)
    public static void requestWriteSettings(SimpleCallback callback) {
        if (PermissionUtils.isGrantedWriteSettings()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        sSimpleCallback4WriteSettings = callback;
        PermissionActivityImpl.start(2);
    }

    @TargetApi(value=23)
    private static void startWriteSettingsActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        if (!UtilsBridge.isIntentAvailable(intent)) {
            PermissionUtils.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    @RequiresApi(api=23)
    public static boolean isGrantedDrawOverlays() {
        return Settings.canDrawOverlays((Context)Utils.getApp());
    }

    @RequiresApi(api=23)
    public static void requestDrawOverlays(SimpleCallback callback) {
        if (PermissionUtils.isGrantedDrawOverlays()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        sSimpleCallback4DrawOverlays = callback;
        PermissionActivityImpl.start(3);
    }

    @TargetApi(value=23)
    private static void startOverlayPermissionActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        if (!UtilsBridge.isIntentAvailable(intent)) {
            PermissionUtils.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public static void launchAppDetailsSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        if (!UtilsBridge.isIntentAvailable(intent)) {
            return;
        }
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    public static PermissionUtils permission(String ... permissions) {
        return new PermissionUtils(permissions);
    }

    private PermissionUtils(String ... permissions) {
        this.mPermissionsParam = permissions;
        sInstance = this;
    }

    public PermissionUtils rationale(OnRationaleListener listener) {
        this.mOnRationaleListener = listener;
        return this;
    }

    public PermissionUtils callback(SimpleCallback callback) {
        this.mSimpleCallback = callback;
        return this;
    }

    public PermissionUtils callback(FullCallback callback) {
        this.mFullCallback = callback;
        return this;
    }

    public PermissionUtils theme(ThemeCallback callback) {
        this.mThemeCallback = callback;
        return this;
    }

    public void request() {
        if (this.mPermissionsParam == null || this.mPermissionsParam.length <= 0) {
            Log.e((String)"PermissionUtils", (String)"No permissions to request.");
            return;
        }
        this.mPermissions = new LinkedHashSet<String>();
        this.mPermissionsRequest = new ArrayList<String>();
        this.mPermissionsGranted = new ArrayList<String>();
        this.mPermissionsDenied = new ArrayList<String>();
        this.mPermissionsDeniedForever = new ArrayList<String>();
        List<String> appPermissions = PermissionUtils.getPermissions();
        for (String param : this.mPermissionsParam) {
            String[] permissions;
            boolean isIncludeInManifest = false;
            for (String permission2 : permissions = PermissionConstants.getPermissions(param)) {
                if (!appPermissions.contains(permission2)) continue;
                this.mPermissions.add(permission2);
                isIncludeInManifest = true;
            }
            if (isIncludeInManifest) continue;
            this.mPermissionsDenied.add(param);
            Log.e((String)"PermissionUtils", (String)("U should add the permission of " + param + " in manifest."));
        }
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionsGranted.addAll(this.mPermissions);
            this.requestCallback();
        } else {
            for (String permission3 : this.mPermissions) {
                if (PermissionUtils.isGranted(permission3)) {
                    this.mPermissionsGranted.add(permission3);
                    continue;
                }
                this.mPermissionsRequest.add(permission3);
            }
            if (this.mPermissionsRequest.isEmpty()) {
                this.requestCallback();
            } else {
                this.startPermissionActivity();
            }
        }
    }

    @RequiresApi(api=23)
    private void startPermissionActivity() {
        PermissionActivityImpl.start(1);
    }

    @RequiresApi(api=23)
    private boolean shouldRationale(UtilsTransActivity activity, Runnable againRunnable) {
        boolean isRationale = false;
        if (this.mOnRationaleListener != null) {
            for (String permission2 : this.mPermissionsRequest) {
                if (!activity.shouldShowRequestPermissionRationale(permission2)) continue;
                this.rationalInner(activity, againRunnable);
                isRationale = true;
                break;
            }
            this.mOnRationaleListener = null;
        }
        return isRationale;
    }

    private void rationalInner(final UtilsTransActivity activity, final Runnable againRunnable) {
        this.getPermissionsStatus((Activity)activity);
        this.mOnRationaleListener.rationale(activity, new OnRationaleListener.ShouldRequest(){

            @Override
            public void again(boolean again) {
                if (again) {
                    PermissionUtils.this.mPermissionsDenied = new ArrayList();
                    PermissionUtils.this.mPermissionsDeniedForever = new ArrayList();
                    againRunnable.run();
                } else {
                    activity.finish();
                    PermissionUtils.this.requestCallback();
                }
            }
        });
    }

    private void getPermissionsStatus(Activity activity) {
        for (String permission2 : this.mPermissionsRequest) {
            if (PermissionUtils.isGranted(permission2)) {
                this.mPermissionsGranted.add(permission2);
                continue;
            }
            this.mPermissionsDenied.add(permission2);
            if (activity.shouldShowRequestPermissionRationale(permission2)) continue;
            this.mPermissionsDeniedForever.add(permission2);
        }
    }

    private void requestCallback() {
        if (this.mSimpleCallback != null) {
            if (this.mPermissionsDenied.isEmpty()) {
                this.mSimpleCallback.onGranted();
            } else {
                this.mSimpleCallback.onDenied();
            }
            this.mSimpleCallback = null;
        }
        if (this.mFullCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissionsGranted.size() > 0) {
                this.mFullCallback.onGranted(this.mPermissionsGranted);
            }
            if (!this.mPermissionsDenied.isEmpty()) {
                this.mFullCallback.onDenied(this.mPermissionsDeniedForever, this.mPermissionsDenied);
            }
            this.mFullCallback = null;
        }
        this.mOnRationaleListener = null;
        this.mThemeCallback = null;
    }

    private void onRequestPermissionsResult(Activity activity) {
        this.getPermissionsStatus(activity);
        this.requestCallback();
    }

    public static interface ThemeCallback {
        public void onActivityCreate(Activity var1);
    }

    public static interface FullCallback {
        public void onGranted(List<String> var1);

        public void onDenied(List<String> var1, List<String> var2);
    }

    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    public static interface OnRationaleListener {
        public void rationale(UtilsTransActivity var1, ShouldRequest var2);

        public static interface ShouldRequest {
            public void again(boolean var1);
        }
    }

    @RequiresApi(api=23)
    static final class PermissionActivityImpl
    extends UtilsTransActivity.TransActivityDelegate {
        private static final String TYPE = "TYPE";
        private static final int TYPE_RUNTIME = 1;
        private static final int TYPE_WRITE_SETTINGS = 2;
        private static final int TYPE_DRAW_OVERLAYS = 3;
        private static PermissionActivityImpl INSTANCE = new PermissionActivityImpl();

        PermissionActivityImpl() {
        }

        public static void start(final int type) {
            UtilsTransActivity.start(new Utils.Consumer<Intent>(){

                @Override
                public void accept(Intent data) {
                    data.putExtra(PermissionActivityImpl.TYPE, type);
                }
            }, (UtilsTransActivity.TransActivityDelegate)INSTANCE);
        }

        @Override
        public void onCreated(final UtilsTransActivity activity, @Nullable Bundle savedInstanceState) {
            activity.getWindow().addFlags(262160);
            int type = activity.getIntent().getIntExtra(TYPE, -1);
            if (type == 1) {
                if (sInstance == null) {
                    Log.e((String)"PermissionUtils", (String)"request permissions failed");
                    activity.finish();
                    return;
                }
                if (sInstance.mThemeCallback != null) {
                    sInstance.mThemeCallback.onActivityCreate((Activity)activity);
                }
                if (sInstance.shouldRationale(activity, new Runnable(){

                    @Override
                    public void run() {
                        PermissionActivityImpl.this.requestPermissions((Activity)activity);
                    }
                })) {
                    return;
                }
                this.requestPermissions((Activity)activity);
            } else if (type == 2) {
                PermissionUtils.startWriteSettingsActivity((Activity)activity, 2);
            } else if (type == 3) {
                PermissionUtils.startOverlayPermissionActivity((Activity)activity, 3);
            } else {
                activity.finish();
                Log.e((String)"PermissionUtils", (String)"type is wrong.");
            }
        }

        private void requestPermissions(Activity activity) {
            if (sInstance.mPermissionsRequest != null) {
                int size = sInstance.mPermissionsRequest.size();
                if (size <= 0) {
                    activity.finish();
                    return;
                }
                activity.requestPermissions(sInstance.mPermissionsRequest.toArray(new String[size]), 1);
            }
        }

        @Override
        public void onRequestPermissionsResult(UtilsTransActivity activity, int requestCode, String[] permissions, int[] grantResults) {
            if (sInstance != null && sInstance.mPermissionsRequest != null) {
                sInstance.onRequestPermissionsResult((Activity)activity);
            }
            activity.finish();
        }

        @Override
        public boolean dispatchTouchEvent(UtilsTransActivity activity, MotionEvent ev) {
            activity.finish();
            return true;
        }

        @Override
        public void onActivityResult(UtilsTransActivity activity, int requestCode, int resultCode, Intent data) {
            if (requestCode == 2) {
                if (sSimpleCallback4WriteSettings == null) {
                    return;
                }
                if (PermissionUtils.isGrantedWriteSettings()) {
                    sSimpleCallback4WriteSettings.onGranted();
                } else {
                    sSimpleCallback4WriteSettings.onDenied();
                }
                sSimpleCallback4WriteSettings = null;
            } else if (requestCode == 3) {
                if (sSimpleCallback4DrawOverlays == null) {
                    return;
                }
                UtilsBridge.runOnUiThreadDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (PermissionUtils.isGrantedDrawOverlays()) {
                            sSimpleCallback4DrawOverlays.onGranted();
                        } else {
                            sSimpleCallback4DrawOverlays.onDenied();
                        }
                        sSimpleCallback4DrawOverlays = null;
                    }
                }, 100L);
            }
            activity.finish();
        }
    }
}

