/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.util.Log;
import com.blankj.utilcode.util.ThreadUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public final class BusUtils {
    private static final Object NULL = "nULl";
    private static final String TAG = "BusUtils";
    private final Map<String, List<BusInfo>> mTag_BusInfoListMap = new HashMap<String, List<BusInfo>>();
    private final Map<String, Set<Object>> mClassName_BusesMap = new ConcurrentHashMap<String, Set<Object>>();
    private final Map<String, List<String>> mClassName_TagsMap = new HashMap<String, List<String>>();
    private final Map<String, Map<String, Object>> mClassName_Tag_Arg4StickyMap = new ConcurrentHashMap<String, Map<String, Object>>();

    private BusUtils() {
        this.init();
    }

    private void init() {
    }

    private void registerBus(String tag, String className, String funName, String paramType, String paramName, boolean sticky, String threadMode) {
        this.registerBus(tag, className, funName, paramType, paramName, sticky, threadMode, 0);
    }

    private void registerBus(String tag, String className, String funName, String paramType, String paramName, boolean sticky, String threadMode, int priority) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            busInfoList = new ArrayList<BusInfo>();
            this.mTag_BusInfoListMap.put(tag, busInfoList);
        }
        busInfoList.add(new BusInfo(className, funName, paramType, paramName, sticky, threadMode, priority));
    }

    public static void register(Object bus) {
        BusUtils.getInstance().registerInner(bus);
    }

    public static void unregister(Object bus) {
        BusUtils.getInstance().unregisterInner(bus);
    }

    public static void post(String tag) {
        BusUtils.post(tag, NULL);
    }

    public static void post(String tag, Object arg) {
        BusUtils.getInstance().postInner(tag, arg);
    }

    public static void postSticky(String tag) {
        BusUtils.postSticky(tag, NULL);
    }

    public static void postSticky(String tag, Object arg) {
        BusUtils.getInstance().postStickyInner(tag, arg);
    }

    public static void removeSticky(String tag) {
        BusUtils.getInstance().removeStickyInner(tag);
    }

    public static String toString_() {
        return BusUtils.getInstance().toString();
    }

    public String toString() {
        return "BusUtils: " + this.mTag_BusInfoListMap;
    }

    private static BusUtils getInstance() {
        return LazyHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInner(Object bus) {
        if (bus == null) {
            return;
        }
        Class<?> aClass = bus.getClass();
        String className = aClass.getName();
        Map<String, Set<Object>> map = this.mClassName_BusesMap;
        synchronized (map) {
            Set<Object> buses = this.mClassName_BusesMap.get(className);
            if (buses == null) {
                buses = new CopyOnWriteArraySet<Object>();
                this.mClassName_BusesMap.put(className, buses);
            }
            buses.add(bus);
        }
        List<String> tags = this.mClassName_TagsMap.get(className);
        if (tags == null) {
            Map<String, List<String>> map2 = this.mClassName_TagsMap;
            synchronized (map2) {
                tags = this.mClassName_TagsMap.get(className);
                if (tags == null) {
                    tags = new ArrayList<String>();
                    for (Map.Entry<String, List<BusInfo>> entry : this.mTag_BusInfoListMap.entrySet()) {
                        for (BusInfo busInfo : entry.getValue()) {
                            try {
                                if (!Class.forName(busInfo.className).isAssignableFrom(aClass)) continue;
                                tags.add(entry.getKey());
                                busInfo.subClassNames.add(className);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    this.mClassName_TagsMap.put(className, tags);
                }
            }
        }
        this.processSticky(bus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSticky(Object bus) {
        Map<String, Object> tagArgMap = this.mClassName_Tag_Arg4StickyMap.get(bus.getClass().getName());
        if (tagArgMap == null) {
            return;
        }
        Map<String, Map<String, Object>> map = this.mClassName_Tag_Arg4StickyMap;
        synchronized (map) {
            for (Map.Entry<String, Object> tagArgEntry : tagArgMap.entrySet()) {
                this.postInner(tagArgEntry.getKey(), tagArgEntry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInner(Object bus) {
        if (bus == null) {
            return;
        }
        String className = bus.getClass().getName();
        Map<String, Set<Object>> map = this.mClassName_BusesMap;
        synchronized (map) {
            Set<Object> buses = this.mClassName_BusesMap.get(className);
            if (buses == null || !buses.contains(bus)) {
                Log.e((String)TAG, (String)("The bus of <" + bus + "> was not registered before."));
                return;
            }
            buses.remove(bus);
        }
    }

    private void postInner(String tag, Object arg) {
        this.postInner(tag, arg, false);
    }

    private void postInner(String tag, Object arg, boolean sticky) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            Log.e((String)TAG, (String)("The bus of tag <" + tag + "> is not exists."));
            return;
        }
        for (BusInfo busInfo : busInfoList) {
            if (busInfo.method == null) {
                Method method = this.getMethodByBusInfo(busInfo);
                if (method == null) {
                    return;
                }
                busInfo.method = method;
            }
            this.invokeMethod(tag, arg, busInfo, sticky);
        }
    }

    private Method getMethodByBusInfo(BusInfo busInfo) {
        try {
            if ("".equals(busInfo.paramType)) {
                return Class.forName(busInfo.className).getDeclaredMethod(busInfo.funName, new Class[0]);
            }
            return Class.forName(busInfo.className).getDeclaredMethod(busInfo.funName, this.getClassName(busInfo.paramType));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Class getClassName(String paramType) throws ClassNotFoundException {
        switch (paramType) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        return Class.forName(paramType);
    }

    private void invokeMethod(final String tag, final Object arg, final BusInfo busInfo, final boolean sticky) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BusUtils.this.realInvokeMethod(tag, arg, busInfo, sticky);
            }
        };
        switch (busInfo.threadMode) {
            case "MAIN": {
                ThreadUtils.runOnUiThread(runnable);
                return;
            }
            case "IO": {
                ThreadUtils.getIoPool().execute(runnable);
                return;
            }
            case "CPU": {
                ThreadUtils.getCpuPool().execute(runnable);
                return;
            }
            case "CACHED": {
                ThreadUtils.getCachedPool().execute(runnable);
                return;
            }
            case "SINGLE": {
                ThreadUtils.getSinglePool().execute(runnable);
                return;
            }
        }
        runnable.run();
    }

    private void realInvokeMethod(String tag, Object arg, BusInfo busInfo, boolean sticky) {
        HashSet<Object> buses = new HashSet<Object>();
        for (String string : busInfo.subClassNames) {
            Set<Object> subBuses = this.mClassName_BusesMap.get(string);
            if (subBuses == null || subBuses.isEmpty()) continue;
            buses.addAll(subBuses);
        }
        if (buses.size() == 0) {
            if (!sticky) {
                Log.e((String)TAG, (String)("The bus of tag <" + tag + "> was not registered before."));
                return;
            }
            return;
        }
        try {
            if (arg == NULL) {
                for (String string : buses) {
                    busInfo.method.invoke((Object)string, new Object[0]);
                }
            } else {
                for (String string : buses) {
                    busInfo.method.invoke((Object)string, arg);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postStickyInner(String tag, Object arg) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            Log.e((String)TAG, (String)("The bus of tag <" + tag + "> is not exists."));
            return;
        }
        for (BusInfo busInfo : busInfoList) {
            if (!busInfo.sticky) {
                this.postInner(tag, arg);
                return;
            }
            Map<String, Map<String, Object>> map = this.mClassName_Tag_Arg4StickyMap;
            synchronized (map) {
                Map<String, Object> tagArgMap = this.mClassName_Tag_Arg4StickyMap.get(busInfo.className);
                if (tagArgMap == null) {
                    tagArgMap = new HashMap<String, Object>();
                    this.mClassName_Tag_Arg4StickyMap.put(busInfo.className, tagArgMap);
                }
                tagArgMap.put(tag, arg);
            }
            this.postInner(tag, arg, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStickyInner(String tag) {
        List<BusInfo> busInfoList = this.mTag_BusInfoListMap.get(tag);
        if (busInfoList == null) {
            Log.e((String)TAG, (String)("The bus of tag <" + tag + "> is not exists."));
            return;
        }
        for (BusInfo busInfo : busInfoList) {
            if (!busInfo.sticky) {
                Log.e((String)TAG, (String)("The bus of tag <" + tag + "> is not sticky."));
                return;
            }
            Map<String, Map<String, Object>> map = this.mClassName_Tag_Arg4StickyMap;
            synchronized (map) {
                Map<String, Object> tagArgMap = this.mClassName_Tag_Arg4StickyMap.get(busInfo.className);
                if (tagArgMap == null || !tagArgMap.containsKey(tag)) {
                    Log.e((String)TAG, (String)("The sticky bus of tag <" + tag + "> didn't post."));
                    return;
                }
                tagArgMap.remove(tag);
            }
        }
    }

    static void registerBus4Test(String tag, String className, String funName, String paramType, String paramName, boolean sticky, String threadMode, int priority) {
        BusUtils.getInstance().registerBus(tag, className, funName, paramType, paramName, sticky, threadMode, priority);
    }

    private static class LazyHolder {
        private static final BusUtils INSTANCE = new BusUtils();

        private LazyHolder() {
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Bus {
        public String tag();

        public boolean sticky() default false;

        public ThreadMode threadMode() default ThreadMode.POSTING;

        public int priority() default 0;
    }

    public static enum ThreadMode {
        MAIN,
        IO,
        CPU,
        CACHED,
        SINGLE,
        POSTING;

    }

    private static final class BusInfo {
        String className;
        String funName;
        String paramType;
        String paramName;
        boolean sticky;
        String threadMode;
        int priority;
        Method method;
        List<String> subClassNames;

        BusInfo(String className, String funName, String paramType, String paramName, boolean sticky, String threadMode, int priority) {
            this.className = className;
            this.funName = funName;
            this.paramType = paramType;
            this.paramName = paramName;
            this.sticky = sticky;
            this.threadMode = threadMode;
            this.priority = priority;
            this.subClassNames = new CopyOnWriteArrayList<String>();
        }

        public String toString() {
            return "BusInfo { desc: " + this.className + "#" + this.funName + ("".equals(this.paramType) ? "()" : "(" + this.paramType + " " + this.paramName + ")") + ", sticky: " + this.sticky + ", threadMode: " + this.threadMode + ", method: " + this.method + ", priority: " + this.priority + " }";
        }
    }
}

