/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.StateSet;
import android.view.View;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;

public class ShadowUtils {
    private static final int SHADOW_TAG = -16;

    public static void apply(View ... views) {
        if (views == null) {
            return;
        }
        for (View view : views) {
            ShadowUtils.apply(view, new Config());
        }
    }

    public static void apply(View view, Config builder) {
        if (view == null || builder == null) {
            return;
        }
        Drawable background = view.getBackground();
        Object tag = view.getTag(-16);
        if (tag instanceof Drawable) {
            ViewCompat.setBackground((View)view, (Drawable)((Drawable)tag));
        } else {
            background = builder.apply(background);
            ViewCompat.setBackground((View)view, (Drawable)background);
            view.setTag(-16, (Object)background);
        }
    }

    static class DrawableWrapper
    extends Drawable
    implements Drawable.Callback {
        private Drawable mDrawable;

        public DrawableWrapper(Drawable drawable) {
            this.setWrappedDrawable(drawable);
        }

        public void draw(Canvas canvas) {
            this.mDrawable.draw(canvas);
        }

        protected void onBoundsChange(Rect bounds) {
            this.mDrawable.setBounds(bounds);
        }

        public void setChangingConfigurations(int configs) {
            this.mDrawable.setChangingConfigurations(configs);
        }

        public int getChangingConfigurations() {
            return this.mDrawable.getChangingConfigurations();
        }

        public void setDither(boolean dither) {
            this.mDrawable.setDither(dither);
        }

        public void setFilterBitmap(boolean filter) {
            this.mDrawable.setFilterBitmap(filter);
        }

        public void setAlpha(int alpha) {
            this.mDrawable.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter cf) {
            this.mDrawable.setColorFilter(cf);
        }

        public boolean isStateful() {
            return this.mDrawable.isStateful();
        }

        public boolean setState(int[] stateSet) {
            return this.mDrawable.setState(stateSet);
        }

        public int[] getState() {
            return this.mDrawable.getState();
        }

        public void jumpToCurrentState() {
            DrawableCompat.jumpToCurrentState((Drawable)this.mDrawable);
        }

        public Drawable getCurrent() {
            return this.mDrawable.getCurrent();
        }

        public boolean setVisible(boolean visible, boolean restart) {
            return super.setVisible(visible, restart) || this.mDrawable.setVisible(visible, restart);
        }

        public int getOpacity() {
            return this.mDrawable.getOpacity();
        }

        public Region getTransparentRegion() {
            return this.mDrawable.getTransparentRegion();
        }

        public int getIntrinsicWidth() {
            return this.mDrawable.getIntrinsicWidth();
        }

        public int getIntrinsicHeight() {
            return this.mDrawable.getIntrinsicHeight();
        }

        public int getMinimumWidth() {
            return this.mDrawable.getMinimumWidth();
        }

        public int getMinimumHeight() {
            return this.mDrawable.getMinimumHeight();
        }

        public boolean getPadding(Rect padding) {
            return this.mDrawable.getPadding(padding);
        }

        public void invalidateDrawable(Drawable who) {
            this.invalidateSelf();
        }

        public void scheduleDrawable(Drawable who, Runnable what, long when) {
            this.scheduleSelf(what, when);
        }

        public void unscheduleDrawable(Drawable who, Runnable what) {
            this.unscheduleSelf(what);
        }

        protected boolean onLevelChange(int level) {
            return this.mDrawable.setLevel(level);
        }

        public void setAutoMirrored(boolean mirrored) {
            DrawableCompat.setAutoMirrored((Drawable)this.mDrawable, (boolean)mirrored);
        }

        public boolean isAutoMirrored() {
            return DrawableCompat.isAutoMirrored((Drawable)this.mDrawable);
        }

        public void setTint(int tint) {
            DrawableCompat.setTint((Drawable)this.mDrawable, (int)tint);
        }

        public void setTintList(ColorStateList tint) {
            DrawableCompat.setTintList((Drawable)this.mDrawable, (ColorStateList)tint);
        }

        public void setTintMode(PorterDuff.Mode tintMode) {
            DrawableCompat.setTintMode((Drawable)this.mDrawable, (PorterDuff.Mode)tintMode);
        }

        public void setHotspot(float x, float y) {
            DrawableCompat.setHotspot((Drawable)this.mDrawable, (float)x, (float)y);
        }

        public void setHotspotBounds(int left, int top, int right, int bottom) {
            DrawableCompat.setHotspotBounds((Drawable)this.mDrawable, (int)left, (int)top, (int)right, (int)bottom);
        }

        public Drawable getWrappedDrawable() {
            return this.mDrawable;
        }

        public void setWrappedDrawable(Drawable drawable) {
            if (this.mDrawable != null) {
                this.mDrawable.setCallback((Drawable.Callback)null);
            }
            this.mDrawable = drawable;
            if (drawable != null) {
                drawable.setCallback((Drawable.Callback)this);
            }
        }
    }

    public static class ShadowDrawable
    extends DrawableWrapper {
        private static final double COS_45 = Math.cos(Math.toRadians(45.0));
        private float mShadowMultiplier = 1.0f;
        private float mShadowTopScale = 1.0f;
        private float mShadowHorizScale = 1.0f;
        private float mShadowBottomScale = 1.0f;
        private Paint mCornerShadowPaint;
        private Paint mEdgeShadowPaint;
        private RectF mContentBounds;
        private float mCornerRadius;
        private Path mCornerShadowPath;
        private float mMaxShadowSize;
        private float mRawMaxShadowSize;
        private float mShadowSize;
        private float mRawShadowSize;
        private boolean mDirty = true;
        private final int mShadowStartColor;
        private final int mShadowEndColor;
        private boolean mAddPaddingForCorners = false;
        private float mRotation;
        private boolean isCircle;

        public ShadowDrawable(Drawable content, float radius, float shadowSize, float maxShadowSize, int shadowColor, boolean isCircle) {
            super(content);
            this.mShadowStartColor = shadowColor;
            this.mShadowEndColor = 0;
            this.isCircle = isCircle;
            if (isCircle) {
                this.mShadowMultiplier = 1.0f;
                this.mShadowTopScale = 1.0f;
                this.mShadowHorizScale = 1.0f;
                this.mShadowBottomScale = 1.0f;
            }
            this.mCornerShadowPaint = new Paint(5);
            this.mCornerShadowPaint.setStyle(Paint.Style.FILL);
            this.mCornerRadius = Math.round(radius);
            this.mContentBounds = new RectF();
            this.mEdgeShadowPaint = new Paint(this.mCornerShadowPaint);
            this.mEdgeShadowPaint.setAntiAlias(false);
            this.setShadowSize(shadowSize, maxShadowSize);
        }

        private static int toEven(float value) {
            int i = Math.round(value);
            return i % 2 == 1 ? i - 1 : i;
        }

        public void setAddPaddingForCorners(boolean addPaddingForCorners) {
            this.mAddPaddingForCorners = addPaddingForCorners;
            this.invalidateSelf();
        }

        @Override
        public void setAlpha(int alpha) {
            super.setAlpha(alpha);
            this.mCornerShadowPaint.setAlpha(alpha);
            this.mEdgeShadowPaint.setAlpha(alpha);
        }

        @Override
        protected void onBoundsChange(Rect bounds) {
            this.mDirty = true;
        }

        void setShadowSize(float shadowSize, float maxShadowSize) {
            if (shadowSize < 0.0f || maxShadowSize < 0.0f) {
                throw new IllegalArgumentException("invalid shadow size");
            }
            if ((shadowSize = (float)ShadowDrawable.toEven(shadowSize)) > (maxShadowSize = (float)ShadowDrawable.toEven(maxShadowSize))) {
                shadowSize = maxShadowSize;
            }
            if (this.mRawShadowSize == shadowSize && this.mRawMaxShadowSize == maxShadowSize) {
                return;
            }
            this.mRawShadowSize = shadowSize;
            this.mRawMaxShadowSize = maxShadowSize;
            this.mShadowSize = Math.round(shadowSize * this.mShadowMultiplier);
            this.mMaxShadowSize = maxShadowSize;
            this.mDirty = true;
            this.invalidateSelf();
        }

        @Override
        public boolean getPadding(Rect padding) {
            int vOffset = (int)Math.ceil(this.calculateVerticalPadding(this.mRawMaxShadowSize, this.mCornerRadius, this.mAddPaddingForCorners));
            int hOffset = (int)Math.ceil(ShadowDrawable.calculateHorizontalPadding(this.mRawMaxShadowSize, this.mCornerRadius, this.mAddPaddingForCorners));
            padding.set(hOffset, vOffset, hOffset, vOffset);
            return true;
        }

        private float calculateVerticalPadding(float maxShadowSize, float cornerRadius, boolean addPaddingForCorners) {
            if (addPaddingForCorners) {
                return (float)((double)(maxShadowSize * this.mShadowMultiplier) + (1.0 - COS_45) * (double)cornerRadius);
            }
            return maxShadowSize * this.mShadowMultiplier;
        }

        private static float calculateHorizontalPadding(float maxShadowSize, float cornerRadius, boolean addPaddingForCorners) {
            if (addPaddingForCorners) {
                return (float)((double)maxShadowSize + (1.0 - COS_45) * (double)cornerRadius);
            }
            return maxShadowSize;
        }

        @Override
        public int getOpacity() {
            return -3;
        }

        public void setCornerRadius(float radius) {
            if (this.mCornerRadius == (radius = (float)Math.round(radius))) {
                return;
            }
            this.mCornerRadius = radius;
            this.mDirty = true;
            this.invalidateSelf();
        }

        @Override
        public void draw(Canvas canvas) {
            if (this.mDirty) {
                this.buildComponents(this.getBounds());
                this.mDirty = false;
            }
            this.drawShadow(canvas);
            super.draw(canvas);
        }

        final void setRotation(float rotation) {
            if (this.mRotation != rotation) {
                this.mRotation = rotation;
                this.invalidateSelf();
            }
        }

        private void drawShadow(Canvas canvas) {
            if (this.isCircle) {
                int saved = canvas.save();
                canvas.translate(this.mContentBounds.centerX(), this.mContentBounds.centerY());
                canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
                canvas.restoreToCount(saved);
                return;
            }
            int rotateSaved = canvas.save();
            canvas.rotate(this.mRotation, this.mContentBounds.centerX(), this.mContentBounds.centerY());
            float edgeShadowTop = -this.mCornerRadius - this.mShadowSize;
            float shadowOffset = this.mCornerRadius;
            boolean drawHorizontalEdges = this.mContentBounds.width() - 2.0f * shadowOffset > 0.0f;
            boolean drawVerticalEdges = this.mContentBounds.height() - 2.0f * shadowOffset > 0.0f;
            float shadowOffsetTop = this.mRawShadowSize - this.mRawShadowSize * this.mShadowTopScale;
            float shadowOffsetHorizontal = this.mRawShadowSize - this.mRawShadowSize * this.mShadowHorizScale;
            float shadowOffsetBottom = this.mRawShadowSize - this.mRawShadowSize * this.mShadowBottomScale;
            float shadowScaleHorizontal = shadowOffset == 0.0f ? 1.0f : shadowOffset / (shadowOffset + shadowOffsetHorizontal);
            float shadowScaleTop = shadowOffset == 0.0f ? 1.0f : shadowOffset / (shadowOffset + shadowOffsetTop);
            float shadowScaleBottom = shadowOffset == 0.0f ? 1.0f : shadowOffset / (shadowOffset + shadowOffsetBottom);
            int saved = canvas.save();
            canvas.translate(this.mContentBounds.left + shadowOffset, this.mContentBounds.top + shadowOffset);
            canvas.scale(shadowScaleHorizontal, shadowScaleTop);
            canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
            if (drawHorizontalEdges) {
                canvas.scale(1.0f / shadowScaleHorizontal, 1.0f);
                canvas.drawRect(0.0f, edgeShadowTop, this.mContentBounds.width() - 2.0f * shadowOffset, -this.mCornerRadius, this.mEdgeShadowPaint);
            }
            canvas.restoreToCount(saved);
            saved = canvas.save();
            canvas.translate(this.mContentBounds.right - shadowOffset, this.mContentBounds.bottom - shadowOffset);
            canvas.scale(shadowScaleHorizontal, shadowScaleBottom);
            canvas.rotate(180.0f);
            canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
            if (drawHorizontalEdges) {
                canvas.scale(1.0f / shadowScaleHorizontal, 1.0f);
                canvas.drawRect(0.0f, edgeShadowTop, this.mContentBounds.width() - 2.0f * shadowOffset, -this.mCornerRadius, this.mEdgeShadowPaint);
            }
            canvas.restoreToCount(saved);
            saved = canvas.save();
            canvas.translate(this.mContentBounds.left + shadowOffset, this.mContentBounds.bottom - shadowOffset);
            canvas.scale(shadowScaleHorizontal, shadowScaleBottom);
            canvas.rotate(270.0f);
            canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
            if (drawVerticalEdges) {
                canvas.scale(1.0f / shadowScaleBottom, 1.0f);
                canvas.drawRect(0.0f, edgeShadowTop, this.mContentBounds.height() - 2.0f * shadowOffset, -this.mCornerRadius, this.mEdgeShadowPaint);
            }
            canvas.restoreToCount(saved);
            saved = canvas.save();
            canvas.translate(this.mContentBounds.right - shadowOffset, this.mContentBounds.top + shadowOffset);
            canvas.scale(shadowScaleHorizontal, shadowScaleTop);
            canvas.rotate(90.0f);
            canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
            if (drawVerticalEdges) {
                canvas.scale(1.0f / shadowScaleTop, 1.0f);
                canvas.drawRect(0.0f, edgeShadowTop, this.mContentBounds.height() - 2.0f * shadowOffset, -this.mCornerRadius, this.mEdgeShadowPaint);
            }
            canvas.restoreToCount(saved);
            canvas.restoreToCount(rotateSaved);
        }

        private void buildShadowCorners() {
            if (this.isCircle) {
                float size = this.mContentBounds.width() / 2.0f - 1.0f;
                RectF innerBounds = new RectF(-size, -size, size, size);
                RectF outerBounds = new RectF(innerBounds);
                outerBounds.inset(-this.mShadowSize, -this.mShadowSize);
                if (this.mCornerShadowPath == null) {
                    this.mCornerShadowPath = new Path();
                } else {
                    this.mCornerShadowPath.reset();
                }
                this.mCornerShadowPath.setFillType(Path.FillType.EVEN_ODD);
                this.mCornerShadowPath.moveTo(-size, 0.0f);
                this.mCornerShadowPath.rLineTo(-this.mShadowSize, 0.0f);
                this.mCornerShadowPath.arcTo(outerBounds, 180.0f, 180.0f, false);
                this.mCornerShadowPath.arcTo(outerBounds, 360.0f, 180.0f, false);
                this.mCornerShadowPath.arcTo(innerBounds, 540.0f, -180.0f, false);
                this.mCornerShadowPath.arcTo(innerBounds, 360.0f, -180.0f, false);
                this.mCornerShadowPath.close();
                float shadowRadius = -outerBounds.top;
                if (shadowRadius > 0.0f) {
                    float startRatio = size / shadowRadius;
                    this.mCornerShadowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, shadowRadius, new int[]{0, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
                }
                return;
            }
            RectF innerBounds = new RectF(-this.mCornerRadius, -this.mCornerRadius, this.mCornerRadius, this.mCornerRadius);
            RectF outerBounds = new RectF(innerBounds);
            outerBounds.inset(-this.mShadowSize, -this.mShadowSize);
            if (this.mCornerShadowPath == null) {
                this.mCornerShadowPath = new Path();
            } else {
                this.mCornerShadowPath.reset();
            }
            this.mCornerShadowPath.setFillType(Path.FillType.EVEN_ODD);
            this.mCornerShadowPath.moveTo(-this.mCornerRadius, 0.0f);
            this.mCornerShadowPath.rLineTo(-this.mShadowSize, 0.0f);
            this.mCornerShadowPath.arcTo(outerBounds, 180.0f, 90.0f, false);
            this.mCornerShadowPath.arcTo(innerBounds, 270.0f, -90.0f, false);
            this.mCornerShadowPath.close();
            float shadowRadius = -outerBounds.top;
            if (shadowRadius > 0.0f) {
                float startRatio = this.mCornerRadius / shadowRadius;
                this.mCornerShadowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, shadowRadius, new int[]{0, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
            }
            this.mEdgeShadowPaint.setShader((Shader)new LinearGradient(0.0f, innerBounds.top, 0.0f, outerBounds.top, new int[]{this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP));
            this.mEdgeShadowPaint.setAntiAlias(false);
        }

        private void buildComponents(Rect bounds) {
            if (this.isCircle) {
                this.mCornerRadius = bounds.width() / 2;
            }
            float verticalOffset = this.mRawMaxShadowSize * this.mShadowMultiplier;
            this.mContentBounds.set((float)bounds.left + this.mRawMaxShadowSize, (float)bounds.top + verticalOffset, (float)bounds.right - this.mRawMaxShadowSize, (float)bounds.bottom - verticalOffset);
            this.getWrappedDrawable().setBounds((int)this.mContentBounds.left, (int)this.mContentBounds.top, (int)this.mContentBounds.right, (int)this.mContentBounds.bottom);
            this.buildShadowCorners();
        }

        public float getCornerRadius() {
            return this.mCornerRadius;
        }

        public void setShadowSize(float size) {
            this.setShadowSize(size, this.mRawMaxShadowSize);
        }

        public void setMaxShadowSize(float size) {
            this.setShadowSize(this.mRawShadowSize, size);
        }

        public float getShadowSize() {
            return this.mRawShadowSize;
        }

        public float getMaxShadowSize() {
            return this.mRawMaxShadowSize;
        }

        public float getMinWidth() {
            float content = 2.0f * Math.max(this.mRawMaxShadowSize, this.mCornerRadius + this.mRawMaxShadowSize / 2.0f);
            return content + this.mRawMaxShadowSize * 2.0f;
        }

        public float getMinHeight() {
            float content = 2.0f * Math.max(this.mRawMaxShadowSize, this.mCornerRadius + this.mRawMaxShadowSize * this.mShadowMultiplier / 2.0f);
            return content + this.mRawMaxShadowSize * this.mShadowMultiplier * 2.0f;
        }
    }

    public static class Config {
        private static final int SHADOW_COLOR_DEFAULT = -1342177280;
        private static final int SHADOW_SIZE = Config.dp2px(8.0f);
        private float mShadowRadius = -1.0f;
        private float mShadowSizeNormal = -1.0f;
        private float mShadowSizePressed = -1.0f;
        private float mShadowMaxSizeNormal = -1.0f;
        private float mShadowMaxSizePressed = -1.0f;
        private int mShadowColorNormal = -1342177280;
        private int mShadowColorPressed = -1342177280;
        private boolean isCircle = false;

        public Config setShadowRadius(float radius) {
            this.mShadowRadius = radius;
            if (this.isCircle) {
                throw new IllegalArgumentException("Set circle needn't set radius.");
            }
            return this;
        }

        public Config setCircle() {
            this.isCircle = true;
            if (this.mShadowRadius != -1.0f) {
                throw new IllegalArgumentException("Set circle needn't set radius.");
            }
            return this;
        }

        public Config setShadowSize(int size) {
            return this.setShadowSize(size, size);
        }

        public Config setShadowSize(int sizeNormal, int sizePressed) {
            this.mShadowSizeNormal = sizeNormal;
            this.mShadowSizePressed = sizePressed;
            return this;
        }

        public Config setShadowMaxSize(int maxSize) {
            return this.setShadowMaxSize(maxSize, maxSize);
        }

        public Config setShadowMaxSize(int maxSizeNormal, int maxSizePressed) {
            this.mShadowMaxSizeNormal = maxSizeNormal;
            this.mShadowMaxSizePressed = maxSizePressed;
            return this;
        }

        public Config setShadowColor(int color) {
            return this.setShadowColor(color, color);
        }

        public Config setShadowColor(int colorNormal, int colorPressed) {
            this.mShadowColorNormal = colorNormal;
            this.mShadowColorPressed = colorPressed;
            return this;
        }

        Drawable apply(Drawable src) {
            if (src == null) {
                src = new ColorDrawable(0);
            }
            StateListDrawable drawable = new StateListDrawable();
            drawable.addState(new int[]{16842919}, (Drawable)new ShadowDrawable(src, this.getShadowRadius(), this.getShadowSizeNormal(), this.getShadowMaxSizeNormal(), this.mShadowColorPressed, this.isCircle));
            drawable.addState(StateSet.WILD_CARD, (Drawable)new ShadowDrawable(src, this.getShadowRadius(), this.getShadowSizePressed(), this.getShadowMaxSizePressed(), this.mShadowColorNormal, this.isCircle));
            return drawable;
        }

        private float getShadowRadius() {
            if (this.mShadowRadius == -1.0f) {
                this.mShadowRadius = 0.0f;
            }
            return this.mShadowRadius;
        }

        private float getShadowSizeNormal() {
            if (this.mShadowSizeNormal == -1.0f) {
                this.mShadowSizeNormal = SHADOW_SIZE;
            }
            return this.mShadowSizeNormal;
        }

        private float getShadowSizePressed() {
            if (this.mShadowSizePressed == -1.0f) {
                this.mShadowSizePressed = this.getShadowSizeNormal();
            }
            return this.mShadowSizePressed;
        }

        private float getShadowMaxSizeNormal() {
            if (this.mShadowMaxSizeNormal == -1.0f) {
                this.mShadowMaxSizeNormal = this.getShadowSizeNormal();
            }
            return this.mShadowMaxSizeNormal;
        }

        private float getShadowMaxSizePressed() {
            if (this.mShadowMaxSizePressed == -1.0f) {
                this.mShadowMaxSizePressed = this.getShadowSizePressed();
            }
            return this.mShadowMaxSizePressed;
        }

        private static int dp2px(float dpValue) {
            float scale = Resources.getSystem().getDisplayMetrics().density;
            return (int)(dpValue * scale + 0.5f);
        }
    }
}

