/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private EncryptUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String encryptMD2ToString(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptMD2ToString(data.getBytes());
    }

    public static String encryptMD2ToString(byte[] data) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD2(data));
    }

    public static byte[] encryptMD2(byte[] data) {
        return EncryptUtils.hashTemplate(data, "MD2");
    }

    public static String encryptMD5ToString(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptMD5ToString(data.getBytes());
    }

    public static String encryptMD5ToString(String data, String salt) {
        if (data == null && salt == null) {
            return "";
        }
        if (salt == null) {
            return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(data.getBytes()));
        }
        if (data == null) {
            return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(salt.getBytes()));
        }
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5((data + salt).getBytes()));
    }

    public static String encryptMD5ToString(byte[] data) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(data));
    }

    public static String encryptMD5ToString(byte[] data, byte[] salt) {
        if (data == null && salt == null) {
            return "";
        }
        if (salt == null) {
            return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(data));
        }
        if (data == null) {
            return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(salt));
        }
        byte[] dataSalt = new byte[data.length + salt.length];
        System.arraycopy(data, 0, dataSalt, 0, data.length);
        System.arraycopy(salt, 0, dataSalt, data.length, salt.length);
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(dataSalt));
    }

    public static byte[] encryptMD5(byte[] data) {
        return EncryptUtils.hashTemplate(data, "MD5");
    }

    public static String encryptMD5File2String(String filePath) {
        File file = EncryptUtils.isSpace(filePath) ? null : new File(filePath);
        return EncryptUtils.encryptMD5File2String(file);
    }

    public static byte[] encryptMD5File(String filePath) {
        File file = EncryptUtils.isSpace(filePath) ? null : new File(filePath);
        return EncryptUtils.encryptMD5File(file);
    }

    public static String encryptMD5File2String(File file) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptMD5File(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            md = digestInputStream.getMessageDigest();
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String encryptSHA1ToString(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA1ToString(data.getBytes());
    }

    public static String encryptSHA1ToString(byte[] data) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA1(data));
    }

    public static byte[] encryptSHA1(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA-1");
    }

    public static String encryptSHA224ToString(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA224ToString(data.getBytes());
    }

    public static String encryptSHA224ToString(byte[] data) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA224(data));
    }

    public static byte[] encryptSHA224(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA224");
    }

    public static String encryptSHA256ToString(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA256ToString(data.getBytes());
    }

    public static String encryptSHA256ToString(byte[] data) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA256(data));
    }

    public static byte[] encryptSHA256(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA-256");
    }

    public static String encryptSHA384ToString(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA384ToString(data.getBytes());
    }

    public static String encryptSHA384ToString(byte[] data) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA384(data));
    }

    public static byte[] encryptSHA384(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA-384");
    }

    public static String encryptSHA512ToString(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptSHA512ToString(data.getBytes());
    }

    public static String encryptSHA512ToString(byte[] data) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptSHA512(data));
    }

    public static byte[] encryptSHA512(byte[] data) {
        return EncryptUtils.hashTemplate(data, "SHA-512");
    }

    private static byte[] hashTemplate(byte[] data, String algorithm) {
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptHmacMD5ToString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacMD5ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacMD5ToString(byte[] data, byte[] key) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacMD5(data, key));
    }

    public static byte[] encryptHmacMD5(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacMD5");
    }

    public static String encryptHmacSHA1ToString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA1ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA1ToString(byte[] data, byte[] key) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA1(data, key));
    }

    public static byte[] encryptHmacSHA1(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA1");
    }

    public static String encryptHmacSHA224ToString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA224ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA224ToString(byte[] data, byte[] key) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA224(data, key));
    }

    public static byte[] encryptHmacSHA224(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA224");
    }

    public static String encryptHmacSHA256ToString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA256ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA256ToString(byte[] data, byte[] key) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA256(data, key));
    }

    public static byte[] encryptHmacSHA256(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA256");
    }

    public static String encryptHmacSHA384ToString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA384ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA384ToString(byte[] data, byte[] key) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA384(data, key));
    }

    public static byte[] encryptHmacSHA384(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA384");
    }

    public static String encryptHmacSHA512ToString(String data, String key) {
        if (data == null || data.length() == 0 || key == null || key.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptHmacSHA512ToString(data.getBytes(), key.getBytes());
    }

    public static String encryptHmacSHA512ToString(byte[] data, byte[] key) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptHmacSHA512(data, key));
    }

    public static byte[] encryptHmacSHA512(byte[] data, byte[] key) {
        return EncryptUtils.hmacTemplate(data, key, "HmacSHA512");
    }

    private static byte[] hmacTemplate(byte[] data, byte[] key, String algorithm) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKey);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptDES2Base64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptDES(data, key, transformation, iv));
    }

    public static String encryptDES2HexString(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptDES(data, key, transformation, iv));
    }

    public static byte[] encryptDES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "DES", transformation, iv, true);
    }

    public static byte[] decryptBase64DES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decryptDES(EncryptUtils.base64Decode(data), key, transformation, iv);
    }

    public static byte[] decryptHexStringDES(String data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decryptDES(EncryptUtils.hexString2Bytes(data), key, transformation, iv);
    }

    public static byte[] decryptDES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "DES", transformation, iv, false);
    }

    public static byte[] encrypt3DES2Base64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.base64Encode(EncryptUtils.encrypt3DES(data, key, transformation, iv));
    }

    public static String encrypt3DES2HexString(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encrypt3DES(data, key, transformation, iv));
    }

    public static byte[] encrypt3DES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "DESede", transformation, iv, true);
    }

    public static byte[] decryptBase64_3DES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decrypt3DES(EncryptUtils.base64Decode(data), key, transformation, iv);
    }

    public static byte[] decryptHexString3DES(String data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decrypt3DES(EncryptUtils.hexString2Bytes(data), key, transformation, iv);
    }

    public static byte[] decrypt3DES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "DESede", transformation, iv, false);
    }

    public static byte[] encryptAES2Base64(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptAES(data, key, transformation, iv));
    }

    public static String encryptAES2HexString(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptAES(data, key, transformation, iv));
    }

    public static byte[] encryptAES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "AES", transformation, iv, true);
    }

    public static byte[] decryptBase64AES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decryptAES(EncryptUtils.base64Decode(data), key, transformation, iv);
    }

    public static byte[] decryptHexStringAES(String data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.decryptAES(EncryptUtils.hexString2Bytes(data), key, transformation, iv);
    }

    public static byte[] decryptAES(byte[] data, byte[] key, String transformation, byte[] iv) {
        return EncryptUtils.symmetricTemplate(data, key, "AES", transformation, iv, false);
    }

    private static byte[] symmetricTemplate(byte[] data, byte[] key, String algorithm, String transformation, byte[] iv, boolean isEncrypt) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            SecretKey secretKey;
            if ("DES".equals(algorithm)) {
                DESKeySpec desKey = new DESKeySpec(key);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
                secretKey = keyFactory.generateSecret(desKey);
            } else {
                secretKey = new SecretKeySpec(key, algorithm);
            }
            Cipher cipher = Cipher.getInstance(transformation);
            if (iv == null || iv.length == 0) {
                cipher.init(isEncrypt ? 1 : 2, secretKey);
            } else {
                IvParameterSpec params = new IvParameterSpec(iv);
                cipher.init(isEncrypt ? 1 : 2, (Key)secretKey, params);
            }
            return cipher.doFinal(data);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptRSA2Base64(byte[] data, byte[] publicKey, int keySize, String transformation) {
        return EncryptUtils.base64Encode(EncryptUtils.encryptRSA(data, publicKey, keySize, transformation));
    }

    public static String encryptRSA2HexString(byte[] data, byte[] publicKey, int keySize, String transformation) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptRSA(data, publicKey, keySize, transformation));
    }

    public static byte[] encryptRSA(byte[] data, byte[] publicKey, int keySize, String transformation) {
        return EncryptUtils.rsaTemplate(data, publicKey, keySize, transformation, true);
    }

    public static byte[] decryptBase64RSA(byte[] data, byte[] privateKey, int keySize, String transformation) {
        return EncryptUtils.decryptRSA(EncryptUtils.base64Decode(data), privateKey, keySize, transformation);
    }

    public static byte[] decryptHexStringRSA(String data, byte[] privateKey, int keySize, String transformation) {
        return EncryptUtils.decryptRSA(EncryptUtils.hexString2Bytes(data), privateKey, keySize, transformation);
    }

    public static byte[] decryptRSA(byte[] data, byte[] privateKey, int keySize, String transformation) {
        return EncryptUtils.rsaTemplate(data, privateKey, keySize, transformation, false);
    }

    private static byte[] rsaTemplate(byte[] data, byte[] key, int keySize, String transformation, boolean isEncrypt) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            int count;
            String lowerTrans;
            Key rsaKey;
            EncodedKeySpec keySpec;
            if (isEncrypt) {
                keySpec = new X509EncodedKeySpec(key);
                rsaKey = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            } else {
                keySpec = new PKCS8EncodedKeySpec(key);
                rsaKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
            }
            if (rsaKey == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(isEncrypt ? 1 : 2, rsaKey);
            int len = data.length;
            int maxLen = keySize / 8;
            if (isEncrypt && (lowerTrans = transformation.toLowerCase()).endsWith("pkcs1padding")) {
                maxLen -= 11;
            }
            if ((count = len / maxLen) > 0) {
                byte[] ret = new byte[]{};
                byte[] buff = new byte[maxLen];
                int index = 0;
                for (int i = 0; i < count; ++i) {
                    System.arraycopy(data, index, buff, 0, maxLen);
                    ret = EncryptUtils.joins(ret, cipher.doFinal(buff));
                    index += maxLen;
                }
                if (index != len) {
                    int restLen = len - index;
                    buff = new byte[restLen];
                    System.arraycopy(data, index, buff, 0, restLen);
                    ret = EncryptUtils.joins(ret, cipher.doFinal(buff));
                }
                return ret;
            }
            return cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] rc4(byte[] data, byte[] key) {
        byte tmp;
        if (data == null || data.length == 0 || key == null) {
            return null;
        }
        if (key.length < 1 || key.length > 256) {
            throw new IllegalArgumentException("key must be between 1 and 256 bytes");
        }
        byte[] iS = new byte[256];
        byte[] iK = new byte[256];
        int keyLen = key.length;
        for (int i = 0; i < 256; ++i) {
            iS[i] = (byte)i;
            iK[i] = key[i % keyLen];
        }
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            j = j + iS[i] + iK[i] & 0xFF;
            tmp = iS[j];
            iS[j] = iS[i];
            iS[i] = tmp;
        }
        byte[] ret = new byte[data.length];
        int i = 0;
        for (int counter = 0; counter < data.length; ++counter) {
            i = i + 1 & 0xFF;
            j = j + iS[i] & 0xFF;
            tmp = iS[j];
            iS[j] = iS[i];
            iS[i] = tmp;
            int t = iS[i] + iS[j] & 0xFF;
            byte k = iS[t];
            ret[counter] = (byte)(data[counter] ^ k);
        }
        return ret;
    }

    private static byte[] joins(byte[] prefix, byte[] suffix) {
        byte[] ret = new byte[prefix.length + suffix.length];
        System.arraycopy(prefix, 0, ret, 0, prefix.length);
        System.arraycopy(suffix, 0, ret, prefix.length, suffix.length);
        return ret;
    }

    private static String bytes2HexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >> 4 & 0xF];
            ret[j++] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    private static byte[] hexString2Bytes(String hexString) {
        if (EncryptUtils.isSpace(hexString)) {
            return null;
        }
        int len = hexString.length();
        if (len % 2 != 0) {
            hexString = "0" + hexString;
            ++len;
        }
        char[] hexBytes = hexString.toUpperCase().toCharArray();
        byte[] ret = new byte[len >> 1];
        for (int i = 0; i < len; i += 2) {
            ret[i >> 1] = (byte)(EncryptUtils.hex2Dec(hexBytes[i]) << 4 | EncryptUtils.hex2Dec(hexBytes[i + 1]));
        }
        return ret;
    }

    private static int hex2Dec(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    private static byte[] base64Encode(byte[] input) {
        return Base64.encode((byte[])input, (int)2);
    }

    private static byte[] base64Decode(byte[] input) {
        return Base64.decode((byte[])input, (int)2);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

