/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.blankj.utilcode.util.ThrowableUtils;
import com.blankj.utilcode.util.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class CrashUtils {
    private static String defaultDir;
    private static String dir;
    private static String versionName;
    private static int versionCode;
    private static final String FILE_SEP;
    @SuppressLint(value={"SimpleDateFormat"})
    private static final Format FORMAT;
    private static final Thread.UncaughtExceptionHandler DEFAULT_UNCAUGHT_EXCEPTION_HANDLER;
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER;
    private static OnCrashListener sOnCrashListener;

    private CrashUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @SuppressLint(value={"MissingPermission"})
    public static void init() {
        CrashUtils.init("");
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(@NonNull File crashDir) {
        if (crashDir == null) {
            throw new NullPointerException("Argument 'crashDir' of type File (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        CrashUtils.init(crashDir.getAbsolutePath(), null);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(String crashDirPath) {
        CrashUtils.init(crashDirPath, null);
    }

    @SuppressLint(value={"MissingPermission"})
    public static void init(OnCrashListener onCrashListener) {
        CrashUtils.init("", onCrashListener);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(@NonNull File crashDir, OnCrashListener onCrashListener) {
        if (crashDir == null) {
            throw new NullPointerException("Argument 'crashDir' of type File (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        CrashUtils.init(crashDir.getAbsolutePath(), onCrashListener);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(String crashDirPath, OnCrashListener onCrashListener) {
        dir = CrashUtils.isSpace(crashDirPath) ? null : (crashDirPath.endsWith(FILE_SEP) ? crashDirPath : crashDirPath + FILE_SEP);
        defaultDir = "mounted".equals(Environment.getExternalStorageState()) && Utils.getApp().getExternalCacheDir() != null ? Utils.getApp().getExternalCacheDir() + FILE_SEP + "crash" + FILE_SEP : Utils.getApp().getCacheDir() + FILE_SEP + "crash" + FILE_SEP;
        sOnCrashListener = onCrashListener;
        Thread.setDefaultUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
    }

    private static void input2File(final String input, final String filePath) {
        Future<Boolean> submit = Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, true), "UTF-8"));
                    bw.write(input);
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        try {
            if (submit.get().booleanValue()) {
                return;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        Log.e((String)"CrashUtils", (String)("write crash info to " + filePath + " failed!"));
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!CrashUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        FILE_SEP = System.getProperty("file.separator");
        FORMAT = new SimpleDateFormat("MM-dd_HH-mm-ss");
        try {
            PackageInfo pi = Utils.getApp().getPackageManager().getPackageInfo(Utils.getApp().getPackageName(), 0);
            if (pi != null) {
                versionName = pi.versionName;
                versionCode = pi.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        DEFAULT_UNCAUGHT_EXCEPTION_HANDLER = Thread.getDefaultUncaughtExceptionHandler();
        UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e == null) {
                    if (DEFAULT_UNCAUGHT_EXCEPTION_HANDLER != null) {
                        DEFAULT_UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(t, null);
                    } else {
                        Process.killProcess((int)Process.myPid());
                        System.exit(1);
                    }
                    return;
                }
                String time = FORMAT.format(new Date(System.currentTimeMillis()));
                StringBuilder sb = new StringBuilder();
                String head = "************* Log Head ****************\nTime Of Crash      : " + time + "\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + versionName + "\nApp VersionCode    : " + versionCode + "\n************* Log Head ****************\n\n";
                sb.append(head).append(ThrowableUtils.getFullStackTrace(e));
                String crashInfo = sb.toString();
                String fullPath = (dir == null ? defaultDir : dir) + time + ".txt";
                if (CrashUtils.createOrExistsFile(fullPath)) {
                    CrashUtils.input2File(crashInfo, fullPath);
                } else {
                    Log.e((String)"CrashUtils", (String)("create " + fullPath + " failed!"));
                }
                if (sOnCrashListener != null) {
                    sOnCrashListener.onCrash(crashInfo, e);
                }
                if (DEFAULT_UNCAUGHT_EXCEPTION_HANDLER != null) {
                    DEFAULT_UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(t, e);
                }
            }
        };
    }

    public static interface OnCrashListener {
        public void onCrash(String var1, Throwable var2);
    }
}

