/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import com.blankj.utilcode.util.ShellUtils;
import com.blankj.utilcode.util.Utils;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class AppUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private AppUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void registerAppStatusChangedListener(@NonNull Utils.OnAppStatusChangedListener listener) {
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type Utils.OnAppStatusChangedListener (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        Utils.getActivityLifecycle().addOnAppStatusChangedListener(listener);
    }

    public static void unregisterAppStatusChangedListener(@NonNull Utils.OnAppStatusChangedListener listener) {
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type Utils.OnAppStatusChangedListener (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        Utils.getActivityLifecycle().removeOnAppStatusChangedListener(listener);
    }

    public static void installApp(String filePath) {
        AppUtils.installApp(AppUtils.getFileByPath(filePath));
    }

    public static void installApp(File file) {
        if (!AppUtils.isFileExists(file)) {
            return;
        }
        Utils.getApp().startActivity(AppUtils.getInstallAppIntent(file, true));
    }

    public static void installApp(Activity activity, String filePath, int requestCode) {
        AppUtils.installApp(activity, AppUtils.getFileByPath(filePath), requestCode);
    }

    public static void installApp(Activity activity, File file, int requestCode) {
        if (!AppUtils.isFileExists(file)) {
            return;
        }
        activity.startActivityForResult(AppUtils.getInstallAppIntent(file), requestCode);
    }

    public static void uninstallApp(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        Utils.getApp().startActivity(AppUtils.getUninstallAppIntent(packageName, true));
    }

    public static void uninstallApp(Activity activity, String packageName, int requestCode) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        activity.startActivityForResult(AppUtils.getUninstallAppIntent(packageName), requestCode);
    }

    public static boolean isAppInstalled(@NonNull String pkgName) {
        if (pkgName == null) {
            throw new NullPointerException("Argument 'pkgName' of type String (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        PackageManager packageManager = Utils.getApp().getPackageManager();
        try {
            return packageManager.getApplicationInfo(pkgName, 0) != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAppRoot() {
        ShellUtils.CommandResult result = ShellUtils.execCmd("echo root", true);
        if (result.result == 0) {
            return true;
        }
        if (result.errorMsg != null) {
            Log.d((String)"AppUtils", (String)("isAppRoot() called" + result.errorMsg));
        }
        return false;
    }

    public static boolean isAppDebug() {
        return AppUtils.isAppDebug(Utils.getApp().getPackageName());
    }

    public static boolean isAppDebug(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 2) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAppSystem() {
        return AppUtils.isAppSystem(Utils.getApp().getPackageName());
    }

    public static boolean isAppSystem(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAppForeground() {
        return Utils.isAppForeground();
    }

    public static boolean isAppForeground(@NonNull String packageName) {
        if (packageName == null) {
            throw new NullPointerException("Argument 'packageName' of type String (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return !AppUtils.isSpace(packageName) && packageName.equals(AppUtils.getForegroundProcessName());
    }

    public static boolean isAppRunning(@NonNull String pkgName) {
        int uid;
        if (pkgName == null) {
            throw new NullPointerException("Argument 'pkgName' of type String (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        PackageManager packageManager = Utils.getApp().getPackageManager();
        try {
            ApplicationInfo ai = packageManager.getApplicationInfo(pkgName, 0);
            if (ai == null) {
                return false;
            }
            uid = ai.uid;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (am != null) {
            List serviceInfo;
            List taskInfo = am.getRunningTasks(Integer.MAX_VALUE);
            if (taskInfo != null && taskInfo.size() > 0) {
                for (ActivityManager.RunningTaskInfo aInfo : taskInfo) {
                    if (!pkgName.equals(aInfo.baseActivity.getPackageName())) continue;
                    return true;
                }
            }
            if ((serviceInfo = am.getRunningServices(Integer.MAX_VALUE)) != null && serviceInfo.size() > 0) {
                for (ActivityManager.RunningServiceInfo aInfo : serviceInfo) {
                    if (uid != aInfo.uid) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void launchApp(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        Intent launchAppIntent = AppUtils.getLaunchAppIntent(packageName, true);
        if (launchAppIntent == null) {
            Log.e((String)"AppUtils", (String)"Didn't exist launcher activity.");
            return;
        }
        Utils.getApp().startActivity(launchAppIntent);
    }

    public static void launchApp(Activity activity, String packageName, int requestCode) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        Intent launchAppIntent = AppUtils.getLaunchAppIntent(packageName);
        if (launchAppIntent == null) {
            Log.e((String)"AppUtils", (String)"Didn't exist launcher activity.");
            return;
        }
        activity.startActivityForResult(launchAppIntent, requestCode);
    }

    public static void relaunchApp() {
        AppUtils.relaunchApp(false);
    }

    public static void relaunchApp(boolean isKillProcess) {
        Intent intent = AppUtils.getLaunchAppIntent(Utils.getApp().getPackageName(), true);
        if (intent == null) {
            Log.e((String)"AppUtils", (String)"Didn't exist launcher activity.");
            return;
        }
        intent.addFlags(335577088);
        Utils.getApp().startActivity(intent);
        if (!isKillProcess) {
            return;
        }
        Process.killProcess((int)Process.myPid());
        System.exit(0);
    }

    public static void launchAppDetailsSettings() {
        AppUtils.launchAppDetailsSettings(Utils.getApp().getPackageName());
    }

    public static void launchAppDetailsSettings(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return;
        }
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    public static void exitApp() {
        LinkedList<Activity> activityList = Utils.getActivityList();
        for (int i = activityList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)activityList.get(i);
            activity.finish();
        }
        System.exit(0);
    }

    public static Drawable getAppIcon() {
        return AppUtils.getAppIcon(Utils.getApp().getPackageName());
    }

    public static Drawable getAppIcon(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadIcon(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppIconId() {
        return AppUtils.getAppIconId(Utils.getApp().getPackageName());
    }

    public static int getAppIconId(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return 0;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? 0 : pi.applicationInfo.icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getAppPackageName() {
        return Utils.getApp().getPackageName();
    }

    public static String getAppName() {
        return AppUtils.getAppName(Utils.getApp().getPackageName());
    }

    public static String getAppName(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return "";
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAppPath() {
        return AppUtils.getAppPath(Utils.getApp().getPackageName());
    }

    public static String getAppPath(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return "";
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAppVersionName() {
        return AppUtils.getAppVersionName(Utils.getApp().getPackageName());
    }

    public static String getAppVersionName(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return "";
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getAppVersionCode() {
        return AppUtils.getAppVersionCode(Utils.getApp().getPackageName());
    }

    public static int getAppVersionCode(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return -1;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? -1 : pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Signature[] getAppSignature() {
        return AppUtils.getAppSignature(Utils.getApp().getPackageName());
    }

    public static Signature[] getAppSignature(String packageName) {
        if (AppUtils.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 64);
            return pi == null ? null : pi.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppSignatureSHA1() {
        return AppUtils.getAppSignatureSHA1(Utils.getApp().getPackageName());
    }

    public static String getAppSignatureSHA1(String packageName) {
        return AppUtils.getAppSignatureHash(packageName, "SHA1");
    }

    public static String getAppSignatureSHA256() {
        return AppUtils.getAppSignatureSHA256(Utils.getApp().getPackageName());
    }

    public static String getAppSignatureSHA256(String packageName) {
        return AppUtils.getAppSignatureHash(packageName, "SHA256");
    }

    public static String getAppSignatureMD5() {
        return AppUtils.getAppSignatureMD5(Utils.getApp().getPackageName());
    }

    public static String getAppSignatureMD5(String packageName) {
        return AppUtils.getAppSignatureHash(packageName, "MD5");
    }

    public static int getAppUid() {
        return AppUtils.getAppUid(Utils.getApp().getPackageName());
    }

    public static int getAppUid(String pkgName) {
        try {
            ApplicationInfo ai = Utils.getApp().getPackageManager().getApplicationInfo(pkgName, 0);
            if (ai != null) {
                return ai.uid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    private static String getAppSignatureHash(String packageName, String algorithm) {
        if (AppUtils.isSpace(packageName)) {
            return "";
        }
        Signature[] signature = AppUtils.getAppSignature(packageName);
        if (signature == null || signature.length <= 0) {
            return "";
        }
        return AppUtils.bytes2HexString(AppUtils.hashTemplate(signature[0].toByteArray(), algorithm)).replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
    }

    public static AppInfo getAppInfo() {
        return AppUtils.getAppInfo(Utils.getApp().getPackageName());
    }

    public static AppInfo getAppInfo(String packageName) {
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            if (pm == null) {
                return null;
            }
            return AppUtils.getBean(pm, pm.getPackageInfo(packageName, 0));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<AppInfo> getAppsInfo() {
        ArrayList<AppInfo> list = new ArrayList<AppInfo>();
        PackageManager pm = Utils.getApp().getPackageManager();
        if (pm == null) {
            return list;
        }
        List installedPackages = pm.getInstalledPackages(0);
        for (PackageInfo pi : installedPackages) {
            AppInfo ai = AppUtils.getBean(pm, pi);
            if (ai == null) continue;
            list.add(ai);
        }
        return list;
    }

    public static AppInfo getApkInfo(File apkFile) {
        if (apkFile == null || !apkFile.isFile() || !apkFile.exists()) {
            return null;
        }
        return AppUtils.getApkInfo(apkFile.getAbsolutePath());
    }

    public static AppInfo getApkInfo(String apkFilePath) {
        if (AppUtils.isSpace(apkFilePath)) {
            return null;
        }
        PackageManager pm = Utils.getApp().getPackageManager();
        if (pm == null) {
            return null;
        }
        PackageInfo pi = pm.getPackageArchiveInfo(apkFilePath, 0);
        if (pi == null) {
            return null;
        }
        ApplicationInfo appInfo = pi.applicationInfo;
        appInfo.sourceDir = apkFilePath;
        appInfo.publicSourceDir = apkFilePath;
        return AppUtils.getBean(pm, pi);
    }

    private static AppInfo getBean(PackageManager pm, PackageInfo pi) {
        if (pi == null) {
            return null;
        }
        ApplicationInfo ai = pi.applicationInfo;
        String packageName = pi.packageName;
        String name = ai.loadLabel(pm).toString();
        Drawable icon = ai.loadIcon(pm);
        String packagePath = ai.sourceDir;
        String versionName = pi.versionName;
        int versionCode = pi.versionCode;
        boolean isSystem = (1 & ai.flags) != 0;
        return new AppInfo(packageName, name, icon, packagePath, versionName, versionCode, isSystem);
    }

    private static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    private static File getFileByPath(String filePath) {
        return AppUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static byte[] hashTemplate(byte[] data, String algorithm) {
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String bytes2HexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >> 4 & 0xF];
            ret[j++] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    private static Intent getInstallAppIntent(File file) {
        return AppUtils.getInstallAppIntent(file, false);
    }

    private static Intent getInstallAppIntent(File file, boolean isNewTask) {
        Uri data;
        Intent intent = new Intent("android.intent.action.VIEW");
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT < 24) {
            data = Uri.fromFile((File)file);
        } else {
            String authority = Utils.getApp().getPackageName() + ".utilcode.provider";
            data = FileProvider.getUriForFile((Context)Utils.getApp(), (String)authority, (File)file);
            intent.setFlags(1);
        }
        Utils.getApp().grantUriPermission(Utils.getApp().getPackageName(), data, 1);
        intent.setDataAndType(data, type);
        return isNewTask ? intent.addFlags(0x10000000) : intent;
    }

    private static Intent getUninstallAppIntent(String packageName) {
        return AppUtils.getUninstallAppIntent(packageName, false);
    }

    private static Intent getUninstallAppIntent(String packageName, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return isNewTask ? intent.addFlags(0x10000000) : intent;
    }

    private static Intent getLaunchAppIntent(String packageName) {
        return AppUtils.getLaunchAppIntent(packageName, false);
    }

    private static Intent getLaunchAppIntent(String packageName, boolean isNewTask) {
        String launcherActivity = AppUtils.getLauncherActivity(packageName);
        if (!launcherActivity.isEmpty()) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.LAUNCHER");
            ComponentName cn = new ComponentName(packageName, launcherActivity);
            intent.setComponent(cn);
            return isNewTask ? intent.addFlags(0x10000000) : intent;
        }
        return null;
    }

    private static String getLauncherActivity(@NonNull String pkg) {
        if (pkg == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setPackage(pkg);
        PackageManager pm = Utils.getApp().getPackageManager();
        List info = pm.queryIntentActivities(intent, 0);
        int size = info.size();
        if (size == 0) {
            return "";
        }
        for (int i = 0; i < size; ++i) {
            ResolveInfo ri = (ResolveInfo)info.get(i);
            if (!ri.activityInfo.processName.equals(pkg)) continue;
            return ri.activityInfo.name;
        }
        return ((ResolveInfo)info.get((int)0)).activityInfo.name;
    }

    private static String getForegroundProcessName() {
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        List pInfo = am.getRunningAppProcesses();
        if (pInfo != null && pInfo.size() > 0) {
            for (ActivityManager.RunningAppProcessInfo aInfo : pInfo) {
                if (aInfo.importance != 100) continue;
                return aInfo.processName;
            }
        }
        if (Build.VERSION.SDK_INT > 21) {
            PackageManager pm = Utils.getApp().getPackageManager();
            Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            List list = pm.queryIntentActivities(intent, 65536);
            Log.i((String)"ProcessUtils", (String)list.toString());
            if (list.size() <= 0) {
                Log.i((String)"ProcessUtils", (String)"getForegroundProcessName: noun of access to usage information.");
                return "";
            }
            try {
                ApplicationInfo info = pm.getApplicationInfo(Utils.getApp().getPackageName(), 0);
                AppOpsManager aom = (AppOpsManager)Utils.getApp().getSystemService("appops");
                if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                    intent.addFlags(0x10000000);
                    Utils.getApp().startActivity(intent);
                }
                if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                    Log.i((String)"ProcessUtils", (String)"getForegroundProcessName: refuse to device usage stats.");
                    return "";
                }
                UsageStatsManager usageStatsManager = (UsageStatsManager)Utils.getApp().getSystemService("usagestats");
                List usageStatsList = null;
                if (usageStatsManager != null) {
                    long endTime = System.currentTimeMillis();
                    long beginTime = endTime - 604800000L;
                    usageStatsList = usageStatsManager.queryUsageStats(4, beginTime, endTime);
                }
                if (usageStatsList == null || usageStatsList.isEmpty()) {
                    return null;
                }
                UsageStats recentStats = null;
                for (UsageStats usageStats : usageStatsList) {
                    if (recentStats != null && usageStats.getLastTimeUsed() <= recentStats.getLastTimeUsed()) continue;
                    recentStats = usageStats;
                }
                return recentStats == null ? null : recentStats.getPackageName();
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static class AppInfo {
        private String packageName;
        private String name;
        private Drawable icon;
        private String packagePath;
        private String versionName;
        private int versionCode;
        private boolean isSystem;

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public void setSystem(boolean isSystem) {
            this.isSystem = isSystem;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int versionCode) {
            this.versionCode = versionCode;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public AppInfo(String packageName, String name, Drawable icon, String packagePath, String versionName, int versionCode, boolean isSystem) {
            this.setName(name);
            this.setIcon(icon);
            this.setPackageName(packageName);
            this.setPackagePath(packagePath);
            this.setVersionName(versionName);
            this.setVersionCode(versionCode);
            this.setSystem(isSystem);
        }

        public String toString() {
            return "{\n    pkg name: " + this.getPackageName() + "\n    app icon: " + this.getIcon() + "\n    app name: " + this.getName() + "\n    app path: " + this.getPackagePath() + "\n    app v name: " + this.getVersionName() + "\n    app v code: " + this.getVersionCode() + "\n    is system: " + this.isSystem() + "\n}";
        }
    }
}

