/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class PhoneUtils {
    private PhoneUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isPhone() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getPhoneType() != 0;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getDeviceId() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        String deviceId = tm.getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            return deviceId;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String imei = tm.getImei();
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                return imei;
            }
            String meid = tm.getMeid();
            return TextUtils.isEmpty((CharSequence)meid) ? "" : meid;
        }
        return "";
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getSerial() {
        return Build.VERSION.SDK_INT >= 26 ? Build.getSerial() : Build.SERIAL;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMEI() {
        String imei;
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        if (Build.VERSION.SDK_INT >= 26) {
            return tm.getImei();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Class<?> clazz = tm.getClass();
                Method getImeiMethod = clazz.getDeclaredMethod("getImei", new Class[0]);
                getImeiMethod.setAccessible(true);
                String imei2 = (String)getImeiMethod.invoke((Object)tm, new Object[0]);
                if (imei2 != null) {
                    return imei2;
                }
            }
            catch (Exception e) {
                Log.e((String)"PhoneUtils", (String)"getIMEI: ", (Throwable)e);
            }
        }
        if ((imei = tm.getDeviceId()) != null && imei.length() == 15) {
            return imei;
        }
        return "";
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMEI(int slotId) {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        if (Build.VERSION.SDK_INT >= 26) {
            return tm.getImei(slotId);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Class<?> clazz = tm.getClass();
                Method getImeiMethod = clazz.getDeclaredMethod("getImei", Integer.TYPE);
                getImeiMethod.setAccessible(true);
                String imei = (String)getImeiMethod.invoke((Object)tm, slotId);
                if (imei != null) {
                    return imei;
                }
            }
            catch (Exception e) {
                Log.e((String)"PhoneUtils", (String)"getIMEI: ", (Throwable)e);
            }
        }
        return PhoneUtils.getIMEI();
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getMEID() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        if (Build.VERSION.SDK_INT >= 26) {
            return tm.getMeid();
        }
        return tm.getDeviceId();
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getMEID(int slotId) {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        if (Build.VERSION.SDK_INT >= 26) {
            return tm.getMeid(slotId);
        }
        return PhoneUtils.getMEID();
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMSI() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getSubscriberId();
    }

    public static int getPhoneType() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getPhoneType();
    }

    public static boolean isSimCardReady() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getSimState() == 5;
    }

    public static String getSimOperatorName() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getSimOperatorName();
    }

    public static String getSimOperatorByMnc() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        String operator = tm.getSimOperator();
        if (operator == null) {
            return "";
        }
        switch (operator) {
            case "46000": 
            case "46002": 
            case "46007": 
            case "46020": {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            case "46001": 
            case "46006": 
            case "46009": {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            case "46003": 
            case "46005": 
            case "46011": {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return operator;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getPhoneStatus() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        String str = "";
        str = str + "DeviceId(IMEI) = " + tm.getDeviceId() + "\n";
        str = str + "DeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion() + "\n";
        str = str + "Line1Number = " + tm.getLine1Number() + "\n";
        str = str + "NetworkCountryIso = " + tm.getNetworkCountryIso() + "\n";
        str = str + "NetworkOperator = " + tm.getNetworkOperator() + "\n";
        str = str + "NetworkOperatorName = " + tm.getNetworkOperatorName() + "\n";
        str = str + "NetworkType = " + tm.getNetworkType() + "\n";
        str = str + "PhoneType = " + tm.getPhoneType() + "\n";
        str = str + "SimCountryIso = " + tm.getSimCountryIso() + "\n";
        str = str + "SimOperator = " + tm.getSimOperator() + "\n";
        str = str + "SimOperatorName = " + tm.getSimOperatorName() + "\n";
        str = str + "SimSerialNumber = " + tm.getSimSerialNumber() + "\n";
        str = str + "SimState = " + tm.getSimState() + "\n";
        str = str + "SubscriberId(IMSI) = " + tm.getSubscriberId() + "\n";
        str = str + "VoiceMailNumber = " + tm.getVoiceMailNumber();
        return str;
    }

    public static boolean dial(String phoneNumber) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber)));
        if (PhoneUtils.isIntentAvailable(intent)) {
            Utils.getApp().startActivity(intent.addFlags(0x10000000));
            return true;
        }
        return false;
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static boolean call(String phoneNumber) {
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber)));
        if (PhoneUtils.isIntentAvailable(intent)) {
            Utils.getApp().startActivity(intent.addFlags(0x10000000));
            return true;
        }
        return false;
    }

    public static boolean sendSms(String phoneNumber, String content) {
        Uri uri = Uri.parse((String)("smsto:" + phoneNumber));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        if (PhoneUtils.isIntentAvailable(intent)) {
            intent.putExtra("sms_body", content);
            Utils.getApp().startActivity(intent.addFlags(0x10000000));
            return true;
        }
        return false;
    }

    @RequiresPermission(value="android.permission.SEND_SMS")
    public static void sendSmsSilent(String phoneNumber, String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        PendingIntent sentIntent = PendingIntent.getBroadcast((Context)Utils.getApp(), (int)0, (Intent)new Intent("send"), (int)0);
        SmsManager smsManager = SmsManager.getDefault();
        if (content.length() >= 70) {
            ArrayList ms = smsManager.divideMessage(content);
            for (String str : ms) {
                smsManager.sendTextMessage(phoneNumber, null, str, sentIntent, null);
            }
        } else {
            smsManager.sendTextMessage(phoneNumber, null, content, sentIntent, null);
        }
    }

    private static TelephonyManager getTelephonyManager() {
        return (TelephonyManager)Utils.getApp().getSystemService("phone");
    }

    private static boolean isIntentAvailable(Intent intent) {
        return Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }
}

