/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import com.blankj.utilcode.util.ShellUtils;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public final class NetworkUtils {
    private NetworkUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void openWirelessSettings() {
        Utils.getApp().startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnected() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByPing() {
        return NetworkUtils.isAvailableByPing(null);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByPing(String ip) {
        boolean ret;
        if (ip == null || ip.length() <= 0) {
            ip = "223.5.5.5";
        }
        ShellUtils.CommandResult result = ShellUtils.execCmd(String.format("ping -c 1 %s", ip), false);
        boolean bl = ret = result.result == 0;
        if (result.errorMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + result.errorMsg));
        }
        if (result.successMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + result.successMsg));
        }
        return ret;
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static void isAvailableByDns(String ip) {
    }

    public static boolean getMobileDataEnabled() {
        try {
            TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
            if (tm == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                return tm.isDataEnabled();
            }
            Method getMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("getDataEnabled", new Class[0]);
            if (null != getMobileDataEnabledMethod) {
                return (Boolean)getMobileDataEnabledMethod.invoke((Object)tm, new Object[0]);
            }
        }
        catch (Exception e) {
            Log.e((String)"NetworkUtils", (String)"getMobileDataEnabled: ", (Throwable)e);
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public static boolean setMobileDataEnabled(boolean enabled) {
        try {
            TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
            if (tm == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                tm.setDataEnabled(enabled);
                return false;
            }
            Method setDataEnabledMethod = tm.getClass().getDeclaredMethod("setDataEnabled", Boolean.TYPE);
            if (null != setDataEnabledMethod) {
                setDataEnabledMethod.invoke((Object)tm, enabled);
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)"NetworkUtils", (String)"setMobileDataEnabled: ", (Throwable)e);
        }
        return false;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isMobileData() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return null != info && info.isAvailable() && info.getType() == 0;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean is4G() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static boolean getWifiEnabled() {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return false;
        }
        return manager.isWifiEnabled();
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public static void setWifiEnabled(boolean enabled) {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return;
        }
        if (enabled == manager.isWifiEnabled()) {
            return;
        }
        manager.setWifiEnabled(enabled);
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isWifiConnected() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.getType() == 1;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static boolean isWifiAvailable() {
        return NetworkUtils.getWifiEnabled() && NetworkUtils.isAvailableByPing();
    }

    public static String getNetworkOperatorName() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (tm == null) {
            return "";
        }
        return tm.getNetworkOperatorName();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static NetworkType getNetworkType() {
        if (NetworkUtils.isEthernet()) {
            return NetworkType.NETWORK_ETHERNET;
        }
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            if (info.getType() == 1) {
                return NetworkType.NETWORK_WIFI;
            }
            if (info.getType() == 0) {
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        return NetworkType.NETWORK_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        return NetworkType.NETWORK_3G;
                    }
                    case 13: 
                    case 18: {
                        return NetworkType.NETWORK_4G;
                    }
                }
                String subtypeName = info.getSubtypeName();
                if (subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000")) {
                    return NetworkType.NETWORK_3G;
                }
            }
        }
        return NetworkType.NETWORK_UNKNOWN;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static boolean isEthernet() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo info = cm.getNetworkInfo(9);
        if (info == null) {
            return false;
        }
        NetworkInfo.State state = info.getState();
        if (null == state) {
            return false;
        }
        return state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return null;
        }
        return cm.getActiveNetworkInfo();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getIPAddress(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList<InetAddress> adds = new LinkedList<InetAddress>();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    adds.addFirst(addresses.nextElement());
                }
            }
            for (InetAddress add : adds) {
                boolean isIPv4;
                if (add.isLoopbackAddress()) continue;
                String hostAddress = add.getHostAddress();
                boolean bl = isIPv4 = hostAddress.indexOf(58) < 0;
                if (useIPv4) {
                    if (!isIPv4) continue;
                    return hostAddress;
                }
                if (isIPv4) continue;
                int index = hostAddress.indexOf(37);
                return index < 0 ? hostAddress.toUpperCase() : hostAddress.substring(0, index).toUpperCase();
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getBroadcastIpAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList adds = new LinkedList();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ias = ni.getInterfaceAddresses();
                int size = ias.size();
                for (int i = 0; i < size; ++i) {
                    InterfaceAddress ia = ias.get(i);
                    InetAddress broadcast = ia.getBroadcast();
                    if (broadcast == null) continue;
                    return broadcast.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getDomainAddress(String domain) {
        try {
            InetAddress inetAddress = InetAddress.getByName(domain);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getIpAddressByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().ipAddress);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getGatewayByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().gateway);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getNetMaskByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().netmask);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getServerAddressByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().serverAddress);
    }

    public static interface Callback {
        public void call(boolean var1);
    }

    public static enum NetworkType {
        NETWORK_ETHERNET,
        NETWORK_WIFI,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO;

    }
}

