/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;

public final class FileUtils {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private FileUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static File getFileByPath(String filePath) {
        return FileUtils.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(String filePath) {
        return FileUtils.isFileExists(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean rename(String filePath, String newName) {
        return FileUtils.rename(FileUtils.getFileByPath(filePath), newName);
    }

    public static boolean rename(File file, String newName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (FileUtils.isSpace(newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static boolean isDir(String dirPath) {
        return FileUtils.isDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return FileUtils.isFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtils.createOrExistsFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyDir(String srcDirPath, String destDirPath) {
        return FileUtils.copyDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath));
    }

    public static boolean copyDir(String srcDirPath, String destDirPath, OnReplaceListener listener) {
        return FileUtils.copyDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), listener);
    }

    public static boolean copyDir(File srcDir, File destDir) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, false);
    }

    public static boolean copyDir(File srcDir, File destDir, OnReplaceListener listener) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, listener, false);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath) {
        return FileUtils.copyFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath));
    }

    public static boolean copyFile(String srcFilePath, String destFilePath, OnReplaceListener listener) {
        return FileUtils.copyFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), listener);
    }

    public static boolean copyFile(File srcFile, File destFile) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, false);
    }

    public static boolean copyFile(File srcFile, File destFile, OnReplaceListener listener) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, listener, false);
    }

    public static boolean moveDir(String srcDirPath, String destDirPath) {
        return FileUtils.moveDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath));
    }

    public static boolean moveDir(String srcDirPath, String destDirPath, OnReplaceListener listener) {
        return FileUtils.moveDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), listener);
    }

    public static boolean moveDir(File srcDir, File destDir) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, true);
    }

    public static boolean moveDir(File srcDir, File destDir, OnReplaceListener listener) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, listener, true);
    }

    public static boolean moveFile(String srcFilePath, String destFilePath) {
        return FileUtils.moveFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath));
    }

    public static boolean moveFile(String srcFilePath, String destFilePath, OnReplaceListener listener) {
        return FileUtils.moveFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), listener);
    }

    public static boolean moveFile(File srcFile, File destFile) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, true);
    }

    public static boolean moveFile(File srcFile, File destFile, OnReplaceListener listener) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, listener, true);
    }

    private static boolean copyOrMoveDir(File srcDir, File destDir, boolean isMove) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, new OnReplaceListener(){

            @Override
            public boolean onReplace() {
                return true;
            }
        }, isMove);
    }

    private static boolean copyOrMoveDir(File srcDir, File destDir, OnReplaceListener listener, boolean isMove) {
        File[] files;
        if (srcDir == null || destDir == null) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (destDir.exists()) {
            if (listener == null || listener.onReplace()) {
                if (!FileUtils.deleteAllInDir(destDir)) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(destDir)) {
            return false;
        }
        for (File file : files = srcDir.listFiles()) {
            File oneDestFile = new File(destPath + file.getName());
            if (!(file.isFile() ? !FileUtils.copyOrMoveFile(file, oneDestFile, listener, isMove) : file.isDirectory() && !FileUtils.copyOrMoveDir(file, oneDestFile, listener, isMove))) continue;
            return false;
        }
        return !isMove || FileUtils.deleteDir(srcDir);
    }

    private static boolean copyOrMoveFile(File srcFile, File destFile, boolean isMove) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, new OnReplaceListener(){

            @Override
            public boolean onReplace() {
                return true;
            }
        }, isMove);
    }

    private static boolean copyOrMoveFile(File srcFile, File destFile, OnReplaceListener listener, boolean isMove) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (srcFile.equals(destFile)) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists()) {
            if (listener == null || listener.onReplace()) {
                if (!destFile.delete()) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        try {
            return FileUtils.writeFileFromIS(destFile, new FileInputStream(srcFile)) && (!isMove || FileUtils.deleteFile(srcFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean delete(String filePath) {
        return FileUtils.delete(FileUtils.getFileByPath(filePath));
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return FileUtils.deleteDir(file);
        }
        return FileUtils.deleteFile(file);
    }

    public static boolean deleteDir(String dirPath) {
        return FileUtils.deleteDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String srcFilePath) {
        return FileUtils.deleteFile(FileUtils.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean deleteAllInDir(String dirPath) {
        return FileUtils.deleteAllInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteAllInDir(File dir) {
        return FileUtils.deleteFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return FileUtils.deleteFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        return FileUtils.deleteFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
    }

    public static boolean deleteFilesInDirWithFilter(String dirPath, FileFilter filter) {
        return FileUtils.deleteFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter);
    }

    public static boolean deleteFilesInDirWithFilter(File dir, FileFilter filter) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file) || !(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtils.listFilesInDir(dirPath, false);
    }

    public static List<File> listFilesInDir(File dir) {
        return FileUtils.listFilesInDir(dir, false);
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        }, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, false);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilter(dir, filter, false);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter, boolean isRecursive) {
        if (!FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (filter.accept(file)) {
                    list.add(file);
                }
                if (!isRecursive || !file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilter(file, filter, true));
            }
        }
        return list;
    }

    public static long getFileLastModified(String filePath) {
        return FileUtils.getFileLastModified(FileUtils.getFileByPath(filePath));
    }

    public static long getFileLastModified(File file) {
        if (file == null) {
            return -1L;
        }
        return file.lastModified();
    }

    public static String getFileCharsetSimple(String filePath) {
        return FileUtils.getFileCharsetSimple(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        int p = 0;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (is.read() << 8) + is.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        switch (p) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static int getFileLines(String filePath) {
        return FileUtils.getFileLines(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        int count = 1;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            if (LINE_SEP.endsWith("\n")) {
                int readChars;
                while ((readChars = is.read(buffer, 0, 1024)) != -1) {
                    for (int i = 0; i < readChars; ++i) {
                        if (buffer[i] != 10) continue;
                        ++count;
                    }
                }
            } else {
                int readChars;
                while ((readChars = is.read(buffer, 0, 1024)) != -1) {
                    for (int i = 0; i < readChars; ++i) {
                        if (buffer[i] != 13) continue;
                        ++count;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    public static String getDirSize(String dirPath) {
        return FileUtils.getDirSize(FileUtils.getFileByPath(dirPath));
    }

    public static String getDirSize(File dir) {
        long len = FileUtils.getDirLength(dir);
        return len == -1L ? "" : FileUtils.byte2FitMemorySize(len);
    }

    public static String getFileSize(String filePath) {
        long len = FileUtils.getFileLength(filePath);
        return len == -1L ? "" : FileUtils.byte2FitMemorySize(len);
    }

    public static String getFileSize(File file) {
        long len = FileUtils.getFileLength(file);
        return len == -1L ? "" : FileUtils.byte2FitMemorySize(len);
    }

    public static long getDirLength(String dirPath) {
        return FileUtils.getDirLength(FileUtils.getFileByPath(dirPath));
    }

    public static long getDirLength(File dir) {
        if (!FileUtils.isDir(dir)) {
            return -1L;
        }
        long len = 0L;
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    len += FileUtils.getDirLength(file);
                    continue;
                }
                len += file.length();
            }
        }
        return len;
    }

    public static long getFileLength(String filePath) {
        boolean isURL = filePath.matches("[a-zA-z]+://[^\\s]*");
        if (isURL) {
            try {
                HttpsURLConnection conn = (HttpsURLConnection)new URL(filePath).openConnection();
                conn.setRequestProperty("Accept-Encoding", "identity");
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    return conn.getContentLength();
                }
                return -1L;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return FileUtils.getFileLength(FileUtils.getFileByPath(filePath));
    }

    public static long getFileLength(File file) {
        if (!FileUtils.isFile(file)) {
            return -1L;
        }
        return file.length();
    }

    public static String getFileMD5ToString(String filePath) {
        File file = FileUtils.isSpace(filePath) ? null : new File(filePath);
        return FileUtils.getFileMD5ToString(file);
    }

    public static String getFileMD5ToString(File file) {
        return FileUtils.bytes2HexString(FileUtils.getFileMD5(file));
    }

    public static byte[] getFileMD5(String filePath) {
        return FileUtils.getFileMD5(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileMD5(File file) {
        if (file == null) {
            return null;
        }
        FilterInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            md = ((DigestInputStream)dis).getMessageDigest();
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getDirName(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getDirName(file.getAbsolutePath());
    }

    public static String getDirName(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return "";
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getFileName(file.getAbsolutePath());
    }

    public static String getFileName(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return "";
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return "";
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastSep == -1) {
            return lastPoi == -1 ? filePath : filePath.substring(0, lastPoi);
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            return filePath.substring(lastSep + 1);
        }
        return filePath.substring(lastSep + 1, lastPoi);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return "";
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            return "";
        }
        return filePath.substring(lastPoi + 1);
    }

    private static String bytes2HexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >> 4 & 0xF];
            ret[j++] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    private static String byte2FitMemorySize(long byteNum) {
        if (byteNum < 0L) {
            return "shouldn't be less than zero!";
        }
        if (byteNum < 1024L) {
            return String.format(Locale.getDefault(), "%.3fB", (double)byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format(Locale.getDefault(), "%.3fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format(Locale.getDefault(), "%.3fMB", (double)byteNum / 1048576.0);
        }
        return String.format(Locale.getDefault(), "%.3fGB", (double)byteNum / 1.073741824E9);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFileFromIS(File file, InputStream is) {
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file));
            byte[] data = new byte[8192];
            while ((len = is.read(data, 0, 8192)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface OnReplaceListener {
        public boolean onReplace();
    }
}

