/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public final class UriUtils {
    private UriUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Uri res2Uri(String resPath) {
        return Uri.parse((String)("android.resource://" + Utils.getApp().getPackageName() + "/" + resPath));
    }

    public static Uri file2Uri(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("Argument 'file' of type File (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = Utils.getApp().getPackageName() + ".utilcode.provider";
            return FileProvider.getUriForFile((Context)Utils.getApp(), (String)authority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static File uri2File(@NonNull Uri uri) {
        if (uri == null) {
            throw new NullPointerException("Argument 'uri' of type Uri (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        File file = UriUtils.uri2FileReal(uri);
        if (file != null) {
            return file;
        }
        return UriUtils.copyUri2Cache(uri);
    }

    private static File uri2FileReal(@NonNull Uri uri) {
        if (uri == null) {
            throw new NullPointerException("Argument 'uri' of type Uri (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Log.d((String)"UriUtils", (String)uri.toString());
        String authority = uri.getAuthority();
        String scheme = uri.getScheme();
        String path = uri.getPath();
        if (Build.VERSION.SDK_INT >= 24 && path != null) {
            String[] externals;
            for (String external : externals = new String[]{"/external", "/external_path"}) {
                File file;
                if (!path.startsWith(external + "/") || !(file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + path.replace(external, ""))).exists()) continue;
                Log.d((String)"UriUtils", (String)(uri.toString() + " -> " + external));
                return file;
            }
        }
        if ("file".equals(scheme)) {
            if (path != null) {
                return new File(path);
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 0"));
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)Utils.getApp(), (Uri)uri)) {
            String[] split;
            String docId;
            if ("com.android.externalstorage.documents".equals(authority)) {
                docId = DocumentsContract.getDocumentId((Uri)uri);
                split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return new File(Environment.getExternalStorageDirectory() + "/" + split[1]);
                }
                StorageManager mStorageManager = (StorageManager)Utils.getApp().getSystemService("storage");
                try {
                    Class<?> storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
                    Method getVolumeList = mStorageManager.getClass().getMethod("getVolumeList", new Class[0]);
                    Method getUuid = storageVolumeClazz.getMethod("getUuid", new Class[0]);
                    Method getState = storageVolumeClazz.getMethod("getState", new Class[0]);
                    Method getPath = storageVolumeClazz.getMethod("getPath", new Class[0]);
                    Method isPrimary = storageVolumeClazz.getMethod("isPrimary", new Class[0]);
                    Method isEmulated = storageVolumeClazz.getMethod("isEmulated", new Class[0]);
                    Object result = getVolumeList.invoke((Object)mStorageManager, new Object[0]);
                    int length = Array.getLength(result);
                    for (int i = 0; i < length; ++i) {
                        String uuid;
                        boolean mounted;
                        Object storageVolumeElement = Array.get(result, i);
                        boolean bl = mounted = "mounted".equals(getState.invoke(storageVolumeElement, new Object[0])) || "mounted_ro".equals(getState.invoke(storageVolumeElement, new Object[0]));
                        if (!mounted || ((Boolean)isPrimary.invoke(storageVolumeElement, new Object[0])).booleanValue() && ((Boolean)isEmulated.invoke(storageVolumeElement, new Object[0])).booleanValue() || (uuid = (String)getUuid.invoke(storageVolumeElement, new Object[0])) == null || !uuid.equals(type)) continue;
                        return new File(getPath.invoke(storageVolumeElement, new Object[0]) + "/" + split[1]);
                    }
                }
                catch (Exception ex) {
                    Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. " + ex.toString() + " -> 1_0"));
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_0"));
                return null;
            }
            if ("com.android.providers.downloads.documents".equals(authority)) {
                String[] contentUriPrefixesToTry;
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                if (TextUtils.isEmpty((CharSequence)id2)) {
                    Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(id is null). -> 1_1"));
                    return null;
                }
                if (id2.startsWith("raw:")) {
                    return new File(id2.substring(4));
                }
                for (String contentUriPrefix : contentUriPrefixesToTry = new String[]{"content://downloads/public_downloads", "content://downloads/all_downloads", "content://downloads/my_downloads"}) {
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)contentUriPrefix), (long)Long.valueOf(id2));
                    try {
                        File file = UriUtils.getFileFromUri(contentUri, "1_1");
                        if (file == null) continue;
                        return file;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_1"));
                return null;
            }
            if ("com.android.providers.media.documents".equals(authority)) {
                Uri contentUri;
                docId = DocumentsContract.getDocumentId((Uri)uri);
                split = docId.split(":");
                String type = split[0];
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                } else {
                    Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_2"));
                    return null;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return UriUtils.getFileFromUri(contentUri, "_id=?", selectionArgs, "1_2");
            }
            if ("content".equals(scheme)) {
                return UriUtils.getFileFromUri(uri, "1_3");
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_4"));
            return null;
        }
        if ("content".equals(scheme)) {
            return UriUtils.getFileFromUri(uri, "2");
        }
        Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 3"));
        return null;
    }

    private static File getFileFromUri(Uri uri, String code) {
        return UriUtils.getFileFromUri(uri, null, null, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getFileFromUri(Uri uri, String selection, String[] selectionArgs, String code) {
        Cursor cursor;
        String path;
        if ("com.google.android.apps.photos.content".equals(uri.getAuthority())) {
            if (!TextUtils.isEmpty((CharSequence)uri.getLastPathSegment())) {
                return new File(uri.getLastPathSegment());
            }
        } else if ("com.tencent.mtt.fileprovider".equals(uri.getAuthority())) {
            path = uri.getPath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File fileDir = Environment.getExternalStorageDirectory();
                return new File(fileDir, path.substring("/QQBrowser".length(), path.length()));
            }
        } else if ("com.huawei.hidisk.fileprovider".equals(uri.getAuthority()) && !TextUtils.isEmpty((CharSequence)(path = uri.getPath()))) {
            return new File(path.replace("/root", ""));
        }
        if ((cursor = Utils.getApp().getContentResolver().query(uri, new String[]{"_data"}, selection, selectionArgs, null)) == null) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(cursor is null). -> " + code));
            return null;
        }
        try {
            if (cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex("_data");
                if (columnIndex > -1) {
                    File file = new File(cursor.getString(columnIndex));
                    return file;
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(columnIndex: " + columnIndex + " is wrong). -> " + code));
                File file = null;
                return file;
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(moveToFirst return false). -> " + code));
            File columnIndex = null;
            return columnIndex;
        }
        catch (Exception e) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> " + code));
            File file = null;
            return file;
        }
        finally {
            cursor.close();
        }
    }

    private static File copyUri2Cache(Uri uri) {
        Log.d((String)"UriUtils", (String)"copyUri2Cache() called");
        InputStream is = UriUtils.uri2InputStream(uri);
        File file = new File(Utils.getApp().getCacheDir(), "" + System.currentTimeMillis());
        UtilsBridge.writeFileFromIS(file.getAbsolutePath(), is);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream uri2InputStream(Uri uri) {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream is = null;
        try {
            InputStream inputStream = is = Utils.getApp().getContentResolver().openInputStream(uri);
            return inputStream;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

