/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.Application;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ProcessUtils {
    private ProcessUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getForegroundProcessName() {
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        List pInfo = am.getRunningAppProcesses();
        if (pInfo != null && pInfo.size() > 0) {
            for (ActivityManager.RunningAppProcessInfo aInfo : pInfo) {
                if (aInfo.importance != 100) continue;
                return aInfo.processName;
            }
        }
        if (Build.VERSION.SDK_INT > 21) {
            PackageManager pm = Utils.getApp().getPackageManager();
            Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            List list = pm.queryIntentActivities(intent, 65536);
            Log.i((String)"ProcessUtils", (String)list.toString());
            if (list.size() <= 0) {
                Log.i((String)"ProcessUtils", (String)"getForegroundProcessName: noun of access to usage information.");
                return "";
            }
            try {
                ApplicationInfo info = pm.getApplicationInfo(Utils.getApp().getPackageName(), 0);
                AppOpsManager aom = (AppOpsManager)Utils.getApp().getSystemService("appops");
                if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                    intent.addFlags(0x10000000);
                    Utils.getApp().startActivity(intent);
                }
                if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                    Log.i((String)"ProcessUtils", (String)"getForegroundProcessName: refuse to device usage stats.");
                    return "";
                }
                UsageStatsManager usageStatsManager = (UsageStatsManager)Utils.getApp().getSystemService("usagestats");
                List usageStatsList = null;
                if (usageStatsManager != null) {
                    long endTime = System.currentTimeMillis();
                    long beginTime = endTime - 604800000L;
                    usageStatsList = usageStatsManager.queryUsageStats(4, beginTime, endTime);
                }
                if (usageStatsList == null || usageStatsList.isEmpty()) {
                    return "";
                }
                UsageStats recentStats = null;
                for (UsageStats usageStats : usageStatsList) {
                    if (recentStats != null && usageStats.getLastTimeUsed() <= recentStats.getLastTimeUsed()) continue;
                    recentStats = usageStats;
                }
                return recentStats == null ? null : recentStats.getPackageName();
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public static Set<String> getAllBackgroundProcesses() {
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        List info = am.getRunningAppProcesses();
        HashSet<String> set = new HashSet<String>();
        if (info != null) {
            for (ActivityManager.RunningAppProcessInfo aInfo : info) {
                Collections.addAll(set, aInfo.pkgList);
            }
        }
        return set;
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public static Set<String> killAllBackgroundProcesses() {
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        List info = am.getRunningAppProcesses();
        HashSet<String> set = new HashSet<String>();
        if (info == null) {
            return set;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            for (String pkg : aInfo.pkgList) {
                am.killBackgroundProcesses(pkg);
                set.add(pkg);
            }
        }
        info = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            for (String pkg : aInfo.pkgList) {
                set.remove(pkg);
            }
        }
        return set;
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public static boolean killBackgroundProcesses(@NonNull String packageName) {
        if (packageName == null) {
            throw new NullPointerException("Argument 'packageName' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (!Arrays.asList(aInfo.pkgList).contains(packageName)) continue;
            am.killBackgroundProcesses(packageName);
        }
        info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (!Arrays.asList(aInfo.pkgList).contains(packageName)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMainProcess() {
        return Utils.getApp().getPackageName().equals(ProcessUtils.getCurrentProcessName());
    }

    public static String getCurrentProcessName() {
        String name = ProcessUtils.getCurrentProcessNameByFile();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = ProcessUtils.getCurrentProcessNameByAms();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = ProcessUtils.getCurrentProcessNameByReflect();
        return name;
    }

    private static String getCurrentProcessNameByFile() {
        try {
            File file = new File("/proc/" + Process.myPid() + "/cmdline");
            BufferedReader mBufferedReader = new BufferedReader(new FileReader(file));
            String processName = mBufferedReader.readLine().trim();
            mBufferedReader.close();
            return processName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getCurrentProcessNameByAms() {
        try {
            ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
            if (am == null) {
                return "";
            }
            List info = am.getRunningAppProcesses();
            if (info == null || info.size() == 0) {
                return "";
            }
            int pid = Process.myPid();
            for (ActivityManager.RunningAppProcessInfo aInfo : info) {
                if (aInfo.pid != pid || aInfo.processName == null) continue;
                return aInfo.processName;
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    private static String getCurrentProcessNameByReflect() {
        String processName = "";
        try {
            Application app = Utils.getApp();
            Field loadedApkField = app.getClass().getField("mLoadedApk");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(app);
            Field activityThreadField = loadedApk.getClass().getDeclaredField("mActivityThread");
            activityThreadField.setAccessible(true);
            Object activityThread = activityThreadField.get(loadedApk);
            Method getProcessName = activityThread.getClass().getDeclaredMethod("getProcessName", new Class[0]);
            processName = (String)getProcessName.invoke(activityThread, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processName;
    }
}

