/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.scan;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.blakequ.bluetooth_manager_lib.BleManager;
import com.blakequ.bluetooth_manager_lib.scan.BackgroundPowerSaver;
import com.blakequ.bluetooth_manager_lib.scan.CycledLeScanner;
import com.blakequ.bluetooth_manager_lib.scan.ScanOverListener;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanCallbackCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanFilterCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanResultCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanSettingsCompat;
import com.orhanobut.logger.Logger;
import java.util.List;

@TargetApi(value=18)
public final class BluetoothScanManager {
    private static BluetoothScanManager INSTANCE = null;
    private boolean backgroundMode = false;
    private BackgroundPowerSaver mPowerSaver;
    private CycledLeScanner cycledLeScanner;
    private ScanCallbackCompat scanCallbackCompat;
    private final Handler mHandler;
    private static Object obj = new Object();

    private BluetoothScanManager(Context context) {
        this.mPowerSaver = new BackgroundPowerSaver(context);
        this.mHandler = new Handler(Looper.getMainLooper());
        this.cycledLeScanner = new CycledLeScanner(context, 10000L, 5000L, this.backgroundMode, this.getScanCallback());
        BleManager.getBleParamsOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BluetoothScanManager getInstance(Context context) {
        if (INSTANCE == null) {
            Object object = obj;
            synchronized (object) {
                if (INSTANCE == null) {
                    Logger.d((String)"BluetoothScanManager instance creation", (Object[])new Object[0]);
                    INSTANCE = new BluetoothScanManager(context);
                }
            }
        }
        return INSTANCE;
    }

    public final void runOnUiThread(Runnable action) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.mHandler.post(action);
        } else {
            action.run();
        }
    }

    public BackgroundPowerSaver getPowerSaver() {
        return this.mPowerSaver;
    }

    public void setScanCallbackCompat(ScanCallbackCompat scanCallbackCompat) {
        this.scanCallbackCompat = scanCallbackCompat;
    }

    public void setScanOverListener(ScanOverListener scanOverListener) {
        this.cycledLeScanner.setScanOverListener(scanOverListener);
    }

    public boolean isScanning() {
        return this.cycledLeScanner.isScanning();
    }

    public boolean isPauseScanning() {
        return this.cycledLeScanner.isPauseScan();
    }

    public void stopCycleScan() {
        this.cycledLeScanner.setPauseScan(true);
    }

    public void startCycleScan() {
        this.cycledLeScanner.startScan();
    }

    public void startScanOnce() {
        this.cycledLeScanner.startOnceScan();
    }

    public void startScanNow() {
        this.cycledLeScanner.setBackgroundMode(this.mPowerSaver.getScanPeriod(), this.mPowerSaver.getBetweenScanPeriod(), this.backgroundMode);
        this.cycledLeScanner.startScanNow();
    }

    public void addScanFilterCompats(ScanFilterCompat scanFilter) {
        this.cycledLeScanner.addScanFilterCompats(scanFilter);
    }

    public void setScanSettings(ScanSettingsCompat scanSettings) {
        this.cycledLeScanner.setScanSettings(scanSettings);
    }

    @Deprecated
    public static boolean isAPI21ScanningDisabled() {
        return false;
    }

    public void setBackgroundMode(boolean backgroundMode) {
        if (Build.VERSION.SDK_INT < 18) {
            Logger.w((String)"Not supported prior to API 18.  Method invocation will be ignored", (Object[])new Object[0]);
        }
        if (backgroundMode != this.backgroundMode) {
            this.backgroundMode = backgroundMode;
            this.cycledLeScanner.setBackgroundMode(this.mPowerSaver.getScanPeriod(), this.mPowerSaver.getBetweenScanPeriod(), backgroundMode);
        }
    }

    public boolean isBackgroundMode() {
        return this.backgroundMode;
    }

    private ScanCallbackCompat getScanCallback() {
        return new ScanCallbackCompat(){

            @Override
            public void onBatchScanResults(final List<ScanResultCompat> results) {
                if (BluetoothScanManager.this.scanCallbackCompat != null) {
                    BluetoothScanManager.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothScanManager.this.scanCallbackCompat.onBatchScanResults(results);
                        }
                    });
                }
            }

            @Override
            public void onScanFailed(final int errorCode) {
                if (BluetoothScanManager.this.scanCallbackCompat != null) {
                    BluetoothScanManager.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothScanManager.this.scanCallbackCompat.onScanFailed(errorCode);
                        }
                    });
                }
            }

            @Override
            public void onScanResult(final int callbackType, final ScanResultCompat result) {
                if (BluetoothScanManager.this.scanCallbackCompat != null) {
                    BluetoothScanManager.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothScanManager.this.scanCallbackCompat.onScanResult(callbackType, result);
                        }
                    });
                }
            }
        };
    }
}

