/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.scan;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.blakequ.bluetooth_manager_lib.BleManager;
import com.blakequ.bluetooth_manager_lib.BleParamsOptions;
import com.blakequ.bluetooth_manager_lib.scan.BluetoothScanManager;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;

@TargetApi(value=18)
public class BackgroundPowerSaver
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "BackgroundPowerSaver";
    private int activeActivityCount = 0;
    private Context mContext;
    public static final long DEFAULT_FOREGROUND_SCAN_PERIOD = 10000L;
    public static final long DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 5000L;
    public static final long DEFAULT_BACKGROUND_SCAN_PERIOD = 10000L;
    public static final long DEFAULT_BACKGROUND_BETWEEN_SCAN_PERIOD = 300000L;
    private long foregroundScanPeriod = 10000L;
    private long foregroundBetweenScanPeriod = 5000L;
    private long backgroundScanPeriod = 10000L;
    private long backgroundBetweenScanPeriod = 300000L;

    public BackgroundPowerSaver(Context context, boolean countActiveActivityStrategy) {
        this(context);
    }

    public BackgroundPowerSaver(Context context) {
        if (Build.VERSION.SDK_INT < 18) {
            LogUtils.w(TAG, "BackgroundPowerSaver requires API 18 or higher.");
            return;
        }
        ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mContext = context;
    }

    @Deprecated
    public void setForegroundScanPeriod(long p) {
        this.foregroundScanPeriod = p;
    }

    @Deprecated
    public void setForegroundBetweenScanPeriod(long p) {
        this.foregroundBetweenScanPeriod = p;
    }

    @Deprecated
    public void setBackgroundScanPeriod(long p) {
        this.backgroundScanPeriod = p;
    }

    @Deprecated
    public void setBackgroundBetweenScanPeriod(long p) {
        this.backgroundBetweenScanPeriod = p;
    }

    public long getScanPeriod() {
        BleParamsOptions options = BleManager.getBleParamsOptions();
        if (BluetoothScanManager.getInstance(this.mContext).isBackgroundMode()) {
            if (options != null) {
                return options.getBackgroundScanPeriod();
            }
            return this.backgroundScanPeriod;
        }
        if (options != null) {
            return options.getForegroundScanPeriod();
        }
        return this.foregroundScanPeriod;
    }

    public long getBetweenScanPeriod() {
        BleParamsOptions options = BleManager.getBleParamsOptions();
        if (BluetoothScanManager.getInstance(this.mContext).isBackgroundMode()) {
            if (options != null) {
                return options.getBackgroundBetweenScanPeriod();
            }
            return this.backgroundBetweenScanPeriod;
        }
        if (options != null) {
            return options.getForegroundBetweenScanPeriod();
        }
        return this.foregroundBetweenScanPeriod;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        ++this.activeActivityCount;
        if (this.activeActivityCount < 1) {
            LogUtils.d(TAG, "reset active activity count on resume.  It was " + this.activeActivityCount);
            this.activeActivityCount = 1;
        }
        BluetoothScanManager.getInstance(this.mContext).setBackgroundMode(false);
        LogUtils.d(TAG, "activity resumed: " + activity + " active activities: " + this.activeActivityCount);
    }

    public void onActivityPaused(Activity activity) {
        --this.activeActivityCount;
        LogUtils.d(TAG, "activity paused: " + activity + " active activities: " + this.activeActivityCount);
        if (this.activeActivityCount < 1) {
            LogUtils.d(TAG, "setting background mode");
            BluetoothScanManager.getInstance(this.mContext).setBackgroundMode(true);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

