/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.connect;

import android.os.SystemClock;
import com.blakequ.bluetooth_manager_lib.BleManager;
import com.blakequ.bluetooth_manager_lib.BleParamsOptions;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;

public class ReconnectParamsBean {
    private String address;
    private int number;
    private long nextReconnectTime;
    private long startDisconnectTime;
    private boolean isReconnectNow = false;

    public ReconnectParamsBean(String address) {
        this.address = address;
        this.startDisconnectTime = SystemClock.elapsedRealtime();
        this.number = 0;
    }

    public String getAddress() {
        return this.address;
    }

    public void updateAddress(String address) {
        this.address = address;
        this.startDisconnectTime = SystemClock.elapsedRealtime();
        this.number = 0;
    }

    public long getNextReconnectTime() {
        BleParamsOptions options = BleManager.getBleParamsOptions();
        switch (options.getReconnectStrategy()) {
            case 2: {
                this.nextReconnectTime = (long)((double)this.startDisconnectTime + (double)options.getReconnectBaseSpaceTime() * Math.pow(2.0, this.number));
                break;
            }
            case 3: {
                if (this.number <= options.getReconnectedLineToExponentTimes()) {
                    this.nextReconnectTime = this.startDisconnectTime + options.getReconnectBaseSpaceTime() * (long)this.number;
                    break;
                }
                this.nextReconnectTime = (long)((double)this.startDisconnectTime + (double)options.getReconnectBaseSpaceTime() * Math.pow(2.0, this.number));
                break;
            }
            case 1: {
                this.nextReconnectTime = this.startDisconnectTime + options.getReconnectBaseSpaceTime() * (long)this.number;
                break;
            }
            case 4: {
                this.nextReconnectTime = this.startDisconnectTime + options.getReconnectBaseSpaceTime();
            }
        }
        if (this.isReconnectNow) {
            this.nextReconnectTime = SystemClock.elapsedRealtime();
        }
        if (this.number >= options.getReconnectMaxTimes()) {
            LogUtils.d("ReconnectParamsBean", "reconnect number=" + this.number + " more than max times " + options.getReconnectMaxTimes());
            this.nextReconnectTime = SystemClock.elapsedRealtime() + 864000000L;
        }
        return this.nextReconnectTime;
    }

    public boolean isReconnectNow() {
        return this.isReconnectNow;
    }

    public void setReconnectNow(boolean reconnectNow) {
        this.number = 0;
        this.startDisconnectTime = SystemClock.elapsedRealtime();
        this.isReconnectNow = reconnectNow;
    }

    public int getNumber() {
        return this.number;
    }

    public void addNumber() {
        this.isReconnectNow = false;
        this.startDisconnectTime = SystemClock.elapsedRealtime();
        ++this.number;
    }

    public void setNumber(int num) {
        this.number = num;
    }

    public String toString() {
        return "ReconnectParamsBean{address='" + this.address + '\'' + ", number=" + this.number + ", next reconnect after " + (this.getNextReconnectTime() - this.startDisconnectTime) / 1000L + "seconds" + ", startDisconnectTime=" + this.startDisconnectTime + '}';
    }
}

