/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import com.blakequ.bluetooth_manager_lib.BleNotAvailableException;
import com.blakequ.bluetooth_manager_lib.BleParamsOptions;
import com.blakequ.bluetooth_manager_lib.connect.BluetoothConnectManager;
import com.blakequ.bluetooth_manager_lib.connect.ConnectConfig;
import com.blakequ.bluetooth_manager_lib.connect.multiple.MultiConnectManager;
import com.blakequ.bluetooth_manager_lib.scan.BluetoothScanManager;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;

@TargetApi(value=18)
public final class BleManager {
    private static BleParamsOptions configOptions;

    private BleManager() {
    }

    public static BleParamsOptions getBleParamsOptions() {
        if (configOptions == null) {
            configOptions = BleParamsOptions.createDefault();
        }
        return configOptions;
    }

    public static void setBleParamsOptions(@NonNull BleParamsOptions options) {
        if (options != null) {
            configOptions = options;
            ConnectConfig.maxConnectDeviceNum = options.getMaxConnectDeviceNum();
            LogUtils.setDebugLog(options.isDebugMode());
        }
    }

    public static BluetoothConnectManager getConnectManager(@NonNull Context context) {
        return BluetoothConnectManager.getInstance(context);
    }

    public static BluetoothScanManager getScanManager(@NonNull Context context) {
        return BluetoothScanManager.getInstance(context);
    }

    public static MultiConnectManager getMultiConnectManager(@NonNull Context context) {
        return MultiConnectManager.getInstance(context);
    }

    public static boolean checkAvailability(Context context) throws BleNotAvailableException {
        if (BleManager.isSDKAvailable()) {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                throw new BleNotAvailableException("Bluetooth LE not supported by this device");
            }
            if (((BluetoothManager)context.getSystemService("bluetooth")).getAdapter().isEnabled()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSDKAvailable() {
        if (Build.VERSION.SDK_INT < 18) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        return true;
    }

    @Deprecated
    public static void setLogDebugMode(boolean isDebugMode) {
        LogUtils.setDebugLog(isDebugMode);
    }
}

