/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat;

import android.os.ParcelUuid;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;

class BluetoothUuidCompat {
    public static final ParcelUuid AudioSink = ParcelUuid.fromString((String)"0000110B-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid AudioSource = ParcelUuid.fromString((String)"0000110A-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid AdvAudioDist = ParcelUuid.fromString((String)"0000110D-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid HSP = ParcelUuid.fromString((String)"00001108-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid HSP_AG = ParcelUuid.fromString((String)"00001112-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid Handsfree = ParcelUuid.fromString((String)"0000111E-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid Handsfree_AG = ParcelUuid.fromString((String)"0000111F-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid AvrcpController = ParcelUuid.fromString((String)"0000110E-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid AvrcpTarget = ParcelUuid.fromString((String)"0000110C-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid ObexObjectPush = ParcelUuid.fromString((String)"00001105-0000-1000-8000-00805f9b34fb");
    public static final ParcelUuid Hid = ParcelUuid.fromString((String)"00001124-0000-1000-8000-00805f9b34fb");
    public static final ParcelUuid Hogp = ParcelUuid.fromString((String)"00001812-0000-1000-8000-00805f9b34fb");
    public static final ParcelUuid PANU = ParcelUuid.fromString((String)"00001115-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid NAP = ParcelUuid.fromString((String)"00001116-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid BNEP = ParcelUuid.fromString((String)"0000000f-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid PBAP_PSE = ParcelUuid.fromString((String)"0000112f-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid MAP = ParcelUuid.fromString((String)"00001134-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid MNS = ParcelUuid.fromString((String)"00001133-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid MAS = ParcelUuid.fromString((String)"00001132-0000-1000-8000-00805F9B34FB");
    public static final ParcelUuid BASE_UUID = ParcelUuid.fromString((String)"00000000-0000-1000-8000-00805F9B34FB");
    public static final int UUID_BYTES_16_BIT = 2;
    public static final int UUID_BYTES_32_BIT = 4;
    public static final int UUID_BYTES_128_BIT = 16;
    public static final ParcelUuid[] RESERVED_UUIDS = new ParcelUuid[]{AudioSink, AudioSource, AdvAudioDist, HSP, Handsfree, AvrcpController, AvrcpTarget, ObexObjectPush, PANU, NAP, MAP, MNS, MAS};

    BluetoothUuidCompat() {
    }

    public static boolean isAudioSource(ParcelUuid uuid) {
        return uuid.equals((Object)AudioSource);
    }

    public static boolean isAudioSink(ParcelUuid uuid) {
        return uuid.equals((Object)AudioSink);
    }

    public static boolean isAdvAudioDist(ParcelUuid uuid) {
        return uuid.equals((Object)AdvAudioDist);
    }

    public static boolean isHandsfree(ParcelUuid uuid) {
        return uuid.equals((Object)Handsfree);
    }

    public static boolean isHeadset(ParcelUuid uuid) {
        return uuid.equals((Object)HSP);
    }

    public static boolean isAvrcpController(ParcelUuid uuid) {
        return uuid.equals((Object)AvrcpController);
    }

    public static boolean isAvrcpTarget(ParcelUuid uuid) {
        return uuid.equals((Object)AvrcpTarget);
    }

    public static boolean isInputDevice(ParcelUuid uuid) {
        return uuid.equals((Object)Hid);
    }

    public static boolean isPanu(ParcelUuid uuid) {
        return uuid.equals((Object)PANU);
    }

    public static boolean isNap(ParcelUuid uuid) {
        return uuid.equals((Object)NAP);
    }

    public static boolean isBnep(ParcelUuid uuid) {
        return uuid.equals((Object)BNEP);
    }

    public static boolean isMap(ParcelUuid uuid) {
        return uuid.equals((Object)MAP);
    }

    public static boolean isMns(ParcelUuid uuid) {
        return uuid.equals((Object)MNS);
    }

    public static boolean isMas(ParcelUuid uuid) {
        return uuid.equals((Object)MAS);
    }

    public static boolean isUuidPresent(ParcelUuid[] uuidArray, ParcelUuid uuid) {
        if ((uuidArray == null || uuidArray.length == 0) && uuid == null) {
            return true;
        }
        if (uuidArray == null) {
            return false;
        }
        for (ParcelUuid element : uuidArray) {
            if (!element.equals((Object)uuid)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyUuid(ParcelUuid[] uuidA, ParcelUuid[] uuidB) {
        if (uuidA == null && uuidB == null) {
            return true;
        }
        if (uuidA == null) {
            return uuidB.length == 0;
        }
        if (uuidB == null) {
            return uuidA.length == 0;
        }
        HashSet<ParcelUuid> uuidSet = new HashSet<ParcelUuid>(Arrays.asList(uuidA));
        for (ParcelUuid uuid : uuidB) {
            if (!uuidSet.contains(uuid)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllUuids(ParcelUuid[] uuidA, ParcelUuid[] uuidB) {
        if (uuidA == null && uuidB == null) {
            return true;
        }
        if (uuidA == null) {
            return uuidB.length == 0;
        }
        if (uuidB == null) {
            return true;
        }
        HashSet<ParcelUuid> uuidSet = new HashSet<ParcelUuid>(Arrays.asList(uuidA));
        for (ParcelUuid uuid : uuidB) {
            if (uuidSet.contains(uuid)) continue;
            return false;
        }
        return true;
    }

    public static int getServiceIdentifierFromParcelUuid(ParcelUuid parcelUuid) {
        UUID uuid = parcelUuid.getUuid();
        long value = (uuid.getMostSignificantBits() & 0xFFFF00000000L) >>> 32;
        return (int)value;
    }

    public static ParcelUuid parseUuidFrom(byte[] uuidBytes) {
        long shortUuid;
        if (uuidBytes == null) {
            throw new IllegalArgumentException("uuidBytes cannot be null");
        }
        int length = uuidBytes.length;
        if (length != 2 && length != 4 && length != 16) {
            throw new IllegalArgumentException("uuidBytes length invalid - " + length);
        }
        if (length == 16) {
            ByteBuffer buf = ByteBuffer.wrap(uuidBytes).order(ByteOrder.LITTLE_ENDIAN);
            long msb = buf.getLong(8);
            long lsb = buf.getLong(0);
            return new ParcelUuid(new UUID(msb, lsb));
        }
        if (length == 2) {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
        } else {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
            shortUuid += (long)((uuidBytes[2] & 0xFF) << 16);
            shortUuid += (long)((uuidBytes[3] & 0xFF) << 24);
        }
        long msb = BASE_UUID.getUuid().getMostSignificantBits() + (shortUuid << 32);
        long lsb = BASE_UUID.getUuid().getLeastSignificantBits();
        return new ParcelUuid(new UUID(msb, lsb));
    }

    public static boolean is16BitUuid(ParcelUuid parcelUuid) {
        UUID uuid = parcelUuid.getUuid();
        if (uuid.getLeastSignificantBits() != BASE_UUID.getUuid().getLeastSignificantBits()) {
            return false;
        }
        return (uuid.getMostSignificantBits() & 0xFFFF0000FFFFFFFFL) == 4096L;
    }

    public static boolean is32BitUuid(ParcelUuid parcelUuid) {
        UUID uuid = parcelUuid.getUuid();
        if (uuid.getLeastSignificantBits() != BASE_UUID.getUuid().getLeastSignificantBits()) {
            return false;
        }
        if (BluetoothUuidCompat.is16BitUuid(parcelUuid)) {
            return false;
        }
        return (uuid.getMostSignificantBits() & 0xFFFFFFFFL) == 4096L;
    }
}

