/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device.ibeacon;

import com.blakequ.bluetooth_manager_lib.device.ibeacon.IBeaconDistanceDescriptor;
import com.blakequ.bluetooth_manager_lib.util.ByteUtils;

final class IBeaconUtils {
    private static final double DISTANCE_THRESHOLD_WTF = 0.0;
    private static final double DISTANCE_THRESHOLD_IMMEDIATE = 0.5;
    private static final double DISTANCE_THRESHOLD_NEAR = 3.0;

    private IBeaconUtils() {
    }

    public static double calculateAccuracy(int txPower, double rssi) {
        if (rssi == 0.0) {
            return -1.0;
        }
        double ratio = rssi * 1.0 / (double)txPower;
        if (ratio < 1.0) {
            return Math.pow(ratio, 10.0);
        }
        return 0.89976 * Math.pow(ratio, 7.7095) + 0.111;
    }

    public static String calculateUuidString(byte[] uuid) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < uuid.length; ++i) {
            int intFromByte;
            if (i == 4) {
                sb.append('-');
            }
            if (i == 6) {
                sb.append('-');
            }
            if (i == 8) {
                sb.append('-');
            }
            if (i == 10) {
                sb.append('-');
            }
            if ((intFromByte = ByteUtils.getIntFromByte(uuid[i])) <= 15) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(intFromByte));
        }
        return sb.toString();
    }

    public static IBeaconDistanceDescriptor getDistanceDescriptor(double accuracy) {
        if (accuracy < 0.0) {
            return IBeaconDistanceDescriptor.UNKNOWN;
        }
        if (accuracy < 0.5) {
            return IBeaconDistanceDescriptor.IMMEDIATE;
        }
        if (accuracy < 3.0) {
            return IBeaconDistanceDescriptor.NEAR;
        }
        return IBeaconDistanceDescriptor.FAR;
    }
}

