/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device.adrecord;

import android.annotation.SuppressLint;
import android.util.SparseArray;
import com.blakequ.bluetooth_manager_lib.device.adrecord.AdRecord;
import com.blakequ.bluetooth_manager_lib.util.ByteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AdRecordUtils {
    private AdRecordUtils() {
    }

    public static String getRecordDataAsString(AdRecord nameRecord) {
        if (nameRecord == null) {
            return "";
        }
        return new String(nameRecord.getData());
    }

    public static byte[] getServiceData(AdRecord serviceData) {
        if (serviceData == null) {
            return null;
        }
        if (serviceData.getType() != 22) {
            return null;
        }
        byte[] raw = serviceData.getData();
        return Arrays.copyOfRange(raw, 2, raw.length);
    }

    public static int getServiceDataUuid(AdRecord serviceData) {
        if (serviceData == null) {
            return -1;
        }
        if (serviceData.getType() != 22) {
            return -1;
        }
        byte[] raw = serviceData.getData();
        int uuid = (raw[1] & 0xFF) << 8;
        return uuid += raw[0] & 0xFF;
    }

    public static List<AdRecord> parseScanRecordAsList(byte[] scanRecord) {
        int type;
        byte length;
        ArrayList<AdRecord> records = new ArrayList<AdRecord>();
        int index = 0;
        while (index < scanRecord.length && (length = scanRecord[index++]) != 0 && (type = ByteUtils.getIntFromByte(scanRecord[index])) != 0) {
            byte[] data = Arrays.copyOfRange(scanRecord, index + 1, index + length);
            records.add(new AdRecord(length, type, data));
            index += length;
        }
        return Collections.unmodifiableList(records);
    }

    @SuppressLint(value={"UseSparseArrays"})
    public static Map<Integer, AdRecord> parseScanRecordAsMap(byte[] scanRecord) {
        int type;
        byte length;
        HashMap<Integer, AdRecord> records = new HashMap<Integer, AdRecord>();
        int index = 0;
        while (index < scanRecord.length && (length = scanRecord[index++]) != 0 && (type = ByteUtils.getIntFromByte(scanRecord[index])) != 0) {
            byte[] data = Arrays.copyOfRange(scanRecord, index + 1, index + length);
            records.put(type, new AdRecord(length, type, data));
            index += length;
        }
        return Collections.unmodifiableMap(records);
    }

    public static SparseArray<AdRecord> parseScanRecordAsSparseArray(byte[] scanRecord) {
        int type;
        byte length;
        SparseArray records = new SparseArray();
        int index = 0;
        while (index < scanRecord.length && (length = scanRecord[index++]) != 0 && (type = ByteUtils.getIntFromByte(scanRecord[index])) != 0) {
            byte[] data = Arrays.copyOfRange(scanRecord, index + 1, index + length);
            records.put(type, (Object)new AdRecord(length, type, data));
            index += length;
        }
        return records;
    }
}

