/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class LogUtils {
    public static int LEVEL = 1;
    public static final int V = 1;
    public static final int W = 2;
    public static final int I = 3;
    public static final int D = 4;
    public static final int E = 5;
    private static final int P = Integer.MAX_VALUE;
    private static final String _L = "[";
    private static final String _R = "]";
    private static boolean IS_SYNS = false;
    private static String LOG_FILE_DIR = "";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
    private static boolean IF_START_NEWLOG = false;
    private static String CURRENT_LOG_NAME = "";
    private static int FILE_LOG_COUNT = 0;
    private static int LOG_MAX_SIZE = 0x600000;
    private static Pattern pattern = Pattern.compile("(\\w+/)+");
    private static boolean DEBUG_MODE = true;

    public static final void setDebugLog(boolean isDebug) {
        DEBUG_MODE = isDebug;
    }

    public static final void closeLog() {
        LEVEL = 10;
    }

    public static final void openLog() {
        LEVEL = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setSyns(boolean flag) {
        Class<LogUtils> clazz = LogUtils.class;
        synchronized (LogUtils.class) {
            IS_SYNS = flag;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static final void startNewLog() {
        IF_START_NEWLOG = true;
    }

    public static final void i(String message) {
        if (LEVEL <= 3) {
            if (DEBUG_MODE) {
                Log.i((String)LogUtils.getTag(message), (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void i(Exception exp) {
        if (LEVEL <= 3) {
            if (DEBUG_MODE) {
                Log.i((String)LogUtils.getTag(exp), (String)LogUtils.getMessage(exp));
            }
            if (IS_SYNS) {
                LogFile.writeLog(exp);
            }
        }
    }

    public static final void i(String tag, String message) {
        if (LEVEL <= 3) {
            if (DEBUG_MODE) {
                Log.i((String)tag, (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void e(String message) {
        if (LEVEL <= 5) {
            if (DEBUG_MODE) {
                Log.e((String)LogUtils.getTag(message), (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void e(Exception exp) {
        if (LEVEL <= 5) {
            if (DEBUG_MODE) {
                Log.e((String)LogUtils.getTag(exp), (String)LogUtils.getMessage(exp));
            }
            if (IS_SYNS) {
                LogFile.writeLog(exp);
            }
        }
    }

    public static final void e(String tag, String message) {
        if (LEVEL <= 5) {
            if (DEBUG_MODE) {
                Log.e((String)tag, (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void w(String message) {
        if (LEVEL <= 2) {
            if (DEBUG_MODE) {
                Log.w((String)LogUtils.getTag(message), (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void w(Exception exp) {
        if (LEVEL <= 2) {
            if (DEBUG_MODE) {
                Log.w((String)LogUtils.getTag(exp), (String)LogUtils.getMessage(exp));
            }
            if (IS_SYNS) {
                LogFile.writeLog(exp);
            }
        }
    }

    public static final void w(String tag, String message) {
        if (LEVEL <= 2) {
            if (DEBUG_MODE) {
                Log.w((String)tag, (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void v(String message) {
        if (LEVEL <= 1) {
            if (DEBUG_MODE) {
                Log.v((String)LogUtils.getTag(message), (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void v(Exception exp) {
        if (LEVEL <= 1) {
            if (DEBUG_MODE) {
                Log.v((String)LogUtils.getTag(exp), (String)LogUtils.getMessage(exp));
            }
            if (IS_SYNS) {
                LogFile.writeLog(exp);
            }
        }
    }

    public static final void v(String tag, String message) {
        if (LEVEL <= 1) {
            if (DEBUG_MODE) {
                Log.v((String)tag, (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void d(String message) {
        if (LEVEL <= 4) {
            if (DEBUG_MODE) {
                Log.d((String)LogUtils.getTag(message), (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void d(Exception exp) {
        if (LEVEL <= 4) {
            if (DEBUG_MODE) {
                Log.d((String)LogUtils.getTag(exp), (String)LogUtils.getMessage(exp));
            }
            if (IS_SYNS) {
                LogFile.writeLog(exp);
            }
        }
    }

    public static final void d(String tag, String message) {
        if (LEVEL <= 4) {
            if (DEBUG_MODE) {
                Log.d((String)tag, (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void print(String message) {
        if (LEVEL <= Integer.MAX_VALUE) {
            if (DEBUG_MODE) {
                Log.e((String)LogUtils.getTag(message), (String)message);
            }
            if (IS_SYNS) {
                LogFile.writeLog(message);
            }
        }
    }

    public static final void print(Exception exp) {
        if (LEVEL <= Integer.MAX_VALUE) {
            if (DEBUG_MODE) {
                Log.e((String)LogUtils.getTag(exp), (String)LogUtils.getMessage(exp));
            }
            if (IS_SYNS) {
                LogFile.writeLog(exp);
            }
        }
    }

    private static String getTag(String msg) {
        if (msg != null && Thread.currentThread().getStackTrace().length > 0) {
            String name = Thread.currentThread().getStackTrace()[0].getClassName();
            return _L + name.substring(name.lastIndexOf(".") + 1) + _R;
        }
        return "[null]";
    }

    private static String getTag(Exception exp) {
        if (exp != null) {
            if (exp.getStackTrace().length > 0) {
                String name = exp.getStackTrace()[0].getClassName();
                return _L + name.substring(name.lastIndexOf(".") + 1) + _R;
            }
            return "[exception]";
        }
        return "[null]";
    }

    private static String getMessage(Exception exp) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] element = exp.getStackTrace();
        int n = 0;
        sb.append("\n");
        sb.append(exp.toString());
        sb.append("\n");
        for (StackTraceElement e : element) {
            sb.append(e.getClassName());
            sb.append(".");
            sb.append(e.getMethodName());
            sb.append(_L);
            sb.append(e.getLineNumber());
            sb.append(_R);
            sb.append("\n");
            if (++n >= 2) break;
        }
        if (exp.getCause() != null) {
            sb.append("Caused by: ");
            sb.append(exp.getMessage());
        }
        return sb.toString();
    }

    public static final void setLogFilePath(String path) {
        String url;
        LOG_FILE_DIR = url = SDcardUtil.getPath() + File.separator + path;
    }

    public static final void setDefaultFilePath(Context context) {
        String pkName = context.getPackageName().replaceAll("\\.", "\\/");
        LogUtils.setLogFilePath(pkName);
    }

    private static String getCurrTimeDir() {
        return sdf.format(new Date());
    }

    public static String getDateCNNotSecond() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5  HH:mm");
        String date = format.format(new Date(System.currentTimeMillis()));
        return date;
    }

    private static class SDcardUtil {
        private SDcardUtil() {
        }

        public static String getPath() {
            if (SDcardUtil.isMounted()) {
                return Environment.getExternalStorageDirectory().getPath();
            }
            LogFile.print("please check if sd card is not mounted");
            return "";
        }

        @SuppressLint(value={"NewApi"})
        public static boolean isMounted() {
            boolean canRead = Environment.getExternalStorageDirectory().canRead();
            boolean onlyRead = Environment.getExternalStorageState().equals("mounted_ro");
            boolean unMounted = Environment.getExternalStorageState().equals("unmounted");
            return canRead && !onlyRead && !unMounted;
        }
    }

    private static class LogFile {
        private LogFile() {
        }

        private static void print(String msg) {
            if (LEVEL <= Integer.MAX_VALUE) {
                Log.e((String)LogUtils.getTag(msg), (String)msg);
            }
        }

        public static synchronized void writeLog(String message) {
            File f = LogFile.getFile();
            if (f != null) {
                try {
                    FileWriter fw = new FileWriter(f, true);
                    BufferedWriter bw = new BufferedWriter(fw);
                    bw.append("---------" + LogUtils.getDateCNNotSecond() + "----------\n");
                    bw.append(message);
                    bw.append("\n");
                    bw.flush();
                    bw.close();
                    fw.close();
                }
                catch (IOException e) {
                    LogFile.print("writeLog error, " + e.getMessage());
                }
            } else {
                LogFile.print("writeLog error, due to the file dir is error");
            }
        }

        public static synchronized void writeLog(Exception exp) {
            File f = LogFile.getFile();
            if (f != null) {
                try {
                    FileWriter fw = new FileWriter(f, true);
                    PrintWriter pw = new PrintWriter(fw);
                    pw.append("---------" + LogUtils.getDateCNNotSecond() + "----------\n");
                    exp.printStackTrace(pw);
                    pw.flush();
                    pw.close();
                    fw.close();
                }
                catch (IOException e) {
                    LogFile.print("writeLog error, " + e.getMessage());
                }
            } else {
                LogFile.print("writeLog error, due to the file dir is error");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final File getFile() {
            if ("".equals(LOG_FILE_DIR)) {
                return null;
            }
            Class<LogUtils> clazz = LogUtils.class;
            synchronized (LogUtils.class) {
                File file;
                if (!IF_START_NEWLOG) {
                    File currFile = new File(CURRENT_LOG_NAME);
                    if (currFile.length() >= (long)LOG_MAX_SIZE) {
                        IF_START_NEWLOG = true;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return LogFile.getFile();
                    }
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return currFile;
                }
                File f = new File(LOG_FILE_DIR);
                if (!f.exists()) {
                    f.mkdirs();
                }
                if (!(file = new File(f.getAbsolutePath() + File.separator + LogUtils.getCurrTimeDir() + ".log")).exists()) {
                    try {
                        file.createNewFile();
                        FILE_LOG_COUNT = 0;
                        IF_START_NEWLOG = false;
                        CURRENT_LOG_NAME = file.getAbsolutePath();
                    }
                    catch (IOException e) {
                        LogFile.print("createFile error , " + e.getMessage());
                    }
                } else if (IF_START_NEWLOG) {
                    FILE_LOG_COUNT++;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return new File(f.getAbsolutePath() + File.separator + LogUtils.getCurrTimeDir() + "_" + FILE_LOG_COUNT + ".log");
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return file;
            }
        }
    }
}

