/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device;

import android.bluetooth.BluetoothDevice;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.blakequ.bluetooth_manager_lib.device.BeaconDevice;
import com.blakequ.bluetooth_manager_lib.device.BeaconType;
import com.blakequ.bluetooth_manager_lib.device.BeaconUtils;
import com.blakequ.bluetooth_manager_lib.device.BluetoothService;
import com.blakequ.bluetooth_manager_lib.device.adrecord.AdRecordStore;
import com.blakequ.bluetooth_manager_lib.device.adrecord.AdRecordUtils;
import com.blakequ.bluetooth_manager_lib.device.ibeacon.IBeaconDevice;
import com.blakequ.bluetooth_manager_lib.device.resolvers.BluetoothClassResolver;
import com.blakequ.bluetooth_manager_lib.util.ByteUtils;
import com.blakequ.bluetooth_manager_lib.util.LimitedLinkHashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BluetoothLeDevice
implements Parcelable,
BeaconDevice {
    public static final Parcelable.Creator<BluetoothLeDevice> CREATOR = new Parcelable.Creator<BluetoothLeDevice>(){

        public BluetoothLeDevice createFromParcel(Parcel in) {
            return new BluetoothLeDevice(in);
        }

        public BluetoothLeDevice[] newArray(int size) {
            return new BluetoothLeDevice[size];
        }
    };
    protected static final int MAX_RSSI_LOG_SIZE = 10;
    private static final String PARCEL_EXTRA_BLUETOOTH_DEVICE = "bluetooth_device";
    private static final String PARCEL_EXTRA_CURRENT_RSSI = "current_rssi";
    private static final String PARCEL_EXTRA_CURRENT_TIMESTAMP = "current_timestamp";
    private static final String PARCEL_EXTRA_DEVICE_RSSI_LOG = "device_rssi_log";
    private static final String PARCEL_EXTRA_DEVICE_SCANRECORD = "device_scanrecord";
    private static final String PARCEL_EXTRA_DEVICE_SCANRECORD_STORE = "device_scanrecord_store";
    private static final String PARCEL_EXTRA_FIRST_RSSI = "device_first_rssi";
    private static final String PARCEL_EXTRA_FIRST_TIMESTAMP = "first_timestamp";
    private static final long LOG_INVALIDATION_THRESHOLD = 10000L;
    private final AdRecordStore mRecordStore;
    private final BluetoothDevice mDevice;
    private final Map<Long, Integer> mRssiLog;
    private final byte[] mScanRecord;
    private final int mFirstRssi;
    private final long mFirstTimestamp;
    private int mCurrentRssi;
    private long mCurrentTimestamp;
    private transient Set<BluetoothService> mServiceSet;

    public BluetoothLeDevice(BluetoothDevice device, int rssi, byte[] scanRecord, long timestamp) {
        this.mDevice = device;
        this.mFirstRssi = rssi;
        this.mFirstTimestamp = timestamp;
        this.mRecordStore = new AdRecordStore(AdRecordUtils.parseScanRecordAsSparseArray(scanRecord));
        this.mScanRecord = scanRecord;
        this.mRssiLog = new LimitedLinkHashMap<Long, Integer>(10);
        this.updateRssiReading(timestamp, rssi);
    }

    public BluetoothLeDevice(BluetoothLeDevice device) {
        this.mCurrentRssi = device.getRssi();
        this.mCurrentTimestamp = device.getTimestamp();
        this.mDevice = device.getDevice();
        this.mFirstRssi = device.getFirstRssi();
        this.mFirstTimestamp = device.getFirstTimestamp();
        this.mRecordStore = new AdRecordStore(AdRecordUtils.parseScanRecordAsSparseArray(device.getScanRecord()));
        this.mRssiLog = device.getRssiLog();
        this.mScanRecord = device.getScanRecord();
    }

    protected BluetoothLeDevice(Parcel in) {
        Bundle b = in.readBundle(this.getClass().getClassLoader());
        this.mCurrentRssi = b.getInt(PARCEL_EXTRA_CURRENT_RSSI, 0);
        this.mCurrentTimestamp = b.getLong(PARCEL_EXTRA_CURRENT_TIMESTAMP, 0L);
        this.mDevice = (BluetoothDevice)b.getParcelable(PARCEL_EXTRA_BLUETOOTH_DEVICE);
        this.mFirstRssi = b.getInt(PARCEL_EXTRA_FIRST_RSSI, 0);
        this.mFirstTimestamp = b.getLong(PARCEL_EXTRA_FIRST_TIMESTAMP, 0L);
        this.mRecordStore = (AdRecordStore)b.getParcelable(PARCEL_EXTRA_DEVICE_SCANRECORD_STORE);
        this.mRssiLog = (Map)((Object)b.getSerializable(PARCEL_EXTRA_DEVICE_RSSI_LOG));
        this.mScanRecord = b.getByteArray(PARCEL_EXTRA_DEVICE_SCANRECORD);
    }

    @Override
    public BeaconType getBeaconType() {
        return BeaconUtils.getBeaconType(this);
    }

    public IBeaconDevice getIBeaconDevice() {
        if (this.getBeaconType() == BeaconType.IBEACON) {
            return new IBeaconDevice(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRssiLog(long timestamp, int rssiReading) {
        Map<Long, Integer> map = this.mRssiLog;
        synchronized (map) {
            if (timestamp - this.mCurrentTimestamp > 10000L) {
                this.mRssiLog.clear();
            }
            this.mCurrentRssi = rssiReading;
            this.mCurrentTimestamp = timestamp;
            this.mRssiLog.put(timestamp, rssiReading);
        }
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BluetoothLeDevice other = (BluetoothLeDevice)obj;
        if (this.mCurrentRssi != other.mCurrentRssi) {
            return false;
        }
        if (this.mCurrentTimestamp != other.mCurrentTimestamp) {
            return false;
        }
        if (this.mDevice == null ? other.mDevice != null : !this.mDevice.equals((Object)other.mDevice)) {
            return false;
        }
        if (this.mFirstRssi != other.mFirstRssi) {
            return false;
        }
        if (this.mFirstTimestamp != other.mFirstTimestamp) {
            return false;
        }
        if (this.mRecordStore == null ? other.mRecordStore != null : !this.mRecordStore.equals(other.mRecordStore)) {
            return false;
        }
        if (this.mRssiLog == null ? other.mRssiLog != null : !this.mRssiLog.equals(other.mRssiLog)) {
            return false;
        }
        return Arrays.equals(this.mScanRecord, other.mScanRecord);
    }

    public AdRecordStore getAdRecordStore() {
        return this.mRecordStore;
    }

    public String getAddress() {
        return this.mDevice.getAddress();
    }

    public String getBluetoothDeviceBondState() {
        return BluetoothLeDevice.resolveBondingState(this.mDevice.getBondState());
    }

    public String getBluetoothDeviceClassName() {
        return BluetoothClassResolver.resolveDeviceClass(this.mDevice.getBluetoothClass().getDeviceClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BluetoothService> getBluetoothDeviceKnownSupportedServices() {
        if (this.mServiceSet == null) {
            BluetoothLeDevice bluetoothLeDevice = this;
            synchronized (bluetoothLeDevice) {
                if (this.mServiceSet == null) {
                    HashSet<BluetoothService> serviceSet = new HashSet<BluetoothService>();
                    for (BluetoothService service : BluetoothService.values()) {
                        if (!this.mDevice.getBluetoothClass().hasService(service.getAndroidConstant())) continue;
                        serviceSet.add(service);
                    }
                    this.mServiceSet = Collections.unmodifiableSet(serviceSet);
                }
            }
        }
        return this.mServiceSet;
    }

    public String getBluetoothDeviceMajorClassName() {
        return BluetoothClassResolver.resolveMajorDeviceClass(this.mDevice.getBluetoothClass().getMajorDeviceClass());
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    public int getFirstRssi() {
        return this.mFirstRssi;
    }

    public long getFirstTimestamp() {
        return this.mFirstTimestamp;
    }

    public String getName() {
        return this.mDevice.getName();
    }

    public int getRssi() {
        return this.mCurrentRssi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Long, Integer> getRssiLog() {
        Map<Long, Integer> map = this.mRssiLog;
        synchronized (map) {
            return this.mRssiLog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRunningAverageRssi() {
        int sum = 0;
        int count = 0;
        Map<Long, Integer> map = this.mRssiLog;
        synchronized (map) {
            for (Long aLong : this.mRssiLog.keySet()) {
                ++count;
                sum += this.mRssiLog.get(aLong).intValue();
            }
        }
        if (count > 0) {
            return sum / count;
        }
        return 0.0;
    }

    public byte[] getScanRecord() {
        return this.mScanRecord;
    }

    public long getTimestamp() {
        return this.mCurrentTimestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mCurrentRssi;
        result = 31 * result + (int)(this.mCurrentTimestamp ^ this.mCurrentTimestamp >>> 32);
        result = 31 * result + (this.mDevice == null ? 0 : this.mDevice.hashCode());
        result = 31 * result + this.mFirstRssi;
        result = 31 * result + (int)(this.mFirstTimestamp ^ this.mFirstTimestamp >>> 32);
        result = 31 * result + (this.mRecordStore == null ? 0 : this.mRecordStore.hashCode());
        result = 31 * result + (this.mRssiLog == null ? 0 : this.mRssiLog.hashCode());
        result = 31 * result + Arrays.hashCode(this.mScanRecord);
        return result;
    }

    public String toString() {
        return "BluetoothLeDevice [mDevice=" + this.mDevice + ", mRssi=" + this.mFirstRssi + ", mScanRecord=" + ByteUtils.byteArrayToHexString(this.mScanRecord) + ", mRecordStore=" + this.mRecordStore + ", getBluetoothDeviceBondState()=" + this.getBluetoothDeviceBondState() + ", getBluetoothDeviceClassName()=" + this.getBluetoothDeviceClassName() + "]";
    }

    public void updateRssiReading(long timestamp, int rssiReading) {
        this.addToRssiLog(timestamp, rssiReading);
    }

    public void writeToParcel(Parcel parcel, int arg1) {
        Bundle b = new Bundle(this.getClass().getClassLoader());
        b.putByteArray(PARCEL_EXTRA_DEVICE_SCANRECORD, this.mScanRecord);
        b.putInt(PARCEL_EXTRA_FIRST_RSSI, this.mFirstRssi);
        b.putInt(PARCEL_EXTRA_CURRENT_RSSI, this.mCurrentRssi);
        b.putLong(PARCEL_EXTRA_FIRST_TIMESTAMP, this.mFirstTimestamp);
        b.putLong(PARCEL_EXTRA_CURRENT_TIMESTAMP, this.mCurrentTimestamp);
        b.putParcelable(PARCEL_EXTRA_BLUETOOTH_DEVICE, (Parcelable)this.mDevice);
        b.putParcelable(PARCEL_EXTRA_DEVICE_SCANRECORD_STORE, (Parcelable)this.mRecordStore);
        b.putSerializable(PARCEL_EXTRA_DEVICE_RSSI_LOG, (Serializable)((Object)this.mRssiLog));
        parcel.writeBundle(b);
    }

    private static String resolveBondingState(int bondState) {
        switch (bondState) {
            case 12: {
                return "Paired";
            }
            case 11: {
                return "Pairing";
            }
            case 10: {
                return "Unbonded";
            }
        }
        return "Unknown";
    }
}

