/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.connect;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BluetoothOperatorQueue {
    private String uuid;
    private final Queue<SimpleEntity> sWriteQueue = new ConcurrentLinkedQueue<SimpleEntity>();
    private boolean sIsWriting = false;
    private BluetoothGatt mBluetoothGatt;

    public synchronized void clean() {
        this.sIsWriting = false;
        this.uuid = null;
        this.sWriteQueue.clear();
    }

    public void start(BluetoothGatt mBluetoothGatt) {
        if (mBluetoothGatt == null) {
            throw new IllegalArgumentException("BluetoothGatt is null, can not write or read BluetoothGatt Service");
        }
        this.mBluetoothGatt = mBluetoothGatt;
        this.nextOperator();
    }

    public synchronized void addOperator(BluetoothGattCharacteristic gattCharacteristic, boolean isWrite) {
        SimpleEntity entity = new SimpleEntity(isWrite, gattCharacteristic);
        this.sWriteQueue.add(entity);
    }

    public synchronized void addOperator(BluetoothGattDescriptor gattDescriptor, boolean isWrite) {
        SimpleEntity entity = new SimpleEntity(isWrite, gattDescriptor);
        this.sWriteQueue.add(entity);
    }

    public synchronized void nextOperator() {
        this.sIsWriting = false;
        if (!this.sWriteQueue.isEmpty() && !this.sIsWriting) {
            this.doOperator(this.sWriteQueue.poll());
        }
    }

    private synchronized boolean doOperator(SimpleEntity entity) {
        if (this.mBluetoothGatt == null) {
            LogUtils.e("BlueToothService", "do operator fail, bluetoothgatt is null");
            return false;
        }
        boolean result = true;
        if (entity.obj instanceof BluetoothGattCharacteristic) {
            this.sIsWriting = true;
            BluetoothGattCharacteristic character = (BluetoothGattCharacteristic)entity.obj;
            this.uuid = character.getUuid().toString();
            result = entity.isWrite ? this.mBluetoothGatt.writeCharacteristic(character) : this.mBluetoothGatt.readCharacteristic(character);
        } else if (entity.obj instanceof BluetoothGattDescriptor) {
            this.sIsWriting = true;
            BluetoothGattDescriptor desc = (BluetoothGattDescriptor)entity.obj;
            this.uuid = desc.getUuid().toString();
            result = entity.isWrite ? this.mBluetoothGatt.writeDescriptor(desc) : this.mBluetoothGatt.readDescriptor(desc);
        } else {
            LogUtils.d("BlueToothService", "do operator next");
            this.nextOperator();
        }
        LogUtils.d("BlueToothService", "do operator result:" + result + " " + this.uuid);
        return result;
    }

    private static class SimpleEntity {
        public boolean isWrite;
        public Object obj;
        public String info;

        public SimpleEntity(boolean isWrite, Object obj) {
            this.isWrite = isWrite;
            this.obj = obj;
        }

        public SimpleEntity(boolean isWrite, Object obj, String info) {
            this.isWrite = isWrite;
            this.obj = obj;
            this.info = info;
        }
    }
}

