/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device.ibeacon;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import com.blakequ.bluetooth_manager_lib.device.BeaconDevice;
import com.blakequ.bluetooth_manager_lib.device.BeaconType;
import com.blakequ.bluetooth_manager_lib.device.BluetoothLeDevice;
import com.blakequ.bluetooth_manager_lib.device.ibeacon.IBeaconDistanceDescriptor;
import com.blakequ.bluetooth_manager_lib.device.ibeacon.IBeaconManufacturerData;
import com.blakequ.bluetooth_manager_lib.device.ibeacon.IBeaconUtils;

@SuppressLint(value={"ParcelCreator"})
public class IBeaconDevice
extends BluetoothLeDevice
implements BeaconDevice {
    private final IBeaconManufacturerData mIBeaconData = new IBeaconManufacturerData(this);

    public IBeaconDevice(BluetoothDevice device, int rssi, byte[] scanRecord) {
        super(device, rssi, scanRecord, 0L);
    }

    public IBeaconDevice(BluetoothDevice device, int rssi, byte[] scanRecord, long timestamp) {
        super(device, rssi, scanRecord, timestamp);
    }

    public IBeaconDevice(BluetoothLeDevice device) {
        super(device);
    }

    private IBeaconDevice(Parcel in) {
        super(in);
    }

    public double getAccuracy() {
        return IBeaconUtils.calculateAccuracy(this.getCalibratedTxPower(), this.getRunningAverageRssi());
    }

    @Override
    public BeaconType getBeaconType() {
        return BeaconType.IBEACON;
    }

    public int getCalibratedTxPower() {
        return this.getIBeaconData().getCalibratedTxPower();
    }

    public int getCompanyIdentifier() {
        return this.getIBeaconData().getCompanyIdentifier();
    }

    public IBeaconDistanceDescriptor getDistanceDescriptor() {
        return IBeaconUtils.getDistanceDescriptor(this.getAccuracy());
    }

    public IBeaconManufacturerData getIBeaconData() {
        return this.mIBeaconData;
    }

    public int getMajor() {
        return this.getIBeaconData().getMajor();
    }

    public int getMinor() {
        return this.getIBeaconData().getMinor();
    }

    public String getUUID() {
        return this.getIBeaconData().getUUID();
    }
}

