/*
 * Decompiled with CFR 0.152.
 */
package com.blade.task;

import com.blade.kit.BladeKit;
import com.blade.task.Task;
import com.blade.task.cron.CronExecutorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private static final Map<String, Task> TASK_MAP = new HashMap<String, Task>(8);
    private static CronExecutorService cronExecutorService;

    public static void init(CronExecutorService cronExecutorService) {
        if (null != TaskManager.cronExecutorService) {
            throw new RuntimeException("Don't re-initialize the task thread pool.");
        }
        TaskManager.cronExecutorService = cronExecutorService;
        Runtime.getRuntime().addShutdownHook(new Thread(cronExecutorService::shutdown));
    }

    public static CronExecutorService getExecutorService() {
        return cronExecutorService;
    }

    public static void addTask(Task task) {
        TASK_MAP.put(task.getName(), task);
        log.info("{}Add task [{}]", (Object)BladeKit.getStartedSymbol(), (Object)task.getName());
    }

    public static List<Task> getTasks() {
        return new ArrayList<Task>(TASK_MAP.values());
    }

    public static Task getTask(String name) {
        return TASK_MAP.get(name);
    }

    public static boolean stopTask(String name) {
        Task task = TASK_MAP.get(name);
        return task.stop();
    }

    private TaskManager() {
    }
}

