/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.exception.BladeException;
import com.blade.kit.JsonKit;
import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Body;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.StringBody;
import com.blade.mvc.ui.ModelAndView;
import com.blade.mvc.wrapper.OutputStreamWrapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface Response {
    public int statusCode();

    public Response status(int var1);

    default public Response badRequest() {
        return this.status(400);
    }

    default public Response unauthorized() {
        return this.status(401);
    }

    default public Response notFound() {
        return this.status(404);
    }

    public Response contentType(String var1);

    public String contentType();

    public Map<String, String> headers();

    public Response header(String var1, String var2);

    public Map<String, String> cookies();

    public Set<io.netty.handler.codec.http.cookie.Cookie> cookiesRaw();

    public Response cookie(Cookie var1);

    public Response cookie(String var1, String var2);

    public Response cookie(String var1, String var2, int var3);

    public Response cookie(String var1, String var2, int var3, boolean var4);

    public Response cookie(String var1, String var2, String var3, int var4, boolean var5);

    public Response removeCookie(String var1);

    default public void text(String text) {
        if (null == text) {
            return;
        }
        if (null == this.contentType()) {
            this.contentType("text/plain; charset=UTF-8");
        }
        this.body(text);
    }

    default public void html(String html) {
        if (null == html) {
            return;
        }
        if (null == this.contentType()) {
            this.contentType("text/html; charset=UTF-8");
        }
        this.body(html);
    }

    default public void json(String json) {
        if (null == json) {
            return;
        }
        if (null == this.contentType()) {
            if (Objects.requireNonNull(WebContext.request()).isIE()) {
                this.contentType("text/html; charset=UTF-8");
            } else {
                this.contentType("application/json; charset=UTF-8");
            }
        }
        this.body(json);
    }

    default public void json(Object bean) {
        if (null == bean) {
            return;
        }
        this.json(JsonKit.toString(bean));
    }

    default public void body(String body) {
        this.body(new StringBody(body));
    }

    public Response body(Body var1);

    public void download(String var1, File var2) throws Exception;

    @Deprecated
    public OutputStreamWrapper outputStream() throws IOException;

    default public void render(String view) {
        if (StringKit.isEmpty(view)) {
            throw new BladeException(500, "Render view not empty.");
        }
        this.render(new ModelAndView(view));
    }

    public void render(ModelAndView var1);

    public void redirect(String var1);

    public ModelAndView modelAndView();

    public Body body();
}

