/*
 * Decompiled with CFR 0.152.
 */
package com.blacklocus.qs;

import com.blacklocus.qs.DelegatingMessageProvider;
import com.blacklocus.qs.Message;
import com.blacklocus.qs.MessageProvider;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProviders {
    public static MessageProvider newDefaultMessageProvider(MessageProvider messageProvider, long maxTimesNextEmpty) {
        return MessageProviders.newSafeMessageProvider(MessageProviders.newUntilNextEmptyMessageProvider(messageProvider, maxTimesNextEmpty));
    }

    public static MessageProvider newDefaultMessageProvider(MessageProvider messageProvider, long maxTimesNextEmpty, int maxMessages) {
        return MessageProviders.newSafeMessageProvider(MessageProviders.newUntilNextEmptyOrMaximumMessageProvider(messageProvider, maxTimesNextEmpty, maxMessages));
    }

    public static MessageProvider newSafeMessageProvider(final MessageProvider messageProvider) {
        return new MessageProvider(){
            private final Logger log = LoggerFactory.getLogger(this.getClass());

            @Override
            public Iterator<Collection<Message>> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                try {
                    return messageProvider.hasNext();
                }
                catch (Throwable t) {
                    this.log.error("An error occurred during hasNext()", t);
                    return true;
                }
            }

            @Override
            public Collection<Message> next() {
                try {
                    return (Collection)messageProvider.next();
                }
                catch (Throwable t) {
                    this.log.error("An error occurred during next()", t);
                    return Collections.emptyList();
                }
            }

            @Override
            public void remove() {
                try {
                    messageProvider.remove();
                }
                catch (Throwable t) {
                    this.log.error("An error occurred during remove()", t);
                }
            }

            @Override
            public void delete(Message message) {
                try {
                    messageProvider.delete(message);
                }
                catch (Throwable t) {
                    this.log.error("An error occurred during delete()", t);
                }
            }
        };
    }

    public static MessageProvider newUntilNextEmptyMessageProvider(MessageProvider messageProvider, final long maxTimesNextEmpty) {
        return new DelegatingMessageProvider(messageProvider){
            private long timesEmpty;
            {
                super(x0);
                this.timesEmpty = 0L;
            }

            @Override
            public boolean hasNext() {
                return this.messageProvider.hasNext() && this.timesEmpty <= maxTimesNextEmpty;
            }

            @Override
            public Collection<Message> next() {
                Collection messages = (Collection)this.messageProvider.next();
                this.timesEmpty = messages.size() > 0 ? 0L : ++this.timesEmpty;
                return messages;
            }
        };
    }

    public static MessageProvider newUntilNextEmptyOrMaximumMessageProvider(MessageProvider messageProvider, long maxTimesNextEmpty, int maxMessages) {
        return MessageProviders.newUntilSlowOrMaximumMessageProvider(messageProvider, maxTimesNextEmpty, 0, maxMessages);
    }

    public static MessageProvider newUntilSlowOrMaximumMessageProvider(MessageProvider messageProvider, final long maxTimesSlow, final int slowThreshold, final int maxMessages) {
        return new DelegatingMessageProvider(messageProvider){
            private long timesSlow;
            private int messageCounter;
            {
                super(x0);
                this.timesSlow = 0L;
                this.messageCounter = 0;
            }

            @Override
            public boolean hasNext() {
                return this.messageProvider.hasNext() && this.timesSlow <= maxTimesSlow && this.messageCounter < maxMessages;
            }

            @Override
            public Collection<Message> next() {
                Collection messages = (Collection)this.messageProvider.next();
                this.timesSlow = messages.size() > slowThreshold ? 0L : ++this.timesSlow;
                this.messageCounter += messages.size();
                return messages;
            }
        };
    }

    public static MessageProvider filtered(MessageProvider messageProvider, final Predicate<Message> filter) {
        return new DelegatingMessageProvider(messageProvider){

            @Override
            public Collection<Message> next() {
                return Collections2.filter((Collection)((Collection)this.messageProvider.next()), (Predicate)filter);
            }
        };
    }

    public static MessageProvider scanningCallback(MessageProvider messageProvider, final NextCallback nextCallback) {
        return new DelegatingMessageProvider(messageProvider){

            @Override
            public Collection<Message> next() {
                Object messages = super.next();
                nextCallback.next((Collection<Message>)messages);
                return messages;
            }
        };
    }

    public static interface NextCallback {
        public void next(Collection<Message> var1);
    }
}

