/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.protex.util;

import com.blackducksoftware.sdk.protex.common.ComponentColumn;
import com.blackducksoftware.sdk.protex.common.ComponentPageFilter;
import com.blackducksoftware.sdk.protex.common.ComponentType;
import com.blackducksoftware.sdk.protex.common.FileDiscoveryPatternColumn;
import com.blackducksoftware.sdk.protex.common.FileDiscoveryPatternPageFilter;
import com.blackducksoftware.sdk.protex.common.LearnedIdentificationColumn;
import com.blackducksoftware.sdk.protex.common.LearnedIdentificationPageFilter;
import com.blackducksoftware.sdk.protex.common.PageFilter;
import com.blackducksoftware.sdk.protex.common.SortType;
import com.blackducksoftware.sdk.protex.license.LicenseInfoColumn;
import com.blackducksoftware.sdk.protex.license.LicenseInfoPageFilter;
import com.blackducksoftware.sdk.protex.obligation.AssignedObligationColumn;
import com.blackducksoftware.sdk.protex.obligation.AssignedObligationPageFilter;
import com.blackducksoftware.sdk.protex.project.ProjectColumn;
import com.blackducksoftware.sdk.protex.project.ProjectInfoColumn;
import com.blackducksoftware.sdk.protex.project.ProjectInfoPageFilter;
import com.blackducksoftware.sdk.protex.project.ProjectPageFilter;
import com.blackducksoftware.sdk.protex.project.localcomponent.LocalComponentColumn;
import com.blackducksoftware.sdk.protex.project.localcomponent.LocalComponentPageFilter;
import com.blackducksoftware.sdk.protex.project.template.TemplateInfoColumn;
import com.blackducksoftware.sdk.protex.project.template.TemplateInfoPageFilter;
import com.blackducksoftware.sdk.protex.role.UserRoleInfoColumn;
import com.blackducksoftware.sdk.protex.role.UserRoleInfoPageFilter;
import com.blackducksoftware.sdk.protex.user.UserColumn;
import com.blackducksoftware.sdk.protex.user.UserPageFilter;
import java.util.Arrays;

public final class PageFilterFactory {
    public static ProjectPageFilter getAllRows(ProjectColumn sortColumn) {
        ProjectPageFilter pageFilter = PageFilterFactory.getAllRows(new ProjectPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static ProjectInfoPageFilter getAllRows(ProjectInfoColumn sortColumn) {
        ProjectInfoPageFilter pageFilter = PageFilterFactory.getAllRows(new ProjectInfoPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static TemplateInfoPageFilter getAllRows(TemplateInfoColumn sortColumn) {
        TemplateInfoPageFilter pageFilter = PageFilterFactory.getAllRows(new TemplateInfoPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static LocalComponentPageFilter getAllRows(LocalComponentColumn sortColumn) {
        LocalComponentPageFilter pageFilter = PageFilterFactory.getAllRows(new LocalComponentPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static LicenseInfoPageFilter getAllRows(LicenseInfoColumn sortColumn) {
        LicenseInfoPageFilter pageFilter = PageFilterFactory.getAllRows(new LicenseInfoPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static ComponentPageFilter getAllRows(ComponentColumn sortColumn) {
        ComponentPageFilter pageFilter = PageFilterFactory.getAllRows(new ComponentPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        pageFilter.setIncludeDeprecated(Boolean.valueOf(false));
        pageFilter.getComponentTypes().addAll(Arrays.asList(ComponentType.values()));
        return pageFilter;
    }

    public static AssignedObligationPageFilter getAllRows(AssignedObligationColumn sortColumn) {
        AssignedObligationPageFilter pageFilter = PageFilterFactory.getAllRows(new AssignedObligationPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static LearnedIdentificationPageFilter getAllRows(LearnedIdentificationColumn sortColumn) {
        LearnedIdentificationPageFilter pageFilter = PageFilterFactory.getAllRows(new LearnedIdentificationPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static FileDiscoveryPatternPageFilter getAllRows(FileDiscoveryPatternColumn sortColumn) {
        return PageFilterFactory.getAllRows(sortColumn, SortType.ALPHABETICAL_CASE_INSENSITIVE);
    }

    public static FileDiscoveryPatternPageFilter getAllRows(FileDiscoveryPatternColumn sortColumn, SortType sortType) {
        FileDiscoveryPatternPageFilter pageFilter = PageFilterFactory.getAllRows(new FileDiscoveryPatternPageFilter(), sortType);
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static UserPageFilter getAllRows(UserColumn sortColumn) {
        UserPageFilter pageFilter = PageFilterFactory.getAllRows(new UserPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static UserPageFilter getAllRows(UserColumn sortColumn, SortType sortType) {
        UserPageFilter pageFilter = PageFilterFactory.getAllRows(new UserPageFilter(), sortType);
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static UserRoleInfoPageFilter getAllRows(UserRoleInfoColumn sortColumn) {
        UserRoleInfoPageFilter pageFilter = PageFilterFactory.getAllRows(new UserRoleInfoPageFilter());
        pageFilter.setSortedColumn(sortColumn);
        return pageFilter;
    }

    public static ComponentPageFilter getFirstPage(int pageSize, ComponentColumn sortedColumn, boolean sortAssending) {
        ComponentPageFilter firstPage = PageFilterFactory.getFirstPage(new ComponentPageFilter(), pageSize, sortAssending);
        firstPage.setSortedColumn(sortedColumn);
        firstPage.setIncludeDeprecated(Boolean.valueOf(false));
        firstPage.getComponentTypes().addAll(Arrays.asList(ComponentType.values()));
        return firstPage;
    }

    public static LicenseInfoPageFilter getFirstPage(int pageSize, LicenseInfoColumn sortedColumn, boolean sortAssending) {
        LicenseInfoPageFilter firstPage = PageFilterFactory.getFirstPage(new LicenseInfoPageFilter(), pageSize, sortAssending);
        firstPage.setSortedColumn(sortedColumn);
        return firstPage;
    }

    public static <T extends PageFilter> T getNextPage(T pageFilter) {
        int pageSize = 1;
        pageSize = pageFilter.getFirstRowIndex() == 0 ? Math.max(1, pageFilter.getLastRowIndex() - pageFilter.getFirstRowIndex()) : Math.max(1, pageFilter.getLastRowIndex() - pageFilter.getFirstRowIndex() + 1);
        pageFilter.setFirstRowIndex(Integer.valueOf(pageFilter.getLastRowIndex() + 1));
        pageFilter.setLastRowIndex(Integer.valueOf(pageFilter.getFirstRowIndex() + pageSize - 1));
        return pageFilter;
    }

    private static <T extends PageFilter> T getAllRows(T pageFilter) {
        return PageFilterFactory.getAllRows(pageFilter, SortType.ALPHABETICAL_CASE_INSENSITIVE);
    }

    private static <T extends PageFilter> T getAllRows(T pageFilter, SortType sortType) {
        pageFilter.setFirstRowIndex(Integer.valueOf(0));
        pageFilter.setLastRowIndex(Integer.valueOf(Integer.MAX_VALUE));
        pageFilter.setSortAscending(Boolean.TRUE);
        pageFilter.setSortType(sortType);
        return pageFilter;
    }

    private static <T extends PageFilter> T getFirstPage(T pageFilter, int pageSize, boolean sortAssending) {
        pageFilter.setFirstRowIndex(Integer.valueOf(0));
        pageFilter.setLastRowIndex(Integer.valueOf(pageSize));
        pageFilter.setSortAscending(Boolean.valueOf(sortAssending));
        pageFilter.setSortType(SortType.ALPHABETICAL_CASE_INSENSITIVE);
        return pageFilter;
    }
}

