/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.protex.util;

import com.blackducksoftware.sdk.protex.project.codetree.CodeTreeNode;
import com.blackducksoftware.sdk.protex.project.codetree.CodeTreeNodeRequest;
import com.blackducksoftware.sdk.protex.project.codetree.CodeTreeNodeType;
import com.blackducksoftware.sdk.protex.project.codetree.NodeCount;
import com.blackducksoftware.sdk.protex.project.codetree.NodeCountType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeTreeUtilities {
    public static final Integer INFINITE_DEPTH = -1;
    public static final Integer SINGLE_NODE = 0;
    public static final Integer DIRECT_CHILDREN = 1;
    public static final List<CodeTreeNodeType> ALL_CODE_TREE_NODE_TYPES = Arrays.asList(CodeTreeNodeType.values());
    public static final CodeTreeNodeRequest ALL_NODES_PARAMETERS = new CodeTreeNodeRequest();
    private static final String PATH_SEPARATOR = "/";

    public static String constructPath(String parentPath, String nodeName) {
        String p = (parentPath.isEmpty() || parentPath.endsWith(PATH_SEPARATOR) || nodeName.isEmpty() ? parentPath : parentPath + PATH_SEPARATOR) + nodeName;
        return p;
    }

    public static Map<NodeCountType, Long> getNodeCountMap(CodeTreeNode node) {
        HashMap<NodeCountType, Long> counts = new HashMap<NodeCountType, Long>();
        if (node != null && node.getNodeCounts() != null) {
            for (NodeCount count : node.getNodeCounts()) {
                counts.put(count.getCountType(), count.getCount());
            }
        }
        return counts;
    }

    static {
        ALL_NODES_PARAMETERS.setDepth(INFINITE_DEPTH);
        ALL_NODES_PARAMETERS.setIncludeParentNode(Boolean.valueOf(true));
        ALL_NODES_PARAMETERS.getIncludedNodeTypes().addAll(ALL_CODE_TREE_NODE_TYPES);
    }
}

