/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.protex.client.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataSource;

public class UnExpandedFileDataSource
implements DataSource {
    private final File sourceArchive;
    private File zipArchive;

    public UnExpandedFileDataSource(File sourceArchive) {
        this.sourceArchive = sourceArchive;
        this.createZipArchive();
    }

    public String getContentType() {
        return "application/zip";
    }

    public InputStream getInputStream() throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        FileOutputStream fos = new FileOutputStream(this.zipArchive);
        ZipOutputStream zos = new ZipOutputStream(fos);
        FileInputStream fis = new FileInputStream(this.sourceArchive);
        zos.putNextEntry(new ZipEntry(this.sourceArchive.getName()));
        while ((len = fis.read(buffer)) > 0) {
            zos.write(buffer, 0, len);
        }
        zos.closeEntry();
        fis.close();
        zos.close();
        return new FileInputStream(this.zipArchive);
    }

    public String getName() {
        return this.sourceArchive.getName();
    }

    public File getZipArchive() {
        return this.zipArchive;
    }

    private void createZipArchive() {
        String sourceName = this.sourceArchive.getName();
        String zipArchiveName = sourceName.substring(0, sourceName.lastIndexOf(".")) + ".zip";
        this.zipArchive = new File(zipArchiveName);
        this.zipArchive.deleteOnExit();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Read Only DataSource");
    }
}

