/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.protex.client.util;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class SimpleCallbackHandler
implements CallbackHandler {
    private final String username;
    private final char[] password;

    private SimpleCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Only " + NameCallback.class.getName() + " and " + PasswordCallback.class.getName() + " are supported");
            }
        }
    }

    public static CallbackHandler create(String username, String password) {
        SimpleCallbackHandler.checkNotNull(username, "Username may not be null");
        SimpleCallbackHandler.checkNotNull(password, "Password may not be null");
        return new SimpleCallbackHandler(username, password.toCharArray());
    }

    public static CallbackHandler create(String username, char[] password) {
        SimpleCallbackHandler.checkNotNull(username, "Username may not be null");
        SimpleCallbackHandler.checkNotNull(password, "Password may not be null");
        return new SimpleCallbackHandler(username, password);
    }

    private static void checkNotNull(Object var, String message) {
        if (var == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

