/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.protex.client.util;

import com.blackducksoftware.sdk.fault.ErrorCode;
import com.blackducksoftware.sdk.fault.SdkFault;
import com.blackducksoftware.sdk.protex.client.util.ProgrammedPasswordCallback;
import com.blackducksoftware.sdk.protex.client.util.ServerAuthenticationException;
import com.blackducksoftware.sdk.protex.client.util.SimpleCallbackHandler;
import com.blackducksoftware.sdk.protex.comparison.FileComparisonApi;
import com.blackducksoftware.sdk.protex.component.ComponentApi;
import com.blackducksoftware.sdk.protex.component.custom.CustomComponentManagementApi;
import com.blackducksoftware.sdk.protex.license.LicenseApi;
import com.blackducksoftware.sdk.protex.obligation.ObligationApi;
import com.blackducksoftware.sdk.protex.policy.PolicyApi;
import com.blackducksoftware.sdk.protex.policy.externalid.ExternalIdApi;
import com.blackducksoftware.sdk.protex.project.ProjectApi;
import com.blackducksoftware.sdk.protex.project.bom.BomApi;
import com.blackducksoftware.sdk.protex.project.codetree.CodeTreeApi;
import com.blackducksoftware.sdk.protex.project.codetree.discovery.DiscoveryApi;
import com.blackducksoftware.sdk.protex.project.codetree.identification.IdentificationApi;
import com.blackducksoftware.sdk.protex.project.localcomponent.LocalComponentApi;
import com.blackducksoftware.sdk.protex.project.template.TemplateApi;
import com.blackducksoftware.sdk.protex.report.ReportApi;
import com.blackducksoftware.sdk.protex.role.RoleApi;
import com.blackducksoftware.sdk.protex.synchronization.SynchronizationApi;
import com.blackducksoftware.sdk.protex.user.UserApi;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtexServerProxy
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ProtexServerProxy.class);
    public static final String PROTEX_SDK_INFO_PROPERTY = "protex.sdk.info";
    public static final long INDEFINITE_TIMEOUT = 0L;
    private static final String PROTEX_SDK_VERSION = "7_0";
    protected Map<String, Object> inProps = null;
    protected Map<String, Object> outProps = null;
    private String serverUrl = null;
    private CallbackHandler callbackHandler = null;
    private long defaultTimeout = 0L;
    private long maximumChildElements = 1000000L;
    private Map<String, List<String>> requestCookies = new HashMap<String, List<String>>();
    private Map<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
    private LicenseApi licenseApi = null;
    private LocalComponentApi localComponentApi = null;
    private ComponentApi componentApi = null;
    private CustomComponentManagementApi customComponentManagementApi = null;
    private ObligationApi obligationApi = null;
    private PolicyApi policyApi = null;
    private ExternalIdApi externalIdApi = null;
    private FileComparisonApi fileComparisonApi = null;
    private ProjectApi projectApi = null;
    private TemplateApi templateApi = null;
    private CodeTreeApi codeTreeApi = null;
    private BomApi bomApi = null;
    private DiscoveryApi discoveryApi = null;
    private IdentificationApi identificationApi = null;
    private ReportApi reportApi = null;
    private RoleApi roleApi = null;
    private UserApi userApi = null;
    private SynchronizationApi synchronizationApi = null;

    public ProtexServerProxy(String serverUrl, String userName, String password, long serverDefaultTimeout) {
        this(serverUrl, SimpleCallbackHandler.create(userName, password), serverDefaultTimeout);
    }

    public ProtexServerProxy(String serverUrl, CallbackHandler callbackHandler, long serverDefaultTimeout) {
        while (serverUrl.length() > 0 && serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        Boolean logInfo = Boolean.valueOf(System.getProperty(PROTEX_SDK_INFO_PROPERTY, "true"));
        logger.debug("Server URL: {}", (Object)serverUrl);
        logger.debug("WSDL Base Version: {}", (Object)PROTEX_SDK_VERSION);
        this.serverUrl = serverUrl;
        this.callbackHandler = callbackHandler;
        this.defaultTimeout = serverDefaultTimeout;
        if (logInfo.booleanValue()) {
            logger.info("Proxy initialized - SDK version 7.2");
        } else {
            logger.debug("Proxy initialized - SDK version 7.2");
        }
    }

    public ProtexServerProxy(String serverUrl, String userName, String password) {
        this(serverUrl, SimpleCallbackHandler.create(userName, password));
    }

    public ProtexServerProxy(String serverUrl, CallbackHandler callbackHandler) {
        this(serverUrl, callbackHandler, 0L);
    }

    public Long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public Map<String, List<String>> getRequestCookies() {
        return this.requestCookies;
    }

    public void setRequestCookies(Map<String, List<String>> requestCookies) {
        if (requestCookies != null) {
            this.requestCookies = requestCookies;
        } else {
            this.requestCookies.clear();
        }
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Map<String, List<String>> requestHeaders) {
        if (requestHeaders != null) {
            this.requestHeaders = requestHeaders;
        } else {
            this.requestHeaders.clear();
        }
    }

    public Long getMaximumChildElements() {
        return this.maximumChildElements;
    }

    public void setMaximumChildElements(long maximumChildElements) {
        this.maximumChildElements = maximumChildElements;
    }

    public void validateCredentials() throws ServerAuthenticationException {
        String userName = null;
        try {
            NameCallback nameCallback = new NameCallback("Username: ");
            this.callbackHandler.handle(new Callback[]{nameCallback});
            userName = nameCallback.getName();
        }
        catch (Exception e) {
            logger.error("Error during credential validation", (Throwable)e);
        }
        try {
            this.getUserApi().getCurrentUserHasServerFileAccess();
        }
        catch (SdkFault e) {
            if (ErrorCode.INVALID_CREDENTIALS.equals((Object)e.getFaultInfo().getErrorCode())) {
                throw new ServerAuthenticationException("Invalid credentials provided for '" + userName + "'", e);
            }
            logger.warn("Non-fatal error during user validation ({})", (Object)e.getMessage());
        }
        catch (SOAPFaultException e) {
            throw new ServerAuthenticationException("Validating credentials for '" + userName + "' failed", e);
        }
    }

    public void resetApiConnections() {
        this.licenseApi = null;
        this.localComponentApi = null;
        this.obligationApi = null;
        this.policyApi = null;
        this.externalIdApi = null;
        this.fileComparisonApi = null;
        this.projectApi = null;
        this.templateApi = null;
        this.codeTreeApi = null;
        this.bomApi = null;
        this.discoveryApi = null;
        this.identificationApi = null;
        this.reportApi = null;
        this.roleApi = null;
        this.userApi = null;
        this.synchronizationApi = null;
    }

    @Override
    public void close() throws IOException {
        this.callbackHandler = null;
    }

    public LicenseApi getLicenseApi() {
        return this.getLicenseApi(this.defaultTimeout);
    }

    public LicenseApi getLicenseApi(long timeout) {
        this.licenseApi = this.getApiInstance(this.licenseApi, ProtexApi.LICENSE, timeout);
        return this.licenseApi;
    }

    public ComponentApi getComponentApi() {
        return this.getComponentApi(this.defaultTimeout);
    }

    public ComponentApi getComponentApi(long timeout) {
        this.componentApi = this.getApiInstance(this.componentApi, ProtexApi.COMPONENT, timeout);
        return this.componentApi;
    }

    public CustomComponentManagementApi getCustomComponentManagementApi() {
        return this.getCustomComponentManagementApi(this.defaultTimeout);
    }

    public CustomComponentManagementApi getCustomComponentManagementApi(long timeout) {
        this.customComponentManagementApi = this.getApiInstance(this.customComponentManagementApi, ProtexApi.CUSTOM_COMPONENT_MANAGEMENT, timeout);
        return this.customComponentManagementApi;
    }

    public LocalComponentApi getLocalComponentApi() {
        return this.getLocalComponentApi(this.defaultTimeout);
    }

    public LocalComponentApi getLocalComponentApi(Long timeout) {
        this.localComponentApi = this.getApiInstance(this.localComponentApi, ProtexApi.LOCAL_COMPONENT, timeout);
        return this.localComponentApi;
    }

    public ObligationApi getObligationApi() {
        return this.getObligationApi(this.defaultTimeout);
    }

    public ObligationApi getObligationApi(long timeout) {
        this.obligationApi = this.getApiInstance(this.obligationApi, ProtexApi.OBLIGATION, timeout);
        return this.obligationApi;
    }

    public PolicyApi getPolicyApi() {
        return this.getPolicyApi(this.defaultTimeout);
    }

    public PolicyApi getPolicyApi(long timeout) {
        this.policyApi = this.getApiInstance(this.policyApi, ProtexApi.POLICY, timeout);
        return this.policyApi;
    }

    public ExternalIdApi getExternalIdApi() {
        return this.getExternalIdApi(this.defaultTimeout);
    }

    public ExternalIdApi getExternalIdApi(long timeout) {
        this.externalIdApi = this.getApiInstance(this.externalIdApi, ProtexApi.EXTERNAL_ID, timeout);
        return this.externalIdApi;
    }

    public FileComparisonApi getFileComparisonApi() {
        return this.getFileComparisonApi(this.defaultTimeout);
    }

    public FileComparisonApi getFileComparisonApi(long timeout) {
        this.fileComparisonApi = this.getApiInstance(this.fileComparisonApi, ProtexApi.FILE_COMPARISON, timeout);
        return this.fileComparisonApi;
    }

    public ProjectApi getProjectApi() {
        return this.getProjectApi(this.defaultTimeout);
    }

    public ProjectApi getProjectApi(long timeout) {
        this.projectApi = this.getApiInstance(this.projectApi, ProtexApi.PROJECT, timeout);
        return this.projectApi;
    }

    public TemplateApi getTemplateApi() {
        return this.getTemplateApi(this.defaultTimeout);
    }

    public TemplateApi getTemplateApi(long timeout) {
        this.templateApi = this.getApiInstance(this.templateApi, ProtexApi.TEMPLATE, timeout);
        return this.templateApi;
    }

    public BomApi getBomApi() {
        return this.getBomApi(this.defaultTimeout);
    }

    public BomApi getBomApi(long timeout) {
        this.bomApi = this.getApiInstance(this.bomApi, ProtexApi.BOM, timeout);
        return this.bomApi;
    }

    public CodeTreeApi getCodeTreeApi() {
        return this.getCodeTreeApi(this.defaultTimeout);
    }

    public CodeTreeApi getCodeTreeApi(Long timeout) {
        this.codeTreeApi = this.getApiInstance(this.codeTreeApi, ProtexApi.CODETREE, timeout);
        return this.codeTreeApi;
    }

    public DiscoveryApi getDiscoveryApi() {
        return this.getDiscoveryApi(this.defaultTimeout);
    }

    public DiscoveryApi getDiscoveryApi(Long timeout) {
        this.discoveryApi = this.getApiInstance(this.discoveryApi, ProtexApi.DISCOVERY, timeout);
        return this.discoveryApi;
    }

    public IdentificationApi getIdentificationApi() {
        return this.getIdentificationApi(this.defaultTimeout);
    }

    public IdentificationApi getIdentificationApi(Long timeout) {
        this.identificationApi = this.getApiInstance(this.identificationApi, ProtexApi.IDENTIFICATION, timeout);
        return this.identificationApi;
    }

    public ReportApi getReportApi() {
        return this.getReportApi(this.defaultTimeout);
    }

    public ReportApi getReportApi(Long timeout) {
        this.reportApi = this.getApiInstance(this.reportApi, ProtexApi.REPORT, timeout);
        return this.reportApi;
    }

    public RoleApi getRoleApi() {
        return this.getRoleApi(this.defaultTimeout);
    }

    public RoleApi getRoleApi(Long timeout) {
        this.roleApi = this.getApiInstance(this.roleApi, ProtexApi.ROLE, timeout);
        return this.roleApi;
    }

    public UserApi getUserApi() {
        return this.getUserApi(this.defaultTimeout);
    }

    public UserApi getUserApi(Long timeout) {
        this.userApi = this.getApiInstance(this.userApi, ProtexApi.USER, timeout);
        return this.userApi;
    }

    public SynchronizationApi getSynchronizationApi() {
        return this.getSynchronizationApi(this.defaultTimeout);
    }

    public SynchronizationApi getSynchronizationApi(Long timeout) {
        this.synchronizationApi = this.getApiInstance(this.synchronizationApi, ProtexApi.SYNCHRONIZATION, timeout);
        return this.synchronizationApi;
    }

    @Deprecated
    protected void initAuthProps(String userName, char[] password) {
        this.initAuthProps(SimpleCallbackHandler.create(userName, password));
    }

    protected void initAuthProps(CallbackHandler callbackHandler) {
        String userName = null;
        try {
            NameCallback nameCallback = new NameCallback("Username: ");
            callbackHandler.handle(new Callback[]{nameCallback});
            userName = nameCallback.getName();
        }
        catch (Exception e) {
            logger.error("Error reading username from callback", (Throwable)e);
        }
        if (this.inProps == null) {
            this.inProps = new HashMap<String, Object>();
            this.inProps.put("action", "NoSecurity");
        }
        if (this.outProps == null) {
            this.outProps = new HashMap<String, Object>();
            this.outProps.put("action", "UsernameToken");
            this.outProps.put("user", userName);
            this.outProps.put("passwordType", "PasswordText");
            this.outProps.put("passwordCallbackRef", new ProgrammedPasswordCallback(callbackHandler));
            this.outProps.put("mustUnderstand", "false");
        }
        logger.debug("Authenticate with: {}", (Object)userName);
    }

    protected void configureCxfEndpoint(Endpoint cxfEndpoint) {
        cxfEndpoint.put((Object)"org.apache.cxf.stax.maxChildElements", (Object)this.maximumChildElements);
    }

    @Deprecated
    protected void instrumentService(Object serviceApi, String userName, char[] password, long timeout) {
        this.instrumentService(serviceApi, SimpleCallbackHandler.create(userName, password), timeout);
    }

    protected void instrumentService(Object serviceApi, CallbackHandler callbackHandler, long timeout) {
        logger.debug("Instrument service: {}", (Object)serviceApi.toString());
        try {
            this.initAuthProps(callbackHandler);
            Client client = ClientProxy.getClient((Object)serviceApi);
            client = this.applyRequestHeaders(client);
            Endpoint cxfEndpoint = client.getEndpoint();
            WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(this.outProps);
            cxfEndpoint.getOutInterceptors().add(wssOut);
            this.configureCxfEndpoint(cxfEndpoint);
            this.setTimeout(serviceApi, timeout);
            if (client.getConduit() instanceof HTTPConduit) {
                HTTPConduit http = (HTTPConduit)client.getConduit();
                http = this.applyCertificates(http);
                HTTPClientPolicy httpClientPolicy = http.getClient();
                httpClientPolicy = this.applyRequestCookies(httpClientPolicy);
                httpClientPolicy.setAutoRedirect(true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getPasswordMask(char[] password) {
        char[] mask = new char[password.length];
        Arrays.fill(mask, '*');
        return new String(mask);
    }

    private <T> T getApiInstance(T targetApi, ProtexApi api, long timeout) {
        if (targetApi == null) {
            targetApi = this.getPortFromUrl(api.getApiClass(), this.serverUrl + api.getServiceStub());
            this.instrumentService(targetApi, this.callbackHandler, timeout);
        } else {
            Long serviceTimeout = this.getTimeout(targetApi);
            if (timeout != serviceTimeout) {
                this.setTimeout(targetApi, timeout);
            }
        }
        return targetApi;
    }

    private Long getTimeout(Object serviceApi) {
        Client client = ClientProxy.getClient((Object)serviceApi);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = http.getClient();
        return httpClientPolicy.getConnectionTimeout();
    }

    private void setTimeout(Object serviceApi, Long timeout) {
        logger.debug("Set timeout for service: {} ({}ms)", (Object)serviceApi.toString(), (Object)timeout);
        Client client = ClientProxy.getClient((Object)serviceApi);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(timeout.longValue());
        httpClientPolicy.setReceiveTimeout(timeout.longValue());
        http.setClient(httpClientPolicy);
    }

    private HTTPClientPolicy applyRequestCookies(HTTPClientPolicy httpClientPolicy) {
        if (!this.requestCookies.isEmpty()) {
            StringBuilder cookieBuilder = new StringBuilder();
            for (Map.Entry<String, List<String>> cookie : this.requestCookies.entrySet()) {
                if (cookie.getKey() == null || cookie.getValue() == null) continue;
                for (String cookieValue : cookie.getValue()) {
                    if (cookieBuilder.length() > 0) {
                        cookieBuilder.append("; ");
                    }
                    cookieBuilder.append(cookie.getKey()).append('=').append(cookieValue);
                }
            }
            httpClientPolicy.setCookie(cookieBuilder.toString());
            logger.debug("Applying custom cookies ({})", this.requestCookies);
        }
        return httpClientPolicy;
    }

    private Client applyRequestHeaders(Client client) {
        if (!this.requestHeaders.isEmpty() && client != null && client.getRequestContext() != null) {
            client.getRequestContext().put(Message.PROTOCOL_HEADERS, this.requestHeaders);
            logger.debug("Applying custom headers ({})", this.requestHeaders);
        }
        return client;
    }

    private HTTPConduit applyCertificates(HTTPConduit http) throws Exception {
        StoreParameters trustStoreParams = StoreParameters.getTrustStoreParameters();
        StoreParameters keyStoreParams = StoreParameters.getKeyStoreParameters();
        boolean disableCnCheck = false;
        if (disableCnCheck || trustStoreParams.isCustomLocation() || keyStoreParams.isCustomLocation()) {
            TLSClientParameters tlsClientParameters = new TLSClientParameters();
            if (disableCnCheck) {
                tlsClientParameters.setDisableCNCheck(true);
                logger.warn("Disabling CN Host checking - not recommended for production operations!");
            }
            if (trustStoreParams.isCustomLocation()) {
                TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustFactory.init(trustStoreParams.asKeyStore());
                TrustManager[] tm = trustFactory.getTrustManagers();
                tlsClientParameters.setTrustManagers(tm);
                logger.info("Configuring CXF with explicit trust store");
            }
            if (keyStoreParams.isCustomLocation()) {
                KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyFactory.init(keyStoreParams.asKeyStore(), keyStoreParams.getStorePassword());
                KeyManager[] km = keyFactory.getKeyManagers();
                tlsClientParameters.setKeyManagers(km);
                logger.info("Configuring CXF with explicit key store");
            }
            http.setTlsClientParameters(tlsClientParameters);
        }
        return http;
    }

    private <T> Object getPortFromUrl(Class<T> serviceClass, String serviceUrl) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(serviceClass);
        factory.setAddress(serviceUrl);
        logger.debug("getPortFromUrl: Service Url={}", (Object)serviceUrl);
        return factory.create();
    }

    private static final class StoreParameters {
        private final String storeLocation;
        private final char[] storePassword;
        private final String storeType;

        private StoreParameters(String storeLocation, char[] storePassword, String storeType) {
            this.storeLocation = storeLocation;
            this.storePassword = storePassword != null ? storePassword : new char[]{};
            this.storeType = storeType != null ? storeType : "JKS";
        }

        public boolean isCustomLocation() {
            return this.storeLocation != null && !this.storeLocation.trim().isEmpty();
        }

        public char[] getStorePassword() {
            return this.storePassword;
        }

        public KeyStore asKeyStore() throws Exception {
            KeyStore store = null;
            if (this.isCustomLocation()) {
                store = KeyStore.getInstance(this.storeType);
                File storeFile = new File(this.storeLocation);
                store.load(new FileInputStream(storeFile), this.storePassword);
            }
            return store;
        }

        public static StoreParameters getKeyStoreParameters() {
            String storeLocation = System.getProperty("javax.net.ssl.keyStore");
            String storePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            String storeType = System.getProperty("javax.net.ssl.keyStoreType");
            return new StoreParameters(storeLocation, storePassword != null ? storePassword.toCharArray() : null, storeType);
        }

        public static StoreParameters getTrustStoreParameters() {
            String storeLocation = System.getProperty("javax.net.ssl.trustStore");
            String storePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            String storeType = System.getProperty("javax.net.ssl.trustStoreType");
            return new StoreParameters(storeLocation, storePassword != null ? storePassword.toCharArray() : null, storeType);
        }
    }

    private static enum ProtexApi {
        LICENSE("license", LicenseApi.class),
        COMPONENT("component", ComponentApi.class),
        CUSTOM_COMPONENT_MANAGEMENT("customcomponentmanagement", CustomComponentManagementApi.class),
        LOCAL_COMPONENT("localcomponent", LocalComponentApi.class),
        OBLIGATION("obligation", ObligationApi.class),
        POLICY("policy", PolicyApi.class),
        EXTERNAL_ID("externalid", ExternalIdApi.class),
        FILE_COMPARISON("filecomparison", FileComparisonApi.class),
        PROJECT("project", ProjectApi.class),
        TEMPLATE("template", TemplateApi.class),
        CODETREE("codetree", CodeTreeApi.class),
        BOM("bom", BomApi.class),
        DISCOVERY("discovery", DiscoveryApi.class),
        IDENTIFICATION("identification", IdentificationApi.class),
        REPORT("report", ReportApi.class),
        ROLE("role", RoleApi.class),
        USER("user", UserApi.class),
        SYNCHRONIZATION("synchronization", SynchronizationApi.class);

        private final String serviceStub;
        private final Class<?> apiClass;

        private ProtexApi(String apiStub, Class<?> apiClass) {
            this.serviceStub = "/protex-sdk/v7_0/" + apiStub;
            this.apiClass = apiClass;
        }

        public String getServiceStub() {
            return this.serviceStub;
        }

        public Class<?> getApiClass() {
            return this.apiClass;
        }
    }
}

