/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.protex.client.util;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;

public class ProgrammedPasswordCallback
implements CallbackHandler {
    private final CallbackHandler callbackHandler;

    public ProgrammedPasswordCallback(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        WSPasswordCallback pc = null;
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (!(callback instanceof WSPasswordCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unsupported callback type " + (callback != null ? callback.getClass().getName() : null) + " provided. Only " + WSPasswordCallback.class.getName() + " is supported ");
                }
                pc = (WSPasswordCallback)callback;
            }
        }
        String identifier = pc.getIdentifier();
        NameCallback usernameCallback = new NameCallback("Username: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
        this.callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        String username = usernameCallback.getName();
        if (username == null) {
            throw new UnsupportedCallbackException((Callback)pc, "Username not set in client. Call constructor method " + ProgrammedPasswordCallback.class.getName() + "(\"<your username>\", \"<your password>\")");
        }
        if (!username.equals(identifier)) {
            throw new UnsupportedCallbackException((Callback)pc, "Password not set in client. Call constructor method " + ProgrammedPasswordCallback.class.getName() + "(\"<your username>\", \"<your password>\")");
        }
        pc.setPassword(new String(passwordCallback.getPassword()));
    }
}

