/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioContext;
import com.blackducksoftware.common.base.ExtraStreams;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class BdioFrame {
    private final BdioContext context;
    private final ImmutableSet<String> classes;
    private final ImmutableSet<String> classTerms;

    private BdioFrame(Builder builder) {
        this.context = Objects.requireNonNull(builder.context);
        this.classes = ImmutableSet.copyOf((Collection)builder.classes);
        this.classTerms = (ImmutableSet)this.classes.stream().flatMap(ExtraStreams.fromOptional(this.context::lookupTerm)).collect(ImmutableSet.toImmutableSet());
    }

    public BdioContext context() {
        return this.context;
    }

    public Map<String, Object> serialize() {
        Map<String, Object> result = this.context.serialize();
        result.put("@type", this.classes.stream().collect(Collectors.toList()));
        this.context().getPrefixes(false).forEach((term, iri) -> {
            if (this.isObjectProperty((String)term)) {
                LinkedHashMap<String, Boolean> frameFlags = new LinkedHashMap<String, Boolean>();
                frameFlags.put("@embed", Boolean.FALSE);
                result.put((String)iri, frameFlags);
            }
        });
        return result;
    }

    public boolean isDataProperty(String term) {
        return !BdioFrame.isKeyword(term) && term.indexOf(58) < 0 && !this.classTerms.contains((Object)term) && !Objects.equals(this.context().getTypeMapping(term), "@id");
    }

    public boolean isObjectProperty(String term) {
        return !BdioFrame.isKeyword(term) && term.indexOf(58) < 0 && !this.classTerms.contains((Object)term) && Objects.equals(this.context().getTypeMapping(term), "@id");
    }

    public Builder newBuilder() {
        return new Builder().context(this.context).classes((Collection<String>)this.classes);
    }

    private static boolean isKeyword(Object obj) {
        return obj instanceof String && ((String)obj).startsWith("@");
    }

    public static final class Builder {
        @Nullable
        private BdioContext context;
        private final Set<String> classes = new LinkedHashSet<String>();

        public Builder() {
            ExtraStreams.stream(Bdio.Class.class).map(Bdio.Class::toString).forEach(this.classes::add);
        }

        public Builder context(BdioContext context) {
            this.context = Objects.requireNonNull(context);
            return this;
        }

        public Builder classes(Collection<String> classes) {
            this.classes.addAll(classes);
            return this;
        }

        public BdioFrame build() {
            Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"must supply a frame context");
            return new BdioFrame(this);
        }
    }
}

