/*
 * Decompiled with CFR 0.152.
 */
package com.bitvale.lavafab.widget;

import android.animation.FloatEvaluator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import com.bitvale.lavafab.widget.LavaView;
import com.bitvale.lavafab.widget.Parent;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0002DEB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00103\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0012\u00105\u001a\u0002042\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u0012\u00108\u001a\u0002042\b\u00106\u001a\u0004\u0018\u000107H\u0002J\u001a\u00109\u001a\u0002042\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010:\u001a\u00020-H\u0002J\u001a\u0010;\u001a\u0002042\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010:\u001a\u00020-H\u0002J\u001a\u0010<\u001a\u0002042\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010:\u001a\u00020-H\u0002J\u001a\u0010=\u001a\u0002042\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010:\u001a\u00020-H\u0002J\u0018\u0010>\u001a\u0002042\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0016J\u0010\u0010A\u001a\u0002042\u0006\u0010.\u001a\u00020-H\u0002J\u0016\u0010B\u001a\u0002042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002040CH\u0016J\u0012\u0010B\u001a\u0002042\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0010R\u000e\u0010+\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006F"}, d2={"Lcom/bitvale/lavafab/widget/Child;", "Lcom/bitvale/lavafab/widget/LavaView;", "parent", "Lcom/bitvale/lavafab/widget/Parent;", "center", "Landroid/graphics/PointF;", "radius", "", "(Lcom/bitvale/lavafab/widget/Parent;Landroid/graphics/PointF;F)V", "angles", "", "animatedFraction", "getCenter", "()Landroid/graphics/PointF;", "currentRadius", "getCurrentRadius", "()F", "setCurrentRadius", "(F)V", "evaluator", "Landroid/animation/FloatEvaluator;", "getEvaluator", "()Landroid/animation/FloatEvaluator;", "icon", "Landroid/graphics/Bitmap;", "getIcon", "()Landroid/graphics/Bitmap;", "setIcon", "(Landroid/graphics/Bitmap;)V", "initialRadius", "listener", "Lcom/bitvale/lavafab/widget/LavaView$LavaOnClickListener;", "getListener", "()Lcom/bitvale/lavafab/widget/LavaView$LavaOnClickListener;", "setListener", "(Lcom/bitvale/lavafab/widget/LavaView$LavaOnClickListener;)V", "middlePointAngle", "", "outChildCubicOffset", "outParentCubicOffset", "getParent", "()Lcom/bitvale/lavafab/widget/Parent;", "getRadius", "radiusOffset", "value", "", "type", "getType", "()I", "setType", "(I)V", "calculatePoints", "", "draw", "canvas", "Landroid/graphics/Canvas;", "drawIcon", "drawLeftBottomOrRightTop", "direction", "drawLeftTopOrRightBottom", "drawOnLeftOrRight", "drawOnTopOrBottom", "handleOnClick", "x", "y", "initProperties", "setOnClickListener", "Lkotlin/Function0;", "Companion", "Type", "lavafab_release"})
public final class Child
implements LavaView {
    private float currentRadius;
    @NotNull
    private final FloatEvaluator evaluator;
    @Nullable
    private Bitmap icon;
    @Nullable
    private LavaView.LavaOnClickListener listener;
    private final double[] angles;
    private float initialRadius;
    private int type;
    private float radiusOffset;
    private float outParentCubicOffset;
    private float outChildCubicOffset;
    private float[] middlePointAngle;
    private float animatedFraction;
    @NotNull
    private final Parent parent;
    @NotNull
    private final PointF center;
    private final float radius;
    public static final int CHILD_NONE = 0;
    public static final int CHILD_TOP = 1;
    public static final int CHILD_RIGHT = 2;
    public static final int CHILD_BOTTOM = 4;
    public static final int CHILD_LEFT = 8;
    public static final int CHILD_LEFT_TOP = 16;
    public static final int CHILD_RIGHT_TOP = 32;
    public static final int CHILD_RIGHT_BOTTOM = 64;
    public static final int CHILD_LEFT_BOTTOM = 128;
    public static final int CHILD_ALL = 255;
    public static final float CHILD_RADIUS_RATIO = 1.6f;
    public static final float CHILD_DISTANCE_RATIO = 2.6f;
    public static final float CHILD_ANGLE_DISTANCE_RATIO = 2.0f;
    public static final Companion Companion = new Companion(null);

    @Override
    public float getCurrentRadius() {
        return this.currentRadius;
    }

    @Override
    public void setCurrentRadius(float f) {
        this.currentRadius = f;
    }

    @Override
    @NotNull
    public FloatEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    @Nullable
    public Bitmap getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(@Nullable Bitmap bitmap) {
        this.icon = bitmap;
    }

    @Override
    @Nullable
    public LavaView.LavaOnClickListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable LavaView.LavaOnClickListener lavaOnClickListener) {
        this.listener = lavaOnClickListener;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int value) {
        this.type = value;
        this.initProperties(this.type);
    }

    private final void initProperties(int type) {
        switch (type) {
            case 8: {
                this.angles[0] = Math.toRadians(45.0);
                this.angles[1] = Math.toRadians(-45.0);
                this.angles[2] = Math.toRadians(60.0);
                this.angles[3] = Math.toRadians(-60.0);
                this.angles[4] = Math.toRadians(0.0);
                break;
            }
            case 16: {
                this.angles[0] = Math.toRadians(0.0);
                this.angles[1] = Math.toRadians(90.0);
                this.angles[2] = Math.toRadians(-15.0);
                this.angles[3] = Math.toRadians(105.0);
                this.angles[4] = Math.toRadians(45.0);
                break;
            }
            case 1: {
                this.angles[0] = Math.toRadians(45.0);
                this.angles[1] = Math.toRadians(135.0);
                this.angles[2] = Math.toRadians(30.0);
                this.angles[3] = Math.toRadians(150.0);
                this.angles[4] = Math.toRadians(90.0);
                break;
            }
            case 32: {
                this.angles[0] = Math.toRadians(90.0);
                this.angles[1] = Math.toRadians(180.0);
                this.angles[2] = Math.toRadians(75.0);
                this.angles[3] = Math.toRadians(195.0);
                this.angles[4] = Math.toRadians(135.0);
                break;
            }
            case 2: {
                this.angles[0] = Math.toRadians(135.0);
                this.angles[1] = Math.toRadians(225.0);
                this.angles[2] = Math.toRadians(120.0);
                this.angles[3] = Math.toRadians(240.0);
                this.angles[4] = Math.toRadians(180.0);
                break;
            }
            case 64: {
                this.angles[0] = Math.toRadians(180.0);
                this.angles[1] = Math.toRadians(270.0);
                this.angles[2] = Math.toRadians(165.0);
                this.angles[3] = Math.toRadians(285.0);
                this.angles[4] = Math.toRadians(225.0);
                break;
            }
            case 4: {
                this.angles[0] = Math.toRadians(315.0);
                this.angles[1] = Math.toRadians(225.0);
                this.angles[2] = Math.toRadians(330.0);
                this.angles[3] = Math.toRadians(210.0);
                this.angles[4] = Math.toRadians(270.0);
                break;
            }
            case 128: {
                this.angles[0] = Math.toRadians(270.0);
                this.angles[1] = Math.toRadians(360.0);
                this.angles[2] = Math.toRadians(255.0);
                this.angles[3] = Math.toRadians(375.0);
                this.angles[4] = Math.toRadians(315.0);
            }
        }
    }

    @Override
    public void calculatePoints(float animatedFraction) {
        this.animatedFraction = animatedFraction;
        Float f = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(0.0f), (Number)Float.valueOf(this.getRadius() / 4.0f));
        Intrinsics.checkExpressionValueIsNotNull((Object)f, (String)"evaluator.evaluate(anima\u2026raction, 0f, radius / 4f)");
        this.radiusOffset = f.floatValue();
        switch (this.type) {
            case 8: {
                PointF pointF = this.getCenter();
                Float f2 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().x - this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().x - 2.6f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f2, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF.x = f2.floatValue();
                break;
            }
            case 16: {
                PointF pointF = this.getCenter();
                Float f3 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().x - this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().x - 2.0f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f3, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF.x = f3.floatValue();
                PointF pointF2 = this.getCenter();
                Float f4 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().y - this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().y - 2.0f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f4, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF2.y = f4.floatValue();
                break;
            }
            case 1: {
                PointF pointF = this.getCenter();
                Float f5 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().y - this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().y - 2.6f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f5, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF.y = f5.floatValue();
                break;
            }
            case 32: {
                PointF pointF = this.getCenter();
                Float f6 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().x + this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().x + 2.0f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f6, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF.x = f6.floatValue();
                PointF pointF3 = this.getCenter();
                Float f7 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().y - this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().y - 2.0f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f7, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF3.y = f7.floatValue();
                break;
            }
            case 2: {
                PointF pointF = this.getCenter();
                Float f8 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().x + this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().x + 2.6f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f8, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF.x = f8.floatValue();
                break;
            }
            case 64: {
                PointF pointF = this.getCenter();
                Float f9 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().x + this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().x + 2.0f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f9, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF.x = f9.floatValue();
                PointF pointF4 = this.getCenter();
                Float f10 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().y + this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().y + 2.0f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f10, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF4.y = f10.floatValue();
                break;
            }
            case 4: {
                PointF pointF = this.getCenter();
                Float f11 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().y + this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().y + 2.6f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f11, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF.y = f11.floatValue();
                break;
            }
            case 128: {
                PointF pointF = this.getCenter();
                Float f12 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().x - this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().x - 2.0f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f12, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF.x = f12.floatValue();
                PointF pointF5 = this.getCenter();
                Float f13 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.parent.getCenter().y + this.initialRadius / (float)2), (Number)Float.valueOf(this.parent.getCenter().y + 2.0f * this.parent.getRadius()));
                Intrinsics.checkExpressionValueIsNotNull((Object)f13, (String)"evaluator.evaluate(anima\u2026CE_RATIO * parent.radius)");
                pointF5.y = f13.floatValue();
            }
        }
        Float f14 = this.getEvaluator().evaluate(animatedFraction, (Number)this.angles[2], (Number)this.angles[4]);
        Intrinsics.checkExpressionValueIsNotNull((Object)f14, (String)"evaluator.evaluate(anima\u2026on, angles[2], angles[4])");
        this.middlePointAngle[0] = f14.floatValue();
        Float f15 = this.getEvaluator().evaluate(animatedFraction, (Number)this.angles[3], (Number)this.angles[4]);
        Intrinsics.checkExpressionValueIsNotNull((Object)f15, (String)"evaluator.evaluate(anima\u2026on, angles[3], angles[4])");
        this.middlePointAngle[1] = f15.floatValue();
        if ((double)animatedFraction >= 0.8) {
            Float f16 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.getRadius() * (float)4), (Number)Float.valueOf(0.0f));
            Intrinsics.checkExpressionValueIsNotNull((Object)f16, (String)"evaluator.evaluate(anima\u2026Fraction, radius * 4, 0f)");
            this.outParentCubicOffset = f16.floatValue();
            Float f17 = this.getEvaluator().evaluate(animatedFraction, (Number)Float.valueOf(this.getRadius() * (float)4), (Number)Float.valueOf(0.0f));
            Intrinsics.checkExpressionValueIsNotNull((Object)f17, (String)"evaluator.evaluate(anima\u2026Fraction, radius * 4, 0f)");
            this.outChildCubicOffset = f17.floatValue();
        }
    }

    @Override
    public void draw(@Nullable Canvas canvas) {
        this.parent.getDrawer().rewindChildCircle();
        this.parent.getDrawer().rewindHelpers();
        this.setCurrentRadius(this.initialRadius + this.radiusOffset);
        this.parent.getDrawer().addCircle(this.getCenter().x, this.getCenter().y, this.getCurrentRadius(), false);
        switch (this.type) {
            case 8: {
                this.drawOnLeftOrRight(canvas, 8);
                break;
            }
            case 16: {
                this.drawLeftTopOrRightBottom(canvas, 16);
                break;
            }
            case 1: {
                this.drawOnTopOrBottom(canvas, 1);
                break;
            }
            case 32: {
                this.drawLeftBottomOrRightTop(canvas, 32);
                break;
            }
            case 2: {
                this.drawOnLeftOrRight(canvas, 2);
                break;
            }
            case 64: {
                this.drawLeftTopOrRightBottom(canvas, 64);
                break;
            }
            case 4: {
                this.drawOnTopOrBottom(canvas, 4);
                break;
            }
            case 128: {
                this.drawLeftBottomOrRightTop(canvas, 128);
            }
        }
        if (this.animatedFraction >= 1.0f) {
            this.parent.getDrawer().rewindHelpers();
            this.parent.getDrawer().drawDisconnectedHelpers(canvas);
        }
        this.parent.getDrawer().drawChildCircle(canvas);
        this.drawIcon(canvas);
    }

    private final void drawIcon(Canvas canvas) {
        if ((double)this.animatedFraction >= 0.5) {
            this.parent.getDrawer().drawIcon(canvas, this.getIcon(), this.getCenter().x, this.getCenter().y, this.getCurrentRadius());
        }
    }

    private final void drawOnLeftOrRight(Canvas canvas, int direction) {
        float x4;
        float y2;
        float x1;
        float f;
        float f2;
        int parentDirector = direction == 8 ? -1 : 1;
        int childDirector = -parentDirector;
        if ((double)this.animatedFraction < 0.8) {
            double d = this.angles[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            double d2 = Math.cos(d);
            x1 = f - f2 * (float)d2;
            double d3 = this.angles[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            d2 = Math.sin(d3);
            float y1 = f - f2 * (float)d2;
            float f3 = this.middlePointAngle[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            float f4 = (float)Math.cos(f3);
            float x2 = f - f2 * f4;
            float f5 = this.middlePointAngle[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            f4 = (float)Math.sin(f5);
            y2 = f - f2 * f4;
            x4 = this.getCenter().x;
            float y4 = this.getCenter().y - this.getCurrentRadius();
            this.parent.getDrawer().addConnectedBezier(x1, y1, x2, y2, x2, y2, x4, y4);
            double d4 = this.angles[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            double d5 = Math.cos(d4);
            x1 = f - f2 * (float)d5;
            d4 = this.angles[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            d5 = Math.sin(d4);
            y1 = f - f2 * (float)d5;
            float f6 = this.middlePointAngle[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            float f7 = (float)Math.cos(f6);
            x2 = f - f2 * f7;
            f6 = this.middlePointAngle[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            f7 = (float)Math.sin(f6);
            y2 = f - f2 * f7;
            x4 = this.getCenter().x;
            y4 = this.getCenter().y + this.getCurrentRadius();
            this.parent.getDrawer().addConnectedBezier(x1, y1, x2, y2, x2, y2, x4, y4);
            this.parent.getDrawer().drawConnectedHelpers(canvas, this.getCenter().x, this.getCenter().y - this.getCurrentRadius(), this.parent.getCenter().x, this.getCenter().y + this.getCurrentRadius());
        }
        if ((double)this.animatedFraction >= 0.8 && this.animatedFraction < 1.0f) {
            double y1 = this.angles[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            double d = Math.cos(y1);
            x1 = f - f2 * (float)d;
            double x2 = this.angles[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            d = Math.sin(x2);
            float y3 = f - f2 * (float)d;
            float x3 = this.parent.getCenter().x + (float)parentDirector * (this.parent.getCurrentRadius() + this.outParentCubicOffset);
            y2 = this.parent.getCenter().y;
            double y4 = this.angles[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            d = Math.cos(y4);
            x4 = f - f2 * (float)d;
            double d6 = this.angles[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            d = Math.sin(d6);
            float y5 = f - f2 * (float)d;
            this.parent.getDrawer().addDisconnectedBezier(x1, y3, x3, y2, x3, y2, x4, y5);
            d6 = this.angles[0];
            f2 = this.getCurrentRadius();
            f = this.getCenter().x;
            d = Math.cos(d6);
            x1 = f + f2 * (float)d;
            d6 = this.angles[0];
            f2 = this.getCurrentRadius();
            f = this.getCenter().y;
            d = Math.sin(d6);
            y3 = f + f2 * (float)d;
            x3 = this.getCenter().x + (float)childDirector * (this.getCurrentRadius() + this.outChildCubicOffset);
            y2 = this.getCenter().y;
            d6 = this.angles[1];
            f2 = this.getCurrentRadius();
            f = this.getCenter().x;
            d = Math.cos(d6);
            x4 = f + f2 * (float)d;
            d6 = this.angles[1];
            f2 = this.getCurrentRadius();
            f = this.getCenter().y;
            d = Math.sin(d6);
            y5 = f + f2 * (float)d;
            this.parent.getDrawer().addDisconnectedBezier(x1, y3, x3, y2, x3, y2, x4, y5);
            this.parent.getDrawer().drawDisconnectedHelpers(canvas);
        }
    }

    private final void drawOnTopOrBottom(Canvas canvas, int direction) {
        float x4;
        float y2;
        float x1;
        float f;
        float f2;
        int parentDirector = direction == 1 ? -1 : 1;
        int childDirector = -parentDirector;
        if ((double)this.animatedFraction < 0.8) {
            double d = this.angles[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            double d2 = Math.cos(d);
            x1 = f - f2 * (float)d2;
            double d3 = this.angles[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            d2 = Math.sin(d3);
            float y1 = f - f2 * (float)d2;
            float f3 = this.middlePointAngle[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            float f4 = (float)Math.cos(f3);
            float x2 = f - f2 * f4;
            float f5 = this.middlePointAngle[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            f4 = (float)Math.sin(f5);
            y2 = f - f2 * f4;
            x4 = this.getCenter().x - this.getCurrentRadius();
            float y4 = this.getCenter().y;
            this.parent.getDrawer().addConnectedBezier(x1, y1, x2, y2, x2, y2, x4, y4);
            double d4 = this.angles[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            double d5 = Math.cos(d4);
            x1 = f - f2 * (float)d5;
            d4 = this.angles[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            d5 = Math.sin(d4);
            y1 = f - f2 * (float)d5;
            float f6 = this.middlePointAngle[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            float f7 = (float)Math.cos(f6);
            x2 = f - f2 * f7;
            f6 = this.middlePointAngle[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            f7 = (float)Math.sin(f6);
            y2 = f - f2 * f7;
            x4 = this.getCenter().x + this.getCurrentRadius();
            y4 = this.getCenter().y;
            this.parent.getDrawer().addConnectedBezier(x1, y1, x2, y2, x2, y2, x4, y4);
            this.parent.getDrawer().drawConnectedHelpers(canvas, this.getCenter().x - this.getCurrentRadius(), this.getCenter().y, this.parent.getCenter().x + this.getCurrentRadius(), this.parent.getCenter().y);
        }
        if ((double)this.animatedFraction >= 0.8 && this.animatedFraction < 1.0f) {
            double y1 = this.angles[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            double d = Math.cos(y1);
            x1 = f - f2 * (float)d;
            double x2 = this.angles[0];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            d = Math.sin(x2);
            float y3 = f - f2 * (float)d;
            float x3 = this.parent.getCenter().x;
            y2 = this.parent.getCenter().y + (float)parentDirector * (this.parent.getCurrentRadius() + this.outParentCubicOffset);
            double y4 = this.angles[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().x;
            d = Math.cos(y4);
            x4 = f - f2 * (float)d;
            double d6 = this.angles[1];
            f2 = this.parent.getCurrentRadius();
            f = this.parent.getCenter().y;
            d = Math.sin(d6);
            float y5 = f - f2 * (float)d;
            this.parent.getDrawer().addDisconnectedBezier(x1, y3, x3, y2, x3, y2, x4, y5);
            d6 = this.angles[0];
            f2 = this.getCurrentRadius();
            f = this.getCenter().x;
            d = Math.cos(d6);
            x1 = f + f2 * (float)d;
            d6 = this.angles[0];
            f2 = this.getCurrentRadius();
            f = this.getCenter().y;
            d = Math.sin(d6);
            y3 = f + f2 * (float)d;
            x3 = this.getCenter().x;
            y2 = this.getCenter().y + (float)childDirector * (this.getCurrentRadius() + this.outChildCubicOffset);
            d6 = this.angles[1];
            f2 = this.getCurrentRadius();
            f = this.getCenter().x;
            d = Math.cos(d6);
            x4 = f + f2 * (float)d;
            d6 = this.angles[1];
            f2 = this.getCurrentRadius();
            f = this.getCenter().y;
            d = Math.sin(d6);
            y5 = f + f2 * (float)d;
            this.parent.getDrawer().addDisconnectedBezier(x1, y3, x3, y2, x3, y2, x4, y5);
            this.parent.getDrawer().drawDisconnectedHelpers(canvas);
        }
    }

    private final void drawLeftTopOrRightBottom(Canvas canvas, int direction) {
        int parentDirector = direction == 16 ? -1 : 1;
        int childDirector = -parentDirector;
        if ((double)this.animatedFraction >= 0.8 && this.animatedFraction < 1.0f) {
            double d = this.angles[0];
            float f = this.parent.getCurrentRadius();
            float f2 = this.parent.getCenter().x;
            double d2 = Math.cos(d);
            float x1 = f2 - f * (float)d2;
            double d3 = this.angles[0];
            f = this.parent.getCurrentRadius();
            f2 = this.parent.getCenter().y;
            d2 = Math.sin(d3);
            float y1 = f2 - f * (float)d2;
            float x2 = this.parent.getCenter().x + (float)parentDirector * (this.parent.getCurrentRadius() + this.outParentCubicOffset);
            float y2 = this.parent.getCenter().y + (float)parentDirector * (this.parent.getCurrentRadius() + this.outParentCubicOffset);
            double d4 = this.angles[1];
            f = this.parent.getCurrentRadius();
            f2 = this.parent.getCenter().x;
            d2 = Math.cos(d4);
            float x4 = f2 - f * (float)d2;
            double d5 = this.angles[1];
            f = this.parent.getCurrentRadius();
            f2 = this.parent.getCenter().y;
            d2 = Math.sin(d5);
            float y4 = f2 - f * (float)d2;
            this.parent.getDrawer().addDisconnectedBezier(x1, y1, x2, y2, x2, y2, x4, y4);
            d5 = this.angles[0];
            f = this.getCurrentRadius();
            f2 = this.getCenter().x;
            d2 = Math.cos(d5);
            x1 = f2 + f * (float)d2;
            d5 = this.angles[0];
            f = this.getCurrentRadius();
            f2 = this.getCenter().y;
            d2 = Math.sin(d5);
            y1 = f2 + f * (float)d2;
            x2 = this.getCenter().x + (float)childDirector * (this.getCurrentRadius() + this.outChildCubicOffset);
            y2 = this.getCenter().y + (float)childDirector * (this.getCurrentRadius() + this.outChildCubicOffset);
            d5 = this.angles[1];
            f = this.getCurrentRadius();
            f2 = this.getCenter().x;
            d2 = Math.cos(d5);
            x4 = f2 + f * (float)d2;
            d5 = this.angles[1];
            f = this.getCurrentRadius();
            f2 = this.getCenter().y;
            d2 = Math.sin(d5);
            y4 = f2 + f * (float)d2;
            this.parent.getDrawer().addDisconnectedBezier(x1, y1, x2, y2, x2, y2, x4, y4);
            this.parent.getDrawer().drawDisconnectedHelpers(canvas);
        }
    }

    private final void drawLeftBottomOrRightTop(Canvas canvas, int direction) {
        int parentDirector = direction == 128 ? -1 : 1;
        int childDirector = -parentDirector;
        if ((double)this.animatedFraction >= 0.8 && this.animatedFraction < 1.0f) {
            double d = this.angles[0];
            float f = this.parent.getCurrentRadius();
            float f2 = this.parent.getCenter().x;
            double d2 = Math.cos(d);
            float x1 = f2 - f * (float)d2;
            double d3 = this.angles[0];
            f = this.parent.getCurrentRadius();
            f2 = this.parent.getCenter().y;
            d2 = Math.sin(d3);
            float y1 = f2 - f * (float)d2;
            float x2 = this.parent.getCenter().x + (float)parentDirector * (this.parent.getCurrentRadius() + this.outParentCubicOffset);
            float y2 = this.parent.getCenter().y + (float)childDirector * (this.parent.getCurrentRadius() + this.outParentCubicOffset);
            double d4 = this.angles[1];
            f = this.parent.getCurrentRadius();
            f2 = this.parent.getCenter().x;
            d2 = Math.cos(d4);
            float x4 = f2 - f * (float)d2;
            double d5 = this.angles[1];
            f = this.parent.getCurrentRadius();
            f2 = this.parent.getCenter().y;
            d2 = Math.sin(d5);
            float y4 = f2 - f * (float)d2;
            this.parent.getDrawer().addDisconnectedBezier(x1, y1, x2, y2, x2, y2, x4, y4);
            d5 = this.angles[0];
            f = this.getCurrentRadius();
            f2 = this.getCenter().x;
            d2 = Math.cos(d5);
            x1 = f2 + f * (float)d2;
            d5 = this.angles[0];
            f = this.getCurrentRadius();
            f2 = this.getCenter().y;
            d2 = Math.sin(d5);
            y1 = f2 + f * (float)d2;
            x2 = this.getCenter().x + (float)childDirector * (this.getCurrentRadius() + this.outChildCubicOffset);
            y2 = this.getCenter().y + (float)parentDirector * (this.getCurrentRadius() + this.outChildCubicOffset);
            d5 = this.angles[1];
            f = this.getCurrentRadius();
            f2 = this.getCenter().x;
            d2 = Math.cos(d5);
            x4 = f2 + f * (float)d2;
            d5 = this.angles[1];
            f = this.getCurrentRadius();
            f2 = this.getCenter().y;
            d2 = Math.sin(d5);
            y4 = f2 + f * (float)d2;
            this.parent.getDrawer().addDisconnectedBezier(x1, y1, x2, y2, x2, y2, x4, y4);
            this.parent.getDrawer().drawDisconnectedHelpers(canvas);
        }
    }

    @Override
    public void handleOnClick(float x, float y) {
        block1: {
            RectF clickRect = new RectF(this.getCenter().x - this.getRadius(), this.getCenter().y - this.getRadius(), this.getCenter().x + this.getRadius(), this.getCenter().y + this.getRadius());
            if (!clickRect.contains(x, y)) break block1;
            LavaView.LavaOnClickListener lavaOnClickListener = this.getListener();
            if (lavaOnClickListener != null) {
                lavaOnClickListener.onClick();
            }
        }
    }

    @Override
    public void setOnClickListener(@Nullable LavaView.LavaOnClickListener listener) {
        this.setListener(listener);
    }

    @Override
    public void setOnClickListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.setListener(new LavaView.LavaOnClickListener(listener){
            final /* synthetic */ Function0 $listener;

            public void onClick() {
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final Parent getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public PointF getCenter() {
        return this.center;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    public Child(@NotNull Parent parent, @NotNull PointF center, float radius) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        this.parent = parent;
        this.center = center;
        this.radius = radius;
        this.evaluator = new FloatEvaluator();
        this.angles = new double[5];
        this.middlePointAngle = new float[]{0.0f, 0.0f};
        this.initialRadius = this.getRadius() - this.getRadius() / 4.0f;
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/bitvale/lavafab/widget/Child$Type;", "", "lavafab_release"})
    public static @interface Type {
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/bitvale/lavafab/widget/Child$Companion;", "", "()V", "CHILD_ALL", "", "CHILD_ANGLE_DISTANCE_RATIO", "", "CHILD_BOTTOM", "CHILD_DISTANCE_RATIO", "CHILD_LEFT", "CHILD_LEFT_BOTTOM", "CHILD_LEFT_TOP", "CHILD_NONE", "CHILD_RADIUS_RATIO", "CHILD_RIGHT", "CHILD_RIGHT_BOTTOM", "CHILD_RIGHT_TOP", "CHILD_TOP", "lavafab_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

