/*
 * Decompiled with CFR 0.152.
 */
package com.bitvale.lavafab.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/bitvale/lavafab/utils/BitmapUtil;", "", "()V", "getBitmapFromDrawable", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "getBitmapFromVector", "vectorDrawable", "Landroidx/vectordrawable/graphics/drawable/VectorDrawableCompat;", "lavafab_release"})
public final class BitmapUtil {
    public static final BitmapUtil INSTANCE;

    @Nullable
    public final Bitmap getBitmapFromDrawable(@Nullable Drawable drawable) {
        Bitmap bitmap;
        if (drawable == null) {
            bitmap = null;
        } else {
            KClass kClass = Reflection.getOrCreateKotlinClass(drawable.getClass());
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(VectorDrawableCompat.class))) {
                bitmap = this.getBitmapFromVector((VectorDrawableCompat)drawable);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(BitmapDrawable.class))) {
                bitmap = ((BitmapDrawable)drawable).getBitmap();
            } else {
                throw (Throwable)new ClassCastException(drawable.toString() + " is not supported!");
            }
        }
        return bitmap;
    }

    private final Bitmap getBitmapFromVector(VectorDrawableCompat vectorDrawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    private BitmapUtil() {
    }

    static {
        BitmapUtil bitmapUtil;
        INSTANCE = bitmapUtil = new BitmapUtil();
    }
}

