/*
 * Decompiled with CFR 0.152.
 */
package com.bitvale.lavafab;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.bitvale.lavafab.LavaView;
import com.bitvale.lavafab.Parent;
import com.bitvale.lavafab.R;
import com.bitvale.lavafab.utils.BitmapUtil;
import com.bitvale.lavafab.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 C2\u00020\u0001:\u0001CB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J\u0006\u0010\"\u001a\u00020\u001eJ\u0006\u0010#\u001a\u00020\u001eJ\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010%\u001a\u00020\u0012J\u0012\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tH\u0014J\u0012\u0010,\u001a\u00020\u00122\b\u0010-\u001a\u0004\u0018\u00010.H\u0017J\u0018\u0010/\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\t2\b\u00102\u001a\u0004\u0018\u000103J\u0018\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\t2\b\b\u0001\u00104\u001a\u00020\tJ\u001c\u00105\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\t2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001e07J\u0016\u00105\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\t2\u0006\u00106\u001a\u000208J\u0010\u00109\u001a\u00020\u001e2\b\b\u0001\u0010:\u001a\u00020\tJ\u0010\u0010;\u001a\u00020\u001e2\b\b\u0001\u0010<\u001a\u00020\tJ\u0012\u0010=\u001a\u00020\u001e2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010@\u001a\u00020\u001e2\b\u00102\u001a\u0004\u0018\u000103J\u0010\u0010@\u001a\u00020\u001e2\b\b\u0001\u00104\u001a\u00020\tJ\u0014\u0010A\u001a\u00020\u001e2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001e07J\u000e\u0010A\u001a\u00020\u001e2\u0006\u00106\u001a\u000208J\u0006\u0010B\u001a\u00020\u001eR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/bitvale/lavafab/LavaFab;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "childFlag", "childIcons", "Landroid/util/SparseArray;", "Landroid/graphics/Bitmap;", "containerHeight", "containerWidth", "drawShadow", "", "lavaBackgroundColor", "lavaSize", "", "parent", "Lcom/bitvale/lavafab/Parent;", "getParent", "()Lcom/bitvale/lavafab/Parent;", "setParent", "(Lcom/bitvale/lavafab/Parent;)V", "parentIcon", "collapse", "", "containsChild", "flagSet", "flag", "enableShadow", "expand", "initParent", "isExpanded", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "retrieveAttributes", "setChildIcon", "childType", "icon", "Landroid/graphics/drawable/Drawable;", "iconId", "setChildOnClickListener", "listener", "Lkotlin/Function0;", "Lcom/bitvale/lavafab/LavaView$LavaOnClickListener;", "setLavaBackgroundColor", "color", "setLavaBackgroundResColor", "colorId", "setOnClickListener", "l", "Landroid/view/View$OnClickListener;", "setParentIcon", "setParentOnClickListener", "trigger", "Companion", "lavafab_release"})
public final class LavaFab
extends View {
    @NotNull
    public Parent parent;
    @ColorInt
    private int lavaBackgroundColor;
    @DrawableRes
    private Bitmap parentIcon;
    private boolean drawShadow;
    private float lavaSize;
    private int containerWidth;
    private int containerHeight;
    private int childFlag;
    private final SparseArray<Bitmap> childIcons;
    public static final float VIEW_SMALL_SIZE_RATIO = 2.9f;
    public static final float VIEW_LARGE_SIZE_RATIO = 3.9f;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Parent getParent() {
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        return parent;
    }

    public final void setParent(@NotNull Parent parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"<set-?>");
        this.parent = parent;
    }

    private final void retrieveAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.LavaFab, defStyleAttr, R.style.LavaFab);
        this.lavaBackgroundColor = typedArray.getColor(R.styleable.LavaFab_lavaBackgroundColor, 0);
        this.lavaSize = typedArray.getDimension(R.styleable.LavaFab_lavaParentSize, 0.0f);
        this.childFlag = typedArray.getInteger(R.styleable.LavaFab_lavaChild, 9);
        this.drawShadow = typedArray.getBoolean(R.styleable.LavaFab_lavaDrawShadow, false);
        int drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaParentIcon, 0);
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        VectorDrawableCompat drawable = ExtensionsKt.getVectorDrawable(context, drawableResId);
        this.parentIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaLeftIcon, 0);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        drawable = ExtensionsKt.getVectorDrawable(context2, drawableResId);
        Bitmap childIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        this.childIcons.put(8, (Object)childIcon);
        drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaLeftTopIcon, 0);
        Context context3 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context");
        drawable = ExtensionsKt.getVectorDrawable(context3, drawableResId);
        childIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        this.childIcons.put(16, (Object)childIcon);
        drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaTopIcon, 0);
        Context context4 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"context");
        drawable = ExtensionsKt.getVectorDrawable(context4, drawableResId);
        childIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        this.childIcons.put(1, (Object)childIcon);
        drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaRightTopIcon, 0);
        Context context5 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context5, (String)"context");
        drawable = ExtensionsKt.getVectorDrawable(context5, drawableResId);
        childIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        this.childIcons.put(32, (Object)childIcon);
        drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaRightIcon, 0);
        Context context6 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context6, (String)"context");
        drawable = ExtensionsKt.getVectorDrawable(context6, drawableResId);
        childIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        this.childIcons.put(2, (Object)childIcon);
        drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaRightBottomIcon, 0);
        Context context7 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context7, (String)"context");
        drawable = ExtensionsKt.getVectorDrawable(context7, drawableResId);
        childIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        this.childIcons.put(64, (Object)childIcon);
        drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaBottomIcon, 0);
        Context context8 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context8, (String)"context");
        drawable = ExtensionsKt.getVectorDrawable(context8, drawableResId);
        childIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        this.childIcons.put(4, (Object)childIcon);
        drawableResId = typedArray.getResourceId(R.styleable.LavaFab_lavaLeftBottomIcon, 0);
        Context context9 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context9, (String)"context");
        drawable = ExtensionsKt.getVectorDrawable(context9, drawableResId);
        childIcon = BitmapUtil.INSTANCE.getBitmapFromDrawable((Drawable)drawable);
        this.childIcons.put(128, (Object)childIcon);
        typedArray.recycle();
    }

    private final void initParent(float lavaSize) {
        boolean none;
        PointF center = new PointF(0.0f, 0.0f);
        float radius = lavaSize / 2.0f;
        float padding = radius / 4.0f;
        boolean left = this.containsChild(this.childFlag, 8);
        boolean right = this.containsChild(this.childFlag, 2);
        boolean top = this.containsChild(this.childFlag, 1);
        boolean bottom = this.containsChild(this.childFlag, 4);
        boolean leftTop = this.containsChild(this.childFlag, 16);
        boolean rightTop = this.containsChild(this.childFlag, 32);
        boolean rightBottom = this.containsChild(this.childFlag, 64);
        boolean leftBottom = this.containsChild(this.childFlag, 128);
        boolean bl = none = this.childFlag == 0;
        if (top && left && !right && !bottom) {
            this.containerHeight = this.containerWidth = (int)(lavaSize * 2.9f);
            center.x = (float)this.containerWidth - radius - padding;
            center.y = (float)this.containerWidth - radius - padding;
        }
        if (top && !left && right && !bottom) {
            this.containerHeight = this.containerWidth = (int)(lavaSize * 2.9f);
            center.x = radius + padding;
            center.y = (float)this.containerWidth - radius - padding;
        }
        if (!top && left && !right && bottom) {
            this.containerHeight = this.containerWidth = (int)(lavaSize * 2.9f);
            center.x = (float)this.containerWidth - radius - padding;
            center.y = radius + padding;
        }
        if (!top && !left && right && bottom) {
            this.containerHeight = this.containerWidth = (int)(lavaSize * 2.9f);
            center.x = radius + padding;
            center.y = radius + padding;
        }
        if (!top && left && right && !bottom) {
            this.containerWidth = (int)(lavaSize * 3.9f);
            this.containerHeight = (int)(lavaSize + padding * (float)2);
            center.x = (float)this.containerWidth / 2.0f;
            center.y = (float)this.containerHeight / 2.0f;
        }
        if (top && !left && !right && bottom) {
            this.containerWidth = (int)(lavaSize + padding * (float)2);
            this.containerHeight = (int)(lavaSize * 3.9f);
            center.x = (float)this.containerWidth / 2.0f;
            center.y = (float)this.containerHeight / 2.0f;
        }
        if (top && left && right && !bottom) {
            this.containerWidth = (int)(lavaSize * 3.9f);
            this.containerHeight = (int)(lavaSize * 2.9f);
            center.x = (float)this.containerWidth / 2.0f;
            center.y = (float)this.containerHeight - radius - padding;
        }
        if (!top && left && right && bottom) {
            this.containerWidth = (int)(lavaSize * 3.9f);
            this.containerHeight = (int)(lavaSize * 2.9f);
            center.x = (float)this.containerWidth / 2.0f;
            center.y = radius + padding;
        }
        if (top && left && !right && bottom) {
            this.containerWidth = (int)(lavaSize * 2.9f);
            this.containerHeight = (int)(lavaSize * 3.9f);
            center.x = (float)this.containerWidth - radius - padding;
            center.y = (float)this.containerHeight / 2.0f;
        }
        if (top && !left && right && bottom) {
            this.containerWidth = (int)(lavaSize * 2.9f);
            this.containerHeight = (int)(lavaSize * 3.9f);
            center.x = radius + padding;
            center.y = (float)this.containerHeight / 2.0f;
        }
        if (left && right && top && bottom) {
            this.containerHeight = this.containerWidth = (int)(lavaSize * 3.9f);
            center.x = (float)this.containerWidth / 2.0f;
            center.y = (float)this.containerWidth / 2.0f;
        }
        if (none) {
            this.containerHeight = this.containerWidth = (int)lavaSize;
            center.x = (float)this.containerWidth / 2.0f;
            center.y = (float)this.containerWidth / 2.0f;
        }
        Parent parent = this.parent = new Parent(center, radius);
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.initChild(this.childIcons, left, top, right, bottom, leftTop, leftBottom, rightTop, rightBottom);
        Parent parent2 = this.parent;
        if (parent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent2.setContainer(this);
        Parent parent3 = this.parent;
        if (parent3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent3.setIcon(this.parentIcon);
        Parent parent4 = this.parent;
        if (parent4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent4.getDrawer().setPaintColor(this.lavaBackgroundColor);
        if (this.drawShadow) {
            this.enableShadow();
        }
    }

    private final boolean containsChild(int flagSet, int flag) {
        return (flagSet | flag) == flagSet;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.draw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.containerWidth, this.containerHeight);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        boolean bl;
        MotionEvent motionEvent = event;
        if (motionEvent != null) {
            MotionEvent motionEvent2;
            MotionEvent it = motionEvent2 = motionEvent;
            Parent parent = this.parent;
            if (parent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
            }
            bl = parent.proceedOnTouch(event);
        } else {
            LavaFab lavaFab;
            LavaFab $receiver = lavaFab = this;
            bl = false;
        }
        return bl;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
    }

    public final void setParentOnClickListener(@NotNull LavaView.LavaOnClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.setOnClickListener(listener);
    }

    public final void setParentOnClickListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.setOnClickListener(listener);
    }

    public final void setChildOnClickListener(int childType, @NotNull LavaView.LavaOnClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.setChildOnClickListener(childType, listener);
    }

    public final void setChildOnClickListener(int childType, @NotNull Function0<Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.setChildOnClickListener(childType, listener);
    }

    public final void expand() {
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.expand();
    }

    public final void collapse() {
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.collapse();
    }

    public final void trigger() {
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.trigger();
    }

    public final boolean isExpanded() {
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        return parent.isExpanded();
    }

    public final void setLavaBackgroundResColor(@ColorRes int colorId) {
        int color;
        this.lavaBackgroundColor = color = ContextCompat.getColor((Context)this.getContext(), (int)colorId);
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.getDrawer().setPaintColor(color);
        this.invalidate();
    }

    public final void setLavaBackgroundColor(@ColorInt int color) {
        this.lavaBackgroundColor = color;
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.getDrawer().setPaintColor(color);
        this.invalidate();
    }

    public final void setParentIcon(@Nullable Drawable icon) {
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.setIcon(BitmapUtil.INSTANCE.getBitmapFromDrawable(icon));
        this.invalidate();
    }

    public final void setParentIcon(@DrawableRes int iconId) {
        VectorDrawableCompat drawable = VectorDrawableCompat.create((Resources)this.getResources(), (int)iconId, null);
        this.setParentIcon((Drawable)drawable);
    }

    public final void setChildIcon(int childType, @Nullable Drawable icon) {
        Bitmap ic = BitmapUtil.INSTANCE.getBitmapFromDrawable(icon);
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.setChildIcon(childType, ic);
        this.invalidate();
    }

    public final void setChildIcon(int childType, @DrawableRes int iconId) {
        VectorDrawableCompat drawable = VectorDrawableCompat.create((Resources)this.getResources(), (int)iconId, null);
        this.setChildIcon(childType, (Drawable)drawable);
    }

    public final void enableShadow() {
        this.setLayerType(1, null);
        Parent parent = this.parent;
        if (parent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        parent.enableShadow();
    }

    public LavaFab(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public LavaFab(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public /* synthetic */ LavaFab(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public LavaFab(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.childIcons = new SparseArray();
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2;
            AttributeSet it = attributeSet2 = attributeSet;
            this.retrieveAttributes(attrs, defStyleAttr);
        } else {
            LavaFab lavaFab;
            LavaFab $receiver = lavaFab = this;
            $receiver.lavaBackgroundColor = ExtensionsKt.getThemeAccentColor(context);
            $receiver.lavaSize = ExtensionsKt.getFloatDimen(context, R.dimen.default_fab_size);
        }
        this.initParent(this.lavaSize);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/bitvale/lavafab/LavaFab$Companion;", "", "()V", "VIEW_LARGE_SIZE_RATIO", "", "VIEW_SMALL_SIZE_RATIO", "lavafab_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

