/*
 * Decompiled with CFR 0.152.
 */
package com.bitvale.lavafab;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.ColorInt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016JF\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012JF\u0010 \u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012J\u0017\u0010!\u001a\u0004\u0018\u00010\u00102\b\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J0\u0010%\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012J\u0010\u0010&\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#J2\u0010'\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012J\u0017\u0010*\u001a\u0004\u0018\u00010\u00102\b\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J\u0016\u0010+\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0004J\u0006\u0010-\u001a\u00020\u0010J\u0006\u0010.\u001a\u00020\u0010J\u0006\u0010/\u001a\u00020\u0010J\u0006\u00100\u001a\u00020\u0010J\u0010\u00101\u001a\u00020\u00102\b\b\u0001\u00102\u001a\u000203R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/bitvale/lavafab/Drawer;", "", "()V", "childCirclePath", "Landroid/graphics/Path;", "connectedBezierPath", "disconnectedBezierPath", "helperRect", "iconPaint", "Landroid/graphics/Paint;", "iconRect", "Landroid/graphics/RectF;", "mainPaint", "parentCirclePath", "rectF", "addCircle", "", "centerX", "", "centerY", "radius", "isParent", "", "addConnectedBezier", "x1", "y1", "x2", "y2", "x3", "y3", "x4", "y4", "addDisconnectedBezier", "drawChildCircle", "canvas", "Landroid/graphics/Canvas;", "(Landroid/graphics/Canvas;)Lkotlin/Unit;", "drawConnectedHelpers", "drawDisconnectedHelpers", "drawIcon", "icon", "Landroid/graphics/Bitmap;", "drawParentCircle", "drawPath", "path", "enableShadow", "rewindChildCircle", "rewindHelpers", "rewindParentCircle", "setPaintColor", "color", "", "lavafab_release"})
public final class Drawer {
    private final Path parentCirclePath = new Path();
    private final Path childCirclePath = new Path();
    private final Path connectedBezierPath = new Path();
    private final Path disconnectedBezierPath = new Path();
    private final Path helperRect = new Path();
    private final RectF rectF = new RectF();
    private RectF iconRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private final Paint iconPaint;
    private final Paint mainPaint;

    public final void setPaintColor(@ColorInt int color) {
        this.mainPaint.setColor(color);
    }

    public final void enableShadow() {
        this.mainPaint.setShadowLayer(7.0f, 0.0f, 3.0f, 1681471801);
    }

    public final void drawPath(@NotNull Canvas canvas, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        canvas.drawPath(path, this.mainPaint);
    }

    public final void rewindParentCircle() {
        this.parentCirclePath.rewind();
    }

    public final void rewindChildCircle() {
        this.childCirclePath.rewind();
    }

    public final void addCircle(float centerX, float centerY, float radius, boolean isParent) {
        if (isParent) {
            this.parentCirclePath.addCircle(centerX, centerY, radius, Path.Direction.CW);
        } else {
            this.childCirclePath.addCircle(centerX, centerY, radius, Path.Direction.CW);
        }
    }

    @Nullable
    public final Unit drawParentCircle(@Nullable Canvas canvas) {
        Unit unit;
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            canvas2.drawPath(this.parentCirclePath, this.mainPaint);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit drawChildCircle(@Nullable Canvas canvas) {
        Unit unit;
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            canvas2.drawPath(this.childCirclePath, this.mainPaint);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void rewindHelpers() {
        this.connectedBezierPath.rewind();
        this.helperRect.rewind();
        this.disconnectedBezierPath.rewind();
        this.disconnectedBezierPath.reset();
    }

    public final void addConnectedBezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.connectedBezierPath.moveTo(x1, y1);
        this.connectedBezierPath.cubicTo(x2, y2, x3, y3, x4, y4);
    }

    public final void addDisconnectedBezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.disconnectedBezierPath.moveTo(x1, y1);
        this.disconnectedBezierPath.cubicTo(x2, y2, x3, y3, x4, y4);
    }

    public final void drawConnectedHelpers(@Nullable Canvas canvas, float x1, float y1, float x2, float y2) {
        block0: {
            this.rectF.set(x1, y1, x2, y2);
            this.helperRect.addRect(this.rectF, Path.Direction.CW);
            this.helperRect.op(this.connectedBezierPath, Path.Op.DIFFERENCE);
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block0;
            canvas2.drawPath(this.helperRect, this.mainPaint);
        }
    }

    public final void drawDisconnectedHelpers(@Nullable Canvas canvas) {
        block0: {
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block0;
            canvas2.drawPath(this.disconnectedBezierPath, this.mainPaint);
        }
    }

    public final void drawIcon(@Nullable Canvas canvas, @Nullable Bitmap icon, float centerX, float centerY, float radius) {
        block2: {
            Bitmap bitmap;
            Bitmap bitmap2 = icon;
            if (bitmap2 == null) break block2;
            Bitmap it = bitmap = bitmap2;
            float widthOffset = (float)icon.getWidth() / 2.0f;
            float heightOffset = (float)icon.getHeight() / 2.0f;
            int maxIconSize = Math.max(icon.getHeight(), icon.getWidth());
            if ((float)maxIconSize > radius) {
                heightOffset = widthOffset = radius / (float)2;
            }
            this.iconRect.left = centerX - widthOffset;
            this.iconRect.top = centerY - heightOffset;
            this.iconRect.right = centerX + widthOffset;
            this.iconRect.bottom = centerY + heightOffset;
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawBitmap(icon, null, this.iconRect, this.iconPaint);
            }
        }
    }

    public Drawer() {
        Paint paint;
        Paint paint2 = new Paint();
        Drawer drawer = this;
        Paint $receiver = paint2;
        $receiver.setAntiAlias(true);
        $receiver.setFilterBitmap(true);
        drawer.iconPaint = paint = paint2;
        this.mainPaint = new Paint(1);
    }
}

