/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vcard;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.property.Note;
import ezvcard.property.RawProperty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class CardDavStore {
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.vcard");
    String host;
    String path;
    String username;
    String password;
    String title;
    String backupPath;
    boolean debug = false;
    protected static Map<String, Properties> propMap = new HashMap<String, Properties>();
    Map<String, VCard> vcardByUid = new HashMap<String, VCard>();
    Map<String, VCard> vcardByName = new HashMap<String, VCard>();
    private Sardine sardine;
    private Map<String, DavResource> resourceMap = new HashMap<String, DavResource>();
    private Map<String, SyncRef> syncMap = new HashMap<String, SyncRef>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public void getBackupPath(String backupPath) {
        this.backupPath = backupPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Map<String, DavResource> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(Map<String, DavResource> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public static File getPropertyFile(String user) {
        String propertyFileName = System.getProperty("user.home") + "/.vcard/" + user + ".ini";
        File propFile = new File(propertyFileName);
        return propFile;
    }

    public static String getProperty(String user, String propName) throws FileNotFoundException, IOException {
        Properties prop = propMap.get(user);
        if (prop == null) {
            prop = new Properties();
            File propFile = CardDavStore.getPropertyFile(user);
            prop.load(new FileReader(propFile));
            propMap.put(user, prop);
        }
        return prop.getProperty(propName);
    }

    public static CardDavStore getCardDavStore(String user) throws Exception {
        String host = CardDavStore.getProperty(user, "host");
        String path = CardDavStore.getProperty(user, "path");
        CardDavStore cs = new CardDavStore(host, path);
        cs.setUsername(CardDavStore.getProperty(user, "username"));
        cs.setPassword(CardDavStore.getProperty(user, "password"));
        cs.getBackupPath(CardDavStore.getProperty(user, "backup"));
        cs.setTitle(CardDavStore.getProperty(user, "title"));
        cs.initSardine();
        return cs;
    }

    private void initSardine() {
        this.sardine = SardineFactory.begin((String)this.username, (String)this.password);
    }

    public CardDavStore(String host, String path) {
        this.host = host;
        this.path = path;
    }

    public void add(VCard vcard, String uidToUse) {
        String name = (String)vcard.getFormattedName().getValue();
        String uid = this.getSyncUid(vcard);
        if (uidToUse != null) {
            if (uid == null) {
                uid = uidToUse;
                LOGGER.log(Level.WARNING, "VCard with no uid added: " + name + "(" + uid + ")");
            } else if (!uidToUse.equals(uid)) {
                LOGGER.log(Level.WARNING, "VCard with different uid added: " + name + "(" + uid + "!=" + uidToUse + ")");
            }
        }
        if (uid != null) {
            this.vcardByUid.put(uid, vcard);
        } else {
            LOGGER.log(Level.WARNING, "VCard with no uid found: " + name);
        }
        if (this.vcardByName.containsKey(name)) {
            LOGGER.log(Level.SEVERE, "Duplicate VCard for name found: " + name);
        }
        this.vcardByName.put(name, vcard);
    }

    public CardDavStore(File vcardPath, String title) throws IOException {
        this.setTitle(title);
        this.read(vcardPath);
    }

    public void read(File vcardPath) throws IOException {
        if (vcardPath.isDirectory()) {
            String[] vcardFileNames;
            for (String vcardFileName : vcardFileNames = vcardPath.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".vcf");
                }
            })) {
                File vcardFile = new File(vcardPath, vcardFileName);
                VCard vcard = Ezvcard.parse((File)vcardFile).first();
                this.add(vcard, null);
            }
        } else {
            List vcards = Ezvcard.parse((File)vcardPath).all();
            for (VCard vcard : vcards) {
                this.add(vcard, null);
            }
        }
    }

    public String getSyncUid(VCard vcard) {
        String uid = null;
        if (vcard.getUid() != null) {
            uid = (String)vcard.getUid().getValue();
        }
        List eprops = vcard.getExtendedProperties();
        for (RawProperty eprop : eprops) {
            String propName = eprop.getPropertyName();
            String value = (String)eprop.getValue();
            LOGGER.log(Level.INFO, propName + "=" + value);
            if (!propName.equals("X-ABUID")) continue;
        }
        return uid;
    }

    public void getVCardRefs() throws Exception {
        if (this.getResourceMap().size() == 0) {
            List resources = this.sardine.list(this.host + this.path);
            if (this.debug) {
                LOGGER.log(Level.INFO, " got " + resources.size() + " resources");
            }
            for (DavResource resource : resources) {
                String contentType = resource.getContentType();
                if (!contentType.contains("text/vcard")) continue;
                String uid = this.getUid(resource);
                this.getResourceMap().put(uid, resource);
            }
        }
    }

    public void prepareSync() throws Exception {
        this.getVCardRefs();
        this.syncMap.clear();
        for (DavResource ref : this.getResourceMap().values()) {
            if (this.debug) {
                LOGGER.log(Level.INFO, ref.toString());
            }
            String uid = this.getUid(ref);
            this.syncMap.put(uid, new SyncRef(ref));
        }
    }

    public VCard getVCardFromRef(DavResource ref) throws Exception {
        String url = this.getHost() + ref.getPath();
        InputStream is = this.sardine.get(url);
        String vcardText = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        VCard vcard = Ezvcard.parse((String)vcardText).first();
        return vcard;
    }

    public void write(VCard vcard, File vCardFile, DavResource ref) throws Exception {
        vcard.write(vCardFile);
        vCardFile.setLastModified(ref.getModified().getTime());
    }

    public String getUid(DavResource ref) {
        String[] hrefparts = ref.getPath().split("/");
        String uid = hrefparts[hrefparts.length - 1];
        return uid.replace(".vcf", "");
    }

    private File getVCardFile(DavResource ref) {
        String cardfilename = this.getUid(ref) + ".vcf";
        File vCardFile = new File(this.backupPath, cardfilename);
        return vCardFile;
    }

    public void sync() throws Exception {
        this.prepareSync();
        for (SyncRef syncRef : this.syncMap.values()) {
            if (this.debug) {
                LOGGER.log(Level.INFO, syncRef.toString());
            }
            syncRef.sync();
        }
        this.synchronizationStatistics();
    }

    public void synchronizationStatistics() {
        HashMap<SyncState, AtomicInteger> stats = new HashMap<SyncState, AtomicInteger>();
        for (SyncState syncState : SyncState.values()) {
            stats.put(syncState, new AtomicInteger(0));
        }
        for (SyncRef syncRef : this.syncMap.values()) {
            AtomicInteger count = (AtomicInteger)stats.get((Object)syncRef.syncState);
            count.set(count.get() + 1);
        }
        for (SyncState syncState : SyncState.values()) {
            LOGGER.log(Level.INFO, syncState.name() + ": " + stats.get((Object)syncState));
        }
    }

    public void diff(Map<String, VCard> self, Map<String, VCard> other, String thisTitle, String otherTitle) {
        Map<String, VCard> bigger = other;
        Map<String, VCard> smaller = self;
        String biggerTitle = otherTitle;
        String smallerTitle = thisTitle;
        if (self.size() > other.size()) {
            bigger = self;
            biggerTitle = thisTitle;
            smaller = other;
            smallerTitle = otherTitle;
        }
        System.out.println(bigger.size() + " (" + biggerTitle + ") <-> " + smaller.size() + "(" + smallerTitle + ")");
        int index = 0;
        for (String key : bigger.keySet()) {
            if (smaller.get(key) != null) continue;
            VCard vcard = bigger.get(key);
            System.out.println("" + ++index + ":vcard " + key + " '" + (String)vcard.getFormattedName().getValue() + "' " + (String)vcard.getUid().getValue() + " is missing in " + smallerTitle);
        }
    }

    public void diff(CardDavStore other) {
        this.diff(this.vcardByUid, other.vcardByUid, this.getTitle(), other.getTitle());
        this.diff(this.vcardByName, other.vcardByName, this.getTitle(), other.getTitle());
    }

    public List<VCard> getVCards(int limit) throws Exception {
        ArrayList<VCard> result = new ArrayList<VCard>();
        this.getVCardRefs();
        for (DavResource ref : this.getResourceMap().values()) {
            VCard vcard = this.getVCardFromRef(ref);
            result.add(vcard);
            if (result.size() < limit) continue;
            break;
        }
        return result;
    }

    public List<VCard> backup() throws Exception {
        File vcardPath = new File(this.backupPath);
        vcardPath.mkdirs();
        ArrayList<VCard> result = new ArrayList<VCard>();
        this.getVCardRefs();
        for (DavResource ref : this.getResourceMap().values()) {
            VCard vcard = this.getVCardFromRef(ref);
            this.write(vcard, this.getVCardFile(ref), ref);
            if (this.debug) {
                System.out.println((String)vcard.getFormattedName().getValue());
            }
            result.add(vcard);
        }
        return result;
    }

    public void readFromBackup() throws IOException {
        this.read(new File(this.backupPath));
    }

    public void remove(String uid) throws Exception {
        this.getVCardRefs();
        DavResource ref = this.getResourceMap().get(uid);
        if (ref != null) {
            System.out.println("removing " + uid);
            this.sardine.delete(this.host + ref.getPath());
            File vcardFile = this.getVCardFile(ref);
            vcardFile.delete();
        } else {
            System.err.println("not found " + uid);
        }
    }

    public class SyncRef {
        SyncState syncState;
        DavResource ref;
        String uid;
        VCard vcard;
        File vCardFile;

        public SyncRef(DavResource ref) {
            boolean needSync;
            this.ref = ref;
            this.uid = CardDavStore.this.getUid(ref);
            this.syncState = SyncState.untouchedCard;
            this.vCardFile = CardDavStore.this.getVCardFile(ref);
            boolean bl = needSync = !this.vCardFile.exists();
            if (!needSync) {
                Date filemodified = new Date(this.vCardFile.lastModified());
                needSync = filemodified.before(ref.getModified());
                if (needSync) {
                    this.syncState = SyncState.modifiedCard;
                }
            } else {
                this.syncState = SyncState.newCard;
            }
        }

        public void sync() throws Exception {
            switch (this.syncState) {
                case untouchedCard: {
                    this.vcard = Ezvcard.parse((File)this.vCardFile).first();
                    break;
                }
                case modifiedCard: 
                case newCard: {
                    this.vcard = CardDavStore.this.getVCardFromRef(this.ref);
                    CardDavStore.this.write(this.vcard, this.vCardFile, this.ref);
                }
            }
            if (CardDavStore.this.debug) {
                LOGGER.log(Level.INFO, this.toString());
            }
        }

        public String toString() {
            String text = this.uid + ":" + (String)this.vcard.getFormattedName().getValue();
            for (Note note : this.vcard.getNotes()) {
                text = text + "\n\t" + (String)note.getValue();
            }
            return text;
        }
    }

    static enum SyncState {
        untouchedCard,
        modifiedCard,
        newCard;

    }
}

