/*
 * Decompiled with CFR 0.152.
 */
package probe;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.NativeLongByReference;
import edsdk.api.CanonCamera;
import edsdk.bindings.EdSdkLibrary;
import edsdk.bindings.EdsFocusInfo;
import edsdk.bindings.EdsPictureStyleDesc;
import edsdk.bindings.EdsPoint;
import edsdk.bindings.EdsPropertyDesc;
import edsdk.bindings.EdsRational;
import edsdk.bindings.EdsRect;
import edsdk.bindings.EdsSize;
import edsdk.bindings.EdsTime;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.util.ArrayList;

public class Test {
    public static void main(String[] args) throws InterruptedException, IOException {
        CanonCamera camera = new CanonCamera();
        if (camera.openSession()) {
            CanonConstants.EdsISOSpeed[] aa;
            Long lvalue = Test.printProperty(camera, CanonConstants.EdsPropertyID.kEdsPropID_BatteryLevel);
            System.out.println(lvalue == -1L ? "On AC power" : "On battery, value is percentage remaining.");
            lvalue = Test.printProperty(camera, CanonConstants.EdsPropertyID.kEdsPropID_BatteryQuality);
            lvalue = Test.printProperty(camera, CanonConstants.EdsPropertyID.kEdsPropID_DriveMode);
            for (CanonConstants.EdsPropertyID id : CanonConstants.EdsPropertyID.values()) {
                Test.getPropertyDesc(camera.getEdsCamera(), id, true);
            }
            CanonConstants.EdsISOSpeed currentISOSpeed = CanonConstants.EdsISOSpeed.enumOfValue(camera.getProperty(CanonConstants.EdsPropertyID.kEdsPropID_ISOSpeed).intValue());
            CanonConstants.EdsISOSpeed[] availableISOSpeeds = camera.getAvailableISOSpeeds();
            if (availableISOSpeeds != null) {
                for (CanonConstants.EdsISOSpeed e : availableISOSpeeds) {
                    System.out.println("ISO Speed " + e.description() + (e.equals(currentISOSpeed) ? " *CURRENT* " : ""));
                }
            } else {
                System.out.println("ISO Speed settings not configurable with current mode/lens");
            }
            CanonConstants.EdsTv currentShutterSpeed = CanonConstants.EdsTv.enumOfValue(camera.getProperty(CanonConstants.EdsPropertyID.kEdsPropID_Tv).intValue());
            CanonConstants.EdsTv[] availableShutterSpeeds = camera.getAvailableShutterSpeeds();
            if (availableShutterSpeeds != null) {
                for (CanonConstants.EdsTv e : availableShutterSpeeds) {
                    System.out.println("Shutter Speed " + e.description() + (e.equals(currentShutterSpeed) ? " *CURRENT* " : ""));
                }
            } else {
                System.out.println("Shutter speed is not configurable with current mode/lens");
            }
            CanonConstants.EdsAv currentApertureValue = CanonConstants.EdsAv.enumOfValue(camera.getProperty(CanonConstants.EdsPropertyID.kEdsPropID_Av).intValue());
            CanonConstants.EdsAv[] availableApertureValues = camera.getAvailableApertureValues();
            if (availableApertureValues != null) {
                for (CanonConstants.EdsAv e : availableApertureValues) {
                    System.out.println("Aperture " + e.description() + (e.equals(currentApertureValue) ? " *CURRENT* " : ""));
                }
            } else {
                System.out.println("Aperture value not configurable with current mode/lens");
            }
            System.out.println("Generic Array Test");
            for (CanonConstants.EdsISOSpeed a : aa = Test.genericArrayTest(CanonConstants.EdsISOSpeed[].class, new int[]{48, 83, 104})) {
                System.out.println(" " + a.description());
            }
            System.out.println("\nMirror Lockup Setting: " + camera.getCustomFunction(CanonConstants.EdsCustomFunction.kEdsCustomFunction_MirrorLockup));
            camera.beginLiveView();
            Thread.sleep(2000L);
            ArrayList<EdSdkLibrary.EdsBaseRef> baserefs = new ArrayList<EdSdkLibrary.EdsBaseRef>();
            baserefs.add(camera.getEdsCamera());
            EdSdkLibrary.EdsBaseRef.ByReference[] liverefs = CanonUtils.getLiveViewImageReference(camera.getEdsCamera());
            if (liverefs != null && liverefs.length > 0 && liverefs[0] != null) {
                System.out.println("\nlive view active so adding evf image reference");
                baserefs.add(liverefs[0].getValue());
            }
            System.out.println("\nMirror Lockup Setting: " + camera.getCustomFunction(CanonConstants.EdsCustomFunction.kEdsCustomFunction_MirrorLockup));
            System.out.println("\nLive View Histogram Status: " + camera.getLiveViewHistogramStatus());
            boolean hideNegativeSizeProperties = true;
            boolean hideNegativeSizeCustomFunctions = true;
            System.out.println("\nProperty Sizes");
            System.out.println("---------------------------------------");
            for (EdSdkLibrary.EdsBaseRef baseref : baserefs) {
                System.out.println("\nGetting properties for: " + ((Object)((Object)baseref)).getClass().getSimpleName());
                System.out.println("---------------------------------------");
                for (CanonConstants.EdsPropertyID id : CanonConstants.EdsPropertyID.values()) {
                    Object value;
                    long size = CanonUtils.getPropertySize(baseref, id);
                    CanonConstants.EdsDataType type = CanonUtils.getPropertyType(baseref, id);
                    if (type == null) {
                        System.out.println(id + "- unsupported");
                        continue;
                    }
                    if (size <= -1L) continue;
                    System.out.println(id.name());
                    System.out.println("  Size: " + size);
                    System.out.println("  Type: " + type.description());
                    if (size == -1L && type.equals(CanonConstants.EdsDataType.kEdsDataType_Unknown)) {
                        System.out.println(id.name() + " - VALUE NOT AVAILABLE ON THIS CAMERA AND/OR WITH CURRENT SETTINGS");
                        continue;
                    }
                    switch (type) {
                        case kEdsDataType_String: {
                            String data = (String)CanonUtils.getPropertyDataAdvanced(baseref, id);
                            value = data;
                            break;
                        }
                        case kEdsDataType_Rational: {
                            Structure struct = (EdsRational)((Object)CanonUtils.getPropertyDataAdvanced(baseref, id));
                            value = struct;
                            break;
                        }
                        case kEdsDataType_Point: {
                            Structure struct = (EdsPoint)((Object)CanonUtils.getPropertyDataAdvanced(baseref, id));
                            value = struct;
                            break;
                        }
                        case kEdsDataType_Rect: {
                            Structure struct = (EdsRect)((Object)CanonUtils.getPropertyDataAdvanced(baseref, id));
                            value = struct;
                            break;
                        }
                        case kEdsDataType_Time: {
                            Structure struct = (EdsTime)((Object)CanonUtils.getPropertyDataAdvanced(baseref, id));
                            value = struct;
                            break;
                        }
                        case kEdsDataType_FocusInfo: {
                            Structure struct = (EdsFocusInfo)((Object)CanonUtils.getPropertyDataAdvanced(baseref, id));
                            value = struct;
                            break;
                        }
                        case kEdsDataType_PictureStyleDesc: {
                            Structure struct = (EdsPictureStyleDesc)((Object)CanonUtils.getPropertyDataAdvanced(baseref, id));
                            value = struct;
                            break;
                        }
                        case kEdsDataType_ByteBlock: 
                        case kEdsDataType_Int8_Array: 
                        case kEdsDataType_UInt8_Array: 
                        case kEdsDataType_Int16_Array: 
                        case kEdsDataType_UInt16_Array: 
                        case kEdsDataType_Int32_Array: 
                        case kEdsDataType_UInt32_Array: {
                            int[] array = (int[])CanonUtils.getPropertyDataAdvanced(baseref, id);
                            value = array;
                            break;
                        }
                        default: {
                            value = (long)CanonUtils.getPropertyData(baseref, id);
                        }
                    }
                    System.out.println(" Value: " + Test.toString(value));
                }
                System.out.println("\n");
            }
            System.out.println("Custom Functions");
            System.out.println("---------------------------------------");
            for (int i = -10000; i < 10000; ++i) {
                long size = CanonUtils.getPropertySize(camera.getEdsCamera(), CanonConstants.EdsPropertyID.kEdsPropID_CFn, i);
                CanonConstants.EdsDataType type = CanonUtils.getPropertyType(camera.getEdsCamera(), CanonConstants.EdsPropertyID.kEdsPropID_CFn, i);
                if (size <= -1L) continue;
                System.out.println("Number: " + i + " (0x" + Integer.toHexString(i) + ")");
                System.out.println("  Type: " + type.description());
                System.out.println("  Size: " + size);
                if (size == -1L && type.equals(CanonConstants.EdsDataType.kEdsDataType_Unknown)) {
                    System.out.println(" VALUE NOT AVAILABLE ON THIS CAMERA AND/OR WITH CURRENT SETTINGS");
                    continue;
                }
                Long value = CanonUtils.getPropertyData(camera.getEdsCamera(), CanonConstants.EdsPropertyID.kEdsPropID_CFn, i);
                System.out.println(" Value: " + value);
                CanonConstants.EdsCustomFunction e = CanonConstants.EdsCustomFunction.enumOfValue(i);
                if (e != null) {
                    System.out.println(" Known: Yes, " + e.name() + " (" + e.description() + ")");
                    continue;
                }
                System.out.println(" Known: NO");
            }
            System.out.println("\n");
            if (liverefs != null) {
                CanonUtils.release(liverefs);
            }
            System.out.println("Property Getters in CanonCamera");
            System.out.println("---------------------------------------");
            Method[] methods = camera.getClass().getMethods();
            for (Method method : methods) {
                if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
                System.out.println("Trying " + method.getName());
                try {
                    Object o = method.invoke((Object)camera, (Object[])null);
                    System.out.println(" Result: " + Test.toString(o));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("\n\n");
            System.out.println("EdsCustomFunction with CanonCamera.getCustomFunction");
            System.out.println("----------------------------------------------------");
            for (CanonConstants.EdsCustomFunction e : CanonConstants.EdsCustomFunction.values()) {
                System.out.println("\nTrying " + e.description() + " (" + e.name() + ")");
                Long result = camera.getCustomFunction(e);
                System.out.println("    Value: " + Test.toString(result));
            }
            System.out.println("\n");
            System.out.println("Testing if its possible to get values from the camera for undefined property IDs from 0x0 to 0xFFFF");
            System.out.println("----------------------------------------------------");
            for (int i = 0; i < 65535; ++i) {
                if (null != CanonConstants.EdsPropertyID.enumOfValue(i)) continue;
                boolean bufferSize = true;
                IntBuffer type = IntBuffer.allocate(1);
                NativeLongByReference number = new NativeLongByReference(new NativeLong(1L));
                CanonConstants.EdsError err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetPropertySize((EdSdkLibrary.EdsBaseRef)camera.getEdsCamera(), new NativeLong((long)i), new NativeLong(0L), type, number));
                if (!err.equals(CanonConstants.EdsError.EDS_ERR_PROPERTIES_UNAVAILABLE)) {
                    System.out.println(i + " (0x" + Integer.toHexString(i) + "): " + err.description());
                }
                if (err != CanonConstants.EdsError.EDS_ERR_OK) continue;
                int size = (int)number.getValue().longValue();
                CanonConstants.EdsDataType edsType = CanonConstants.EdsDataType.enumOfValue(type.get(0));
                if (size <= -1) continue;
                if (edsType == null || edsType.equals(CanonConstants.EdsDataType.kEdsDataType_Unknown)) {
                    System.out.println("WARNING: size is greater than -1 (" + size + "), but edsType is unknown!");
                    continue;
                }
                Memory memory = new Memory(size > 0 ? (long)size : 1L);
                err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetPropertyData(camera.getEdsCamera(), new NativeLong((long)i), new NativeLong(0L), new NativeLong((long)size), (Pointer)memory));
                if (err != CanonConstants.EdsError.EDS_ERR_OK) continue;
                if (edsType.equals(CanonConstants.EdsDataType.kEdsDataType_Int32) || edsType.equals(CanonConstants.EdsDataType.kEdsDataType_UInt32)) {
                    System.out.println("    property: " + i + " (0x" + Integer.toHexString(i) + "), value: " + memory.getNativeLong(0L) + ", data type: " + edsType.description() + ", size: " + size);
                    continue;
                }
                if (edsType.equals(CanonConstants.EdsDataType.kEdsDataType_String)) {
                    System.out.println("    property: " + i + " (0x" + Integer.toHexString(i) + "), value: " + memory.getString(0L) + ", data type: " + edsType.description() + ", size: " + size);
                    continue;
                }
                System.out.println("    property: " + i + " (0x" + Integer.toHexString(i) + "), value: NOT SUPPORTED, data type: " + edsType.description() + ", size: " + size);
            }
            camera.endLiveView();
            camera.closeSession();
        }
        CanonCamera.close();
    }

    public static final CanonConstants.DescriptiveEnum<?>[] getPropertyDesc(EdSdkLibrary.EdsCameraRef camera, CanonConstants.EdsPropertyID property, boolean hideEmptyPropertyDesc) {
        EdsPropertyDesc propertyDesc = CanonUtils.getPropertyDesc((EdSdkLibrary.EdsBaseRef)camera, property);
        if (propertyDesc.numElements.intValue() > 0 || !hideEmptyPropertyDesc) {
            System.out.println("Getting available property values for " + property.description() + " (" + property.name() + ")");
            CanonConstants.DescriptiveEnum currentProperty = null;
            try {
                int currentPropertyValue = CanonUtils.getPropertyData(camera, property).intValue();
                switch (property) {
                    case kEdsPropID_DriveMode: {
                        currentProperty = CanonConstants.EdsDriveMode.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_ISOSpeed: {
                        currentProperty = CanonConstants.EdsISOSpeed.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_MeteringMode: {
                        currentProperty = CanonConstants.EdsMeteringMode.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_AFMode: {
                        currentProperty = CanonConstants.EdsAFMode.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_Av: {
                        currentProperty = CanonConstants.EdsAv.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_Tv: {
                        currentProperty = CanonConstants.EdsTv.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_ExposureCompensation: {
                        currentProperty = CanonConstants.EdsExposureCompensation.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_AEMode: {
                        currentProperty = CanonConstants.EdsAEMode.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_ImageQuality: {
                        currentProperty = CanonConstants.EdsImageQuality.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_WhiteBalance: {
                        currentProperty = CanonConstants.EdsWhiteBalance.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_ColorSpace: {
                        currentProperty = CanonConstants.EdsColorSpace.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_PictureStyle: {
                        currentProperty = CanonConstants.EdsPictureStyle.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_Evf_OutputDevice: {
                        currentProperty = CanonConstants.EdsEvfOutputDevice.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_Evf_WhiteBalance: {
                        currentProperty = CanonConstants.EdsWhiteBalance.enumOfValue(currentPropertyValue);
                        break;
                    }
                    case kEdsPropID_Evf_AFMode: {
                        currentProperty = CanonConstants.EdsEvfAFMode.enumOfValue(currentPropertyValue);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException currentPropertyValue) {
                // empty catch block
            }
            if (currentProperty == null) {
                if (propertyDesc.numElements.intValue() > 0) {
                    System.out.println("WARNING: Could not get the current value for " + property.description() + " (" + property.name() + ")");
                }
            } else {
                System.out.println("Current Value: ( " + currentProperty.value() + " ) " + currentProperty.description());
            }
            System.out.println("Number of elements: " + propertyDesc.numElements);
            NativeLong[] propDesc = propertyDesc.propDesc;
            CanonConstants.DescriptiveEnum[] properties = new CanonConstants.DescriptiveEnum[propertyDesc.numElements.intValue()];
            for (int i = 0; i < propertyDesc.numElements.intValue(); ++i) {
                Enum e = null;
                switch (property) {
                    case kEdsPropID_DriveMode: {
                        e = CanonConstants.EdsDriveMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_ISOSpeed: {
                        e = CanonConstants.EdsISOSpeed.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_MeteringMode: {
                        e = CanonConstants.EdsMeteringMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_AFMode: {
                        e = CanonConstants.EdsAFMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Av: {
                        e = CanonConstants.EdsAv.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Tv: {
                        e = CanonConstants.EdsTv.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_ExposureCompensation: {
                        e = CanonConstants.EdsExposureCompensation.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_AEMode: {
                        e = CanonConstants.EdsAEMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_ImageQuality: {
                        e = CanonConstants.EdsImageQuality.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_WhiteBalance: {
                        e = CanonConstants.EdsWhiteBalance.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_ColorSpace: {
                        e = CanonConstants.EdsColorSpace.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_PictureStyle: {
                        e = CanonConstants.EdsPictureStyle.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Evf_OutputDevice: {
                        e = CanonConstants.EdsEvfOutputDevice.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Evf_WhiteBalance: {
                        e = CanonConstants.EdsWhiteBalance.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Evf_AFMode: {
                        e = CanonConstants.EdsEvfAFMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_AEBracket: 
                    case kEdsPropID_Evf_Mode: {
                        return null;
                    }
                    default: {
                        if (CanonUtils.lenient) break;
                        throw new IllegalArgumentException("Property '" + property.name() + "' is not supported.");
                    }
                }
                if (e == null) {
                    System.out.println("WARNING: Could not find " + property.name() + " enum with value of: " + propDesc[i].intValue());
                } else {
                    System.out.println(e.name() + " ( " + e.value() + " ) " + e.description());
                }
                properties[i] = e;
            }
            System.out.println("DONE!\n");
            return properties;
        }
        return null;
    }

    public static final Long printProperty(CanonCamera camera, CanonConstants.EdsPropertyID property) {
        Long value = camera.getProperty(property);
        System.out.println(property.name() + " - " + property.description() + ": " + value + "\n");
        return value;
    }

    public static final String toString(Object value) {
        if (value != null) {
            String result;
            Class<?> klass = value.getClass();
            if (String.class.isAssignableFrom(klass)) {
                result = (String)value;
            } else if (CanonConstants.DescriptiveEnum.class.isAssignableFrom(klass)) {
                CanonConstants.DescriptiveEnum descEnum = (CanonConstants.DescriptiveEnum)value;
                result = descEnum.description() + " (" + descEnum.name() + ")";
            } else if (CanonConstants.DescriptiveEnum[].class.isAssignableFrom(klass)) {
                CanonConstants.DescriptiveEnum[] array = (CanonConstants.DescriptiveEnum[])value;
                String s = "\n";
                if (array.length > 0) {
                    for (CanonConstants.DescriptiveEnum descEnum : array) {
                        s = s + "\n    " + descEnum.description() + " (" + descEnum.name() + ")";
                    }
                    s = s.substring(1);
                }
                result = s;
            } else if (EdsRational.class.isAssignableFrom(klass)) {
                EdsRational struct = (EdsRational)((Object)value);
                result = new String(struct.numerator.longValue() + " / " + struct.denominator.longValue());
            } else if (EdsPoint.class.isAssignableFrom(klass)) {
                EdsPoint struct = (EdsPoint)((Object)value);
                result = new String("(" + struct.x + ", " + struct.y + ")");
            } else if (EdsRect.class.isAssignableFrom(klass)) {
                EdsRect struct = (EdsRect)((Object)value);
                result = new String(struct.size.width + "x" + struct.size.height + ", (" + struct.point.x + ", " + struct.point.y + ")");
            } else if (EdsSize.class.isAssignableFrom(klass)) {
                EdsSize struct = (EdsSize)((Object)value);
                result = new String(struct.width + "x" + struct.height);
            } else if (EdsTime.class.isAssignableFrom(klass)) {
                EdsTime struct = (EdsTime)((Object)value);
                result = new String(struct.year.intValue() + "-" + struct.month.intValue() + "-" + struct.day.intValue() + " " + struct.hour.intValue() + ":" + struct.minute.intValue() + ":" + struct.second.intValue() + "." + struct.milliseconds.intValue());
            } else if (EdsFocusInfo.class.isAssignableFrom(klass)) {
                EdsFocusInfo struct = (EdsFocusInfo)((Object)value);
                result = struct.toString();
            } else if (EdsPictureStyleDesc.class.isAssignableFrom(klass)) {
                EdsPictureStyleDesc struct = (EdsPictureStyleDesc)((Object)value);
                result = new String("\n    Color tone: " + struct.colorTone.longValue() + "\n    Contrast: " + struct.contrast.longValue() + "\n    Filter effect: " + CanonConstants.EdsFilterEffect.enumOfValue(struct.filterEffect.intValue()).description() + "\n    Saturation: " + struct.saturation.longValue() + "\n    Sharpness: " + struct.sharpness.longValue() + "\n    Toning Effect: " + CanonConstants.EdsTonigEffect.enumOfValue(struct.toningEffect.intValue()).description());
            } else if (int[].class.isAssignableFrom(klass)) {
                int[] array = (int[])value;
                String s = "";
                if (array != null && array.length > 0) {
                    for (int i : array) {
                        s = s + ", " + i;
                    }
                    s = s.substring(2);
                }
                result = s;
            } else {
                result = value.toString();
            }
            return result;
        }
        return "";
    }

    public static final <T> T genericArrayTest(Class<T> klass, int[] data) {
        CanonConstants.DescriptiveEnum[] array = (CanonConstants.DescriptiveEnum[])Array.newInstance(klass.getComponentType(), data.length);
        for (int i = 0; i < data.length; ++i) {
            array[i] = CanonConstants.enumOfValue(klass.getComponentType(), data[i]);
        }
        return (T)array;
    }
}

