/*
 * Decompiled with CFR 0.152.
 */
package probe;

import edsdk.api.CanonCamera;
import edsdk.utils.CanonConstants;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.imgscalr.Scalr;

public class SinglePhoto {
    public static final int shotAttempts = 5;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){
            final CanonCamera camera = new CanonCamera();
            JFrame frame;
            JLabel label;
            JButton button;

            @Override
            public void run() {
                this.frame = new JFrame("Canon EDSDK - Shoot Single Photo");
                this.frame.setLayout(new FlowLayout());
                this.frame.setDefaultCloseOperation(2);
                this.frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        CanonCamera.close();
                    }
                });
                this.initialize();
                this.frame.pack();
                this.frame.setVisible(true);
            }

            private void initialize() {
                this.label = new JLabel();
                this.frame.getContentPane().add((Component)this.label, "Center");
                this.button = new JButton("Take Photo");
                this.button.addActionListener(new ButtonListener());
                this.frame.getContentPane().add(this.button);
            }

            final class ButtonListener
            implements ActionListener {
                ButtonListener() {
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    final AbstractButton button = (AbstractButton)e.getSource();
                    final String oldText = button.getText();
                    button.setText("working...");
                    button.setEnabled(false);
                    new SwingWorker<File[], Object>(){

                        @Override
                        protected File[] doInBackground() throws Exception {
                            return SinglePhoto.takePhoto(camera);
                        }

                        @Override
                        protected void done() {
                            try {
                                SinglePhoto.updateImage(frame, label, (File[])this.get());
                                button.setText(oldText);
                                button.setEnabled(true);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.execute();
                }
            }
        });
    }

    public static void updateImage(JFrame frame, JLabel label, File[] photos) throws IOException {
        if (photos != null) {
            BufferedImage image;
            File photo = photos.length == 2 ? (photos[1].getCanonicalPath().toLowerCase().endsWith(".jpg") ? photos[1] : photos[0]) : photos[0];
            if (photo != null && (image = ImageIO.read(photo)) != null) {
                image = Scalr.resize((BufferedImage)image, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)768, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
                label.setIcon(new ImageIcon(image));
                frame.pack();
                image.flush();
            }
            for (File p : photos) {
                if (p == null) continue;
                System.out.println(p.getCanonicalPath());
            }
        }
    }

    public static File[] takePhoto(CanonCamera cam) {
        if (cam.openSession()) {
            File[] photos = cam.shoot(CanonConstants.EdsSaveTo.kEdsSaveTo_Host, 5);
            cam.closeSession();
            return photos;
        }
        return null;
    }
}

