/*
 * Decompiled with CFR 0.152.
 */
package gettingstarted;

import edsdk.api.CanonCamera;
import edsdk.api.commands.ShootCommand;
import edsdk.utils.CanonConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class E05_Timelapse {
    public static void main(String[] args) throws InterruptedException {
        CanonCamera camera = new CanonCamera();
        if (camera.openSession()) {
            E05_Timelapse.createUI(camera);
            while (true) {
                System.out.println("=========================================");
                long level = camera.getBatteryLevel();
                if (level != -1L) {
                    System.out.println("Battery Level = " + level);
                }
                camera.execute(new ShootCommand(CanonConstants.EdsSaveTo.kEdsSaveTo_Host, 20, E05_Timelapse.filename()));
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        CanonCamera.close();
    }

    public static File filename() {
        return new File("images\\" + new SimpleDateFormat("yyyy\\MM\\dd\\HH-mm-ss").format(new Date()) + ".jpg");
    }

    private static void createUI(final CanonCamera camera) {
        JFrame frame = new JFrame();
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 1;
        CanonConstants.EdsTv currentShutterSpeed = camera.getShutterSpeed();
        CanonConstants.EdsAv currentApertureValue = camera.getApertureValue();
        CanonConstants.EdsISOSpeed currentISOSpeed = camera.getISOSpeed();
        CanonConstants.EdsTv[] availableShutterSpeeds = camera.getAvailableShutterSpeeds();
        CanonConstants.EdsAv[] availableApertureValues = camera.getAvailableApertureValues();
        CanonConstants.EdsISOSpeed[] availableISOSpeeds = camera.getAvailableISOSpeeds();
        E05_Timelapse.addCombobox(content, gbc, "Shutter Speed", availableShutterSpeeds, currentShutterSpeed, new Callback(){

            @Override
            public void call(String name) {
                camera.setShutterSpeed(CanonConstants.EdsTv.enumOfDescription(name));
            }
        });
        E05_Timelapse.addCombobox(content, gbc, "Aperture", availableApertureValues, currentApertureValue, new Callback(){

            @Override
            public void call(String name) {
                camera.setApertureValue(CanonConstants.EdsAv.enumOfDescription(name));
            }
        });
        E05_Timelapse.addCombobox(content, gbc, "ISO", availableISOSpeeds, currentISOSpeed, new Callback(){

            @Override
            public void call(String name) {
                camera.setISOSpeed(CanonConstants.EdsISOSpeed.enumOfDescription(name));
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(content);
        frame.setSize(500, 400);
        frame.setVisible(true);
    }

    private static void addCombobox(JPanel content, GridBagConstraints gbc, String label, CanonConstants.DescriptiveEnum<?>[] enums, CanonConstants.DescriptiveEnum<?> selected, final Callback callback) {
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        content.add((Component)new JLabel(label), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        if (enums == null) {
            content.add((Component)new JLabel("not available with current mode / lens"), gbc);
        } else {
            LinkedList<String> items = new LinkedList<String>();
            for (CanonConstants.DescriptiveEnum<?> e : enums) {
                items.add(e.description());
            }
            final JComboBox<String> combo = new JComboBox<String>(items.toArray(new String[0]));
            combo.setSelectedItem(selected.description());
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    callback.call(combo.getSelectedItem().toString());
                }
            });
            content.add(combo, gbc);
        }
        ++gbc.gridy;
    }

    static interface Callback {
        public void call(String var1);
    }
}

