/*
 * Decompiled with CFR 0.152.
 */
package gettingstarted;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.NativeLongByReference;
import edsdk.api.CanonCamera;
import edsdk.bindings.EdSdkLibrary;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;

public class E01_Simple {
    public static void main(String[] args) throws InterruptedException {
        int result = CanonCamera.EDSDK.EdsInitializeSDK().intValue();
        E01_Simple.check(result);
        EdSdkLibrary.EdsCameraListRef.ByReference list = new EdSdkLibrary.EdsCameraListRef.ByReference();
        E01_Simple.debug(list);
        result = CanonCamera.EDSDK.EdsGetCameraList(list).intValue();
        E01_Simple.debug(list);
        E01_Simple.check(result);
        NativeLongByReference outRef = new NativeLongByReference();
        result = CanonCamera.EDSDK.EdsGetChildCount(list.getValue(), outRef).intValue();
        E01_Simple.check(result);
        System.out.println("Cameras: " + outRef.getValue().longValue());
        long numCams = outRef.getValue().longValue();
        if (numCams == 0L) {
            System.err.println("no camera found");
        }
        EdSdkLibrary.EdsCameraRef.ByReference camera = new EdSdkLibrary.EdsCameraRef.ByReference();
        E01_Simple.debug(camera);
        result = CanonCamera.EDSDK.EdsGetChildAtIndex(list.getValue(), new NativeLong(0L), camera).intValue();
        E01_Simple.debug(camera);
        E01_Simple.check(result);
        Pointer context = new Pointer(0L);
        EdSdkLibrary.EdsObjectEventHandler handler = new EdSdkLibrary.EdsObjectEventHandler(){

            @Override
            public NativeLong apply(NativeLong inEvent, EdSdkLibrary.EdsBaseRef inRef, Pointer inContext) {
                System.out.println("Event!!!" + inEvent.doubleValue() + ", " + inContext);
                if (inEvent.intValue() == 516) {
                    CanonUtils.download(new EdSdkLibrary.EdsDirectoryItemRef(inRef.getPointer()), null, false);
                }
                return new NativeLong(-1L);
            }
        };
        result = CanonCamera.EDSDK.EdsSetObjectEventHandler(camera.getValue(), new NativeLong(512L), handler, context).intValue();
        E01_Simple.check(result);
        result = CanonCamera.EDSDK.EdsOpenSession(camera.getValue()).intValue();
        E01_Simple.check(result);
        result = CanonCamera.EDSDK.EdsSendCommand(camera.getValue(), new NativeLong(0L), new NativeLong(0L)).intValue();
        E01_Simple.check(result);
        E01_Simple.dispatchMessages();
        CanonCamera.EDSDK.EdsTerminateSDK();
    }

    public static void check(int result) {
        if (result != 0) {
            CanonConstants.EdsError err = CanonUtils.toEdsError(result);
            System.err.println("Error " + err.value() + ": " + err.name() + " - " + err.description());
        }
    }

    public static void debug(EdSdkLibrary.EdsBaseRef.ByReference ... obj) {
        System.out.println("----------------");
        for (EdSdkLibrary.EdsBaseRef.ByReference o : obj) {
            if (o == null || o.getPointer() == null) continue;
            System.out.println((Object)((Object)o) + ": " + o.getPointer().getShort(0L));
            E01_Simple.debug(o.getValue());
        }
    }

    public static void debug(EdSdkLibrary.EdsBaseRef ... obj) {
        System.out.println("----------------");
        for (EdSdkLibrary.EdsBaseRef o : obj) {
            if (o == null || o.getPointer() == null) continue;
            System.out.println((Object)((Object)o) + ": " + o.getPointer().getLong(0L));
        }
    }

    public static void dispatchMessages() {
        int result = -1;
        WinUser.MSG msg = new WinUser.MSG();
        while (result != 0) {
            result = User32.INSTANCE.GetMessage(msg, null, 0, 0);
            if (result == -1) {
                System.err.println("error in get message");
                break;
            }
            User32.INSTANCE.TranslateMessage(msg);
            try {
                User32.INSTANCE.DispatchMessage(msg);
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
    }
}

