/*
 * Decompiled with CFR 0.152.
 */
package edsdk.utils;

import com.sun.jna.Platform;
import edsdk.api.BaseCanonCamera;
import java.io.File;
import java.net.URI;
import java.net.URL;

public class DLL_Setup {
    public static boolean debug = false;

    public static void setJNALibraryPath() {
        URL url = null;
        Class<BaseCanonCamera> clazz = BaseCanonCamera.class;
        try {
            url = clazz.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (Exception e) {
            url = null;
        }
        if (url == null) {
            try {
                url = clazz.getResource(clazz.getSimpleName() + ".class");
                url = new URL(url.getPath().substring(0, url.getPath().indexOf(33)));
            }
            catch (Exception e) {
                url = null;
            }
        }
        if (url != null) {
            try {
                URI uri = url.toURI();
                if (uri.getAuthority() != null && uri.getAuthority().length() > 0) {
                    uri = new URL("file://" + url.toString().substring(5)).toURI();
                }
                File file = new File(uri);
                String dir = file.getParentFile().getPath();
                System.setProperty("jna.library.path", dir);
                if (debug) {
                    System.out.println("jna.library.path: " + dir);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static LibraryInfo initLibrary(String libName) {
        LibraryInfo result = new LibraryInfo(libName);
        DLL_Setup.setJNALibraryPath();
        String arch = System.getProperty("os.arch");
        if (arch == null) {
            arch = System.getProperty("com.ibm.vm.bitmode");
        }
        if (Platform.isMac()) {
            String libpath = System.getProperty("user.home") + "/Library/Frameworks/";
            System.setProperty("jna.library.path", libpath);
            result.dllLoc = libpath + libName;
            result.libFile = new File(result.dllLoc);
            if (!result.libFile.exists() && !libName.endsWith(".dylib")) {
                result.dllLoc = result.dllLoc + ".dylib";
            }
            result.hint = libName + " Dynamic Link Library from ";
        } else {
            libName = libName.toUpperCase();
            result.hint = libName + " DLL";
            result.dllLoc = arch != null && arch.endsWith("64") ? libName + "_64/" + libName + ".dll" : libName + "/Dll/" + libName + ".dll";
        }
        result.libFile = new File(result.dllLoc);
        if (debug) {
            System.err.println("Java Architecture: " + arch + " - Using " + result.hint + ": " + result.dllLoc);
        }
        return result;
    }

    public static class LibraryInfo {
        public String libName;
        public String libpath;
        public String dllLoc;
        public String hint;
        public File libFile;

        public LibraryInfo(String libName) {
            this.libName = libName;
        }
    }
}

