/*
 * Decompiled with CFR 0.152.
 */
package edsdk.utils;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import edsdk.api.CanonCamera;
import edsdk.bindings.EdSdkLibrary;
import edsdk.bindings.EdsCapacity;
import edsdk.bindings.EdsDirectoryItemInfo;
import edsdk.bindings.EdsFocusInfo;
import edsdk.bindings.EdsPictureStyleDesc;
import edsdk.bindings.EdsPoint;
import edsdk.bindings.EdsPropertyDesc;
import edsdk.bindings.EdsRational;
import edsdk.bindings.EdsRect;
import edsdk.bindings.EdsTime;
import edsdk.utils.CanonConstants;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;

public class CanonUtils {
    public static boolean lenient = true;

    public static final int classIntField(Class<?> klass, String fieldName) {
        Exception t = null;
        try {
            Field field = klass.getField(fieldName);
            long longValue = field.getLong(null);
            int value = 0;
            value = longValue == Long.MAX_VALUE ? Integer.MAX_VALUE : (int)longValue;
            return value;
        }
        catch (IllegalArgumentException e) {
            t = e;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        catch (NoSuchFieldException e) {
            t = e;
        }
        catch (SecurityException e) {
            t = e;
        }
        throw new IllegalArgumentException(klass.getCanonicalName() + " does not contain field " + fieldName, t);
    }

    public static EdsDirectoryItemInfo getDirectoryItemInfo(EdSdkLibrary.EdsDirectoryItemRef directoryItem) {
        CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_OK;
        EdsDirectoryItemInfo dirItemInfo = new EdsDirectoryItemInfo();
        try {
            err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetDirectoryItemInfo(directoryItem, dirItemInfo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return err == CanonConstants.EdsError.EDS_ERR_OK ? dirItemInfo : null;
    }

    public static File download(EdSdkLibrary.EdsDirectoryItemRef directoryItem, File destination, boolean appendFileExtension) {
        CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_OK;
        EdSdkLibrary.EdsStreamRef.ByReference stream = new EdSdkLibrary.EdsStreamRef.ByReference();
        EdsDirectoryItemInfo dirItemInfo = new EdsDirectoryItemInfo();
        boolean success = false;
        try {
            err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetDirectoryItemInfo(directoryItem, dirItemInfo));
            if (err == CanonConstants.EdsError.EDS_ERR_OK) {
                String sourceFileName;
                int i;
                if (destination == null) {
                    destination = new File(System.getProperty("java.io.tmpdir"));
                }
                if (destination.isDirectory()) {
                    destination = new File(destination, Native.toString((byte[])dirItemInfo.szFileName));
                } else if (appendFileExtension && (i = (sourceFileName = Native.toString((byte[])dirItemInfo.szFileName)).lastIndexOf(".")) > 0) {
                    String extension = sourceFileName.substring(i);
                    if (!destination.getName().toLowerCase().endsWith(extension)) {
                        destination = new File(destination.getPath() + extension);
                    }
                }
                if (destination.getParentFile() != null) {
                    destination.getParentFile().mkdirs();
                }
                err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsCreateFileStream(Native.toByteArray((String)destination.getCanonicalPath()), (int)CanonConstants.EdsFileCreateDisposition.kEdsFileCreateDisposition_CreateAlways.value(), (int)CanonConstants.EdsAccess.kEdsAccess_ReadWrite.value(), stream));
            }
            if (err == CanonConstants.EdsError.EDS_ERR_OK) {
                NativeLong nsize = new NativeLong(dirItemInfo.size);
                err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsDownload(directoryItem, nsize, stream.getValue()));
            }
            if (err == CanonConstants.EdsError.EDS_ERR_OK) {
                err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsDownloadComplete(directoryItem));
                success = true;
            }
            if (stream != null) {
                CanonCamera.EDSDK.EdsRelease(stream.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success ? destination : null;
    }

    public static CanonConstants.EdsError setPropertyData(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, CanonConstants.DescriptiveEnum<? extends Number> value) {
        return CanonUtils.setPropertyDataAdvanced(ref, property, 0L, value.value().longValue());
    }

    public static CanonConstants.EdsError setPropertyData(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param, CanonConstants.DescriptiveEnum<? extends Number> value) {
        return CanonUtils.setPropertyDataAdvanced(ref, property, param, value.value().longValue());
    }

    public static CanonConstants.EdsError setPropertyData(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long value) {
        return CanonUtils.setPropertyDataAdvanced(ref, property, 0L, value);
    }

    public static CanonConstants.EdsError setPropertyData(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param, long value) {
        return CanonUtils.setPropertyDataAdvanced(ref, property, param, value);
    }

    public static CanonConstants.EdsError setPropertyData(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param, int size, Pointer data) {
        return CanonUtils.toEdsError(CanonCamera.EDSDK.EdsSetPropertyData(ref, new NativeLong((long)property.value().intValue()), new NativeLong(param), new NativeLong((long)size), data));
    }

    public static CanonConstants.EdsError setPropertyDataAdvanced(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, Object value) {
        return CanonUtils.setPropertyDataAdvanced(ref, property, 0L, value);
    }

    public static CanonConstants.EdsError setPropertyDataAdvanced(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param, Object value) throws IllegalStateException {
        Memory pointer;
        int size;
        CanonConstants.EdsDataType type = CanonUtils.getPropertyType(ref, property, param);
        switch (type) {
            case kEdsDataType_String: {
                String string = (String)value;
                size = string.length() + 1;
                pointer = new Memory((long)size);
                pointer.setString(0L, string);
                break;
            }
            case kEdsDataType_Int8: 
            case kEdsDataType_UInt8: {
                size = 1;
                pointer = new Memory((long)size);
                pointer.setByte(0L, ((Byte)value).byteValue());
                break;
            }
            case kEdsDataType_Int16: 
            case kEdsDataType_UInt16: {
                size = 2;
                pointer = new Memory((long)size);
                pointer.setShort(0L, ((Short)value).shortValue());
                break;
            }
            case kEdsDataType_Int32: 
            case kEdsDataType_UInt32: {
                size = 4;
                pointer = new Memory((long)size);
                pointer.setNativeLong(0L, new NativeLong(((Long)value).longValue()));
                break;
            }
            case kEdsDataType_Int64: 
            case kEdsDataType_UInt64: {
                size = 8;
                pointer = new Memory((long)size);
                pointer.setLong(0L, ((Long)value).longValue());
                break;
            }
            case kEdsDataType_Float: {
                size = 4;
                pointer = new Memory((long)size);
                pointer.setFloat(0L, ((Float)value).floatValue());
                break;
            }
            case kEdsDataType_Double: {
                size = 8;
                pointer = new Memory((long)size);
                pointer.setDouble(0L, ((Double)value).doubleValue());
                break;
            }
            case kEdsDataType_ByteBlock: {
                int[] array = (int[])value;
                size = 4 * array.length;
                pointer = new Memory((long)size);
                pointer.write(0L, array, 0, array.length);
                break;
            }
            case kEdsDataType_Rational: 
            case kEdsDataType_Point: 
            case kEdsDataType_Rect: 
            case kEdsDataType_Time: 
            case kEdsDataType_FocusInfo: 
            case kEdsDataType_PictureStyleDesc: {
                Structure structure = (Structure)value;
                structure.write();
                pointer = structure.getPointer();
                size = structure.size();
                break;
            }
            case kEdsDataType_Int8_Array: 
            case kEdsDataType_UInt8_Array: {
                byte[] array = (byte[])value;
                size = array.length;
                pointer = new Memory((long)size);
                pointer.write(0L, array, 0, array.length);
                break;
            }
            case kEdsDataType_Int16_Array: 
            case kEdsDataType_UInt16_Array: {
                short[] array = (short[])value;
                size = 2 * array.length;
                pointer = new Memory((long)size);
                pointer.write(0L, array, 0, array.length);
                break;
            }
            case kEdsDataType_Int32_Array: 
            case kEdsDataType_UInt32_Array: {
                int[] array = (int[])value;
                size = 4 * array.length;
                pointer = new Memory((long)size);
                pointer.write(0L, array, 0, array.length);
                break;
            }
            default: {
                throw new IllegalStateException(type.description() + " (" + type.name() + ") is not currently supported by GetPropertyCommand");
            }
        }
        return CanonUtils.setPropertyData(ref, property, param, size, (Pointer)pointer);
    }

    public static Long getPropertyData(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property) {
        Object result = CanonUtils.getPropertyDataAdvanced(ref, property, 0L);
        if (result instanceof Long) {
            Long value = (Long)result;
            return value;
        }
        String type = result.getClass().getName();
        String msg = "getPropertyData for " + property + " expected Long but got " + type;
        if (lenient) {
            return 0L;
        }
        throw new RuntimeException(msg);
    }

    public static Long getPropertyData(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param) {
        return (Long)CanonUtils.getPropertyDataAdvanced(ref, property, param);
    }

    public static CanonConstants.EdsError getPropertyData(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param, long size, Pointer data) {
        return CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetPropertyData(ref, new NativeLong((long)property.value().intValue()), new NativeLong(param), new NativeLong(size), data));
    }

    public static <T> T getPropertyDataAdvanced(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property) {
        return CanonUtils.getPropertyDataAdvanced(ref, property, 0L);
    }

    public static <T> T getPropertyDataAdvanced(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param) throws IllegalArgumentException, IllegalStateException {
        int size = (int)CanonUtils.getPropertySize(ref, property, param);
        CanonConstants.EdsDataType type = CanonUtils.getPropertyType(ref, property, param);
        Memory memory = new Memory(size > 0 ? (long)size : 1L);
        CanonConstants.EdsError err = CanonUtils.getPropertyData(ref, property, param, size, (Pointer)memory);
        if (err == CanonConstants.EdsError.EDS_ERR_OK) {
            switch (type) {
                case kEdsDataType_Unknown: {
                    return null;
                }
                case kEdsDataType_String: {
                    return (T)memory.getString(0L);
                }
                case kEdsDataType_Int8: 
                case kEdsDataType_UInt8: {
                    return (T)Byte.valueOf(memory.getByte(0L));
                }
                case kEdsDataType_Int16: 
                case kEdsDataType_UInt16: {
                    return (T)Short.valueOf(memory.getShort(0L));
                }
                case kEdsDataType_Int32: 
                case kEdsDataType_UInt32: {
                    return (T)Long.valueOf(memory.getNativeLong(0L).longValue());
                }
                case kEdsDataType_Int64: 
                case kEdsDataType_UInt64: {
                    return (T)Long.valueOf(memory.getLong(0L));
                }
                case kEdsDataType_Float: {
                    return (T)Float.valueOf(memory.getFloat(0L));
                }
                case kEdsDataType_Double: {
                    return (T)Double.valueOf(memory.getDouble(0L));
                }
                case kEdsDataType_ByteBlock: {
                    return (T)memory.getIntArray(0L, size / 4);
                }
                case kEdsDataType_Rational: {
                    return (T)((Object)new EdsRational((Pointer)memory));
                }
                case kEdsDataType_Point: {
                    return (T)((Object)new EdsPoint((Pointer)memory));
                }
                case kEdsDataType_Rect: {
                    return (T)((Object)new EdsRect((Pointer)memory));
                }
                case kEdsDataType_Time: {
                    return (T)((Object)new EdsTime((Pointer)memory));
                }
                case kEdsDataType_FocusInfo: {
                    return (T)((Object)new EdsFocusInfo((Pointer)memory));
                }
                case kEdsDataType_PictureStyleDesc: {
                    return (T)((Object)new EdsPictureStyleDesc((Pointer)memory));
                }
                case kEdsDataType_Int8_Array: 
                case kEdsDataType_UInt8_Array: {
                    return (T)memory.getByteArray(0L, size);
                }
                case kEdsDataType_Int16_Array: 
                case kEdsDataType_UInt16_Array: {
                    return (T)memory.getShortArray(0L, size / 2);
                }
                case kEdsDataType_Int32_Array: 
                case kEdsDataType_UInt32_Array: {
                    return (T)memory.getIntArray(0L, size / 4);
                }
            }
            throw new IllegalStateException(type.description() + " (" + type.name() + ") is not currently supported by GetPropertyCommand");
        }
        throw new IllegalArgumentException("An error occurred while getting " + property.name() + " data (error " + err.value() + ": " + err.name() + " - " + err.description() + ")");
    }

    public static CanonConstants.EdsDataType getPropertyType(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property) {
        return CanonUtils.getPropertyType(ref, property, 0L);
    }

    public static CanonConstants.EdsDataType getPropertyType(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param) {
        boolean bufferSize = true;
        IntBuffer type = IntBuffer.allocate(1);
        NativeLongByReference number = new NativeLongByReference(new NativeLong(1L));
        CanonConstants.EdsError err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetPropertySize(ref, new NativeLong((long)property.value().intValue()), new NativeLong(param), type, number));
        if (err == CanonConstants.EdsError.EDS_ERR_OK) {
            CanonConstants.EdsDataType edsDataType = CanonConstants.EdsDataType.enumOfValue(type.get(0));
            if (edsDataType != null) {
                return edsDataType;
            }
        } else if (err == CanonConstants.EdsError.EDS_ERR_NOT_SUPPORTED) {
            return null;
        }
        return CanonConstants.EdsDataType.kEdsDataType_Unknown;
    }

    public static long getPropertySize(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property) {
        return CanonUtils.getPropertySize(ref, property, 0L);
    }

    public static long getPropertySize(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property, long param) {
        boolean bufferSize = true;
        IntBuffer type = IntBuffer.allocate(1);
        NativeLongByReference number = new NativeLongByReference(new NativeLong(1L));
        CanonConstants.EdsError err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetPropertySize(ref, new NativeLong((long)property.value().intValue()), new NativeLong(param), type, number));
        if (err == CanonConstants.EdsError.EDS_ERR_OK) {
            return number.getValue().longValue();
        }
        return -1L;
    }

    public static final CanonConstants.DescriptiveEnum<?>[] getPropertyDesc(EdSdkLibrary.EdsCameraRef camera, CanonConstants.EdsPropertyID property) throws IllegalArgumentException, IllegalStateException {
        EdsPropertyDesc propertyDesc = CanonUtils.getPropertyDesc((EdSdkLibrary.EdsBaseRef)camera, property);
        if (propertyDesc.numElements.intValue() > 0) {
            NativeLong[] propDesc = propertyDesc.propDesc;
            CanonConstants.DescriptiveEnum[] properties = new CanonConstants.DescriptiveEnum[propertyDesc.numElements.intValue()];
            for (int i = 0; i < propertyDesc.numElements.intValue(); ++i) {
                Enum de = null;
                switch (property) {
                    case kEdsPropID_DriveMode: {
                        de = CanonConstants.EdsDriveMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_ISOSpeed: {
                        de = CanonConstants.EdsISOSpeed.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_MeteringMode: {
                        de = CanonConstants.EdsMeteringMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_AFMode: {
                        de = CanonConstants.EdsAFMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Av: {
                        de = CanonConstants.EdsAv.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Tv: {
                        de = CanonConstants.EdsTv.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_ExposureCompensation: {
                        de = CanonConstants.EdsExposureCompensation.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_AEMode: {
                        de = CanonConstants.EdsAEMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_ImageQuality: {
                        de = CanonConstants.EdsImageQuality.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_WhiteBalance: {
                        de = CanonConstants.EdsWhiteBalance.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_ColorSpace: {
                        de = CanonConstants.EdsColorSpace.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_PictureStyle: {
                        de = CanonConstants.EdsPictureStyle.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Evf_WhiteBalance: {
                        de = CanonConstants.EdsWhiteBalance.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    case kEdsPropID_Evf_AFMode: {
                        de = CanonConstants.EdsEvfAFMode.enumOfValue(propDesc[i].intValue());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Property '" + property.name() + "' is not supported.");
                    }
                }
                if (de == null) {
                    throw new IllegalStateException("Could not find " + property.name() + " enum with value of: " + propDesc[i].intValue());
                }
                properties[i] = de;
            }
            return properties;
        }
        return null;
    }

    public static EdsPropertyDesc getPropertyDesc(EdSdkLibrary.EdsBaseRef ref, CanonConstants.EdsPropertyID property) throws IllegalArgumentException {
        EdsPropertyDesc propertyDesc = new EdsPropertyDesc();
        CanonConstants.EdsError err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetPropertyDesc(ref, new NativeLong((long)property.value().intValue()), propertyDesc));
        if (err == CanonConstants.EdsError.EDS_ERR_OK) {
            return propertyDesc;
        }
        throw new IllegalArgumentException("An error occurred while getting detailed " + property.name() + " data (error " + err.value() + ": " + err.name() + " - " + err.description() + ")");
    }

    public static CanonConstants.EdsError setCapacity(EdSdkLibrary.EdsCameraRef ref) {
        return CanonUtils.setCapacity(ref, Integer.MAX_VALUE);
    }

    public static CanonConstants.EdsError setCapacity(EdSdkLibrary.EdsCameraRef ref, int capacity) {
        EdsCapacity.ByValue edsCapacity = new EdsCapacity.ByValue();
        edsCapacity.bytesPerSector = new NativeLong(512L);
        edsCapacity.numberOfFreeClusters = new NativeLong((long)(capacity / edsCapacity.bytesPerSector.intValue()));
        edsCapacity.reset = 1;
        return CanonUtils.toEdsError(CanonCamera.EDSDK.EdsSetCapacity(ref, edsCapacity));
    }

    public static boolean isMirrorLockupEnabled(EdSdkLibrary.EdsCameraRef camera) {
        try {
            return 1L == CanonUtils.getPropertyData(camera, CanonConstants.EdsPropertyID.kEdsPropID_CFn, CanonConstants.EdsCustomFunction.kEdsCustomFunction_MirrorLockup.value().intValue());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Could not check if mirror lockup enabled: " + e.getMessage());
            return false;
        }
    }

    public static boolean beginLiveView(EdSdkLibrary.EdsCameraRef camera) {
        CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_OK;
        NativeLongByReference number = new NativeLongByReference(new NativeLong(1L));
        Pointer data = number.getPointer();
        err = CanonUtils.setPropertyData(camera, CanonConstants.EdsPropertyID.kEdsPropID_Evf_Mode, 0L, NativeLong.SIZE, data);
        if (err != CanonConstants.EdsError.EDS_ERR_OK) {
            System.err.println("Could not start live view (set image mode) (error " + err.value() + ": " + err.name() + " - " + err.description() + ")");
            return false;
        }
        number = new NativeLongByReference(new NativeLong((long)CanonConstants.EdsEvfOutputDevice.kEdsEvfOutputDevice_PC.value().intValue()));
        data = number.getPointer();
        err = CanonUtils.setPropertyData(camera, CanonConstants.EdsPropertyID.kEdsPropID_Evf_OutputDevice, 0L, NativeLong.SIZE, data);
        if (err != CanonConstants.EdsError.EDS_ERR_OK) {
            System.err.println("Could not start live view (set output device) (error " + err.value() + ": " + err.name() + " - " + err.description() + ")");
            return false;
        }
        return true;
    }

    public static boolean endLiveView(EdSdkLibrary.EdsCameraRef camera) {
        CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_OK;
        NativeLongByReference number = new NativeLongByReference(new NativeLong((long)CanonConstants.EdsEvfOutputDevice.kEdsEvfOutputDevice_TFT.value().intValue()));
        Pointer data = number.getPointer();
        err = CanonUtils.setPropertyData(camera, CanonConstants.EdsPropertyID.kEdsPropID_Evf_OutputDevice, 0L, NativeLong.SIZE, data);
        if (err != CanonConstants.EdsError.EDS_ERR_OK) {
            return false;
        }
        number = new NativeLongByReference(new NativeLong(0L));
        data = number.getPointer();
        err = CanonUtils.setPropertyData(camera, CanonConstants.EdsPropertyID.kEdsPropID_Evf_Mode, 0L, NativeLong.SIZE, data);
        return err == CanonConstants.EdsError.EDS_ERR_OK;
    }

    public static boolean isLiveViewEnabled(EdSdkLibrary.EdsCameraRef camera, boolean checkLiveViewActive) {
        try {
            if (checkLiveViewActive) {
                EdSdkLibrary.EdsBaseRef.ByReference[] references = CanonUtils.getLiveViewImageReference(camera);
                if (references != null) {
                    CanonUtils.release(references);
                    return true;
                }
                return false;
            }
            return 1L == CanonUtils.getPropertyData(camera, CanonConstants.EdsPropertyID.kEdsPropID_Evf_Mode);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Could not check live view status: " + e.getMessage());
            return false;
        }
    }

    public static EdSdkLibrary.EdsBaseRef.ByReference[] getLiveViewImageReference(EdSdkLibrary.EdsCameraRef camera) {
        CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_OK;
        EdSdkLibrary.EdsStreamRef.ByReference streamRef = new EdSdkLibrary.EdsStreamRef.ByReference();
        EdSdkLibrary.EdsEvfImageRef.ByReference imageRef = new EdSdkLibrary.EdsEvfImageRef.ByReference();
        err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsCreateMemoryStream(new NativeLong(0L), streamRef));
        if (err != CanonConstants.EdsError.EDS_ERR_OK) {
            System.err.println("Failed to download live view image, memory stream could not be created (error " + err.value() + ": " + err.name() + " - " + err.description() + ")");
            CanonUtils.release(imageRef, streamRef);
            return null;
        }
        err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsCreateEvfImageRef(new EdSdkLibrary.EdsStreamRef(streamRef.getPointer().getPointer(0L)), imageRef));
        if (err != CanonConstants.EdsError.EDS_ERR_OK) {
            System.err.println("Failed to download live view image, image ref could not be created (error " + err.value() + ": " + err.name() + " - " + err.description() + ")");
            CanonUtils.release(imageRef, streamRef);
            return null;
        }
        err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsDownloadEvfImage(camera, imageRef.getValue()));
        if (err != CanonConstants.EdsError.EDS_ERR_OK) {
            CanonUtils.release(imageRef, streamRef);
            return null;
        }
        return new EdSdkLibrary.EdsBaseRef.ByReference[]{imageRef, streamRef};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getLiveViewImage(EdSdkLibrary.EdsCameraRef camera) {
        CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_OK;
        EdSdkLibrary.EdsBaseRef.ByReference[] references = CanonUtils.getLiveViewImageReference(camera);
        if (references != null) {
            BufferedImage bufferedImage;
            EdSdkLibrary.EdsStreamRef.ByReference streamRef = (EdSdkLibrary.EdsStreamRef.ByReference)references[1];
            EdSdkLibrary.EdsEvfImageRef.ByReference imageRef = (EdSdkLibrary.EdsEvfImageRef.ByReference)references[0];
            NativeLongByReference length = new NativeLongByReference();
            err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetLength(streamRef.getValue(), length));
            if (err != CanonConstants.EdsError.EDS_ERR_OK) {
                System.err.println("Failed to download live view image, failed to read stream length (error " + err.value() + ": " + err.name() + " - " + err.description() + ")");
                CanonUtils.release(imageRef, streamRef);
                return null;
            }
            PointerByReference ref = new PointerByReference();
            err = CanonUtils.toEdsError(CanonCamera.EDSDK.EdsGetPointer(streamRef.getValue(), ref));
            if (err != CanonConstants.EdsError.EDS_ERR_OK) {
                System.err.println("Failed to download live view image, failed to get reference to image in memory (error " + err.value() + ": " + err.name() + " - " + err.description() + ")");
                CanonUtils.release(imageRef, streamRef);
                return null;
            }
            byte[] data = ref.getValue().getByteArray(0L, length.getValue().intValue());
            try {
                BufferedImage img;
                bufferedImage = img = ImageIO.read(new ByteArrayInputStream(data));
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    CanonUtils.release(imageRef, streamRef);
                    throw throwable;
                }
                CanonUtils.release(imageRef, streamRef);
            }
            CanonUtils.release(imageRef, streamRef);
            return bufferedImage;
        }
        return null;
    }

    public static CanonConstants.EdsError toEdsError(NativeLong value) {
        return CanonUtils.toEdsError(value.intValue());
    }

    public static CanonConstants.EdsError toEdsError(long value) {
        return CanonUtils.toEdsError(value);
    }

    public static CanonConstants.EdsError toEdsError(int value) {
        CanonConstants.EdsError error = CanonConstants.EdsError.enumOfValue(value);
        if (error != null) {
            return error;
        }
        return CanonConstants.EdsError.EDS_ERR_UNEXPECTED_EXCEPTION;
    }

    public static void release(EdSdkLibrary.EdsBaseRef.ByReference ... objects) {
        for (EdSdkLibrary.EdsBaseRef.ByReference obj : objects) {
            if (obj == null) continue;
            CanonUtils.release(obj.getValue());
        }
    }

    public static void release(EdSdkLibrary.EdsBaseRef ... objects) {
        for (EdSdkLibrary.EdsBaseRef obj : objects) {
            if (obj == null) continue;
            CanonCamera.EDSDK.EdsRelease(obj);
        }
    }
}

