/*
 * Decompiled with CFR 0.152.
 */
package edsdk.utils;

import edsdk.bindings.EdSdkLibrary;
import edsdk.utils.CanonUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;

public class CanonConstants {
    private static final HashMap<String, DescriptiveEnum<?>> nameLUT;
    private static final HashMap<String, DescriptiveEnum<?>> descriptionLUT;
    private static final HashMap<String, HashSet<DescriptiveEnum<?>>> duplicateNameLUT;
    private static final HashMap<String, HashSet<DescriptiveEnum<?>>> duplicateDescriptionLUT;
    private static final HashMap<String, LinkedHashMap<String, DescriptiveEnum<?>>> tieredNameLUT;
    private static final HashMap<String, LinkedHashMap<Object, DescriptiveEnum<?>>> tieredValueLUT;
    private static final HashMap<String, LinkedHashMap<String, DescriptiveEnum<?>>> tieredDescriptionLUT;
    private static final HashMap<String, HashMap<Object, HashSet<DescriptiveEnum<?>>>> tieredDuplicateValueLUT;
    private static final HashMap<String, HashMap<String, HashSet<DescriptiveEnum<?>>>> tieredDuplicateDescriptionLUT;
    private static final HashSet<String> constantIgnoreList;

    public static final boolean verifyAllConstants() {
        Class<?>[] edsdkClasses;
        Field[] fields;
        boolean nothingMissing = true;
        System.out.println("Begin checking whether " + CanonConstants.class.getSimpleName() + " has all constants from EdSdkLibrary");
        for (Field f : fields = EdSdkLibrary.class.getDeclaredFields()) {
            if (nameLUT.containsKey(f.getName()) || constantIgnoreList.contains(f.getName())) continue;
            System.err.println(CanonConstants.class.getSimpleName() + " is Missing: " + f.getName() + " in " + EdSdkLibrary.class.getCanonicalName());
            nothingMissing = false;
        }
        for (Class<?> klass : edsdkClasses = EdSdkLibrary.class.getClasses()) {
            for (Field f : fields = klass.getDeclaredFields()) {
                if (nameLUT.containsKey(f.getName()) || constantIgnoreList.contains(f.getName())) continue;
                System.err.println(CanonConstants.class.getSimpleName() + " is Missing: " + f.getName() + " in " + klass.getCanonicalName());
                nothingMissing = false;
            }
        }
        System.out.println("Completed checking");
        return nothingMissing;
    }

    public static final DescriptiveEnum<?> enumOfName(String name) {
        return nameLUT.get(name);
    }

    public static final DescriptiveEnum<?> enumOfName(Class<? extends DescriptiveEnum<?>> klass, String name) {
        return tieredNameLUT.get(klass.getSimpleName()).get(name);
    }

    public static final DescriptiveEnum<?> enumOfDescription(Class<? extends DescriptiveEnum<?>> klass, String description) {
        return tieredDescriptionLUT.get(klass.getSimpleName()).get(description);
    }

    public static final DescriptiveEnum<?> enumOfValue(Class<? extends DescriptiveEnum<?>> klass, int value) {
        return tieredValueLUT.get(klass.getSimpleName()).get(value);
    }

    static {
        Class<?>[] classes;
        nameLUT = new HashMap();
        descriptionLUT = new HashMap();
        duplicateNameLUT = new HashMap();
        duplicateDescriptionLUT = new HashMap();
        tieredNameLUT = new HashMap();
        tieredValueLUT = new HashMap();
        tieredDescriptionLUT = new HashMap();
        tieredDuplicateValueLUT = new HashMap();
        tieredDuplicateDescriptionLUT = new HashMap();
        constantIgnoreList = new HashSet<String>(Arrays.asList("INSTANCE", "JNA_LIBRARY_NAME", "JNA_NATIVE_LIB", "NULL", "FALSE", "TRUE", "oldif"));
        for (Class<?> klass : classes = CanonConstants.class.getClasses()) {
            if (!Enum.class.isAssignableFrom(klass) || !DescriptiveEnum.class.isAssignableFrom(klass)) continue;
            DescriptiveEnum[] enums = (DescriptiveEnum[])klass.getEnumConstants();
            if (enums == null) {
                throw new IllegalStateException("Class " + klass.getCanonicalName() + " was not initialized properly before before static initializer accessed, probably due to a dependency from a constructor accessing a static member or method of the outer class therefore requiring the static class to fully initialize first.");
            }
            for (DescriptiveEnum e : enums) {
                if (e == null) {
                    throw new IllegalStateException("Class " + klass.getCanonicalName() + " was not initialized properly before before static initializer accessed, probably due to a dependency from a constructor accessing a static member or method of the outer class therefore requiring the static class to fully initialize first.");
                }
                if (!nameLUT.containsKey(e.name())) {
                    nameLUT.put(e.name(), e);
                } else {
                    if (!duplicateNameLUT.containsKey(e.name())) {
                        duplicateNameLUT.put(e.name(), new HashSet());
                    }
                    duplicateNameLUT.get(e.name()).add(e);
                }
                if (!descriptionLUT.containsKey(e.description())) {
                    descriptionLUT.put(e.description(), e);
                } else {
                    if (!duplicateDescriptionLUT.containsKey(e.description())) {
                        duplicateDescriptionLUT.put(e.description(), new HashSet());
                    }
                    duplicateDescriptionLUT.get(e.description()).add(e);
                }
                if (!tieredNameLUT.containsKey(klass.getSimpleName())) {
                    tieredNameLUT.put(klass.getSimpleName(), new LinkedHashMap());
                    tieredValueLUT.put(klass.getSimpleName(), new LinkedHashMap());
                    tieredDescriptionLUT.put(klass.getSimpleName(), new LinkedHashMap());
                }
                tieredNameLUT.get(klass.getSimpleName()).put(e.name(), e);
                if (!tieredValueLUT.get(klass.getSimpleName()).containsKey(e.value())) {
                    tieredValueLUT.get(klass.getSimpleName()).put(e.value(), e);
                } else {
                    if (!tieredDuplicateValueLUT.containsKey(klass.getSimpleName())) {
                        tieredDuplicateValueLUT.put(klass.getSimpleName(), new HashMap());
                    }
                    if (!tieredDuplicateValueLUT.get(klass.getSimpleName()).containsKey(e.value())) {
                        tieredDuplicateValueLUT.get(klass.getSimpleName()).put(e.value(), new HashSet());
                    }
                    tieredDuplicateValueLUT.get(klass.getSimpleName()).get(e.value()).add(e);
                }
                if (!tieredDescriptionLUT.get(klass.getSimpleName()).containsKey(e.description())) {
                    tieredDescriptionLUT.get(klass.getSimpleName()).put(e.description(), e);
                    continue;
                }
                if (!tieredDuplicateDescriptionLUT.containsKey(klass.getSimpleName())) {
                    tieredDuplicateDescriptionLUT.put(klass.getSimpleName(), new HashMap());
                }
                if (!tieredDuplicateDescriptionLUT.get(klass.getSimpleName()).containsKey(e.description())) {
                    tieredDuplicateDescriptionLUT.get(klass.getSimpleName()).put(e.description(), new HashSet());
                }
                tieredDuplicateDescriptionLUT.get(klass.getSimpleName()).get(e.description()).add(e);
            }
        }
    }

    public static enum EdsETTL2Mode implements DescriptiveEnum<Integer>
    {
        kEdsETTL2ModeEvaluative("Evaluative"),
        kEdsETTL2ModeAverage("Average");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsETTL2Mode.class, this.name());
        private final String description;

        private EdsETTL2Mode(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsETTL2Mode enumOfName(String name) {
            return (EdsETTL2Mode)CanonConstants.enumOfName(EdsETTL2Mode.class, name);
        }

        public static final EdsETTL2Mode enumOfValue(int value) {
            return (EdsETTL2Mode)CanonConstants.enumOfValue(EdsETTL2Mode.class, value);
        }

        public static final EdsETTL2Mode enumOfDescription(String description) {
            return (EdsETTL2Mode)CanonConstants.enumOfDescription(EdsETTL2Mode.class, description);
        }
    }

    public static enum EdsStroboMode implements DescriptiveEnum<Integer>
    {
        kEdsStroboModeInternal("Internal"),
        kEdsStroboModeExternalETTL("External ETTL"),
        kEdsStroboModeExternalATTL("External ATTL"),
        kEdsStroboModeExternalTTL("External TTL"),
        kEdsStroboModeExternalAuto("External Auto"),
        kEdsStroboModeExternalManual("External Manual"),
        kEdsStroboModeManual("Manual");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsStroboMode.class, this.name());
        private final String description;

        private EdsStroboMode(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsStroboMode enumOfName(String name) {
            return (EdsStroboMode)CanonConstants.enumOfName(EdsStroboMode.class, name);
        }

        public static final EdsStroboMode enumOfValue(int value) {
            return (EdsStroboMode)CanonConstants.enumOfValue(EdsStroboMode.class, value);
        }

        public static final EdsStroboMode enumOfDescription(String description) {
            return (EdsStroboMode)CanonConstants.enumOfDescription(EdsStroboMode.class, description);
        }
    }

    public static enum EdsEvfAFMode implements DescriptiveEnum<Integer>
    {
        Evf_AFMode_Quick("Quick"),
        Evf_AFMode_Live("Live"),
        Evf_AFMode_LiveFace("Live Face");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsEvfAFMode.class, this.name());
        private final String description;

        private EdsEvfAFMode(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsEvfAFMode enumOfName(String name) {
            return (EdsEvfAFMode)CanonConstants.enumOfName(EdsEvfAFMode.class, name);
        }

        public static final EdsEvfAFMode enumOfValue(int value) {
            return (EdsEvfAFMode)CanonConstants.enumOfValue(EdsEvfAFMode.class, value);
        }

        public static final EdsEvfAFMode enumOfDescription(String description) {
            return (EdsEvfAFMode)CanonConstants.enumOfDescription(EdsEvfAFMode.class, description);
        }
    }

    public static enum EdsEvfZoom implements DescriptiveEnum<Integer>
    {
        kEdsEvfZoom_Fit("Fit Screen"),
        kEdsEvfZoom_x5("5 times"),
        kEdsEvfZoom_x10("10 times");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsEvfZoom.class, this.name());
        private final String description;

        private EdsEvfZoom(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsEvfZoom enumOfName(String name) {
            return (EdsEvfZoom)CanonConstants.enumOfName(EdsEvfZoom.class, name);
        }

        public static final EdsEvfZoom enumOfValue(int value) {
            return (EdsEvfZoom)CanonConstants.enumOfValue(EdsEvfZoom.class, value);
        }

        public static final EdsEvfZoom enumOfDescription(String description) {
            return (EdsEvfZoom)CanonConstants.enumOfDescription(EdsEvfZoom.class, description);
        }
    }

    public static enum EdsEvfOutputDevice implements DescriptiveEnum<Integer>
    {
        kEdsEvfOutputDevice_TFT("Camera"),
        kEdsEvfOutputDevice_PC("Host Computer");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsEvfOutputDevice.class, this.name());
        private final String description;

        private EdsEvfOutputDevice(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsEvfOutputDevice enumOfName(String name) {
            return (EdsEvfOutputDevice)CanonConstants.enumOfName(EdsEvfOutputDevice.class, name);
        }

        public static final EdsEvfOutputDevice enumOfValue(int value) {
            return (EdsEvfOutputDevice)CanonConstants.enumOfValue(EdsEvfOutputDevice.class, value);
        }

        public static final EdsEvfOutputDevice enumOfDescription(String description) {
            return (EdsEvfOutputDevice)CanonConstants.enumOfDescription(EdsEvfOutputDevice.class, description);
        }
    }

    public static enum EdsBracket implements DescriptiveEnum<Integer>
    {
        kEdsBracket_AEB("AE"),
        kEdsBracket_ISOB("ISO"),
        kEdsBracket_WBB("WB"),
        kEdsBracket_FEB("FE"),
        kEdsBracket_Unknown("Off");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsBracket.class, this.name());
        private final String description;

        private EdsBracket(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsBracket enumOfName(String name) {
            return (EdsBracket)CanonConstants.enumOfName(EdsBracket.class, name);
        }

        public static final EdsBracket enumOfValue(int value) {
            return (EdsBracket)CanonConstants.enumOfValue(EdsBracket.class, value);
        }

        public static final EdsBracket enumOfDescription(String description) {
            return (EdsBracket)CanonConstants.enumOfDescription(EdsBracket.class, description);
        }
    }

    public static enum EdsAEMode implements DescriptiveEnum<Integer>
    {
        kEdsAEMode_Program("Program AE"),
        kEdsAEMode_Tv("Shutter-Speed Priority AE"),
        kEdsAEMode_Av("Aperture Priority AE"),
        kEdsAEMode_Manual("Manual Exposure"),
        kEdsAEMode_Bulb("Bulb"),
        kEdsAEMode_A_DEP("Auto Depth-of-Field AE"),
        kEdsAEMode_DEP("Depth-of-Field AE"),
        kEdsAEMode_Custom("Camera settings registered"),
        kEdsAEMode_Lock("Lock"),
        kEdsAEMode_Green("Auto"),
        kEdsAEMode_NightPortrait("Night Scene Portrait"),
        kEdsAEMode_Sports("Sports"),
        kEdsAEMode_Portrait("Portrait"),
        kEdsAEMode_Landscape("Landscape"),
        kEdsAEMode_Closeup("Close-Up"),
        kEdsAEMode_FlashOff("Flash Off"),
        kEdsAEMode_CreativeAuto("Creative Auto"),
        kEdsAEMode_Movie("Movie"),
        kEdsAEMode_PhotoInMovie("Photo In Movie"),
        kEdsAEMode_Unknown("Unknown");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsAEMode.class, this.name());
        private final String description;

        private EdsAEMode(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsAEMode enumOfName(String name) {
            return (EdsAEMode)CanonConstants.enumOfName(EdsAEMode.class, name);
        }

        public static final EdsAEMode enumOfValue(int value) {
            return (EdsAEMode)CanonConstants.enumOfValue(EdsAEMode.class, value);
        }

        public static final EdsAEMode enumOfDescription(String description) {
            return (EdsAEMode)CanonConstants.enumOfDescription(EdsAEMode.class, description);
        }
    }

    public static enum EdsTransferOption implements DescriptiveEnum<Integer>
    {
        kEdsTransferOption_ByDirectTransfer("By Direct Transfer"),
        kEdsTransferOption_ByRelease("By Release"),
        kEdsTransferOption_ToDesktop("To Desktop");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsTransferOption.class, this.name());
        private final String description;

        private EdsTransferOption(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsTransferOption enumOfName(String name) {
            return (EdsTransferOption)CanonConstants.enumOfName(EdsTransferOption.class, name);
        }

        public static final EdsTransferOption enumOfValue(int value) {
            return (EdsTransferOption)CanonConstants.enumOfValue(EdsTransferOption.class, value);
        }

        public static final EdsTransferOption enumOfDescription(String description) {
            return (EdsTransferOption)CanonConstants.enumOfDescription(EdsTransferOption.class, description);
        }
    }

    public static enum EdsPictureStyle implements DescriptiveEnum<Integer>
    {
        kEdsPictureStyle_Standard("Standard"),
        kEdsPictureStyle_Portrait("Portrait"),
        kEdsPictureStyle_Landscape("Landscape"),
        kEdsPictureStyle_Neutral("Neutral"),
        kEdsPictureStyle_Faithful("Faithful"),
        kEdsPictureStyle_Monochrome("Monochrome"),
        kEdsPictureStyle_Auto("Auto"),
        kEdsPictureStyle_User1("User 1"),
        kEdsPictureStyle_User2("User 2"),
        kEdsPictureStyle_User3("User 3"),
        kEdsPictureStyle_PC1("Computer 1"),
        kEdsPictureStyle_PC2("Computer 2"),
        kEdsPictureStyle_PC3("Computer 3");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsPictureStyle.class, this.name());
        private final String description;

        private EdsPictureStyle(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsPictureStyle enumOfName(String name) {
            return (EdsPictureStyle)CanonConstants.enumOfName(EdsPictureStyle.class, name);
        }

        public static final EdsPictureStyle enumOfValue(int value) {
            return (EdsPictureStyle)CanonConstants.enumOfValue(EdsPictureStyle.class, value);
        }

        public static final EdsPictureStyle enumOfDescription(String description) {
            return (EdsPictureStyle)CanonConstants.enumOfDescription(EdsPictureStyle.class, description);
        }
    }

    public static enum EdsColorSpace implements DescriptiveEnum<Integer>
    {
        kEdsColorSpace_sRGB("sRGB"),
        kEdsColorSpace_AdobeRGB("AdobeRGB"),
        kEdsColorSpace_Unknown("Unknown");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsColorSpace.class, this.name());
        private final String description;

        private EdsColorSpace(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsColorSpace enumOfName(String name) {
            return (EdsColorSpace)CanonConstants.enumOfName(EdsColorSpace.class, name);
        }

        public static final EdsColorSpace enumOfValue(int value) {
            return (EdsColorSpace)CanonConstants.enumOfValue(EdsColorSpace.class, value);
        }

        public static final EdsColorSpace enumOfDescription(String description) {
            return (EdsColorSpace)CanonConstants.enumOfDescription(EdsColorSpace.class, description);
        }
    }

    public static enum EdsTonigEffect implements DescriptiveEnum<Integer>
    {
        kEdsTonigEffect_None("None"),
        kEdsTonigEffect_Sepia("Sepia"),
        kEdsTonigEffect_Blue("Blue"),
        kEdsTonigEffect_Purple("Purple"),
        kEdsTonigEffect_Green("Green");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsTonigEffect.class, this.name());
        private final String description;

        private EdsTonigEffect(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsTonigEffect enumOfName(String name) {
            return (EdsTonigEffect)CanonConstants.enumOfName(EdsTonigEffect.class, name);
        }

        public static final EdsTonigEffect enumOfValue(int value) {
            return (EdsTonigEffect)CanonConstants.enumOfValue(EdsTonigEffect.class, value);
        }

        public static final EdsTonigEffect enumOfDescription(String description) {
            return (EdsTonigEffect)CanonConstants.enumOfDescription(EdsTonigEffect.class, description);
        }
    }

    public static enum EdsFilterEffect implements DescriptiveEnum<Integer>
    {
        kEdsFilterEffect_None("None"),
        kEdsFilterEffect_Yellow("Yellow"),
        kEdsFilterEffect_Orange("Orange"),
        kEdsFilterEffect_Red("Red"),
        kEdsFilterEffect_Green("Green");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsFilterEffect.class, this.name());
        private final String description;

        private EdsFilterEffect(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsFilterEffect enumOfName(String name) {
            return (EdsFilterEffect)CanonConstants.enumOfName(EdsFilterEffect.class, name);
        }

        public static final EdsFilterEffect enumOfValue(int value) {
            return (EdsFilterEffect)CanonConstants.enumOfValue(EdsFilterEffect.class, value);
        }

        public static final EdsFilterEffect enumOfDescription(String description) {
            return (EdsFilterEffect)CanonConstants.enumOfDescription(EdsFilterEffect.class, description);
        }
    }

    public static enum EdsColorMatrix implements DescriptiveEnum<Integer>
    {
        kEdsColorMatrix_Custom("Custom"),
        kEdsColorMatrix_1("ColorMatrix1"),
        kEdsColorMatrix_2("ColorMatrix2"),
        kEdsColorMatrix_3("ColorMatrix3"),
        kEdsColorMatrix_4("ColorMatrix4"),
        kEdsColorMatrix_5("ColorMatrix5"),
        kEdsColorMatrix_6("ColorMatrix6"),
        kEdsColorMatrix_7("ColorMatrix7");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsColorMatrix.class, this.name());
        private final String description;

        private EdsColorMatrix(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsColorMatrix enumOfName(String name) {
            return (EdsColorMatrix)CanonConstants.enumOfName(EdsColorMatrix.class, name);
        }

        public static final EdsColorMatrix enumOfValue(int value) {
            return (EdsColorMatrix)CanonConstants.enumOfValue(EdsColorMatrix.class, value);
        }

        public static final EdsColorMatrix enumOfDescription(String description) {
            return (EdsColorMatrix)CanonConstants.enumOfDescription(EdsColorMatrix.class, description);
        }
    }

    public static enum EdsPhotoEffect implements DescriptiveEnum<Integer>
    {
        kEdsPhotoEffect_Off("Off"),
        kEdsPhotoEffect_Monochrome("Monochrome");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsPhotoEffect.class, this.name());
        private final String description;

        private EdsPhotoEffect(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsPhotoEffect enumOfName(String name) {
            return (EdsPhotoEffect)CanonConstants.enumOfName(EdsPhotoEffect.class, name);
        }

        public static final EdsPhotoEffect enumOfValue(int value) {
            return (EdsPhotoEffect)CanonConstants.enumOfValue(EdsPhotoEffect.class, value);
        }

        public static final EdsPhotoEffect enumOfDescription(String description) {
            return (EdsPhotoEffect)CanonConstants.enumOfDescription(EdsPhotoEffect.class, description);
        }
    }

    public static enum EdsWhiteBalance implements DescriptiveEnum<Integer>
    {
        kEdsWhiteBalance_Auto("Auto"),
        kEdsWhiteBalance_Daylight("Daylight"),
        kEdsWhiteBalance_Cloudy("Cloudy"),
        kEdsWhiteBalance_Tangsten("Tungsten"),
        kEdsWhiteBalance_Fluorescent("Fluorescent"),
        kEdsWhiteBalance_Strobe("Flash"),
        kEdsWhiteBalance_WhitePaper("Manual"),
        kEdsWhiteBalance_Shade("Shade"),
        kEdsWhiteBalance_ColorTemp("Color temperature"),
        kEdsWhiteBalance_PCSet1("Custom: PC-1"),
        kEdsWhiteBalance_PCSet2("Custom: PC-2"),
        kEdsWhiteBalance_PCSet3("Custom: PC-3"),
        kEdsWhiteBalance_WhitePaper2("Manual 2"),
        kEdsWhiteBalance_WhitePaper3("Manual 3"),
        kEdsWhiteBalance_WhitePaper4("Manual 4"),
        kEdsWhiteBalance_WhitePaper5("Manual 5"),
        kEdsWhiteBalance_PCSet4("Custom: PC-4"),
        kEdsWhiteBalance_PCSet5("Custom: PC-5"),
        kEdsWhiteBalance_Click("Click to set"),
        kEdsWhiteBalance_Pasted("Copied from image");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsWhiteBalance.class, this.name());
        private final String description;

        private EdsWhiteBalance(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsWhiteBalance enumOfName(String name) {
            return (EdsWhiteBalance)CanonConstants.enumOfName(EdsWhiteBalance.class, name);
        }

        public static final EdsWhiteBalance enumOfValue(int value) {
            return (EdsWhiteBalance)CanonConstants.enumOfValue(EdsWhiteBalance.class, value);
        }

        public static final EdsWhiteBalance enumOfDescription(String description) {
            return (EdsWhiteBalance)CanonConstants.enumOfDescription(EdsWhiteBalance.class, description);
        }
    }

    public static enum EdsStorageType implements DescriptiveEnum<Integer>
    {
        kEdsStorageType_Non("No memory card"),
        kEdsStorageType_CF("Compact Flash"),
        kEdsStorageType_SD("SD Flash"),
        kEdsStorageType_HD("Hard Drive");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsStorageType.class, this.name());
        private final String description;

        private EdsStorageType(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsStorageType enumOfName(String name) {
            return (EdsStorageType)CanonConstants.enumOfName(EdsStorageType.class, name);
        }

        public static final EdsStorageType enumOfValue(int value) {
            return (EdsStorageType)CanonConstants.enumOfValue(EdsStorageType.class, value);
        }

        public static final EdsStorageType enumOfDescription(String description) {
            return (EdsStorageType)CanonConstants.enumOfDescription(EdsStorageType.class, description);
        }
    }

    public static enum EdsSaveTo implements DescriptiveEnum<Integer>
    {
        kEdsSaveTo_Camera("Camera"),
        kEdsSaveTo_Host("Host Computer"),
        kEdsSaveTo_Both("Both");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsSaveTo.class, this.name());
        private final String description;

        private EdsSaveTo(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsSaveTo enumOfName(String name) {
            return (EdsSaveTo)CanonConstants.enumOfName(EdsSaveTo.class, name);
        }

        public static final EdsSaveTo enumOfValue(int value) {
            return (EdsSaveTo)CanonConstants.enumOfValue(EdsSaveTo.class, value);
        }

        public static final EdsSaveTo enumOfDescription(String description) {
            return (EdsSaveTo)CanonConstants.enumOfDescription(EdsSaveTo.class, description);
        }
    }

    public static enum EdsBatteryLevel2 implements DescriptiveEnum<Integer>
    {
        kEdsBatteryLevel2_Empty("Empty"),
        kEdsBatteryLevel2_Low("Low"),
        kEdsBatteryLevel2_Half("Half"),
        kEdsBatteryLevel2_Normal("Normal"),
        kEdsBatteryLevel2_Hi("Hi"),
        kEdsBatteryLevel2_Quarter("Quarter"),
        kEdsBatteryLevel2_BCLevel("BC Level"),
        kEdsBatteryLevel2_Error("Error"),
        kEdsBatteryLevel2_AC("AC power");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsBatteryLevel2.class, this.name());
        private final String description;

        private EdsBatteryLevel2(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsBatteryLevel2 enumOfName(String name) {
            return (EdsBatteryLevel2)CanonConstants.enumOfName(EdsBatteryLevel2.class, name);
        }

        public static final EdsBatteryLevel2 enumOfValue(int value) {
            return (EdsBatteryLevel2)CanonConstants.enumOfValue(EdsBatteryLevel2.class, value);
        }

        public static final EdsBatteryLevel2 enumOfDescription(String description) {
            return (EdsBatteryLevel2)CanonConstants.enumOfDescription(EdsBatteryLevel2.class, description);
        }
    }

    public static enum EdsFileAttributes implements DescriptiveEnum<Integer>
    {
        kEdsFileAttribute_Normal("Normal"),
        kEdsFileAttribute_ReadOnly("Read-Only"),
        kEdsFileAttribute_Hidden("Hidden"),
        kEdsFileAttribute_System("System"),
        kEdsFileAttribute_Archive("Archive");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsFileAttributes.class, this.name());
        private final String description;

        private EdsFileAttributes(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsFileAttributes enumOfName(String name) {
            return (EdsFileAttributes)CanonConstants.enumOfName(EdsFileAttributes.class, name);
        }

        public static final EdsFileAttributes enumOfValue(int value) {
            return (EdsFileAttributes)CanonConstants.enumOfValue(EdsFileAttributes.class, value);
        }

        public static final EdsFileAttributes enumOfDescription(String description) {
            return (EdsFileAttributes)CanonConstants.enumOfDescription(EdsFileAttributes.class, description);
        }
    }

    public static enum EdsProgressOption implements DescriptiveEnum<Integer>
    {
        kEdsProgressOption_NoReport("No callback"),
        kEdsProgressOption_Done("Callback when done"),
        kEdsProgressOption_Periodically("Periodic Callback");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsProgressOption.class, this.name());
        private final String description;

        private EdsProgressOption(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsProgressOption enumOfName(String name) {
            return (EdsProgressOption)CanonConstants.enumOfName(EdsProgressOption.class, name);
        }

        public static final EdsProgressOption enumOfValue(int value) {
            return (EdsProgressOption)CanonConstants.enumOfValue(EdsProgressOption.class, value);
        }

        public static final EdsProgressOption enumOfDescription(String description) {
            return (EdsProgressOption)CanonConstants.enumOfDescription(EdsProgressOption.class, description);
        }
    }

    public static enum EdsTargetImageType implements DescriptiveEnum<Integer>
    {
        kEdsTargetImageType_Unknown("Folder or unknown"),
        kEdsTargetImageType_Jpeg("JPEG"),
        kEdsTargetImageType_TIFF("8-bit TIFF"),
        kEdsTargetImageType_TIFF16("16-bit TIFF"),
        kEdsTargetImageType_RGB("8-bit RGB"),
        kEdsTargetImageType_RGB16("16-bit RGB"),
        kEdsTargetImageType_DIB("DIB (BMP)");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsTargetImageType.class, this.name());
        private final String description;

        private EdsTargetImageType(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsTargetImageType enumOfName(String name) {
            return (EdsTargetImageType)CanonConstants.enumOfName(EdsTargetImageType.class, name);
        }

        public static final EdsTargetImageType enumOfValue(int value) {
            return (EdsTargetImageType)CanonConstants.enumOfValue(EdsTargetImageType.class, value);
        }

        public static final EdsTargetImageType enumOfDescription(String description) {
            return (EdsTargetImageType)CanonConstants.enumOfDescription(EdsTargetImageType.class, description);
        }
    }

    public static enum EdsImageSource implements DescriptiveEnum<Integer>
    {
        kEdsImageSrc_FullView("Full-size"),
        kEdsImageSrc_Thumbnail("Thumbnail"),
        kEdsImageSrc_Preview("Preview"),
        kEdsImageSrc_RAWThumbnail("RAW thumbnail"),
        kEdsImageSrc_RAWFullView("RAW full-size");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsImageSource.class, this.name());
        private final String description;

        private EdsImageSource(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsImageSource enumOfName(String name) {
            return (EdsImageSource)CanonConstants.enumOfName(EdsImageSource.class, name);
        }

        public static final EdsImageSource enumOfValue(int value) {
            return (EdsImageSource)CanonConstants.enumOfValue(EdsImageSource.class, value);
        }

        public static final EdsImageSource enumOfDescription(String description) {
            return (EdsImageSource)CanonConstants.enumOfDescription(EdsImageSource.class, description);
        }
    }

    public static enum EdsImageQualityForLegacy implements DescriptiveEnum<Integer>
    {
        kEdsImageQualityForLegacy_LJ("JPEG large"),
        kEdsImageQualityForLegacy_M1J("JPEG medium 1"),
        kEdsImageQualityForLegacy_M2J("JPEG medium 2"),
        kEdsImageQualityForLegacy_SJ("JPEG small"),
        kEdsImageQualityForLegacy_LJF("JPEG large fine"),
        kEdsImageQualityForLegacy_LJN("JPEG large normal"),
        kEdsImageQualityForLegacy_MJF("JPEG medium fine"),
        kEdsImageQualityForLegacy_MJN("JPEG medium normal"),
        kEdsImageQualityForLegacy_SJF("JPEG small fine"),
        kEdsImageQualityForLegacy_SJN("JPEG small normal"),
        kEdsImageQualityForLegacy_LR("RAW"),
        kEdsImageQualityForLegacy_LRLJF("RAW + JPEG large fine"),
        kEdsImageQualityForLegacy_LRLJN("RAW + JPEG large normal"),
        kEdsImageQualityForLegacy_LRMJF("RAW + JPEG medium fine"),
        kEdsImageQualityForLegacy_LRMJN("RAW + JPEG medium normal"),
        kEdsImageQualityForLegacy_LRSJF("RAW + JPEG small fine"),
        kEdsImageQualityForLegacy_LRSJN("RAW + JPEG small normal"),
        kEdsImageQualityForLegacy_LR2("RAW "),
        kEdsImageQualityForLegacy_LR2LJ("RAW + JPEG large"),
        kEdsImageQualityForLegacy_LR2M1J("RAW + JPEG medium 1"),
        kEdsImageQualityForLegacy_LR2M2J("RAW + JPEG medium 2"),
        kEdsImageQualityForLegacy_LR2SJ("RAW + JPEG small"),
        kEdsImageQualityForLegacy_Unknown("Unknown");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsImageQualityForLegacy.class, this.name());
        private final String description;

        private EdsImageQualityForLegacy(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsImageQualityForLegacy enumOfName(String name) {
            return (EdsImageQualityForLegacy)CanonConstants.enumOfName(EdsImageQualityForLegacy.class, name);
        }

        public static final EdsImageQualityForLegacy enumOfValue(int value) {
            return (EdsImageQualityForLegacy)CanonConstants.enumOfValue(EdsImageQualityForLegacy.class, value);
        }

        public static final EdsImageQualityForLegacy enumOfDescription(String description) {
            return (EdsImageQualityForLegacy)CanonConstants.enumOfDescription(EdsImageQualityForLegacy.class, description);
        }
    }

    public static enum EdsImageQuality implements DescriptiveEnum<Integer>
    {
        EdsImageQuality_LJ("JPEG Large"),
        EdsImageQuality_M1J("JPEG Medium 1"),
        EdsImageQuality_M2J("JPEG Medium 2"),
        EdsImageQuality_SJ("JPEG Small"),
        EdsImageQuality_LJF("JPEG Large Fine"),
        EdsImageQuality_LJN("JPEG Large Normal"),
        EdsImageQuality_MJF("JPEG Medium Fine"),
        EdsImageQuality_MJN("JPEG Medium Normal"),
        EdsImageQuality_SJF("JPEG Small Fine"),
        EdsImageQuality_SJN("JPEG Small Normal"),
        EdsImageQuality_S1JF("JPEG Small 1 Fine"),
        EdsImageQuality_S1JN("JPEG Small 1 Normal"),
        EdsImageQuality_S2JF("JPEG Small 2"),
        EdsImageQuality_S3JF("JPEG Small 3"),
        EdsImageQuality_LR("RAW"),
        EdsImageQuality_LRLJF("RAW + JPEG Large Fine"),
        EdsImageQuality_LRLJN("RAW + JPEG Large Normal"),
        EdsImageQuality_LRMJF("RAW + JPEG Middle Fine"),
        EdsImageQuality_LRMJN("RAW + JPEG Middle Normal"),
        EdsImageQuality_LRSJF("RAW + JPEG Small Fine"),
        EdsImageQuality_LRSJN("RAW + JPEG Small Normal"),
        EdsImageQuality_LRS1JF("RAW + JPEG Small 1 Fine"),
        EdsImageQuality_LRS1JN("RAW + JPEG Small 1 Normal"),
        EdsImageQuality_LRS2JF("RAW + JPEG Small 2"),
        EdsImageQuality_LRS3JF("RAW + JPEG Small 3"),
        EdsImageQuality_LRLJ("RAW + JPEG Large"),
        EdsImageQuality_LRM1J("RAW + JPEG Middle 1"),
        EdsImageQuality_LRM2J("RAW + JPEG Middle 2"),
        EdsImageQuality_LRSJ("RAW + JPEG Small"),
        EdsImageQuality_MR("MRAW (SRAW1)"),
        EdsImageQuality_MRLJF("MRAW (SRAW1) + JPEG Large Fine"),
        EdsImageQuality_MRLJN("MRAW (SRAW1) + JPEG Large Normal"),
        EdsImageQuality_MRMJF("MRAW (SRAW1) + JPEG Medium Fine"),
        EdsImageQuality_MRMJN("MRAW (SRAW1) + JPEG Medium Normal"),
        EdsImageQuality_MRSJF("MRAW (SRAW1) + JPEG Small Fine"),
        EdsImageQuality_MRSJN("MRAW (SRAW1) + JPEG Small Normal"),
        EdsImageQuality_MRS1JF("MRAW (SRAW1) + JPEG Small 1 Fine"),
        EdsImageQuality_MRS1JN("MRAW (SRAW1) + JPEG Small 1 Normal"),
        EdsImageQuality_MRS2JF("MRAW (SRAW1) + JPEG Small 2"),
        EdsImageQuality_MRS3JF("MRAW (SRAW1) + JPEG Small 3"),
        EdsImageQuality_MRLJ("MRAW (SRAW1) + JPEG Large"),
        EdsImageQuality_MRM1J("MRAW (SRAW1) + JPEG Medium 1"),
        EdsImageQuality_MRM2J("MRAW (SRAW1) + JPEG Medium 2"),
        EdsImageQuality_MRSJ("MRAW (SRAW1) + JPEG Small"),
        EdsImageQuality_SR("SRAW (SRAW2)"),
        EdsImageQuality_SRLJF("SRAW (SRAW2) + JPEG Large Fine"),
        EdsImageQuality_SRLJN("SRAW (SRAW2) + JPEG Large Normal"),
        EdsImageQuality_SRMJF("SRAW (SRAW2) + JPEG Middle Fine"),
        EdsImageQuality_SRMJN("SRAW (SRAW2) + JPEG Middle Normal"),
        EdsImageQuality_SRSJF("SRAW (SRAW2) + JPEG Small Fine"),
        EdsImageQuality_SRSJN("SRAW (SRAW2) + JPEG Small Normal"),
        EdsImageQuality_SRS1JF("SRAW (SRAW2) + JPEG Small1 Fine"),
        EdsImageQuality_SRS1JN("SRAW (SRAW2) + JPEG Small1 Normal"),
        EdsImageQuality_SRS2JF("SRAW (SRAW2) + JPEG Small2"),
        EdsImageQuality_SRS3JF("SRAW (SRAW2) + JPEG Small3"),
        EdsImageQuality_SRLJ("SRAW (SRAW2) + JPEG Large"),
        EdsImageQuality_SRM1J("SRAW (SRAW2) + JPEG Medium 1"),
        EdsImageQuality_SRM2J("SRAW (SRAW2) + JPEG Medium 2"),
        EdsImageQuality_SRSJ("SRAW (SRAW2) + JPEG Small"),
        EdsImageQuality_Unknown("Unknown");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsImageQuality.class, this.name());
        private final String description;

        private EdsImageQuality(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsImageQuality enumOfName(String name) {
            return (EdsImageQuality)CanonConstants.enumOfName(EdsImageQuality.class, name);
        }

        public static final EdsImageQuality enumOfValue(int value) {
            return (EdsImageQuality)CanonConstants.enumOfValue(EdsImageQuality.class, value);
        }

        public static final EdsImageQuality enumOfDescription(String description) {
            return (EdsImageQuality)CanonConstants.enumOfDescription(EdsImageQuality.class, description);
        }
    }

    public static enum EdsCompressQuality implements DescriptiveEnum<Integer>
    {
        kEdsCompressQuality_Normal("Normal"),
        kEdsCompressQuality_Fine("Fine"),
        kEdsCompressQuality_Lossless("Lossless"),
        kEdsCompressQuality_SuperFine("Superfine"),
        kEdsCompressQuality_Unknown("Unknown");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsCompressQuality.class, this.name());
        private final String description;

        private EdsCompressQuality(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsCompressQuality enumOfName(String name) {
            return (EdsCompressQuality)CanonConstants.enumOfName(EdsCompressQuality.class, name);
        }

        public static final EdsCompressQuality enumOfValue(int value) {
            return (EdsCompressQuality)CanonConstants.enumOfValue(EdsCompressQuality.class, value);
        }

        public static final EdsCompressQuality enumOfDescription(String description) {
            return (EdsCompressQuality)CanonConstants.enumOfDescription(EdsCompressQuality.class, description);
        }
    }

    public static enum EdsImageSize implements DescriptiveEnum<Integer>
    {
        kEdsImageSize_Large("Large"),
        kEdsImageSize_Middle("Medium"),
        kEdsImageSize_Small("Small"),
        kEdsImageSize_Middle1("Medium 1"),
        kEdsImageSize_Middle2("Medium 2"),
        kEdsImageSize_Small1("Small 1"),
        kEdsImageSize_Small2("Small 2"),
        kEdsImageSize_Small3("Small 3"),
        kEdsImageSize_Unknown("Unknown");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsImageSize.class, this.name());
        private final String description;

        private EdsImageSize(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsImageSize enumOfName(String name) {
            return (EdsImageSize)CanonConstants.enumOfName(EdsImageSize.class, name);
        }

        public static final EdsImageSize enumOfValue(int value) {
            return (EdsImageSize)CanonConstants.enumOfValue(EdsImageSize.class, value);
        }

        public static final EdsImageSize enumOfDescription(String description) {
            return (EdsImageSize)CanonConstants.enumOfDescription(EdsImageSize.class, description);
        }
    }

    public static enum EdsImageType implements DescriptiveEnum<Integer>
    {
        kEdsImageType_Unknown("Folder or Unknown"),
        kEdsImageType_Jpeg("JPEG"),
        kEdsImageType_CRW("CRW"),
        kEdsImageType_RAW("RAW"),
        kEdsImageType_CR2("CR2");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsImageType.class, this.name());
        private final String description;

        private EdsImageType(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsImageType enumOfName(String name) {
            return (EdsImageType)CanonConstants.enumOfName(EdsImageType.class, name);
        }

        public static final EdsImageType enumOfValue(int value) {
            return (EdsImageType)CanonConstants.enumOfValue(EdsImageType.class, value);
        }

        public static final EdsImageType enumOfDescription(String description) {
            return (EdsImageType)CanonConstants.enumOfDescription(EdsImageType.class, description);
        }
    }

    public static enum EdsFileCreateDisposition implements DescriptiveEnum<Integer>
    {
        kEdsFileCreateDisposition_CreateNew("Create New"),
        kEdsFileCreateDisposition_CreateAlways("Create New or Overwrite Existing"),
        kEdsFileCreateDisposition_OpenExisting("Open Existing"),
        kEdsFileCreateDisposition_OpenAlways("Open Existing or Create New"),
        kEdsFileCreateDisposition_TruncateExsisting("Open and Erase Existing");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsFileCreateDisposition.class, this.name());
        private final String description;

        private EdsFileCreateDisposition(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsFileCreateDisposition enumOfName(String name) {
            return (EdsFileCreateDisposition)CanonConstants.enumOfName(EdsFileCreateDisposition.class, name);
        }

        public static final EdsFileCreateDisposition enumOfValue(int value) {
            return (EdsFileCreateDisposition)CanonConstants.enumOfValue(EdsFileCreateDisposition.class, value);
        }

        public static final EdsFileCreateDisposition enumOfDescription(String description) {
            return (EdsFileCreateDisposition)CanonConstants.enumOfDescription(EdsFileCreateDisposition.class, description);
        }
    }

    public static enum EdsAccess implements DescriptiveEnum<Integer>
    {
        kEdsAccess_Read("Read-only"),
        kEdsAccess_Write("Write-only"),
        kEdsAccess_ReadWrite("Read + Write"),
        kEdsAccess_Error("Error");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsAccess.class, this.name());
        private final String description;

        private EdsAccess(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsAccess enumOfName(String name) {
            return (EdsAccess)CanonConstants.enumOfName(EdsAccess.class, name);
        }

        public static final EdsAccess enumOfValue(int value) {
            return (EdsAccess)CanonConstants.enumOfValue(EdsAccess.class, value);
        }

        public static final EdsAccess enumOfDescription(String description) {
            return (EdsAccess)CanonConstants.enumOfDescription(EdsAccess.class, description);
        }
    }

    public static enum EdsSeekOrigin implements DescriptiveEnum<Integer>
    {
        kEdsSeek_Cur("Current"),
        kEdsSeek_Begin("Beginning"),
        kEdsSeek_End("Ending");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsSeekOrigin.class, this.name());
        private final String description;

        private EdsSeekOrigin(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsSeekOrigin enumOfName(String name) {
            return (EdsSeekOrigin)CanonConstants.enumOfName(EdsSeekOrigin.class, name);
        }

        public static final EdsSeekOrigin enumOfValue(int value) {
            return (EdsSeekOrigin)CanonConstants.enumOfValue(EdsSeekOrigin.class, value);
        }

        public static final EdsSeekOrigin enumOfDescription(String description) {
            return (EdsSeekOrigin)CanonConstants.enumOfDescription(EdsSeekOrigin.class, description);
        }
    }

    public static enum EdsEvfDepthOfFieldPreview implements DescriptiveEnum<Integer>
    {
        kEdsEvfDepthOfFieldPreview_OFF("Off"),
        kEdsEvfDepthOfFieldPreview_ON("On");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsEvfDepthOfFieldPreview.class, this.name());
        private final String description;

        private EdsEvfDepthOfFieldPreview(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsEvfDepthOfFieldPreview enumOfName(String name) {
            return (EdsEvfDepthOfFieldPreview)CanonConstants.enumOfName(EdsEvfDepthOfFieldPreview.class, name);
        }

        public static final EdsEvfDepthOfFieldPreview enumOfValue(int value) {
            return (EdsEvfDepthOfFieldPreview)CanonConstants.enumOfValue(EdsEvfDepthOfFieldPreview.class, value);
        }

        public static final EdsEvfDepthOfFieldPreview enumOfDescription(String description) {
            return (EdsEvfDepthOfFieldPreview)CanonConstants.enumOfDescription(EdsEvfDepthOfFieldPreview.class, description);
        }
    }

    public static enum EdsEvfDriveLens implements DescriptiveEnum<Integer>
    {
        kEdsEvfDriveLens_Near1("Near 1"),
        kEdsEvfDriveLens_Near2("Near 2"),
        kEdsEvfDriveLens_Near3("Near 3"),
        kEdsEvfDriveLens_Far1("Far 1"),
        kEdsEvfDriveLens_Far2("Far 2"),
        kEdsEvfDriveLens_Far3("Far 3");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsEvfDriveLens.class, this.name());
        private final String description;

        private EdsEvfDriveLens(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsEvfDriveLens enumOfName(String name) {
            return (EdsEvfDriveLens)CanonConstants.enumOfName(EdsEvfDriveLens.class, name);
        }

        public static final EdsEvfDriveLens enumOfValue(int value) {
            return (EdsEvfDriveLens)CanonConstants.enumOfValue(EdsEvfDriveLens.class, value);
        }

        public static final EdsEvfDriveLens enumOfDescription(String description) {
            return (EdsEvfDriveLens)CanonConstants.enumOfDescription(EdsEvfDriveLens.class, description);
        }
    }

    public static enum EdsStateEvent implements DescriptiveEnum<Integer>
    {
        kEdsStateEvent_All("Notify All"),
        kEdsStateEvent_Shutdown("Camera Unavailable"),
        kEdsStateEvent_JobStatusChanged("Job State Changed"),
        kEdsStateEvent_WillSoonShutDown("Camera Auto-off Active"),
        kEdsStateEvent_ShutDownTimerUpdate("Seconds Until Auto-Off"),
        kEdsStateEvent_CaptureError("Remote Release Error"),
        kEdsStateEvent_InternalError("SDK Software Error"),
        kEdsStateEvent_AfResult("AF Result"),
        kEdsStateEvent_BulbExposureTime("Bulb Exposure Time");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.class, this.name());
        private final String description;

        private EdsStateEvent(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsStateEvent enumOfName(String name) {
            return (EdsStateEvent)CanonConstants.enumOfName(EdsStateEvent.class, name);
        }

        public static final EdsStateEvent enumOfValue(int value) {
            return (EdsStateEvent)CanonConstants.enumOfValue(EdsStateEvent.class, value);
        }

        public static final EdsStateEvent enumOfDescription(String description) {
            return (EdsStateEvent)CanonConstants.enumOfDescription(EdsStateEvent.class, description);
        }
    }

    public static enum EdsObjectEvent implements DescriptiveEnum<Integer>
    {
        kEdsObjectEvent_All("Notify All"),
        kEdsObjectEvent_VolumeInfoChanged("Memory Card Changed"),
        kEdsObjectEvent_VolumeUpdateItems("Memory Card Formatted"),
        kEdsObjectEvent_FolderUpdateItems("Images Deleted"),
        kEdsObjectEvent_DirItemCreated("Folders/Files Created"),
        kEdsObjectEvent_DirItemRemoved("Folders/Files Deleted"),
        kEdsObjectEvent_DirItemInfoChanged("Folders/Files Changed"),
        kEdsObjectEvent_DirItemContentChanged("Images Updated"),
        kEdsObjectEvent_DirItemRequestTransfer("Folders/Files Ready for Transfer"),
        kEdsObjectEvent_DirItemRequestTransferDT("Direct Transfer Pressed"),
        kEdsObjectEvent_DirItemCancelTransferDT("Direct Tranfer Cancelled"),
        kEdsObjectEvent_VolumeAdded("Memory Card Added"),
        kEdsObjectEvent_VolumeRemoved("Memory Card Removed");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.class, this.name());
        private final String description;

        private EdsObjectEvent(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsObjectEvent enumOfName(String name) {
            return (EdsObjectEvent)CanonConstants.enumOfName(EdsObjectEvent.class, name);
        }

        public static final EdsObjectEvent enumOfValue(int value) {
            return (EdsObjectEvent)CanonConstants.enumOfValue(EdsObjectEvent.class, value);
        }

        public static final EdsObjectEvent enumOfDescription(String description) {
            return (EdsObjectEvent)CanonConstants.enumOfDescription(EdsObjectEvent.class, description);
        }
    }

    public static enum EdsPropertyEvent implements DescriptiveEnum<Integer>
    {
        kEdsPropertyEvent_All("Notify All"),
        kEdsPropertyEvent_PropertyChanged("Camera Property Changed"),
        kEdsPropertyEvent_PropertyDescChanged("Details of Property Changed");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.class, this.name());
        private final String description;

        private EdsPropertyEvent(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsPropertyEvent enumOfName(String name) {
            return (EdsPropertyEvent)CanonConstants.enumOfName(EdsPropertyEvent.class, name);
        }

        public static final EdsPropertyEvent enumOfValue(int value) {
            return (EdsPropertyEvent)CanonConstants.enumOfValue(EdsPropertyEvent.class, value);
        }

        public static final EdsPropertyEvent enumOfDescription(String description) {
            return (EdsPropertyEvent)CanonConstants.enumOfDescription(EdsPropertyEvent.class, description);
        }
    }

    public static enum EdsCameraStatusCommand implements DescriptiveEnum<Integer>
    {
        kEdsCameraStatusCommand_UILock("UI Lock"),
        kEdsCameraStatusCommand_UIUnLock("UI Unlock"),
        kEdsCameraStatusCommand_EnterDirectTransfer("Enter Direct Transfer"),
        kEdsCameraStatusCommand_ExitDirectTransfer("Exit Direct Transfer");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.class, this.name());
        private final String description;

        private EdsCameraStatusCommand(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsCameraStatusCommand enumOfName(String name) {
            return (EdsCameraStatusCommand)CanonConstants.enumOfName(EdsCameraStatusCommand.class, name);
        }

        public static final EdsCameraStatusCommand enumOfValue(int value) {
            return (EdsCameraStatusCommand)CanonConstants.enumOfValue(EdsCameraStatusCommand.class, value);
        }

        public static final EdsCameraStatusCommand enumOfDescription(String description) {
            return (EdsCameraStatusCommand)CanonConstants.enumOfDescription(EdsCameraStatusCommand.class, description);
        }
    }

    public static enum EdsShutterButton implements DescriptiveEnum<Integer>
    {
        kEdsCameraCommand_ShutterButton_OFF("Not Depressed"),
        kEdsCameraCommand_ShutterButton_Halfway("Halfway Depressed"),
        kEdsCameraCommand_ShutterButton_Completely("Fully Depressed"),
        kEdsCameraCommand_ShutterButton_Halfway_NonAF("Halfway Depressed (Non-AF)"),
        kEdsCameraCommand_ShutterButton_Completely_NonAF("Fully Depressed (Non-AF)");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsShutterButton.class, this.name());
        private final String description;

        private EdsShutterButton(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsShutterButton enumOfName(String name) {
            return (EdsShutterButton)CanonConstants.enumOfName(EdsShutterButton.class, name);
        }

        public static final EdsShutterButton enumOfValue(int value) {
            return (EdsShutterButton)CanonConstants.enumOfValue(EdsShutterButton.class, value);
        }

        public static final EdsShutterButton enumOfDescription(String description) {
            return (EdsShutterButton)CanonConstants.enumOfDescription(EdsShutterButton.class, description);
        }
    }

    public static enum EdsEvfAf implements DescriptiveEnum<Integer>
    {
        kEdsCameraCommand_EvfAf_OFF("AF Off"),
        kEdsCameraCommand_EvfAf_ON("AF On");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsEvfAf.class, this.name());
        private final String description;

        private EdsEvfAf(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsEvfAf enumOfName(String name) {
            return (EdsEvfAf)CanonConstants.enumOfName(EdsEvfAf.class, name);
        }

        public static final EdsEvfAf enumOfValue(int value) {
            return (EdsEvfAf)CanonConstants.enumOfValue(EdsEvfAf.class, value);
        }

        public static final EdsEvfAf enumOfDescription(String description) {
            return (EdsEvfAf)CanonConstants.enumOfDescription(EdsEvfAf.class, description);
        }
    }

    public static enum EdsCameraCommand implements DescriptiveEnum<Integer>
    {
        kEdsCameraCommand_TakePicture("Take Picture"),
        kEdsCameraCommand_ExtendShutDownTimer("Extend Auto-off Timer"),
        kEdsCameraCommand_BulbStart("Start Bulb Shooting"),
        kEdsCameraCommand_BulbEnd("Stop Bulb Shooting"),
        kEdsCameraCommand_DoEvfAf("Change Live View AF"),
        kEdsCameraCommand_DriveLensEvf("Change Live View Focus"),
        kEdsCameraCommand_DoClickWBEvf("Change Live View WB at Location"),
        kEdsCameraCommand_PressShutterButton("Change Shutter Button");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.class, this.name());
        private final String description;

        private EdsCameraCommand(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsCameraCommand enumOfName(String name) {
            return (EdsCameraCommand)CanonConstants.enumOfName(EdsCameraCommand.class, name);
        }

        public static final EdsCameraCommand enumOfValue(int value) {
            return (EdsCameraCommand)CanonConstants.enumOfValue(EdsCameraCommand.class, value);
        }

        public static final EdsCameraCommand enumOfDescription(String description) {
            return (EdsCameraCommand)CanonConstants.enumOfDescription(EdsCameraCommand.class, description);
        }
    }

    public static enum EdsPropertyID implements DescriptiveEnum<Integer>
    {
        kEdsPropID_Unknown("Unknown", EdsDataType.kEdsDataType_Unknown),
        kEdsPropID_ProductName("Product Name", EdsDataType.kEdsDataType_String),
        kEdsPropID_OwnerName("Owner Name", EdsDataType.kEdsDataType_String),
        kEdsPropID_MakerName("Maker Name", EdsDataType.kEdsDataType_String),
        kEdsPropID_DateTime("Date/Time", EdsDataType.kEdsDataType_Time),
        kEdsPropID_FirmwareVersion("Firmware Version", EdsDataType.kEdsDataType_String),
        kEdsPropID_BatteryLevel("Battery Level", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_CFn("Custom Function #", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_SaveTo("Save To", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_CurrentStorage("Current Storage", EdsDataType.kEdsDataType_String),
        kEdsPropID_CurrentFolder("Current Folder", EdsDataType.kEdsDataType_String),
        kEdsPropID_MyMenu("My Menu", EdsDataType.kEdsDataType_UInt32_Array),
        kEdsPropID_BatteryQuality("Battery Quality", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_BodyIDEx("Body ID Ex", EdsDataType.kEdsDataType_String),
        kEdsPropID_HDDirectoryStructure("Hard Drive Directory Structure", EdsDataType.kEdsDataType_String),
        kEdsPropID_ImageQuality("Image Quality", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_JpegQuality("JPEG Quality", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Orientation("Orientation", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_ICCProfile("ICC Profile", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_FocusInfo("Focus Info", EdsDataType.kEdsDataType_FocusInfo),
        kEdsPropID_DigitalExposure("Digital Exposure", EdsDataType.kEdsDataType_Rational),
        kEdsPropID_WhiteBalance("White Balance", EdsDataType.kEdsDataType_Int32),
        kEdsPropID_ColorTemperature("Color Temperature", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_WhiteBalanceShift("White Balance Shift", EdsDataType.kEdsDataType_Int32_Array),
        kEdsPropID_Contrast("Contrast", EdsDataType.kEdsDataType_Int32),
        kEdsPropID_ColorSaturation("Color Saturation", EdsDataType.kEdsDataType_Int32),
        kEdsPropID_ColorTone("Color Tone", EdsDataType.kEdsDataType_Int32),
        kEdsPropID_Sharpness("Sharpness", EdsDataType.kEdsDataType_Int32),
        kEdsPropID_ColorSpace("Color Space", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_ToneCurve("Tone Curve", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_PhotoEffect("Photo Effect", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_FilterEffect("Filter Effect", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_ToningEffect("Toning Effect", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_ParameterSet("Parameter Set", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_ColorMatrix("Color Matrix", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_PictureStyle("Picture Style", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_PictureStyleDesc("Picture Style Description", EdsDataType.kEdsDataType_PictureStyleDesc),
        kEdsPropID_PictureStyleCaption("Picture Style Caption", EdsDataType.kEdsDataType_String),
        kEdsPropID_Linear("Linear Processing Status", EdsDataType.kEdsDataType_Bool),
        kEdsPropID_ClickWBPoint("Coordinates for White Balance", EdsDataType.kEdsDataType_Point),
        kEdsPropID_WBCoeffs("White Balance Values", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_GPSVersionID("GPS Version ID", EdsDataType.kEdsDataType_UInt8),
        kEdsPropID_GPSLatitudeRef("GPS N or S Latitude", EdsDataType.kEdsDataType_String),
        kEdsPropID_GPSLatitude("GPS Latitude", EdsDataType.kEdsDataType_Rational_Array),
        kEdsPropID_GPSLongitudeRef("GPS E or W Longitude", EdsDataType.kEdsDataType_String),
        kEdsPropID_GPSLongitude("GPS Longitude", EdsDataType.kEdsDataType_Rational_Array),
        kEdsPropID_GPSAltitudeRef("GPS Reference Altitude", EdsDataType.kEdsDataType_UInt8),
        kEdsPropID_GPSAltitude("GPS Altitude", EdsDataType.kEdsDataType_Rational),
        kEdsPropID_GPSTimeStamp("GPS Time Stamp", EdsDataType.kEdsDataType_Rational_Array),
        kEdsPropID_GPSSatellites("GPS Satellites", EdsDataType.kEdsDataType_String),
        kEdsPropID_GPSStatus("GPS Status", EdsDataType.kEdsDataType_String),
        kEdsPropID_GPSMapDatum("GPS Geodetic Data", EdsDataType.kEdsDataType_String),
        kEdsPropID_GPSDateStamp("GPS Date Stamp", EdsDataType.kEdsDataType_String),
        kEdsPropID_AtCapture_Flag("Get Properties at Time of Shooting", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_AEMode("Shooting Mode", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_DriveMode("Drive Mode", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_ISOSpeed("ISO Speed", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_MeteringMode("Metering Mode", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_AFMode("Auto-Focus Mode", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Av("Aperture Value", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Tv("Shutter Speed", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_ExposureCompensation("Exposure Compensation", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_FlashCompensation("Flash Compensation", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_FocalLength("Focal Length", EdsDataType.kEdsDataType_Rational_Array),
        kEdsPropID_AvailableShots("Available Shots", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Bracket("Bracket", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_WhiteBalanceBracket("White Balance Bracket", EdsDataType.kEdsDataType_Int32_Array),
        kEdsPropID_LensName("Lens Name", EdsDataType.kEdsDataType_String),
        kEdsPropID_AEBracket("AE Bracket", EdsDataType.kEdsDataType_Rational),
        kEdsPropID_FEBracket("FE Bracket", EdsDataType.kEdsDataType_Rational),
        kEdsPropID_ISOBracket("ISO Bracket", EdsDataType.kEdsDataType_Rational),
        kEdsPropID_NoiseReduction("Noise Reduction", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_FlashOn("Flash Status", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_RedEye("Red Eye Status", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_FlashMode("Flash Mode", EdsDataType.kEdsDataType_UInt32_Array),
        kEdsPropID_LensStatus("Lens Status", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Artist("Artist", EdsDataType.kEdsDataType_String),
        kEdsPropID_Copyright("Copyright", EdsDataType.kEdsDataType_String),
        kEdsPropID_DepthOfField("Depth of Field", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_EFCompensation("EF Compensation", EdsDataType.kEdsDataType_Unknown),
        kEdsPropID_AEModeSelect(1078, "Shooting Mode Select", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Record(1296, "Movie Shooting Status", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Evf_OutputDevice("Live View Output Device", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Evf_Mode("Live View Mode", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Evf_WhiteBalance("Live View White Balance", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Evf_ColorTemperature("Live View Color Temperature", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Evf_DepthOfFieldPreview("Live View Depth of Field in Preview", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Evf_Zoom("Live View Zoom Ratio", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Evf_ZoomPosition("Live View Zoom Position", EdsDataType.kEdsDataType_Point),
        kEdsPropID_Evf_FocusAid("Live View Focus Aid", EdsDataType.kEdsDataType_Unknown),
        kEdsPropID_Evf_Histogram("Live View Histogram", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_Evf_ImagePosition("Live View Crop Position", EdsDataType.kEdsDataType_Point),
        kEdsPropID_Evf_HistogramStatus("Live View Histogram Status", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_Evf_AFMode("Live View Auto-Focus Mode", EdsDataType.kEdsDataType_UInt32),
        kEdsPropID_Evf_HistogramY(1301, "Live View Histogram Y", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_Evf_HistogramR(1302, "Live View Histogram R", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_Evf_HistogramG(1303, "Live View Histogram G", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_Evf_HistogramB(1304, "Live View Histogram B", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_Evf_CoordinateSystem("Live View Coordinate System", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_Evf_ZoomRect("Live View Zoom Rectangle", EdsDataType.kEdsDataType_ByteBlock),
        kEdsPropID_Evf_ImageClipRect(1349, "Live View Crop Rectangle", EdsDataType.kEdsDataType_ByteBlock);

        private final int value;
        private final String description;
        private final EdsDataType type;

        private EdsPropertyID(int value, String description, EdsDataType type) {
            this.value = value;
            this.description = description;
            this.type = type;
        }

        private EdsPropertyID(String description, EdsDataType type) {
            this.value = CanonUtils.classIntField(EdSdkLibrary.class, this.name());
            this.description = description;
            this.type = type;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public final EdsDataType type() {
            return this.type;
        }

        public static final EdsPropertyID enumOfName(String name) {
            return (EdsPropertyID)CanonConstants.enumOfName(EdsPropertyID.class, name);
        }

        public static final EdsPropertyID enumOfValue(int value) {
            return (EdsPropertyID)CanonConstants.enumOfValue(EdsPropertyID.class, value);
        }

        public static final EdsPropertyID enumOfDescription(String description) {
            return (EdsPropertyID)CanonConstants.enumOfDescription(EdsPropertyID.class, description);
        }
    }

    public static enum EdsDataType implements DescriptiveEnum<Integer>
    {
        kEdsDataType_Unknown("Unknown"),
        kEdsDataType_Bool("EdsBool"),
        kEdsDataType_String("EdsChar[]"),
        kEdsDataType_Int8("EdsInt8"),
        kEdsDataType_UInt8("EdsUInt8"),
        kEdsDataType_Int16("EdsInt16"),
        kEdsDataType_UInt16("EdsUInt16"),
        kEdsDataType_Int32("EdsInt32"),
        kEdsDataType_UInt32("EdsUInt32"),
        kEdsDataType_Int64("EdsInt64"),
        kEdsDataType_UInt64("EdsUInt64"),
        kEdsDataType_Float("EdsFloat"),
        kEdsDataType_Double("EdsDouble"),
        kEdsDataType_ByteBlock("Byte Block"),
        kEdsDataType_Rational("EdsRational"),
        kEdsDataType_Point("EdsPoint"),
        kEdsDataType_Rect("EdsRect"),
        kEdsDataType_Time("EdsTime"),
        kEdsDataType_Bool_Array("EdsBool[]"),
        kEdsDataType_Int8_Array("EdsInt8[]"),
        kEdsDataType_Int16_Array("EdsInt16[]"),
        kEdsDataType_Int32_Array("EdsInt32[]"),
        kEdsDataType_UInt8_Array("EdsUInt8[]"),
        kEdsDataType_UInt16_Array("EdsUInt16[]"),
        kEdsDataType_UInt32_Array("EdsUInt32[]"),
        kEdsDataType_Rational_Array("EdsRational[]"),
        kEdsDataType_FocusInfo("EdsFocusInfo"),
        kEdsDataType_PictureStyleDesc("EdsPictureStyleDesc");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.EdsDataType.class, this.name());
        private final String description;

        private EdsDataType(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsDataType enumOfName(String name) {
            return (EdsDataType)CanonConstants.enumOfName(EdsDataType.class, name);
        }

        public static final EdsDataType enumOfValue(int value) {
            return (EdsDataType)CanonConstants.enumOfValue(EdsDataType.class, value);
        }

        public static final EdsDataType enumOfDescription(String description) {
            return (EdsDataType)CanonConstants.enumOfDescription(EdsDataType.class, description);
        }
    }

    public static enum EdsError implements DescriptiveEnum<Integer>
    {
        EDS_ISSPECIFIC_MASK("IS Specific Mask"),
        EDS_COMPONENTID_MASK("Component ID Mask"),
        EDS_RESERVED_MASK("Reserved Mask"),
        EDS_ERRORID_MASK("Error ID Mask"),
        EDS_CMP_ID_CLIENT_COMPONENTID("Component ID Client"),
        EDS_CMP_ID_LLSDK_COMPONENTID("Component ID LLSDK"),
        EDS_CMP_ID_HLSDK_COMPONENTID("Component ID HLSDK"),
        EDS_ERR_OK("Success, No Errors"),
        EDS_ERR_UNIMPLEMENTED("Unimplemented"),
        EDS_ERR_INTERNAL_ERROR("Internal Error"),
        EDS_ERR_MEM_ALLOC_FAILED("Memory Allocation Failed"),
        EDS_ERR_MEM_FREE_FAILED("Memory Release Failed"),
        EDS_ERR_OPERATION_CANCELLED("Operation Cancelled"),
        EDS_ERR_INCOMPATIBLE_VERSION("Incompatible Version"),
        EDS_ERR_NOT_SUPPORTED("Not Supported"),
        EDS_ERR_UNEXPECTED_EXCEPTION("Unexpected Exception"),
        EDS_ERR_PROTECTION_VIOLATION("Protection Violation"),
        EDS_ERR_MISSING_SUBCOMPONENT("Missing Subcomponent"),
        EDS_ERR_SELECTION_UNAVAILABLE("Selection Unavailable"),
        EDS_ERR_FILE_IO_ERROR("File I/O Error"),
        EDS_ERR_FILE_TOO_MANY_OPEN("Too Many Files Open"),
        EDS_ERR_FILE_NOT_FOUND("File Not Found"),
        EDS_ERR_FILE_OPEN_ERROR("File Open Error"),
        EDS_ERR_FILE_CLOSE_ERROR("File Close Error"),
        EDS_ERR_FILE_SEEK_ERROR("File Seek Error"),
        EDS_ERR_FILE_TELL_ERROR("File Tell Error"),
        EDS_ERR_FILE_READ_ERROR("File Read Error"),
        EDS_ERR_FILE_WRITE_ERROR("File Write Error"),
        EDS_ERR_FILE_PERMISSION_ERROR("File Permission Error"),
        EDS_ERR_FILE_DISK_FULL_ERROR("Disk Full Error"),
        EDS_ERR_FILE_ALREADY_EXISTS("File Already Exists"),
        EDS_ERR_FILE_FORMAT_UNRECOGNIZED("File Format Not Recognized"),
        EDS_ERR_FILE_DATA_CORRUPT("File Data Corrupt"),
        EDS_ERR_FILE_NAMING_NA("File Naming Error"),
        EDS_ERR_DIR_NOT_FOUND("Directory Does Not Exist"),
        EDS_ERR_DIR_IO_ERROR("Directory I/O Error"),
        EDS_ERR_DIR_ENTRY_NOT_FOUND("No Files In Directory"),
        EDS_ERR_DIR_ENTRY_EXISTS("Directory Contains Files"),
        EDS_ERR_DIR_NOT_EMPTY("Directory Full"),
        EDS_ERR_PROPERTIES_UNAVAILABLE("Property Unavailable"),
        EDS_ERR_PROPERTIES_MISMATCH("Property Mismatch"),
        EDS_ERR_PROPERTIES_NOT_LOADED("Property Not Loaded"),
        EDS_ERR_INVALID_PARAMETER("Invalid Function Parameter"),
        EDS_ERR_INVALID_HANDLE("Function Handle Error"),
        EDS_ERR_INVALID_POINTER("Function Pointer Error"),
        EDS_ERR_INVALID_INDEX("Function Index Error"),
        EDS_ERR_INVALID_LENGTH("Function Length Error"),
        EDS_ERR_INVALID_FN_POINTER("Function FN Pointer Error"),
        EDS_ERR_INVALID_SORT_FN("Function Sort FN Error"),
        EDS_ERR_DEVICE_NOT_FOUND("Device Not Found"),
        EDS_ERR_DEVICE_BUSY("Device Busy"),
        EDS_ERR_DEVICE_INVALID("Device Error"),
        EDS_ERR_DEVICE_EMERGENCY("Device Emergency"),
        EDS_ERR_DEVICE_MEMORY_FULL("Device Memory Full"),
        EDS_ERR_DEVICE_INTERNAL_ERROR("Internal Device Error"),
        EDS_ERR_DEVICE_INVALID_PARAMETER("Invalid Device Parameter"),
        EDS_ERR_DEVICE_NO_DISK("No Device Disk"),
        EDS_ERR_DEVICE_DISK_ERROR("Device Disk Error"),
        EDS_ERR_DEVICE_CF_GATE_CHANGED("Device CF Gate Changed"),
        EDS_ERR_DEVICE_DIAL_CHANGED("Device Dial Changed"),
        EDS_ERR_DEVICE_NOT_INSTALLED("Device Not Installed"),
        EDS_ERR_DEVICE_STAY_AWAKE("Device Connect In Awake Mode"),
        EDS_ERR_DEVICE_NOT_RELEASED("Device Not Released"),
        EDS_ERR_STREAM_IO_ERROR("Stream I/O Error"),
        EDS_ERR_STREAM_NOT_OPEN("Stream Not Open"),
        EDS_ERR_STREAM_ALREADY_OPEN("Stream Already Open"),
        EDS_ERR_STREAM_OPEN_ERROR("Stream Open Error"),
        EDS_ERR_STREAM_CLOSE_ERROR("Stream Close Error"),
        EDS_ERR_STREAM_SEEK_ERROR("Stream Seek Error"),
        EDS_ERR_STREAM_TELL_ERROR("Stream Tell Error"),
        EDS_ERR_STREAM_READ_ERROR("Stream Read Error"),
        EDS_ERR_STREAM_WRITE_ERROR("Stream Write Error"),
        EDS_ERR_STREAM_PERMISSION_ERROR("Stream Permission Error"),
        EDS_ERR_STREAM_COULDNT_BEGIN_THREAD("Stream Could Not Start Reading Thumbnail"),
        EDS_ERR_STREAM_BAD_OPTIONS("Invalid Stream Options"),
        EDS_ERR_STREAM_END_OF_STREAM("Invalid Stream Termination"),
        EDS_ERR_COMM_PORT_IS_IN_USE("Communication Port In Use"),
        EDS_ERR_COMM_DISCONNECTED("Communication Port Disconnected"),
        EDS_ERR_COMM_DEVICE_INCOMPATIBLE("Communication Device Incompatible"),
        EDS_ERR_COMM_BUFFER_FULL("Communication Buffer Full"),
        EDS_ERR_COMM_USB_BUS_ERR("USB Bus Error"),
        EDS_ERR_USB_DEVICE_LOCK_ERROR("Failed To Lock The UI"),
        EDS_ERR_USB_DEVICE_UNLOCK_ERROR("Failed To Unlock The UI"),
        EDS_ERR_STI_UNKNOWN_ERROR("Unknown STI"),
        EDS_ERR_STI_INTERNAL_ERROR("Internal STI Error"),
        EDS_ERR_STI_DEVICE_CREATE_ERROR("STI Device Creation Error"),
        EDS_ERR_STI_DEVICE_RELEASE_ERROR("STI Device Release Error"),
        EDS_ERR_DEVICE_NOT_LAUNCHED("Device Start-up Failed"),
        EDS_ERR_ENUM_NA("Enumeration Terminated"),
        EDS_ERR_INVALID_FN_CALL("Function Call Made In Incompatible Mode"),
        EDS_ERR_HANDLE_NOT_FOUND("Handle Not Found"),
        EDS_ERR_INVALID_ID("Invalid ID"),
        EDS_ERR_WAIT_TIMEOUT_ERROR("Timeout"),
        EDS_ERR_SESSION_NOT_OPEN("Session Open Error"),
        EDS_ERR_INVALID_TRANSACTIONID("Invalid Transaction ID"),
        EDS_ERR_INCOMPLETE_TRANSFER("Transfer Incomplete"),
        EDS_ERR_INVALID_STRAGEID("Invalid Storage ID"),
        EDS_ERR_DEVICEPROP_NOT_SUPPORTED("Unsupported Device Property"),
        EDS_ERR_INVALID_OBJECTFORMATCODE("Invalid Object Format Code"),
        EDS_ERR_SELF_TEST_FAILED("Failed Self-Diagnosis"),
        EDS_ERR_PARTIAL_DELETION("Partial Deletion Failed"),
        EDS_ERR_SPECIFICATION_BY_FORMAT_UNSUPPORTED("Unsupported Format Specification"),
        EDS_ERR_NO_VALID_OBJECTINFO("Invalid Object Information"),
        EDS_ERR_INVALID_CODE_FORMAT("Invalid Code Format"),
        EDS_ERR_UNKNOWN_VENDOR_CODE("Unknown Vendor Code"),
        EDS_ERR_CAPTURE_ALREADY_TERMINATED("Capture Already Terminated"),
        EDS_ERR_INVALID_PARENTOBJECT("Invalid Parent Object"),
        EDS_ERR_INVALID_DEVICEPROP_FORMAT("Invalid Device Property Format"),
        EDS_ERR_INVALID_DEVICEPROP_VALUE("Invalid Device Property Value"),
        EDS_ERR_SESSION_ALREADY_OPEN("Session Already Open"),
        EDS_ERR_TRANSACTION_CANCELLED("Transaction Cancelled"),
        EDS_ERR_SPECIFICATION_OF_DESTINATION_UNSUPPORTED("Unsupported Destination Specification"),
        EDS_ERR_UNKNOWN_COMMAND("Unknown Command"),
        EDS_ERR_OPERATION_REFUSED("Operation Refused"),
        EDS_ERR_LENS_COVER_CLOSE("Lens Cover Closed"),
        EDS_ERR_LOW_BATTERY("Low Battery"),
        EDS_ERR_OBJECT_NOTREADY("Live View Image Data Set Not Ready"),
        EDS_ERR_CANNOT_MAKE_OBJECT("Cannot Make Object"),
        EDS_ERR_TAKE_PICTURE_AF_NG("Focus Failed"),
        EDS_ERR_TAKE_PICTURE_RESERVED("Reserved"),
        EDS_ERR_TAKE_PICTURE_MIRROR_UP_NG("Currently Configuring Mirror Up"),
        EDS_ERR_TAKE_PICTURE_SENSOR_CLEANING_NG("Currently Cleaning Sensor"),
        EDS_ERR_TAKE_PICTURE_SILENCE_NG("Currently Performing Silent Operations"),
        EDS_ERR_TAKE_PICTURE_NO_CARD_NG("Card Not Installed"),
        EDS_ERR_TAKE_PICTURE_CARD_NG("Error Writing To Card"),
        EDS_ERR_TAKE_PICTURE_CARD_PROTECT_NG("Card Write Protected"),
        EDS_ERR_TAKE_PICTURE_MOVIE_CROP_NG("Cropping Movie"),
        EDS_ERR_TAKE_PICTURE_STROBO_CHARGE_NG("Strobe Charging"),
        EDS_ERR_LAST_GENERIC_ERROR_PLUS_ONE("Not Used");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.class, this.name());
        private final String description;

        private EdsError(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsError enumOfName(String name) {
            return (EdsError)CanonConstants.enumOfName(EdsError.class, name);
        }

        public static final EdsError enumOfValue(int value) {
            return (EdsError)CanonConstants.enumOfValue(EdsError.class, value);
        }

        public static final EdsError enumOfDescription(String description) {
            return (EdsError)CanonConstants.enumOfDescription(EdsError.class, description);
        }
    }

    public static enum EdsConstant implements DescriptiveEnum<Integer>
    {
        EDS_MAX_NAME("Maximum File Name Length"),
        EDS_TRANSFER_BLOCK_SIZE("Transfer Block Size");

        private final int value = CanonUtils.classIntField(EdSdkLibrary.class, this.name());
        private final String description;

        private EdsConstant(String description) {
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsConstant enumOfName(String name) {
            return (EdsConstant)CanonConstants.enumOfName(EdsConstant.class, name);
        }

        public static final EdsConstant enumOfValue(int value) {
            return (EdsConstant)CanonConstants.enumOfValue(EdsConstant.class, value);
        }

        public static final EdsConstant enumOfDescription(String description) {
            return (EdsConstant)CanonConstants.enumOfDescription(EdsConstant.class, description);
        }
    }

    public static enum EdsCustomFunction implements DescriptiveEnum<Integer>
    {
        kEdsCustomFunction_ExposureIncrements(257, "Exposure level increments"),
        kEdsCustomFunction_ISOExpansion(259, "ISO Expansion"),
        kEdsCustomFunction_FlashSyncSpeed(271, "Flash sync. speed in Av mode"),
        kEdsCustomFunction_LongExpNoiseReduction(513, "Long exp. noise reduction"),
        kEdsCustomFunction_HighISONoiseReduction(514, "High ISO speed noise reduct'n"),
        kEdsCustomFunction_HighlighTonePriority(515, "Highlight tone priority"),
        kEdsCustomFunction_AFAssistBeam(1294, "AF-assist beam firing"),
        kEdsCustomFunction_MirrorLockup(1551, "Mirror lockup"),
        kEdsCustomFunction_ShutterAELockButton(1793, "Shutter/AE lock button"),
        kEdsCustomFunction_AssignSETButton(1796, "Assign SET button"),
        kEdsCustomFunction_LCDDisplayWhenOn(2063, "LCD display when power ON"),
        kEdsCustomFunction_AddVerificationData(2065, "Add image verification data");

        private final int value;
        private final String description;

        private EdsCustomFunction(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsCustomFunction enumOfName(String name) {
            return (EdsCustomFunction)CanonConstants.enumOfName(EdsCustomFunction.class, name);
        }

        public static final EdsCustomFunction enumOfValue(int value) {
            return (EdsCustomFunction)CanonConstants.enumOfValue(EdsCustomFunction.class, value);
        }

        public static final EdsCustomFunction enumOfDescription(String description) {
            return (EdsCustomFunction)CanonConstants.enumOfDescription(EdsCustomFunction.class, description);
        }
    }

    public static enum EdsEvfHistogramStatus implements DescriptiveEnum<Integer>
    {
        kEdsEvfHistogramStatus_Hide(0, "Hide"),
        kEdsEvfHistogramStatus_Normal(0, "Display"),
        kEdsEvfHistogramStatus_Grayout(0, "Gray Out");

        private final int value;
        private final String description;

        private EdsEvfHistogramStatus(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsEvfHistogramStatus enumOfName(String name) {
            return (EdsEvfHistogramStatus)CanonConstants.enumOfName(EdsEvfHistogramStatus.class, name);
        }

        public static final EdsEvfHistogramStatus enumOfValue(int value) {
            return (EdsEvfHistogramStatus)CanonConstants.enumOfValue(EdsEvfHistogramStatus.class, value);
        }

        public static final EdsEvfHistogramStatus enumOfDescription(String description) {
            return (EdsEvfHistogramStatus)CanonConstants.enumOfDescription(EdsEvfHistogramStatus.class, description);
        }
    }

    public static enum EdsExposureCompensation implements DescriptiveEnum<Integer>
    {
        kEdsExposureCompensation_5(40, "+5"),
        kEdsExposureCompensation_4_2by3(37, "+4 2/3"),
        kEdsExposureCompensation_4_1by2(36, "+4 1/2"),
        kEdsExposureCompensation_4_1by3(35, "+4 1/3"),
        kEdsExposureCompensation_4(32, "+4"),
        kEdsExposureCompensation_3_2by3(29, "+3 2/3"),
        kEdsExposureCompensation_3_1by2(28, "+3 1/2"),
        kEdsExposureCompensation_3_1by3(27, "+3 1/3"),
        kEdsExposureCompensation_3(24, "+3"),
        kEdsExposureCompensation_2_2by3(21, "+2 2/3"),
        kEdsExposureCompensation_2_1by2(20, "+2 1/2"),
        kEdsExposureCompensation_2_1by3(19, "+2 1/3"),
        kEdsExposureCompensation_2(16, "+2"),
        kEdsExposureCompensation_1_2by3(13, "+1 2/3"),
        kEdsExposureCompensation_1_1by2(12, "+1 1/2"),
        kEdsExposureCompensation_1_1by3(11, "+1 1/3"),
        kEdsExposureCompensation_1(8, "+1"),
        kEdsExposureCompensation_2by3(5, "+2/3"),
        kEdsExposureCompensation_1by2(4, "+1/2"),
        kEdsExposureCompensation_1by3(3, "+1/3"),
        kEdsExposureCompensation_0(0, "0"),
        kEdsExposureCompensation_n1by3(253, "-1/3"),
        kEdsExposureCompensation_n1by2(252, "-1/2"),
        kEdsExposureCompensation_n2by3(251, "-2/3"),
        kEdsExposureCompensation_n1(248, "-1"),
        kEdsExposureCompensation_n1_1by3(245, "-1 1/3"),
        kEdsExposureCompensation_n1_1by2(244, "-1 1/2"),
        kEdsExposureCompensation_n1_2by3(243, "-1 2/3"),
        kEdsExposureCompensation_n2(240, "-2"),
        kEdsExposureCompensation_n2_1by3(237, "-2 1/3"),
        kEdsExposureCompensation_n2_1by2(236, "-2 1/2"),
        kEdsExposureCompensation_n2_2by3(235, "-2 2/3"),
        kEdsExposureCompensation_n3(232, "-3"),
        kEdsExposureCompensation_n3_1by3(229, "-3 1/3"),
        kEdsExposureCompensation_n3_1by2(228, "-3 1/2"),
        kEdsExposureCompensation_n3_2by3(227, "-3 2/3"),
        kEdsExposureCompensation_n4(224, "-4"),
        kEdsExposureCompensation_n4_1by3(221, "-4 1/3"),
        kEdsExposureCompensation_n4_1by2(220, "-4 1/2"),
        kEdsExposureCompensation_n4_2by3(219, "-4 2/3"),
        kEdsExposureCompensation_n5(216, "-5"),
        kEdsExposureCompensation_Unknown(-1, "Not valid/no settings changes");

        private final int value;
        private final String description;

        private EdsExposureCompensation(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsExposureCompensation enumOfName(String name) {
            return (EdsExposureCompensation)CanonConstants.enumOfName(EdsExposureCompensation.class, name);
        }

        public static final EdsExposureCompensation enumOfValue(int value) {
            return (EdsExposureCompensation)CanonConstants.enumOfValue(EdsExposureCompensation.class, value);
        }

        public static final EdsExposureCompensation enumOfDescription(String description) {
            return (EdsExposureCompensation)CanonConstants.enumOfDescription(EdsExposureCompensation.class, description);
        }
    }

    public static enum EdsTv implements DescriptiveEnum<Integer>
    {
        kEdsTv_BULB(12, "BULB"),
        kEdsTv_30(16, "30\""),
        kEdsTv_25(19, "25\""),
        kEdsTv_20(20, "20\""),
        kEdsTv_20b(21, "20\" (1/3)"),
        kEdsTv_15(24, "15\""),
        kEdsTv_13(27, "13\""),
        kEdsTv_10(28, "10\""),
        kEdsTv_10b(29, "10\" (1/3)"),
        kEdsTv_8(32, "8\""),
        kEdsTv_6b(35, "6\" (1/3)"),
        kEdsTv_6(36, "6\""),
        kEdsTv_5(37, "5\""),
        kEdsTv_4(40, "4\""),
        kEdsTv_3_2(43, "3\"2"),
        kEdsTv_3(44, "3\""),
        kEdsTv_2_5(45, "2\"5"),
        kEdsTv_2(48, "2\""),
        kEdsTv_1_6(51, "1\"6"),
        kEdsTv_1_5(52, "1\"5"),
        kEdsTv_1_3(53, "1\"3"),
        kEdsTv_1(56, "1\""),
        kEdsTv_0_8(59, "0\"8"),
        kEdsTv_0_7(60, "0\"7"),
        kEdsTv_0_6(61, "0\"6"),
        kEdsTv_0_5(64, "0\"5"),
        kEdsTv_0_4(67, "0\"4"),
        kEdsTv_0_3(68, "0\"3"),
        kEdsTv_0_3b(69, "0\"3 (1/3)"),
        kEdsTv_1by4(72, "1/4"),
        kEdsTv_1by5(75, "1/5"),
        kEdsTv_1by6(76, "1/6"),
        kEdsTv_1by6b(77, "1/6 (1/3)"),
        kEdsTv_1by8(80, "1/8"),
        kEdsTv_1by10b(83, "1/10 (1/3)"),
        kEdsTv_1by10(84, "1/10"),
        kEdsTv_1by13(85, "1/13"),
        kEdsTv_1by15(88, "1/15"),
        kEdsTv_1by20b(91, "1/20 (1/3)"),
        kEdsTv_1by20(92, "1/20"),
        kEdsTv_1by25(93, "1/25"),
        kEdsTv_1by30(96, "1/30"),
        kEdsTv_1by40(99, "1/40"),
        kEdsTv_1by45(100, "1/45"),
        kEdsTv_1by50(101, "1/50"),
        kEdsTv_1by60(104, "1/60"),
        kEdsTv_1by80(107, "1/80"),
        kEdsTv_1by90(108, "1/90"),
        kEdsTv_1by100(109, "1/100"),
        kEdsTv_1by125(112, "1/125"),
        kEdsTv_1by160(115, "1/160"),
        kEdsTv_1by180(116, "1/180"),
        kEdsTv_1by200(117, "1/200"),
        kEdsTv_1by250(120, "1/250"),
        kEdsTv_1by320(123, "1/320"),
        kEdsTv_1by350(124, "1/350"),
        kEdsTv_1by400(125, "1/400"),
        kEdsTv_1by500(128, "1/500"),
        kEdsTv_1by640(131, "1/640"),
        kEdsTv_1by750(132, "1/750"),
        kEdsTv_1by800(133, "1/800"),
        kEdsTv_1by1000(136, "1/1000"),
        kEdsTv_1by1250(139, "1/1250"),
        kEdsTv_1by1500(140, "1/1500"),
        kEdsTv_1by1600(141, "1/1600"),
        kEdsTv_1by2000(144, "1/2000"),
        kEdsTv_1by2500(147, "1/2500"),
        kEdsTv_1by3000(148, "1/3000"),
        kEdsTv_1by3200(149, "1/3200"),
        kEdsTv_1by4000(152, "1/4000"),
        kEdsTv_1by5000(155, "1/5000"),
        kEdsTv_1by6000(156, "1/6000"),
        kEdsTv_1by6400(157, "1/6400"),
        kEdsTv_1by8000(160, "1/8000"),
        kEdsTv_Unknown(-1, "Not valid/no settings changes");

        private final int value;
        private final String description;

        private EdsTv(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsTv enumOfName(String name) {
            return (EdsTv)CanonConstants.enumOfName(EdsTv.class, name);
        }

        public static final EdsTv enumOfValue(int value) {
            return (EdsTv)CanonConstants.enumOfValue(EdsTv.class, value);
        }

        public static final EdsTv enumOfDescription(String description) {
            return (EdsTv)CanonConstants.enumOfDescription(EdsTv.class, description);
        }
    }

    public static enum EdsAv implements DescriptiveEnum<Integer>
    {
        kEdsAv_1(8, "1"),
        kEdsAv_1_1(11, "1.1"),
        kEdsAv_1_2(12, "1.2"),
        kEdsAv_1_2b(13, "1.2 (1/3)"),
        kEdsAv_1_4(16, "1.4"),
        kEdsAv_1_6(19, "1.6"),
        kEdsAv_1_8(20, "1.8"),
        kEdsAv_1_8b(21, "1.8 (1/3)"),
        kEdsAv_2(24, "2"),
        kEdsAv_2_2(27, "2.2"),
        kEdsAv_2_5(28, "2.5"),
        kEdsAv_2_5b(29, "2.5 (1/3)"),
        kEdsAv_2_8(32, "2.8"),
        kEdsAv_3_2(35, "3.2"),
        kEdsAv_3_5(36, "3.5"),
        kEdsAv_3_5b(37, "3.5 (1/3)"),
        kEdsAv_4(40, "4"),
        kEdsAv_4_5b(43, "4.5 (1/3)"),
        kEdsAv_4_5(44, "4.5"),
        kEdsAv_5_0(45, "5.0"),
        kEdsAv_5_6(48, "5.6"),
        kEdsAv_6_3(51, "6.3"),
        kEdsAv_6_7(52, "6.7"),
        kEdsAv_7_1(53, "7.1"),
        kEdsAv_8(56, "8"),
        kEdsAv_9(59, "9"),
        kEdsAv_9_5(60, "9.5"),
        kEdsAv_10(61, "10"),
        kEdsAv_11(64, "11"),
        kEdsAv_13b(67, "13 (1/3)"),
        kEdsAv_13(68, "13"),
        kEdsAv_14(69, "14"),
        kEdsAv_16(72, "16"),
        kEdsAv_18(75, "18"),
        kEdsAv_19(76, "19"),
        kEdsAv_20(77, "20"),
        kEdsAv_22(80, "22"),
        kEdsAv_25(83, "25"),
        kEdsAv_27(84, "27"),
        kEdsAv_29(85, "29"),
        kEdsAv_32(88, "32"),
        kEdsAv_36(91, "36"),
        kEdsAv_38(92, "38"),
        kEdsAv_40(93, "40"),
        kEdsAv_45(96, "45"),
        kEdsAv_51(99, "51"),
        kEdsAv_54(100, "54"),
        kEdsAv_57(101, "57"),
        kEdsAv_64(104, "64"),
        kEdsAv_72(107, "72"),
        kEdsAv_76(108, "76"),
        kEdsAv_80(109, "80"),
        kEdsAv_91(112, "91"),
        kEdsAv_Unknown(-1, "Not valid/no settings changes");

        private final int value;
        private final String description;

        private EdsAv(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsAv enumOfName(String name) {
            return (EdsAv)CanonConstants.enumOfName(EdsAv.class, name);
        }

        public static final EdsAv enumOfValue(int value) {
            return (EdsAv)CanonConstants.enumOfValue(EdsAv.class, value);
        }

        public static final EdsAv enumOfDescription(String description) {
            return (EdsAv)CanonConstants.enumOfDescription(EdsAv.class, description);
        }
    }

    public static enum EdsAFMode implements DescriptiveEnum<Integer>
    {
        kEdsAFMode_OneShot(0, "One-Shot AF"),
        kEdsAFMode_AIServo(1, "AI Servo AF"),
        kEdsAFMode_AIFocus(2, "AI Focus AF"),
        kEdsAFMode_Manual(3, "Manual Focus"),
        kEdsAFMode_Unknown(-1, "Not valid/no settings changes");

        private final int value;
        private final String description;

        private EdsAFMode(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsAFMode enumOfName(String name) {
            return (EdsAFMode)CanonConstants.enumOfName(EdsAFMode.class, name);
        }

        public static final EdsAFMode enumOfValue(int value) {
            return (EdsAFMode)CanonConstants.enumOfValue(EdsAFMode.class, value);
        }

        public static final EdsAFMode enumOfDescription(String description) {
            return (EdsAFMode)CanonConstants.enumOfDescription(EdsAFMode.class, description);
        }
    }

    public static enum EdsMeteringMode implements DescriptiveEnum<Integer>
    {
        kEdsMeteringMode_Spot(1, "Spot metering"),
        kEdsMeteringMode_Evaluative(3, "Evaluative metering"),
        kEdsMeteringMode_Partial(4, "Partial metering"),
        kEdsMeteringMode_CenterWeightedAvg(5, "Center-weighted averaging metering"),
        kEdsMeteringMode_Unknown(-1, "Not valid/no settings changes");

        private final int value;
        private final String description;

        private EdsMeteringMode(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsMeteringMode enumOfName(String name) {
            return (EdsMeteringMode)CanonConstants.enumOfName(EdsMeteringMode.class, name);
        }

        public static final EdsMeteringMode enumOfValue(int value) {
            return (EdsMeteringMode)CanonConstants.enumOfValue(EdsMeteringMode.class, value);
        }

        public static final EdsMeteringMode enumOfDescription(String description) {
            return (EdsMeteringMode)CanonConstants.enumOfDescription(EdsMeteringMode.class, description);
        }
    }

    public static enum EdsISOSpeed implements DescriptiveEnum<Integer>
    {
        kEdsISOSpeed_Auto(0, "Auto"),
        kEdsISOSpeed_6(40, "6"),
        kEdsISOSpeed_12(48, "12"),
        kEdsISOSpeed_25(56, "25"),
        kEdsISOSpeed_50(64, "50"),
        kEdsISOSpeed_100(72, "100"),
        kEdsISOSpeed_125(75, "125"),
        kEdsISOSpeed_160(77, "160"),
        kEdsISOSpeed_200(80, "200"),
        kEdsISOSpeed_250(83, "250"),
        kEdsISOSpeed_320(85, "320"),
        kEdsISOSpeed_400(88, "400"),
        kEdsISOSpeed_500(91, "500"),
        kEdsISOSpeed_640(93, "640"),
        kEdsISOSpeed_800(96, "800"),
        kEdsISOSpeed_1000(99, "1000"),
        kEdsISOSpeed_1250(101, "1250"),
        kEdsISOSpeed_1600(104, "1600"),
        kEdsISOSpeed_2000(107, "2000"),
        kEdsISOSpeed_2500(109, "2500"),
        kEdsISOSpeed_3200(112, "3200"),
        kEdsISOSpeed_4000(115, "4000"),
        kEdsISOSpeed_5000(117, "5000"),
        kEdsISOSpeed_6400(120, "6400"),
        kEdsISOSpeed_8000(123, "8000"),
        kEdsISOSpeed_10000(125, "10000"),
        kEdsISOSpeed_12800(128, "12800"),
        kEdsISOSpeed_25600(136, "25600"),
        kEdsISOSpeed_51200(144, "51200"),
        kEdsISOSpeed_102400(152, "102400"),
        kEdsISOSpeed_Unknown(-1, "Not valid/no settings changes");

        private final int value;
        private final String description;

        private EdsISOSpeed(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsISOSpeed enumOfName(String name) {
            return (EdsISOSpeed)CanonConstants.enumOfName(EdsISOSpeed.class, name);
        }

        public static final EdsISOSpeed enumOfValue(int value) {
            return (EdsISOSpeed)CanonConstants.enumOfValue(EdsISOSpeed.class, value);
        }

        public static final EdsISOSpeed enumOfDescription(String description) {
            return (EdsISOSpeed)CanonConstants.enumOfDescription(EdsISOSpeed.class, description);
        }
    }

    public static enum EdsDriveMode implements DescriptiveEnum<Integer>
    {
        kEdsDriveMode_SingleFrame(0, "Single-Frame Shooting"),
        kEdsDriveMode_Continuous(1, "Continuous Shooting"),
        kEdsDriveMode_Video(2, "Video"),
        kEdsDriveMode_NotUsed(3, "Not used"),
        kEdsDriveMode_HighSpeedContinuous(4, "High-Speed Continuous Shooting"),
        kEdsDriveMode_LowSpeedContinuous(5, "Low-Speed Continuous Shooting"),
        kEdsDriveMode_SilentSingleFrame(6, "Silent single shooting"),
        kEdsDriveMode_10SecSelfTimerWithContinuous(7, "10-Sec Self-Timer + Continuous Shooting"),
        kEdsDriveMode_10SecSelfTimer(16, "10-Sec Self-Timer"),
        kEdsDriveMode_2SecSelfTimer(17, "2-Sec Self-Timer");

        private final int value;
        private final String description;

        private EdsDriveMode(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsDriveMode enumOfName(String name) {
            return (EdsDriveMode)CanonConstants.enumOfName(EdsDriveMode.class, name);
        }

        public static final EdsDriveMode enumOfValue(int value) {
            return (EdsDriveMode)CanonConstants.enumOfValue(EdsDriveMode.class, value);
        }

        public static final EdsDriveMode enumOfDescription(String description) {
            return (EdsDriveMode)CanonConstants.enumOfDescription(EdsDriveMode.class, description);
        }
    }

    public static enum EdsBatteryQuality implements DescriptiveEnum<Integer>
    {
        kEdsBatteryQuality_Low(0, "Very degraded"),
        kEdsBatteryQuality_Half(1, "Degraded"),
        kEdsBatteryQuality_HI(2, "Slight degradation"),
        kEdsBatteryQuality_Full(3, "No degradation");

        private final int value;
        private final String description;

        private EdsBatteryQuality(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public final Integer value() {
            return this.value;
        }

        @Override
        public final String description() {
            return this.description;
        }

        public static final EdsBatteryQuality enumOfName(String name) {
            return (EdsBatteryQuality)CanonConstants.enumOfName(EdsBatteryQuality.class, name);
        }

        public static final EdsBatteryQuality enumOfValue(int value) {
            return (EdsBatteryQuality)CanonConstants.enumOfValue(EdsBatteryQuality.class, value);
        }

        public static final EdsBatteryQuality enumOfDescription(String description) {
            return (EdsBatteryQuality)CanonConstants.enumOfDescription(EdsBatteryQuality.class, description);
        }
    }

    public static interface DescriptiveEnum<V> {
        public String name();

        public V value();

        public String description();
    }
}

