/*
 * Decompiled with CFR 0.152.
 */
package edsdk.api.commands;

import com.sun.jna.Pointer;
import edsdk.api.CanonCommand;
import edsdk.bindings.EdSdkLibrary;
import edsdk.utils.CanonConstants;
import edsdk.utils.CanonUtils;
import java.io.File;
import java.io.IOException;

public class ShootCommand
extends CanonCommand<File[]> {
    private final CanonConstants.EdsSaveTo saveTo;
    private final boolean appendFileExtension;
    private File[] dest = null;
    private boolean oldEvfMode;
    private int shotAttempts;
    private int count;

    public ShootCommand() {
        this(CanonConstants.EdsSaveTo.kEdsSaveTo_Both);
    }

    public ShootCommand(CanonConstants.EdsSaveTo saveTo) {
        this(saveTo, Integer.MAX_VALUE, null, false);
    }

    public ShootCommand(CanonConstants.EdsSaveTo saveTo, int shotAttempts) {
        this(saveTo, shotAttempts, null, false);
    }

    public ShootCommand(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File dest) {
        this(saveTo, shotAttempts, new File[]{dest}, false);
    }

    public ShootCommand(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File[] dest) {
        this(saveTo, shotAttempts, dest, false);
    }

    public ShootCommand(CanonConstants.EdsSaveTo saveTo, int shotAttempts, File[] dest, boolean appendFileExtension) {
        this.saveTo = saveTo;
        this.shotAttempts = shotAttempts;
        this.appendFileExtension = appendFileExtension;
        this.count = 1;
        if (dest != null && (dest.length < 0 || dest.length > 2)) {
            throw new IllegalArgumentException("dest must contain one or two file paths (depending on camera image quality settings)");
        }
        this.dest = dest;
    }

    @Override
    public void run() {
        CanonConstants.EdsError err = CanonConstants.EdsError.EDS_ERR_OK;
        if (this.camera.getEdsCamera() != null) {
            long imageQuality;
            try {
                imageQuality = CanonUtils.getPropertyData(this.camera.getEdsCamera(), CanonConstants.EdsPropertyID.kEdsPropID_ImageQuality);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                return;
            }
            CanonConstants.EdsImageType secondaryImageType = CanonConstants.EdsImageType.enumOfValue((int)(imageQuality >>> 4 & 0xFL));
            if (secondaryImageType != CanonConstants.EdsImageType.kEdsImageType_Unknown) {
                this.count = 2;
            }
            if (this.dest == null) {
                this.dest = new File[this.count];
            } else if (this.dest.length < this.count) {
                this.dest = new File[]{this.dest[0], null};
            }
            for (File f : this.dest) {
                if (f == null) continue;
                try {
                    f.getCanonicalPath();
                }
                catch (IOException e) {
                    System.err.println("The file path \"" + f.getPath() + "\" contains characters that are invalid for this filesystem, stopping...");
                    return;
                }
            }
            err = CanonUtils.setPropertyData((EdSdkLibrary.EdsBaseRef)this.camera.getEdsCamera(), CanonConstants.EdsPropertyID.kEdsPropID_SaveTo, this.saveTo);
            if (err == CanonConstants.EdsError.EDS_ERR_OK && !CanonConstants.EdsSaveTo.kEdsSaveTo_Camera.equals(this.saveTo)) {
                CanonUtils.setCapacity(this.camera.getEdsCamera());
            }
            err = CanonConstants.EdsError.EDS_ERR_UNIMPLEMENTED;
            while (this.shotAttempts > 0 && err != CanonConstants.EdsError.EDS_ERR_OK) {
                this.oldEvfMode = CanonUtils.isLiveViewEnabled(this.camera.getEdsCamera(), true);
                if (this.oldEvfMode) {
                    CanonUtils.endLiveView(this.camera.getEdsCamera());
                }
                if ((err = this.sendCommand(CanonConstants.EdsCameraCommand.kEdsCameraCommand_TakePicture, 0L)) != CanonConstants.EdsError.EDS_ERR_OK) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                } else if (CanonUtils.isMirrorLockupEnabled(this.camera.getEdsCamera())) {
                    this.sendCommand(CanonConstants.EdsCameraCommand.kEdsCameraCommand_PressShutterButton, CanonConstants.EdsShutterButton.kEdsCameraCommand_ShutterButton_Completely_NonAF);
                    this.sendCommand(CanonConstants.EdsCameraCommand.kEdsCameraCommand_PressShutterButton, CanonConstants.EdsShutterButton.kEdsCameraCommand_ShutterButton_OFF);
                }
                --this.shotAttempts;
            }
        }
        if (err == CanonConstants.EdsError.EDS_ERR_OK) {
            this.notYetFinished();
        }
    }

    @Override
    public CanonConstants.EdsError apply(CanonConstants.EdsObjectEvent inEvent, EdSdkLibrary.EdsBaseRef inRef, Pointer inContext) {
        return this.apply(inEvent, new EdSdkLibrary.EdsDirectoryItemRef(inRef.getPointer()), inContext);
    }

    public CanonConstants.EdsError apply(CanonConstants.EdsObjectEvent inEvent, EdSdkLibrary.EdsDirectoryItemRef inRef, Pointer inContext) {
        if (inEvent == CanonConstants.EdsObjectEvent.kEdsObjectEvent_DirItemCreated || inEvent == CanonConstants.EdsObjectEvent.kEdsObjectEvent_DirItemRequestTransfer) {
            --this.count;
            System.out.println("Camera saved an image file" + (this.count > 0 ? ", " + this.count + " file remains" : ""));
            if (!CanonConstants.EdsSaveTo.kEdsSaveTo_Camera.equals(this.saveTo)) {
                this.dest[this.dest.length - this.count - 1] = CanonUtils.download(inRef, this.dest[this.dest.length - this.count - 1], this.appendFileExtension);
            }
            if (this.count == 0) {
                this.setResult(this.dest);
                if (this.oldEvfMode) {
                    CanonUtils.beginLiveView(this.camera.getEdsCamera());
                }
                this.finish();
            }
        }
        return CanonConstants.EdsError.EDS_ERR_OK;
    }
}

